/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.UserPrefs;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.ChildMapNumTilesDialog;
import com.inkwellideas.ographer.ui.dialog.CreateChildMapDialog;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;

public class ViewLevelBox {
    private final Worldographer worldographer;
    public static boolean dontRecalculateViewLevels = false;
    public Spinner<Double> tileWidthSpinner = new FocusSpinner<Double>(0.0, 4000.0, 50.0);
    public Spinner<Double> tileHeightSpinner = new FocusSpinner<Double>(0.0, 4000.0, 44.0);
    private boolean dontCascadeSizeChanges = false;
    public Label overviewLabel;
    boolean alreadyUpdating = false;
    boolean viewLevelSwitchingBack = false;
    public GridPane levelbox;
    public ComboBox<ViewLevel> viewLevelCombo;
    public final ViewLevel[] levels = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE};

    public ViewLevelBox(Worldographer worldographer) {
        this.worldographer = worldographer;
    }

    private MapUI mapUI() {
        ViewLevelBox viewLevelBox = this;
        return viewLevelBox.worldographer.getMapUI();
    }

    public void initControls() {
    }

    public void updateViewLevelBox(ViewLevel initiallvl) {
        if (this.levelbox == null) {
            return;
        }
        this.levelbox.getChildren().removeAll((Collection)this.levelbox.getChildren());
        Label levelLabel = new Label("Level:");
        levelLabel.setTooltip(new Tooltip("Switches the map to a new view level where the number of hexes increases or decreases depending on the \ndirection and based on the setting you chose when you created the new level. If the new level doesn't\nexist yet, it will prompt you for the number of hexes across per hex in the current map level."));
        if (initiallvl != ViewLevel.BATTLEMAT && initiallvl != ViewLevel.SETTLEMENT && initiallvl != ViewLevel.COSMIC) {
            this.levelbox.getChildren().add((Object)levelLabel);
        }
        this.viewLevelCombo = new ComboBox(FXCollections.observableArrayList((Object[])this.levels));
        this.viewLevelCombo.setTooltip(new Tooltip("Switches the map to a new view level where the number of hexes increases or decreases depending on the \ndirection and based on the setting you chose when you created the new level. If the new level doesn't\nexist yet, it will prompt you for the number of hexes across per hex in the current map level."));
        if (initiallvl != ViewLevel.BATTLEMAT && initiallvl != ViewLevel.SETTLEMENT && initiallvl != ViewLevel.COSMIC) {
            this.levelbox.getChildren().add(this.viewLevelCombo);
        }
        this.viewLevelCombo.getSelectionModel().select((Object)initiallvl);
        this.viewLevelCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue == newValue) {
                return;
            }
            if (this.viewLevelSwitchingBack) {
                this.viewLevelSwitchingBack = false;
                return;
            }
            if (!UserPrefs.FULL) {
                this.viewLevelSwitchingBack = true;
                this.viewLevelCombo.getSelectionModel().select((Object)oldValue);
                return;
            }
            if (newValue != this.mapUI().getViewLevel() && (oldValue != ViewLevel.WORLD && oldValue != ViewLevel.CONTINENT && oldValue != ViewLevel.KINGDOM && oldValue != ViewLevel.PROVINCE || newValue != ViewLevel.WORLD && newValue != ViewLevel.CONTINENT && newValue != ViewLevel.KINGDOM && newValue != ViewLevel.PROVINCE)) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Can't switch View Levels", "The current map view level can not be switched to " + String.valueOf(newValue), "Battlemat and Settlement maps are separate from World/Continent/Kingdom maps.", null, "");
                this.viewLevelCombo.getSelectionModel().select((Object)oldValue);
                return;
            }
            if (!dontRecalculateViewLevels) {
                boolean usercancelled = false;
                if (this.mapUI().getMapData().getTerrain((ViewLevel)((Object)newValue)) == null) {
                    int numTiles = new ChildMapNumTilesDialog().showChildMapNumTilesDialog(this.worldographer, (ViewLevel)((Object)oldValue), this.worldographer.viewLevelBox);
                    if (numTiles < 1) {
                        usercancelled = true;
                        return;
                    }
                    if (usercancelled) {
                        return;
                    }
                    new CreateChildMapDialog(this.worldographer).createChildMap((ViewLevel)((Object)oldValue), (ViewLevel)((Object)newValue), numTiles, this.mapUI().getMapData());
                } else {
                    double factor = MapObject.getConversionFactor(newValue, oldValue, this.mapUI().getMapData().getView().getContinentFactor(), this.mapUI().getMapData().getView().getKingdomFactor(), this.mapUI().getMapData().getView().getProvinceFactor());
                    if (this.worldographer.viewLevelBox.switchMapViewLevel((ViewLevel)((Object)newValue), (ViewLevel)((Object)oldValue), factor, this.worldographer.rightClickModelPt)) {
                        this.worldographer.rightClickModelPt = null;
                    }
                    if (this.mapUI().getCurrentObjects() != null && this.mapUI().getCurrentObjects().size() > 0) {
                        for (MapObject mo : this.mapUI().getCurrentObjects()) {
                            if (!(mo instanceof MapShape)) continue;
                            this.worldographer.shapesToolbox.strokeWidthSpinner.getValueFactory().setValue((Object)(((MapShape)mo).getShape().getStrokeWidth() * 100.0));
                            break;
                        }
                    }
                }
            }
        });
        Label widthLabel = new Label(" Tile Width:");
        widthLabel.setTooltip(new Tooltip("Changes the width in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe height spinner will also change proportionally."));
        this.tileWidthSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileWidth());
        this.tileWidthSpinner.setTooltip(new Tooltip("Changes the width in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe height spinner will also change proportionally."));
        this.tileWidthSpinner.setEditable(true);
        this.tileWidthSpinner.setMaxWidth(75.0);
        this.tileWidthSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            Point2D centerModelPt = this.mapUI().getModelCoordsFromScreenPt(this.mapUI().canvas.getWidth() / 2.0, this.mapUI().canvas.getHeight() / 2.0);
            this.mapUI().getMapData().setTileWidthHeight((double)newValue, -1.0, this.worldographer.miniMapToolbox.preserveAspectCB());
            this.mapUI().totalMapWidthScreen = 0.0;
            this.mapUI().totalMapWidthBase = 0.0;
            this.mapUI().totalMapHeightScreen = 0.0;
            this.mapUI().totalMapHeightBase = 0.0;
            if (this.worldographer.miniMapToolbox.preserveAspectCB()) {
                if (!this.dontCascadeSizeChanges) {
                    this.dontCascadeSizeChanges = true;
                    this.tileWidthSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileWidth());
                    this.tileHeightSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileHeight());
                }
                this.dontCascadeSizeChanges = false;
            }
            this.mapUI().resetOverview();
            this.mapUI().recaclulateMapSize();
            this.mapUI().hScrollBar.setValue(centerModelPt.getX() - this.mapUI().canvas.getWidth() / 2.0 * 300.0 / this.mapUI().getMapData().getTileWidth());
            this.mapUI().vScrollBar.setValue(centerModelPt.getY() - this.mapUI().canvas.getHeight() / 2.0 * 300.0 / this.mapUI().getMapData().getTileHeight());
            this.mapUI().draw();
            this.updateOverviewLabel(true);
        });
        Label heightLabel = new Label(" Height:");
        heightLabel.setTooltip(new Tooltip("Changes the height in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe width spinner will also change proportionally."));
        this.tileHeightSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileHeight());
        this.tileHeightSpinner.setTooltip(new Tooltip("Changes the height in pixels of the tiles/hexes. If Preserve Aspect Ratio is checked\nthe width spinner will also change proportionally."));
        this.tileHeightSpinner.setEditable(true);
        this.tileHeightSpinner.setMaxWidth(75.0);
        this.tileHeightSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            Point2D centerModelPt = this.mapUI().getModelCoordsFromScreenPt(this.mapUI().canvas.getWidth() / 2.0, this.mapUI().canvas.getHeight() / 2.0);
            this.mapUI().getMapData().setTileWidthHeight(-1.0, (double)newValue, this.worldographer.miniMapToolbox.preserveAspectCB());
            this.mapUI().totalMapWidthScreen = 0.0;
            this.mapUI().totalMapWidthBase = 0.0;
            this.mapUI().totalMapHeightScreen = 0.0;
            this.mapUI().totalMapHeightBase = 0.0;
            if (this.worldographer.miniMapToolbox.preserveAspectCB()) {
                if (!this.dontCascadeSizeChanges) {
                    this.dontCascadeSizeChanges = true;
                    this.tileHeightSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileHeight());
                    this.tileWidthSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileWidth());
                }
                this.dontCascadeSizeChanges = false;
            }
            this.mapUI().resetOverview();
            this.mapUI().recaclulateMapSize();
            this.mapUI().hScrollBar.setValue(centerModelPt.getX() - this.mapUI().canvas.getWidth() / 2.0 * 300.0 / this.mapUI().getMapData().getTileWidth());
            this.mapUI().vScrollBar.setValue(centerModelPt.getY() - this.mapUI().canvas.getHeight() / 2.0 * 300.0 / this.mapUI().getMapData().getTileHeight());
            this.mapUI().draw();
            this.updateOverviewLabel(true);
        });
        this.levelbox.setAlignment(Pos.CENTER);
    }

    public void setupKingdomSpecificControls() {
        if (this.viewLevelCombo != null) {
            this.viewLevelCombo.setVisible(true);
            this.viewLevelCombo.getSelectionModel().select((Object)this.mapUI().getViewLevel());
        }
    }

    public boolean switchMapViewLevel(ViewLevel newValue, ViewLevel oldValue, double factor, Point2D rightClickModelPt) {
        this.mapUI().resetOverview();
        this.mapUI().totalMapWidthScreen = 0.0;
        this.mapUI().totalMapWidthBase = 0.0;
        this.mapUI().totalMapHeightScreen = 0.0;
        this.mapUI().totalMapHeightBase = 0.0;
        if (this.mapUI().getMapData().getTerrain(newValue) != null) {
            this.mapUI().setViewLevel(newValue);
            for (MapShape ms : this.mapUI().getMapData().getShapes()) {
                ms.getShape(this.mapUI().getMapData(), newValue);
            }
            this.mapUI().recaclulateMapSize();
            this.mapUI().resetOverview();
            if (rightClickModelPt == null) {
                rightClickModelPt = this.mapUI().getModelCoordsFromScreenPt(this.mapUI().canvas.getWidth() / 2.0, this.mapUI().canvas.getHeight() / 2.0);
            }
            this.mapUI().hScrollBar.setValue(rightClickModelPt.getX() * factor - this.mapUI().canvas.getWidth() / 2.0 * 300.0 / this.mapUI().getMapData().getTileWidth());
            this.mapUI().vScrollBar.setValue(rightClickModelPt.getY() * factor - this.mapUI().canvas.getHeight() / 2.0 * 300.0 / this.mapUI().getMapData().getTileHeight());
            if (this.mapUI().hScrollBar.getValue() < -this.mapUI().totalMapWidthBase + this.mapUI().totalMapWidthBase + 300.0) {
                this.mapUI().hScrollBar.setValue(0.0);
            }
            if (this.mapUI().vScrollBar.getValue() < -this.mapUI().totalMapHeightBase + this.mapUI().totalMapHeightBase + 300.0) {
                this.mapUI().vScrollBar.setValue(0.0);
            }
            if (this.mapUI().hScrollBar.getValue() > this.mapUI().totalMapWidthBase) {
                this.mapUI().hScrollBar.setValue(this.mapUI().totalMapWidthBase - 3000.0);
            }
            if (this.mapUI().vScrollBar.getValue() > this.mapUI().totalMapHeightBase) {
                this.mapUI().vScrollBar.setValue(this.mapUI().totalMapHeightBase - 3000.0);
            }
            this.mapUI().draw();
            this.updateOverviewLabel(true);
            Worldographer.pingUsage("http://www.worldographer.com/usage/switchvl_" + String.valueOf((Object)oldValue) + "_" + String.valueOf((Object)newValue) + ".txt");
            return true;
        }
        return false;
    }

    public void updateOverviewLabel(boolean viewareaonly) {
        if (this.overviewLabel == null) {
            return;
        }
        try {
            if (this.alreadyUpdating) {
                return;
            }
            this.alreadyUpdating = true;
            if (!viewareaonly) {
                this.mapUI().overviewCanvas.isDirty = true;
            }
            if (this.mapUI().getMapData().getTerrain(this.mapUI().getViewLevel()) == null) {
                this.alreadyUpdating = false;
                return;
            }
            this.mapUI().overviewCanvas.draw();
            WritableImage wi = new WritableImage(this.mapUI().overviewImage.getWidth(), this.mapUI().overviewImage.getHeight());
            this.overviewLabel.setPrefSize((double)this.mapUI().overviewImage.getWidth(), (double)this.mapUI().overviewImage.getHeight());
            this.overviewLabel.setMinSize((double)this.mapUI().overviewImage.getWidth(), (double)this.mapUI().overviewImage.getHeight());
            this.overviewLabel.setMaxSize((double)this.mapUI().overviewImage.getWidth(), (double)this.mapUI().overviewImage.getHeight());
            SwingFXUtils.toFXImage((BufferedImage)this.mapUI().overviewImage, (WritableImage)wi);
            this.overviewLabel.setGraphic((Node)new ImageView((Image)wi));
            this.alreadyUpdating = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.alreadyUpdating = false;
        }
    }

    public void updateSpinners() {
        if (this.tileWidthSpinner != null) {
            this.tileWidthSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileWidth());
        }
        if (this.tileHeightSpinner != null) {
            this.tileHeightSpinner.getValueFactory().setValue((Object)this.mapUI().getMapData().getTileHeight());
        }
    }

    public void zoomIn(Point2D centerModelPt) {
        this.mapUI().totalMapWidthScreen = 0.0;
        this.mapUI().totalMapWidthBase = 0.0;
        this.mapUI().totalMapHeightScreen = 0.0;
        this.mapUI().totalMapHeightBase = 0.0;
        this.tileHeightSpinner.getValueFactory().setValue((Object)((Double)this.tileHeightSpinner.getValue() * 1.5));
        if (!this.worldographer.miniMapToolbox.preserveAspectCB()) {
            this.tileWidthSpinner.getValueFactory().setValue((Object)((Double)this.tileWidthSpinner.getValue() * 1.5));
        }
        this.mapUI().hScrollBar.setValue(centerModelPt.getX() - this.mapUI().canvas.getWidth() / 2.0 * 300.0 / this.mapUI().getMapData().getTileWidth());
        this.mapUI().vScrollBar.setValue(centerModelPt.getY() - this.mapUI().canvas.getHeight() / 2.0 * 300.0 / this.mapUI().getMapData().getTileHeight());
        this.mapUI().draw();
    }

    public void zoomOut(Point2D centerModelPt) {
        this.mapUI().totalMapWidthScreen = 0.0;
        this.mapUI().totalMapWidthBase = 0.0;
        this.mapUI().totalMapHeightScreen = 0.0;
        this.mapUI().totalMapHeightBase = 0.0;
        double newheight = (Double)this.tileHeightSpinner.getValue() * 0.75;
        double newwidth = (Double)this.tileWidthSpinner.getValue() * 0.75;
        this.tileHeightSpinner.getValueFactory().setValue((Object)newheight);
        this.tileWidthSpinner.getValueFactory().setValue((Object)newwidth);
        this.mapUI().hScrollBar.setValue(centerModelPt.getX() - this.mapUI().canvas.getWidth() / 2.0 * 300.0 / this.mapUI().getMapData().getTileWidth());
        this.mapUI().vScrollBar.setValue(centerModelPt.getY() - this.mapUI().canvas.getHeight() / 2.0 * 300.0 / this.mapUI().getMapData().getTileHeight());
        this.mapUI().draw();
    }
}

