/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.toolbox;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.dialog.ConfigureGridDialog;
import com.inkwellideas.ographer.ui.dialog.ConfigureTileNumbersDialog;
import java.util.prefs.Preferences;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class ViewOptions {
    final TextField noteFilter = new TextField("");
    public ToggleButton noteButton;
    private CheckBox showGridCB;
    private CheckBox showGMOnlyCB;
    private CheckBox showFeatureLabelsCB;
    private CheckBox showNumbersCB;
    private CheckBox showGlowGMOnlyCB;
    private CheckBox showDropShadowsCB;
    private TextField hideTagsTF;
    private TextField showTagsTF;
    private MapUI mapUI;

    public void setMapUI(MapUI mapui) {
        this.mapUI = mapui;
        this.update();
    }

    public void initViewOptionsControls() {
        this.noteFilter.setTooltip(new Tooltip("If text is entered here and the adjacent show notes checkbox is selected, then\nthe map only shows notes where the note's title contains the text in this field."));
        this.showGridCB = new CheckBox("Show ");
        this.showGridCB.setTooltip(new Tooltip("Toggles displaying the grid. Configure the grid by clicking the adjacent gear icon."));
        this.noteButton = new ToggleButton("Add/Edit/View ");
        this.noteButton.setTooltip(new Tooltip("When selected, click any of the note boxes on the map to view & edit it.\nAdd new notes by clicking anywhere on the map that doesn't yet have a note."));
        this.showGMOnlyCB = new CheckBox("Show ");
        this.showGMOnlyCB.setTooltip(new Tooltip("When selected, any features marked 'GM Only' are shown anyway.\nWhen turned off, GM Only objects are not shown."));
        this.showGlowGMOnlyCB = new CheckBox("Glow ");
        this.showGlowGMOnlyCB.setTooltip(new Tooltip("When selected and GM Only is also checked, then GM Only map objects have a reddish glow."));
        this.showFeatureLabelsCB = new CheckBox("");
        this.showFeatureLabelsCB.setTooltip(new Tooltip("Show or hide labels associated with specific features."));
        this.hideTagsTF = new TextField();
        this.hideTagsTF.setTooltip(new Tooltip("Hide all notes that have tags with the text entered here."));
        this.showTagsTF = new TextField();
        this.showTagsTF.setTooltip(new Tooltip("Show only the notes that have tags with the text entered here."));
        this.showNumbersCB = new CheckBox("Numbers ");
        this.showNumbersCB.setTooltip(new Tooltip("Show the hex/square numbers on the map. Configure the numbering via the adjacent gear button."));
        this.showDropShadowsCB = new CheckBox("Shadows ");
        this.showDropShadowsCB.setTooltip(new Tooltip("Drop shadows can drastically affect display performance.  If your map has many\nand you see poor performance, uncheck this until you need to display the shadows."));
    }

    public void update() {
        this.noteFilter.setText(this.mapUI.getNoteFilter());
        this.showGMOnlyCB.setSelected(this.mapUI.getMapData().getShow().isGMOnly());
        this.showGlowGMOnlyCB.setSelected(this.mapUI.getMapData().getShow().isGMOnlyGlow());
        this.showFeatureLabelsCB.setSelected(this.mapUI.getMapData().getShow().isFeatureLabels());
        this.hideTagsTF.setText(this.mapUI.getHideTags());
        this.showTagsTF.setText(this.mapUI.getShowTags());
        this.showGridCB.setSelected(this.mapUI.getMapData().getShow().isGrid());
        this.showNumbersCB.setSelected(this.mapUI.getMapData().getShow().isGridNumbers());
        this.showDropShadowsCB.setSelected(this.mapUI.getMapData().getShow().isShadows());
    }

    public Node createViewOptionsBar(Stage parentStage, ToggleGroup toggleGroup, MapUI mapui) {
        this.mapUI = mapui;
        FlowPane flowWrapper = new FlowPane();
        flowWrapper.setPadding(new Insets(0.0, 0.0, 4.0, 0.0));
        flowWrapper.setHgap(4.0);
        flowWrapper.setAlignment(Pos.CENTER_LEFT);
        HBox noteFlow = new HBox(4.0);
        noteFlow.setAlignment(Pos.CENTER_LEFT);
        Label notesLabel = new Label("Notes: ");
        notesLabel.setTooltip(new Tooltip("If text is entered here and the adjacent show notes checkbox is selected, then\nthe map only shows notes where the note's title contains the text in this field."));
        Font f = notesLabel.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        notesLabel.setFont(f);
        noteFlow.getChildren().add((Object)notesLabel);
        this.noteButton.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setNotes(this.noteButton.isSelected());
                this.mapUI.setNoteFilter(this.noteFilter.getText());
                this.mapUI.draw();
            }
        });
        this.noteButton.setToggleGroup(toggleGroup);
        noteFlow.getChildren().add((Object)this.noteButton);
        Label filterLabel = new Label("Filter:");
        filterLabel.setTooltip(new Tooltip("If text is entered here and the adjacent show notes checkbox is selected, then\nthe map only shows notes where the note's title contains the text in this field."));
        noteFlow.getChildren().add((Object)filterLabel);
        this.noteFilter.setMaxWidth(50.0);
        noteFlow.getChildren().add((Object)this.noteFilter);
        this.noteFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.mapUI != null) {
                this.mapUI.setNoteFilter(this.noteFilter.getText());
                this.mapUI.draw();
            }
        });
        HBox gmFlow = new HBox(4.0);
        gmFlow.setAlignment(Pos.CENTER_LEFT);
        Label gml = new Label("GM Only: ");
        gml.setTooltip(new Tooltip("When selected, any features marked 'GM Only' are shown anyway.\nWhen turned off, GM Only objects are not shown."));
        gml.setFont(f);
        gmFlow.getChildren().add((Object)gml);
        this.showGMOnlyCB.setOnAction(event -> {
            System.out.println("showGMOnly:" + String.valueOf((Object)this.mapUI));
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setGMOnly(this.showGMOnlyCB.isSelected());
                this.mapUI.draw();
            }
        });
        this.showGlowGMOnlyCB.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setGMOnlyGlow(this.showGlowGMOnlyCB.isSelected());
                this.mapUI.draw();
            }
        });
        this.showFeatureLabelsCB.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setFeatureLabels(this.showFeatureLabelsCB.isSelected());
                this.mapUI.draw();
            }
        });
        gmFlow.getChildren().add((Object)this.showGMOnlyCB);
        gmFlow.getChildren().add((Object)this.showGlowGMOnlyCB);
        Label fl = new Label("Feature Labels: ");
        fl.setTooltip(new Tooltip("Show or hide labels associated with specific features."));
        fl.setFont(f);
        gmFlow.getChildren().add((Object)fl);
        gmFlow.getChildren().add((Object)this.showFeatureLabelsCB);
        HBox tagsFlow = new HBox(4.0);
        tagsFlow.setAlignment(Pos.CENTER_LEFT);
        Label tagsLabel = new Label("Tags: ");
        tagsLabel.setFont(f);
        tagsFlow.getChildren().add((Object)tagsLabel);
        Label hideTagsLabel = new Label("Hide Objs w/:");
        hideTagsLabel.setTooltip(new Tooltip("Hide all notes that have tags with the text entered here."));
        tagsFlow.getChildren().add((Object)hideTagsLabel);
        this.hideTagsTF.setMaxWidth(55.0);
        this.hideTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.mapUI != null) {
                this.mapUI.setHideTags((String)newValue);
                this.mapUI.draw();
            }
        });
        tagsFlow.getChildren().add((Object)this.hideTagsTF);
        Label showTagsLabel = new Label("Show Only Objs w/:");
        showTagsLabel.setTooltip(new Tooltip("Show only the notes that have tags with the text entered here."));
        tagsFlow.getChildren().add((Object)showTagsLabel);
        this.showTagsTF.setMaxWidth(55.0);
        this.showTagsTF.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.mapUI != null) {
                this.mapUI.setShowTags((String)newValue);
                this.mapUI.draw();
            }
        });
        tagsFlow.getChildren().add((Object)this.showTagsTF);
        HBox gridFlow = new HBox(4.0);
        gridFlow.setAlignment(Pos.CENTER_LEFT);
        Label gridLabel = new Label("Grid: ");
        gridLabel.setTooltip(new Tooltip("Toggles displaying the grid. Configure the grid by clicking the adjacent gear icon."));
        gridLabel.setFont(f);
        gridFlow.getChildren().add((Object)gridLabel);
        this.showGridCB.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setGrid(this.showGridCB.isSelected());
                Preferences.userRoot().node("com/inkwellideas/worldographer2025").putBoolean("showGrid", this.showGridCB.isSelected());
                FileSaveLoad.flushPrefs();
                this.mapUI.draw();
            }
        });
        Button configureGridButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/configure.png")));
        configureGridButton.setTooltip(new Tooltip("Change the color, width and other details of the grid."));
        configureGridButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        configureGridButton.setOnAction(event -> new ConfigureGridDialog(this.mapUI).showConfigureGridDialog(parentStage));
        gridFlow.getChildren().add((Object)this.showGridCB);
        gridFlow.getChildren().add((Object)configureGridButton);
        this.showNumbersCB.setSelected(Preferences.userRoot().node("com/inkwellideas/worldographer2025").getBoolean("showNumbers", true));
        this.showNumbersCB.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setGridNumbers(this.showNumbersCB.isSelected());
                Preferences.userRoot().node("com/inkwellideas/worldographer2025").putBoolean("showNumbers", this.showNumbersCB.isSelected());
                FileSaveLoad.flushPrefs();
                this.mapUI.draw();
            }
        });
        Button configureNumberingButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/configure.png")));
        configureNumberingButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        configureNumberingButton.setTooltip(new Tooltip("Change the grid numbering."));
        configureNumberingButton.setOnAction(event -> new ConfigureTileNumbersDialog().showConfigureTileNumbersDialog(parentStage, this.mapUI));
        gridFlow.getChildren().add((Object)this.showNumbersCB);
        gridFlow.getChildren().add((Object)configureNumberingButton);
        gridFlow.getChildren().add((Object)this.showDropShadowsCB);
        this.showDropShadowsCB.setOnAction(event -> {
            if (this.mapUI != null) {
                this.mapUI.getMapData().getShow().setShadows(this.showDropShadowsCB.isSelected());
                this.mapUI.draw();
            }
        });
        flowWrapper.getChildren().add((Object)noteFlow);
        flowWrapper.getChildren().add((Object)gmFlow);
        flowWrapper.getChildren().add((Object)tagsFlow);
        flowWrapper.getChildren().add((Object)gridFlow);
        return flowWrapper;
    }
}

