/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.CustomTextField;
import atlantafx.base.util.MaskChar;
import atlantafx.base.util.MaskTextFormatter;
import java.util.List;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;
import org.jetbrains.annotations.Nullable;

public class MaskTextField
extends CustomTextField {
    protected final StringProperty mask = new SimpleStringProperty((Object)this, "mask");
    protected final ReadOnlyObjectWrapper<MaskTextFormatter> formatter = new ReadOnlyObjectWrapper((Object)this, "formatter");

    public MaskTextField() {
        super("");
        this.init();
    }

    public MaskTextField(@NamedArg(value="mask") String mask) {
        this("", mask);
    }

    private MaskTextField(@NamedArg(value="text") String text, @NamedArg(value="mask") String mask) {
        super(Objects.requireNonNullElse(text, ""));
        this.formatter.set((Object)MaskTextFormatter.create((TextField)this, mask));
        this.setMask(mask);
        this.init();
    }

    public MaskTextField(String text, List<MaskChar> mask) {
        super(Objects.requireNonNullElse(text, ""));
        this.formatter.set((Object)MaskTextFormatter.create((TextField)this, mask));
        this.setMask(null);
        this.init();
    }

    protected void init() {
        this.mask.addListener((obs, old, val) -> this.formatter.set(val != null ? MaskTextFormatter.create((TextField)this, val) : null));
    }

    public StringProperty maskProperty() {
        return this.mask;
    }

    @Nullable
    public String getMask() {
        return (String)this.mask.get();
    }

    public void setMask(@Nullable String mask) {
        this.mask.set((Object)mask);
    }
}

