/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.RingProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class RingProgressIndicatorSkin
extends SkinBase<RingProgressIndicator> {
    protected static final double DEFAULT_ANIMATION_TIME = 3.0;
    protected final StackPane container = new StackPane();
    protected final Circle trackCircle = new Circle();
    protected final Arc progressArc = new Arc();
    protected final Label progressLabel = new Label();
    protected final RotateTransition transition = new RotateTransition(Duration.seconds((double)3.0), (Node)this.progressArc);
    protected DoubleProperty indeterminateAnimationTime = null;

    public RingProgressIndicatorSkin(RingProgressIndicator indicator) {
        super((Control)indicator);
        this.trackCircle.getStyleClass().add((Object)"track");
        this.trackCircle.setManaged(false);
        this.trackCircle.setFill((Paint)Color.TRANSPARENT);
        this.progressArc.getStyleClass().add((Object)"ring");
        this.progressArc.setManaged(false);
        this.progressArc.setStartAngle(90.0);
        this.progressArc.setLength(this.calcProgressArcLength());
        this.progressArc.setCache(true);
        this.progressArc.setCacheHint(CacheHint.ROTATE);
        this.progressArc.setFill((Paint)Color.TRANSPARENT);
        this.transition.setAutoReverse(false);
        this.transition.setByAngle((double)(-this.getMaxAngle()));
        this.transition.setCycleCount(-1);
        this.transition.setDelay(Duration.ZERO);
        this.transition.setInterpolator(Interpolator.LINEAR);
        this.progressLabel.getStyleClass().add((Object)"progress");
        this.container.getStyleClass().addAll((Object[])new String[]{"container"});
        this.container.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.container.getChildren().addAll((Object[])new Node[]{this.trackCircle, this.progressArc});
        this.container.getChildren().add(indicator.getGraphic() != null ? indicator.getGraphic() : this.progressLabel);
        indicator.getStyleClass().add((Object)"ring-progress-indicator");
        indicator.setMaxHeight(Double.NEGATIVE_INFINITY);
        indicator.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)this.container);
        this.updateProgressLabel();
        this.toggleIndeterminate();
        this.registerChangeListener((ObservableValue)indicator.progressProperty(), e -> {
            this.updateProgressLabel();
            this.progressArc.setLength(this.calcProgressArcLength());
        });
        this.registerChangeListener((ObservableValue)indicator.indeterminateProperty(), e -> this.toggleIndeterminate());
        this.registerChangeListener((ObservableValue)indicator.visibleProperty(), e -> {
            if (indicator.isVisible() && indicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.registerChangeListener((ObservableValue)this.indeterminateAnimationTimeProperty(), e -> {
            this.transition.setDuration(Duration.seconds((double)this.getIndeterminateAnimationTime()));
            if (indicator.isIndeterminate()) {
                this.transition.playFromStart();
            }
        });
        this.registerChangeListener((ObservableValue)indicator.graphicProperty(), e -> {
            if (indicator.getGraphic() != null) {
                this.container.getChildren().remove((Object)this.progressLabel);
                this.container.getChildren().add((Object)indicator.getGraphic());
            } else if (this.container.getChildren().size() > 1) {
                this.container.getChildren().remove(1);
                this.container.getChildren().add((Object)this.progressLabel);
                this.updateProgressLabel();
            }
        });
    }

    private int getMaxAngle() {
        return ((RingProgressIndicator)this.getSkinnable()).isReverse() ? 360 : -360;
    }

    private double calcProgressArcLength() {
        double progress = ((RingProgressIndicator)this.getSkinnable()).getProgress();
        return ((RingProgressIndicator)this.getSkinnable()).isReverse() ? (1.0 - progress) * (double)this.getMaxAngle() : progress * (double)this.getMaxAngle();
    }

    protected void updateProgressLabel() {
        double progress = ((RingProgressIndicator)this.getSkinnable()).getProgress();
        if (((RingProgressIndicator)this.getSkinnable()).getStringConverter() != null) {
            this.progressLabel.setText(((RingProgressIndicator)this.getSkinnable()).getStringConverter().toString((Object)progress));
            return;
        }
        if (progress >= 0.0) {
            this.progressLabel.setText((int)Math.ceil(progress * 100.0) + "%");
        }
    }

    protected void toggleIndeterminate() {
        boolean indeterminate = ((RingProgressIndicator)this.getSkinnable()).isIndeterminate();
        this.progressLabel.setManaged(!indeterminate);
        this.progressLabel.setVisible(!indeterminate);
        if (indeterminate) {
            if (((RingProgressIndicator)this.getSkinnable()).isVisible()) {
                this.transition.play();
            }
        } else {
            this.progressArc.setRotate(0.0);
            this.transition.stop();
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double size = Math.max(w, h);
        double radius = size / 2.0 - this.progressArc.getStrokeWidth() / 2.0;
        this.trackCircle.setCenterX(size / 2.0);
        this.trackCircle.setCenterY(size / 2.0);
        this.trackCircle.setRadius(radius);
        this.progressArc.setCenterX(size / 2.0);
        this.progressArc.setCenterY(size / 2.0);
        this.progressArc.setRadiusX(radius);
        this.progressArc.setRadiusY(radius);
        this.container.resizeRelocate(x, y, size, size);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(0.0, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(0.0, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMaxWidth(0.0, topInset, rightInset, bottomInset, leftInset);
    }

    public void dispose() {
        this.transition.stop();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RingProgressIndicatorSkin.getClassCssMetaData();
    }

    private DoubleProperty indeterminateAnimationTimeProperty() {
        if (this.indeterminateAnimationTime == null) {
            this.indeterminateAnimationTime = new StyleableDoubleProperty(3.0){

                public Object getBean() {
                    return RingProgressIndicatorSkin.this;
                }

                public String getName() {
                    return "indeterminateAnimationTime";
                }

                public CssMetaData<RingProgressIndicator, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_ANIMATION_TIME;
                }
            };
        }
        return this.indeterminateAnimationTime;
    }

    public double getIndeterminateAnimationTime() {
        return this.indeterminateAnimationTime == null ? 3.0 : this.indeterminateAnimationTime.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<RingProgressIndicator, Number> INDETERMINATE_ANIMATION_TIME = new CssMetaData<RingProgressIndicator, Number>("-fx-indeterminate-animation-time", SizeConverter.getInstance(), (Number)3.0){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isSettable(RingProgressIndicator n) {
                Skin skin = n.getSkin();
                if (!(skin instanceof RingProgressIndicatorSkin)) return false;
                RingProgressIndicatorSkin s = (RingProgressIndicatorSkin)skin;
                if (s.indeterminateAnimationTime == null) return true;
                if (s.indeterminateAnimationTime.isBound()) return false;
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(RingProgressIndicator n) {
                RingProgressIndicatorSkin skin = (RingProgressIndicatorSkin)n.getSkin();
                return (StyleableProperty)skin.indeterminateAnimationTimeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<RingProgressIndicator, Number>> styleables = new ArrayList<CssMetaData<RingProgressIndicator, Number>>(SkinBase.getClassCssMetaData());
            styleables.add(INDETERMINATE_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

