/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.data;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapDataIO;
import java.util.Map;
import javafx.scene.paint.Color;

public class LabelStyle {
    public static final LabelStyle STAR_SYSTEM = new LabelStyle("Star System", "Arial", Color.LIGHTGRAY, 0.0, null, 22.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle ROOM = new LabelStyle("Room", "Arial", Color.BLACK, 0.0, null, 25.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle BUILDING = new LabelStyle("Building", "Arial", Color.BLACK, 0.0, null, 25.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle VILLAGE = new LabelStyle("Village", "Times", Color.BLACK, 0.0, null, 28.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle CITY = new LabelStyle("City", "Times", Color.BLACK, 0.0, null, 33.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle PROVINCE = new LabelStyle("Province", "Times", Color.BLACK, 1.0, Color.WHITE, 70.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle NATION = new LabelStyle("Nation", "Times", Color.BLACK, 2.0, Color.WHITE, 80.0, true, false, null, null, 0.0, 0.0);
    public static final LabelStyle GEOGRAPHY_MINOR = new LabelStyle("Geography Minor", "Arial", Color.DARKRED, 1.0, Color.WHITE, 50.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle GEOGRAPHY = new LabelStyle("Geography", "Arial", Color.DARKRED, 2.0, Color.WHITE, 70.0, false, false, null, null, 0.0, 0.0);
    public static final LabelStyle GEOGRAPHY_MAJOR = new LabelStyle("Geography Major", "Arial", Color.DARKRED, 2.0, Color.WHITE, 80.0, false, false, null, null, 0.0, 0.0);
    private String name;
    private String fontFace;
    private Color color;
    private Color outlineColor;
    private double outlineSize;
    private double scale;
    private boolean isBold;
    private boolean isItalic;
    private Color backgroundColor;
    private Color dropShadowColor;
    private double dropShadowSpread;
    private double dropShadowRadius;

    public LabelStyle(String name, String fontFace, Color color, Double outlineSize, Color outlineColor, Double scale, boolean isBold, boolean isItalic, Color backgroundColor, Color dropShadowColor, double dropShadowRadius, double dropShadowSpread) {
        this.name = name;
        this.fontFace = fontFace;
        this.color = color;
        this.outlineSize = outlineSize;
        this.outlineColor = outlineColor;
        this.scale = scale == null ? 0.0 : scale;
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.backgroundColor = backgroundColor;
        this.dropShadowColor = dropShadowColor;
        this.dropShadowRadius = dropShadowRadius;
        this.dropShadowSpread = dropShadowSpread;
    }

    public static void setupLabelStyles(Map<String, LabelStyle> labelStyleMap, ViewLevel viewLevel) {
        if (viewLevel == ViewLevel.BATTLEMAT) {
            labelStyleMap.put("Room", ROOM);
            labelStyleMap.put("Building", BUILDING);
        } else if (viewLevel == ViewLevel.COSMIC) {
            labelStyleMap.put("Star System", STAR_SYSTEM);
        } else if (viewLevel == ViewLevel.SETTLEMENT) {
            labelStyleMap.put("City", CITY);
            labelStyleMap.put("Building", BUILDING);
        } else {
            labelStyleMap.put("Village", VILLAGE);
            labelStyleMap.put("City", CITY);
            labelStyleMap.put("Province", PROVINCE);
            labelStyleMap.put("Nation", NATION);
            labelStyleMap.put("Geography Minor", GEOGRAPHY_MINOR);
            labelStyleMap.put("Geography", GEOGRAPHY);
            labelStyleMap.put("Geography Major", GEOGRAPHY_MAJOR);
        }
    }

    public String getXMLString() {
        if (this.name == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<labelstyle name=\"").append(MapDataIO.toEscapedXML(this.name)).append("\" fontFace=\"").append(MapDataIO.toEscapedXML(this.fontFace)).append("\" scale=\"").append(this.scale).append("\" isBold=\"").append(this.isBold).append("\" isItalic=\"").append(this.isItalic).append("\" ");
        if (this.getColor() != null) {
            sb.append(" color=\"").append(this.getColor().getRed()).append(",").append(this.getColor().getGreen()).append(",").append(this.getColor().getBlue()).append(",").append(this.getColor().getOpacity()).append("\" ");
        } else {
            sb.append(" color=\"null\" ");
        }
        if (this.getBackgroundColor() != null) {
            sb.append(" backgroundColor=\"").append(this.getBackgroundColor().getRed()).append(",").append(this.getBackgroundColor().getGreen()).append(",").append(this.getBackgroundColor().getBlue()).append(",").append(this.getBackgroundColor().getOpacity()).append("\" ");
        } else {
            sb.append(" backgroundColor=\"null\" ");
        }
        if (this.getOutlineColor() != null) {
            sb.append(" outlineSize=\"").append(this.getOutlineSize()).append("\" outlineColor=\"").append(this.getOutlineColor().getRed()).append(",").append(this.getOutlineColor().getGreen()).append(",").append(this.getOutlineColor().getBlue()).append(",").append(this.getOutlineColor().getOpacity()).append("\" ");
        } else {
            sb.append(" outlineSize=\"").append(this.getOutlineSize()).append("\" outlineColor=\"null\" ");
        }
        if (this.getDropShadowColor() != null) {
            sb.append(" dropShadowColor=\"" + this.dropShadowColor.getRed() + "," + this.dropShadowColor.getGreen() + "," + this.dropShadowColor.getBlue() + "," + this.dropShadowColor.getOpacity() + "\" dropShadowRadius=\"" + this.dropShadowRadius + "\" dropShadowSpread=\"" + this.dropShadowSpread + "\" ");
        } else {
            sb.append(" dropShadowColor=\"null\" dropShadowRadius=\"0\" dropShadowSpread=\"0\" ");
        }
        sb.append(" />\n");
        return sb.toString();
    }

    public String toString() {
        return this.getXMLString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFontFace() {
        return this.fontFace;
    }

    public void setFontFace(String fontFace) {
        this.fontFace = fontFace;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public double getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineSize(double outlineSize) {
        this.outlineSize = outlineSize;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getDropShadowColor() {
        return this.dropShadowColor;
    }

    public void setDropShadowColor(Color dropShadowColor) {
        this.dropShadowColor = dropShadowColor;
    }

    public double getDropShadowSpread() {
        return this.dropShadowSpread;
    }

    public void setDropShadowSpread(double dropShadowSpread) {
        this.dropShadowSpread = dropShadowSpread;
    }

    public double getDropShadowRadius() {
        return this.dropShadowRadius;
    }

    public void setDropShadowRadius(double dropShadowRadius) {
        this.dropShadowRadius = dropShadowRadius;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }
}

