/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.battlemat;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.battlemat.Exit;
import com.inkwellideas.ographer.generator.battlemat.MakeDungeonGeomorph;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.FeatureType;
import com.inkwellideas.ographer.model.TextureType;
import com.inkwellideas.ographer.undo.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;

public class BattlematDataGenerator {
    public static void generateDungeon(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> maplabels, int roompercent, int corridorpercent, MapLayer mapLayer, MapLayer labelml, MapLayer shapelayer) {
        if (roompercent < 1) {
            roompercent = 1;
        }
        if (roompercent > 90) {
            roompercent = 90;
        }
        int roomsquaresmax = t.length * t[0].length * roompercent / 100;
        int numRooms = 5;
        int roomwidth = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
        int roomheight = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
        int x = t.length / 2 - roomwidth / 2;
        int y = t[0].length / 2 - roomheight / 2;
        ArrayList<Exit> exits = new ArrayList<Exit>();
        System.out.println("made exits");
        MapShape initialRoom = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + roomwidth, y + roomheight, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room", exits);
        shapes.add(initialRoom);
        for (int j = x; j < x + roomwidth; ++j) {
            for (int k = y; k < y + roomheight; ++k) {
                if (j < 0 || j >= t.length || k < 0 || k >= t[j].length) continue;
                t[j][k] = new Terrain("Floor/Stone Light", false);
            }
        }
        int maxCount = 0;
        while (numRooms > 0 && maxCount < 10) {
            ++maxCount;
            System.out.println("generate Dungeon numRooms:" + numRooms);
            Exit exit = (Exit)exits.get((int)(Math.random() * (double)exits.size()));
            roomwidth = (int)(Math.random() * 6.0) + 1 + ((int)(Math.random() * 6.0) + 1);
            roomheight = (int)(Math.random() * 6.0) + 1 + ((int)(Math.random() * 6.0) + 1);
            if (exit.preferCorridor && Math.random() < 0.8) {
                if (exit.angle == 0.0 || exit.angle == 180.0) {
                    roomwidth = Math.random() < 0.6 ? 1 : 2;
                } else {
                    int n = roomheight = Math.random() < 0.6 ? 1 : 2;
                }
            }
            if (exit.angle == 0.0) {
                x = (int)(exit.x / 300.0 - 0.5) - roomwidth / 2;
                y = (int)(exit.y / 300.0) - roomheight;
            } else if (exit.angle == 90.0) {
                y = (int)(exit.y / 300.0 - 0.5) - roomheight / 2;
                x = (int)(exit.x / 300.0);
            } else if (exit.angle == 180.0) {
                x = (int)(exit.x / 300.0 - 0.5) - roomwidth / 2;
                y = (int)(exit.y / 300.0);
            } else if (exit.angle == 270.0) {
                y = (int)(exit.y / 300.0 - 0.5) - roomheight / 2;
                x = (int)(exit.x / 300.0);
            }
            System.out.println("exit:" + exit.x / 300.0 + "," + exit.y / 300.0 + "/" + exit.angle + " room x:" + x + " y:" + y + " roomWidth:" + roomwidth + " roomHeight:" + roomheight);
            if (BattlematDataGenerator.doRoomsOverlap(t, x, y, roomwidth, roomheight)) continue;
            maxCount = 0;
            MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + roomwidth, y + roomheight, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room", exits);
            shapes.add(ms);
            for (int j = x; j < x + roomwidth; ++j) {
                for (int k = y; k < y + roomheight; ++k) {
                    if (j < 0 || j >= t.length || k < 0 || k >= t[j].length) continue;
                    t[j][k] = new Terrain("Floor/Stone Light", false);
                }
            }
            Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, exit.angle, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, mapLayer);
            door.setLocation(ViewLevel.BATTLEMAT, new Point2D(exit.x, exit.y));
            features.add(door);
            exits.remove(exit);
            --numRooms;
        }
    }

    public static boolean doRoomsOverlap(Terrain[][] t, int x, int y, int width, int height) {
        if (x < 0 || y < 0 || x + width > t.length || y + height > t[0].length) {
            return true;
        }
        for (int i = x; i < x + width; ++i) {
            for (int j = y; j < y + height; ++j) {
                if (t[i][j].getTypeName().contains("Blank")) continue;
                System.out.println(t[i][j].getTypeName());
                return true;
            }
        }
        return false;
    }

    public static void generateDungeonPrior(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> maplabels, int roompercent, int corridorpercent, MapLayer maplayer, MapLayer labelml, MapLayer shapelayer) {
        if (roompercent < 1) {
            roompercent = 1;
        }
        if (roompercent > 90) {
            roompercent = 90;
        }
        int roomsquaresmax = t.length * t[0].length * roompercent / 100;
        int roomwidth = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
        int roomheight = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
        int x = t.length / 2 - roomwidth / 2;
        int y = t[0].length / 2 - roomheight / 2;
        MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x, y, x + roomwidth, y + roomheight, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room");
        shapes.add(ms);
        for (int j = x; j < x + roomwidth; ++j) {
            for (int k = y; k < y + roomheight; ++k) {
                if (j < 0 || j >= t.length || k < 0 || k >= t[j].length) continue;
                t[j][k] = new Terrain("Floor/Stone Light", false);
            }
        }
        MapLabel ml = new MapLabel("Room", "1", "Arial", Color.BLACK, 0.0, Color.BLACK, null, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", labelml);
        ml.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D((double)(t.length - 1) / 2.0 * 300.0, (double)(t[0].length - 1) / 2.0 * 300.0), 25.0);
        maplabels.add(ml);
        int roomsquarecounter = roomwidth * roomheight;
        int fails = 0;
        int nextx = -1;
        int nexty = -1;
        int nextx2 = -1;
        int nexty2 = -1;
        int counter = 2;
        while (roomsquarecounter < roomsquaresmax && fails < 500) {
            double ca;
            int roomsquarecounternew;
            roomwidth = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
            roomheight = (int)(Math.random() * 4.0) + 1 + ((int)(Math.random() * 4.0) + 1);
            if (Math.random() < (double)corridorpercent / 100.0) {
                if (Math.random() < 0.5) {
                    roomwidth = 1;
                    roomheight += 3;
                } else {
                    roomheight = 1;
                    roomwidth += 3;
                }
            }
            if (nextx >= 0 && nexty >= 0) {
                x = nextx;
                y = nexty;
                nextx = -1;
                nexty = -1;
            } else {
                x = (int)(Math.random() * (double)(t.length - roomwidth + 1));
                y = (int)(Math.random() * (double)(t[0].length - roomheight + 1));
                nextx2 = -1;
                nexty2 = -1;
            }
            for (int fails2 = 0; !t[x][y].getTypeName().equals("Floor/Stone Light") && fails2 < 100; ++fails2) {
                x = (int)(Math.random() * (double)(t.length - roomwidth + 1));
                y = (int)(Math.random() * (double)(t[0].length - roomheight + 1));
            }
            boolean clear = MakeDungeonGeomorph.generateDungeonCheckForClearArea(t, roomwidth, roomheight, x, y);
            if (!clear && nextx2 > 0) {
                int origx = x;
                int origy = y;
                x = nextx2;
                y = nexty2;
                clear = MakeDungeonGeomorph.generateDungeonCheckForClearArea(t, roomwidth, roomheight, x, y);
                if (!clear && !(clear = MakeDungeonGeomorph.generateDungeonCheckForClearArea(t, roomwidth = 1, roomheight = 1, x, y))) {
                    x = origx;
                    y = origy;
                    clear = MakeDungeonGeomorph.generateDungeonCheckForClearArea(t, roomwidth, roomheight, x, y);
                }
            }
            if (clear) continue;
            ArrayList<Integer> nextdirections = new ArrayList<Integer>();
            if (y > 0 && "Blank".equals(t[x][y - 1].getTypeName())) {
                nextdirections.add(0);
            }
            if (x < t.length - 1 && "Blank".equals(t[x + 1][y].getTypeName())) {
                nextdirections.add(1);
            }
            if (y < t[0].length - 1 && "Blank".equals(t[x][y + 1].getTypeName())) {
                nextdirections.add(2);
            }
            if (x > 0 && "Blank".equals(t[x - 1][y].getTypeName())) {
                nextdirections.add(3);
            }
            if (nextdirections.size() <= 0) continue;
            int nextdirection = (Integer)nextdirections.get((int)(Math.random() * (double)nextdirections.size()));
            if (nextdirection == 2) {
                roomsquarecounternew = BattlematDataGenerator.addRoomCorridorBelow(t, shapes, features, maplabels, roomwidth, roomheight, x, y, counter, maplayer, labelml, shapelayer);
                roomsquarecounter += roomsquarecounternew;
                if (roomsquarecounternew == 0) {
                    ++fails;
                    continue;
                }
                ++counter;
                if (roomwidth == 1) {
                    ca = Math.random();
                    if (ca < 0.5) {
                        nextx = x;
                        nexty = y + roomheight;
                    } else {
                        nextx = x;
                        nexty = y - 1;
                    }
                }
                if (roomheight != 1) continue;
                ca = Math.random();
                nextx = ca < 0.5 ? x - roomwidth / 2 : x + roomwidth / 2;
                nexty = y;
                continue;
            }
            if (nextdirection == 1) {
                roomsquarecounternew = BattlematDataGenerator.addRoomCorridorRight(t, shapes, features, maplabels, roomwidth, roomheight, x, y, counter, maplayer, labelml, shapelayer);
                roomsquarecounter += roomsquarecounternew;
                if (roomsquarecounternew == 0) {
                    ++fails;
                    continue;
                }
                ++counter;
                if (roomwidth == 1) {
                    nextx = x + roomwidth;
                    int n = nexty = (double)y + Math.random() < 0.5 ? roomheight / 2 : -roomheight / 2;
                }
                if (roomheight != 1) continue;
                ca = Math.random();
                nextx = ca < 0.5 ? x - roomwidth / 2 : x + roomwidth / 2;
                nexty = y;
                continue;
            }
            if (nextdirection == 3) {
                roomsquarecounternew = BattlematDataGenerator.addRoomCorridorAbove(t, shapes, features, maplabels, roomwidth, roomheight, x, y, counter, maplayer, labelml, shapelayer);
                roomsquarecounter += roomsquarecounternew;
                if (roomsquarecounternew == 0) {
                    ++fails;
                    continue;
                }
                ++counter;
                if (roomwidth == 1) {
                    nextx = x;
                    nexty = y - roomheight;
                }
                if (roomheight != 1) continue;
                ca = Math.random();
                nextx = ca < 0.5 ? x - roomwidth / 2 : x + roomwidth / 2;
                nexty = y;
                continue;
            }
            roomsquarecounternew = BattlematDataGenerator.addRoomCorridorLeft(t, shapes, features, maplabels, roomwidth, roomheight, x, y, counter, maplayer, labelml, shapelayer);
            roomsquarecounter += roomsquarecounternew;
            if (roomsquarecounternew == 0) {
                ++fails;
                continue;
            }
            ++counter;
            if (roomwidth == 1) {
                nextx = x + roomwidth;
                int n = nexty = (double)y - Math.random() < 0.5 ? roomheight / 2 : -roomheight / 2;
            }
            if (roomheight != 1) continue;
            ca = Math.random();
            if (ca < 0.5) {
                nextx = x;
                nexty = y - roomheight / 2;
                continue;
            }
            nextx = x;
            nexty = y + roomheight / 2;
        }
    }

    public static void generateDungeonB(Terrain[][] t, List<MapShape> shapes, List<Feature> features, MapLayer featuresML, MapLayer aboveTerrainML) {
        double maxpercentfull = 0.295;
        double currentpercentfull = 0.0;
        boolean[][] grid = new boolean[t.length][t[0].length];
        int w = (int)(Math.random() * 5.0 + 2.0);
        int h = (int)(Math.random() * 5.0 + 2.0);
        int roomx = (int)(Math.random() * (double)(t.length - w));
        int roomy = (int)(Math.random() * (double)(t[0].length - h));
        int count = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h, roomx, roomy, aboveTerrainML);
        while (currentpercentfull < maxpercentfull) {
            MapShape previous = shapes.get((int)(Math.random() * (double)shapes.size()));
            int wall = (int)(Math.random() * 4.0);
            Polygon p = (Polygon)previous.getShape();
            ObservableList pts = p.getPoints();
            int doorx = 0;
            int doory = 0;
            w = (int)(Math.random() * 5.0 + 2.0);
            h = (int)(Math.random() * 5.0 + 2.0);
            double hallchance = Math.random();
            if (wall == 0) {
                doorx = (int)((((Double)pts.get(2) - (Double)pts.get(0)) * Math.random() + (Double)pts.get(0)) / 300.0);
                doory = (int)((Double)pts.get(1) / 300.0);
                if (hallchance < 0.3) {
                    w = 1;
                    h *= 2;
                }
                roomx = doorx - w / 2;
                roomy = doory - h;
            } else if (wall == 1) {
                doorx = (int)((Double)pts.get(2) / 300.0);
                doory = (int)((((Double)pts.get(5) - (Double)pts.get(3)) * Math.random() + (Double)pts.get(3)) / 300.0);
                if (hallchance < 0.3) {
                    w *= 2;
                    h = 1;
                }
                roomx = doorx;
                roomy = doory - h / 2;
            } else if (wall == 2) {
                doorx = (int)((((Double)pts.get(2) - (Double)pts.get(0)) * Math.random() + (Double)pts.get(0)) / 300.0);
                doory = (int)((Double)pts.get(5) / 300.0);
                if (hallchance < 0.3) {
                    w = 1;
                    h *= 2;
                }
                roomx = doorx - w / 2;
                roomy = doory;
            } else if (wall == 3) {
                doorx = (int)((Double)pts.get(4) / 300.0);
                doory = (int)((((Double)pts.get(5) - (Double)pts.get(3)) * Math.random() + (Double)pts.get(3)) / 300.0);
                if (hallchance < 0.3) {
                    w *= 2;
                    h = 1;
                }
                roomx = doorx - w;
                roomy = doory - h / 2;
            }
            int newcount = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h, roomx, roomy, aboveTerrainML);
            if (newcount > 0) {
                MakeDungeonGeomorph.addDungeonDoor(features, wall, doorx, doory, featuresML);
            }
            count += newcount;
            if (newcount > 0 && hallchance < 0.3) {
                if (wall == 0) {
                    doory = roomy;
                    roomy -= h;
                    w = (int)(Math.random() * 5.0 + 2.0);
                    newcount = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h = (int)(Math.random() * 5.0 + 2.0), roomx, roomy, aboveTerrainML);
                    if (newcount > 0) {
                        MakeDungeonGeomorph.addDungeonDoor(features, wall, doorx, doory, featuresML);
                    }
                } else if (wall == 1) {
                    doorx = roomx + w;
                    w = (int)(Math.random() * 5.0 + 2.0);
                    newcount = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h = (int)(Math.random() * 5.0 + 2.0), roomx, roomy, aboveTerrainML);
                    if (newcount > 0) {
                        MakeDungeonGeomorph.addDungeonDoor(features, wall, doorx, doory, featuresML);
                    }
                } else if (wall == 2) {
                    doory = roomy + h;
                    w = (int)(Math.random() * 5.0 + 2.0);
                    newcount = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h = (int)(Math.random() * 5.0 + 2.0), roomx, roomy, aboveTerrainML);
                    if (newcount > 0) {
                        MakeDungeonGeomorph.addDungeonDoor(features, wall, doorx, doory, featuresML);
                    }
                } else if (wall == 3) {
                    doorx = roomx;
                    roomx -= w;
                    w = (int)(Math.random() * 5.0 + 2.0);
                    newcount = MakeDungeonGeomorph.makeDungeonRoomNew(shapes, grid, w, h = (int)(Math.random() * 5.0 + 2.0), roomx, roomy, aboveTerrainML);
                    if (newcount > 0) {
                        MakeDungeonGeomorph.addDungeonDoor(features, wall, doorx, doory, featuresML);
                    }
                }
            }
            currentpercentfull = 1.0 * (double)count / (double)(t.length * t[0].length);
        }
    }

    private static int addRoomCorridorLeft(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> labels, int roomwidth, int roomheight, int x, int y, int counter, MapLayer ml, MapLayer labelml, MapLayer shapelayer) {
        int roomsquarecounter = 0;
        if (y - roomheight / 2 > 0 && y + (roomheight + 1) / 2 < t[0].length - 1 && x - roomwidth - 1 > 0) {
            int n;
            int m;
            boolean cantplace = false;
            block0: for (m = x - roomwidth; m < x; ++m) {
                for (n = y - roomheight / 2; n < y + (roomheight + 1) / 2; ++n) {
                    if (!"Floor/Stone Light".equals(t[m][n].getTypeName())) continue;
                    cantplace = true;
                    continue block0;
                }
            }
            if (!cantplace) {
                for (m = x - roomwidth; m < x; ++m) {
                    for (n = y - roomheight / 2; n < y + (roomheight + 1) / 2; ++n) {
                        t[m][n].setType("Floor/Stone Light");
                    }
                }
                MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x - roomwidth, y - roomheight / 2, x, y + (roomheight + 1) / 2, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room");
                shapes.add(ms);
                roomsquarecounter = roomwidth * roomheight;
                Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D((double)(x * 300), ((double)y + 0.5) * 300.0));
                features.add(door);
                MapLabel mlb = new MapLabel("Room", "" + counter, "Arial", Color.BLACK, 0.0, Color.BLACK, null, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", labelml);
                mlb.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D(((double)x - (double)(roomwidth % 2 == 0 ? roomwidth + 1 : roomwidth) / 2.0) * 300.0, ((double)y + 0.5) * 300.0), 25.0);
                labels.add(mlb);
            }
        }
        return roomsquarecounter;
    }

    private static int addRoomCorridorAbove(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> labels, int roomwidth, int roomheight, int x, int y, int counter, MapLayer ml, MapLayer labelml, MapLayer shapelayer) {
        int roomsquarecounter = 0;
        if (x - roomwidth / 2 > 0 && x + (roomwidth + 1) / 2 < t.length - 1 && y - roomheight - 1 > 0) {
            int n;
            int m;
            boolean cantplace = false;
            block0: for (m = x - roomwidth / 2; m < x + (roomwidth + 1) / 2; ++m) {
                for (n = y - roomheight; n < y; ++n) {
                    if (!"Floor/Stone Light".equals(t[m][n].getTypeName())) continue;
                    cantplace = true;
                    continue block0;
                }
            }
            if (!cantplace) {
                for (m = x - roomwidth / 2; m < x + (roomwidth + 1) / 2; ++m) {
                    for (n = y - roomheight; n < y; ++n) {
                        t[m][n].setType("Floor/Stone Light");
                    }
                }
                MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x - roomwidth / 2, y - roomheight, x + (roomwidth + 1) / 2, y, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room");
                shapes.add(ms);
                roomsquarecounter = roomwidth * roomheight;
                Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D(((double)x + 0.5) * 300.0, (double)(y * 300)));
                features.add(door);
                MapLabel mlb = new MapLabel("Room", "" + counter, "Arial", Color.BLACK, 0.0, Color.BLACK, null, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", labelml);
                mlb.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D(((double)x + 0.5) * 300.0, ((double)y - (double)(roomheight % 2 == 0 ? roomheight + 1 : roomheight) / 2.0) * 300.0), 25.0);
                labels.add(mlb);
            }
        }
        return roomsquarecounter;
    }

    private static int addRoomCorridorRight(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> labels, int roomwidth, int roomheight, int x, int y, int counter, MapLayer ml, MapLayer labelml, MapLayer shapelayer) {
        int roomsquarecounter = 0;
        if (y - roomheight / 2 > 0 && y + (roomheight + 1) / 2 < t[0].length - 1 && x + roomwidth + 1 < t.length - 1) {
            int n;
            int m;
            boolean cantplace = false;
            block0: for (m = x + 1; m < x + 1 + roomwidth; ++m) {
                for (n = y - roomheight / 2; n < y + (roomheight + 1) / 2; ++n) {
                    if (!"Floor/Stone Light".equals(t[m][n].getTypeName())) continue;
                    cantplace = true;
                    continue block0;
                }
            }
            if (!cantplace) {
                for (m = x + 1; m < x + 1 + roomwidth; ++m) {
                    for (n = y - roomheight / 2; n < y + (roomheight + 1) / 2; ++n) {
                        t[m][n].setType("Floor/Stone Light");
                    }
                }
                MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x + 1, y - roomheight / 2, x + 1 + roomwidth, y + (roomheight + 1) / 2, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room");
                shapes.add(ms);
                roomsquarecounter = roomwidth * roomheight;
                Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 90.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D((double)((x + 1) * 300), ((double)y + 0.5) * 300.0));
                features.add(door);
                MapLabel mlb = new MapLabel("Room", "" + counter, "Arial", Color.BLACK, 0.0, Color.BLACK, null, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", labelml);
                mlb.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D(((double)(x + 1) + (double)(roomwidth % 2 == 0 ? roomwidth - 1 : roomwidth) / 2.0) * 300.0, ((double)y + 0.5) * 300.0), 25.0);
                labels.add(mlb);
            }
        }
        return roomsquarecounter;
    }

    private static int addRoomCorridorBelow(Terrain[][] t, List<MapShape> shapes, List<Feature> features, List<MapLabel> labels, int roomwidth, int roomheight, int x, int y, int counter, MapLayer ml, MapLayer labelml, MapLayer shapelayer) {
        int roomsquarecounter = 0;
        if (x - roomwidth / 2 > 0 && x + (roomwidth + 1) / 2 < t.length - 1 && y + roomheight + 1 < t[0].length - 1) {
            int n;
            int m;
            boolean cantplace = false;
            block0: for (m = x - roomwidth / 2; m < x + (roomwidth + 1) / 2; ++m) {
                for (n = y + 1; n < y + 1 + roomheight; ++n) {
                    if (!"Floor/Stone Light".equals(t[m][n].getTypeName())) continue;
                    cantplace = true;
                    continue block0;
                }
            }
            if (!cantplace) {
                for (m = x - roomwidth / 2; m < x + (roomwidth + 1) / 2; ++m) {
                    for (n = y + 1; n < y + 1 + roomheight; ++n) {
                        t[m][n].setType("Floor/Stone Light");
                    }
                }
                MapShape ms = BattlematDataGenerator.makeRoomCreatePolygon(x - roomwidth / 2, y + 1, x + (roomwidth + 1) / 2, y + 1 + roomheight, "Rock Dark", 0.1, "Pavers Light", shapelayer, "room");
                shapes.add(ms);
                roomsquarecounter = roomwidth * roomheight;
                Feature door = new Feature("Battlemat/Door Wood", false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "door", false, false, false, false, ml);
                door.setLocation(ViewLevel.BATTLEMAT, new Point2D(((double)x + 0.5) * 300.0, (double)((y + 1) * 300)));
                features.add(door);
                MapLabel mlb = new MapLabel("Room", "" + counter, "Arial", Color.BLACK, 0.0, Color.BLACK, null, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "room number", labelml);
                mlb.setLocationAndScale(ViewLevel.BATTLEMAT, new Point2D(((double)x + 0.5) * 300.0, ((double)(y + 1) + (double)(roomheight % 2 == 0 ? roomheight - 1 : roomheight) / 2.0) * 300.0), 25.0);
                labels.add(mlb);
            }
        }
        return roomsquarecounter;
    }

    protected static Feature checkAndPlaceFeature(Random r, boolean evenSpacing, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, double width, double height, String itemType, String itemTags, double minX, double rangeX, double minY, double rangeY, double rotate, int maxTries, ViewLevel viewLevel, boolean avoidEdgese) {
        boolean success = false;
        Feature result = null;
        for (int triesx = 0; triesx < maxTries && !success; ++triesx) {
            boolean intersect;
            double xt = r.nextDouble() * rangeX;
            if (evenSpacing) {
                xt = (int)xt;
            }
            double itemX = minX + xt;
            double yt = r.nextDouble() * rangeY;
            if (evenSpacing) {
                yt = (int)yt;
            }
            double itemY = minY + yt;
            Feature feature = new Feature(itemType, false, false, false, false, null, rotate, null, width, -1.0, false, false, null, itemTags, false, false, false, false, featureLayer);
            double ht = feature.getScaleHtFallbackType();
            if (ht <= 0.0) {
                ht = feature.getScaleFallbackType();
            }
            if (intersect = BattlematDataGenerator.isIntersect(featureBoundingBoxes, itemX, itemY, rotate == 0.0 || rotate == 180.0 ? feature.getScaleFallbackType() * 3.0 : ht * 3.0, rotate == 0.0 || rotate == 180.0 ? ht * 3.0 : feature.getScaleFallbackType() * 3.0)) continue;
            result = BattlematDataGenerator.getFeature(featureLayer, featureBoundingBoxes, (int)rotate, itemX, itemY, width, height, itemType, itemTags);
            success = true;
        }
        if (result != null && avoidEdgese && viewLevel != null) {
            if (rangeX > 1.0) {
                if (result.getLocation(viewLevel).getX() < minX * 300.0 + 175.0) {
                    result.setLocation(viewLevel, new Point2D(result.getLocation(viewLevel).getX() + 25.0, result.getLocation(viewLevel).getY()));
                }
                if (result.getLocation(viewLevel).getX() > (minX + rangeX - 1.0) * 300.0 - 175.0) {
                    result.setLocation(viewLevel, new Point2D(result.getLocation(viewLevel).getX() - 25.0, result.getLocation(viewLevel).getY()));
                }
            }
            if (rangeY > 1.0) {
                if (result.getLocation(viewLevel).getY() < minY * 300.0 + 175.0) {
                    result.setLocation(viewLevel, new Point2D(result.getLocation(viewLevel).getX(), result.getLocation(viewLevel).getY() + 25.0));
                }
                if (result.getLocation(viewLevel).getY() > (minY + rangeY - 1.0) * 300.0 - 175.0) {
                    result.setLocation(viewLevel, new Point2D(result.getLocation(viewLevel).getX(), result.getLocation(viewLevel).getY() - 25.0));
                }
            }
        }
        return result;
    }

    protected static Feature checkAndPlaceFeature(List<Feature> features, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, String itemType, String itemTags, double minX, double rangeX, double minY, double rangeY, double rotate) {
        return BattlematDataGenerator.checkAndPlaceFeature(new Random(), false, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, minX, rangeX, minY, rangeY, rotate, 10, null, false);
    }

    protected static Feature placeFeature(List<Feature> features, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, int rotate, double locX, double locY, double width, double height, String featureType, String tags) {
        Feature feature = BattlematDataGenerator.getFeature(featureLayer, featureBoundingBoxes, rotate, locX, locY, width, height, featureType, tags);
        features.add(feature);
        return feature;
    }

    protected static Feature getFeature(MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, int rotate, double locX, double locY, double width, double height, String featureType, String tags) {
        Feature feature = new Feature(featureType, false, false, false, false, null, rotate, null, width, height, false, false, null, tags, false, false, false, false, featureLayer);
        feature.setLocation(ViewLevel.BATTLEMAT, new Point2D(locX * 300.0, locY * 300.0));
        double ht = feature.getScaleHtFallbackType();
        if (ht <= 0.0) {
            ht = feature.getScaleFallbackType();
        }
        if (featureType.contains("Door")) {
            ht = feature.getScaleFallbackType();
        }
        featureBoundingBoxes.add(new Rectangle(rotate == 0 || rotate == 180 ? locX * 300.0 - feature.getScaleFallbackType() / 2.0 * 3.0 : locX * 300.0 - ht / 2.0 * 3.0, rotate == 0 || rotate == 180 ? locY * 300.0 - ht / 2.0 * 3.0 : locY * 300.0 - feature.getScaleFallbackType() / 2.0 * 3.0, rotate == 0 || rotate == 180 ? feature.getScaleFallbackType() * 3.0 : ht * 3.0, rotate == 0 || rotate == 180 ? ht * 3.0 : feature.getScaleFallbackType() * 3.0));
        return feature;
    }

    protected static boolean isIntersect(Set<Rectangle> featureBoundingBoxes, double locX, double locY, double fWidth, double fHeight) {
        Rectangle rect;
        boolean intersect = false;
        Iterator<Rectangle> iterator = featureBoundingBoxes.iterator();
        while (iterator.hasNext() && !(intersect = (rect = iterator.next()).intersects(locX * 300.0 - fWidth / 2.0, locY * 300.0 - fHeight / 2.0, fWidth, fHeight))) {
        }
        return intersect;
    }

    /*
     * WARNING - void declaration
     */
    public static List makeBedroom(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, String bedWall, String bedType) {
        String[] otherFurniture;
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        bedType = ((String)bedType).equals("Single") ? "" : (String)bedType + " ";
        for (String string : otherFurniture = new String[]{"Bed", "Desk", "Wardrobe"}) {
            boolean placed = false;
            for (int tries = 0; tries < 5 && !placed; ++tries) {
                Feature f;
                void var37_32;
                String[] walls = new String[]{"Top", "Right", "Bottom", "Left"};
                String wall = walls[r.nextInt(4)];
                if (var37_32.equals("Bed")) {
                    wall = bedWall;
                    String string2 = (String)var37_32 + " " + (String)bedType + "Red";
                }
                FeatureType ft = Feature.featureTypes.get("Battlemat/" + (String)var37_32 + " " + furnitureStyle);
                double x = 0.0;
                double y = 0.0;
                double rangeX = 0.0;
                double rangeY = 0.0;
                int rotate = 0;
                if (wall.equals("Top") || wall.equals("Bottom")) {
                    x = left + ft.getIconSize() / 2.0 + 0.05;
                    y = wall.equals("Top") ? top + ft.getIconHeight() / 2.0 + 0.05 : bottom - ft.getIconHeight() / 2.0 - 0.05;
                    rangeX = right - left - ft.getIconSize() - 0.1;
                    if (wall.equals("Bottom")) {
                        rotate = 180;
                    }
                } else {
                    x = wall.equals("Left") ? left + ft.getIconHeight() / 2.0 + 0.05 : right - ft.getIconHeight() / 2.0 - 0.05;
                    y = top + ft.getIconSize() / 2.0 + 0.05;
                    rangeY = bottom - top - ft.getIconSize() - 0.1;
                    rotate = wall.equals("Right") ? 90 : 270;
                }
                if ((f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/" + (String)var37_32 + " " + furnitureStyle, "furniture", x, rangeX, y, rangeY, rotate, 5, viewLevel, true)) == null) continue;
                if (var37_32.contains("Desk")) {
                    double chairX = f.getLocation(viewLevel).getX() / 300.0;
                    double chairY = f.getLocation(viewLevel).getY() / 300.0;
                    int chairRotate = 90;
                    if (wall.equals("Top")) {
                        chairY += 0.2;
                        chairRotate = 180;
                    } else if (wall.equals("Bottom")) {
                        chairY -= 0.2;
                        chairRotate = 0;
                    } else if (wall.equals("Right")) {
                        chairX -= 0.2;
                        chairRotate = 270;
                    } else {
                        chairX += 0.2;
                    }
                    Feature chair = BattlematDataGenerator.getFeature(featureLayer, featureBoundingBoxes, chairRotate, chairX, chairY, -1.0, -1.0, "Battlemat/Chair " + furnitureStyle, "furniture");
                    objects.add(chair);
                }
                objects.add(f);
                placed = true;
            }
        }
        return objects;
    }

    public static List makeStudy(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, List<String> desks, List<String> chairs, List<String> bookcases, int bookcaseChance) {
        int[] rotates;
        int deskRotate;
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        boolean success = false;
        Object deskType = desks.size() == 0 ? "Battlemat/Desk " + furnitureStyle : desks.get((int)(r.nextDouble() * (double)desks.size()));
        Feature desk = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, (String)deskType, "furniture", left + (right - left) / 2.0, 0.0, top + (bottom - top) / 2.0, 0.0, deskRotate = (rotates = new int[]{0, 90, 180, 270})[(int)(r.nextDouble() * 4.0)], 5, viewLevel, true);
        if (desk != null) {
            double chairX = desk.getLocation(viewLevel).getX() / 300.0;
            double chairY = desk.getLocation(viewLevel).getY() / 300.0;
            int chairRotate = 180;
            if (deskRotate == 180) {
                chairY -= 0.2;
                chairRotate = 0;
            } else if (deskRotate == 90) {
                chairX -= 0.2;
                chairRotate = 270;
            } else if (deskRotate == 270) {
                chairX += 0.2;
                chairRotate = 90;
            } else {
                chairY += 0.2;
            }
            Object chairType = chairs.size() == 0 ? "Battlemat/Chair " + furnitureStyle : chairs.get((int)(r.nextDouble() * (double)chairs.size()));
            Feature chair = BattlematDataGenerator.getFeature(featureLayer, featureBoundingBoxes, chairRotate, chairX, chairY, -1.0, -1.0, (String)chairType, "furniture");
            objects.add(chair);
            objects.add(desk);
        }
        BattlematDataGenerator.addItemsAlongWalls(r, left, top, right, bottom, bookcases, "bookcase", featureLayer, featureBoundingBoxes, viewLevel, bookcaseChance, objects);
        return objects;
    }

    public static List makeDiningRoom(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, List<String> tableOptions, List<String> chairOptions, int maxTables) {
        String[] otherFurniture;
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        double squares = (right - left) * (bottom - top);
        double roomWidth = right - left;
        double roomHeight = bottom - top;
        Random random = new Random();
        ArrayList<Feature> tables = new ArrayList<Feature>();
        String tableType = tableOptions.get((int)((double)tableOptions.size() * Math.random()));
        Feature table = new Feature(tableType, false, false, false, false, null, 0.0, null, -1.0, -1.0, false, false, null, "table", false, false, false, false, featureLayer);
        int tablesWide = (int)(roomWidth / ((table.getScaleFallbackType() + 50.0) / 100.0));
        int tablesHigh = (int)(roomHeight / ((table.getScaleHtFallbackType() + 50.0) / 100.0));
        if (maxTables < tablesHigh * tablesWide) {
            if (tablesHigh >= tablesWide) {
                tablesHigh = (int)((double)maxTables * 1.0 / (double)tablesWide + 0.99);
            } else {
                tablesWide = (int)((double)maxTables * 1.0 / (double)tablesHigh + 0.99);
            }
        }
        String chairType = chairOptions.get((int)((double)chairOptions.size() * Math.random()));
        ArrayList<Point> tableLocationsOrig = new ArrayList<Point>();
        double dx = roomWidth / (double)tablesWide;
        double dy = roomHeight / (double)tablesHigh;
        int tableLocationCount = 0;
        for (int i = 0; i < tablesWide; ++i) {
            for (int j = 0; j < tablesHigh; ++j) {
                tableLocationsOrig.add(new Point(dx * (double)i + dx / 2.0, dy * (double)j + dy / 2.0));
                ++tableLocationCount;
            }
        }
        ArrayList<Point> tableLocations = new ArrayList<Point>();
        for (int i = 0; i < tableLocationCount; ++i) {
            Point pt = (Point)tableLocationsOrig.get(tableLocationsOrig.size() / 2);
            tableLocations.add(pt);
            tableLocationsOrig.remove(pt);
        }
        HashSet<Rectangle> tableBoundingBoxes = new HashSet<Rectangle>();
        for (int i = 0; i < maxTables; ++i) {
            double rangeX = 0.0;
            double rangeY = 0.0;
            double rotate = 0.0;
            if (i >= tableLocations.size()) break;
            Feature tablef = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, tableBoundingBoxes, -1.0, -1.0, tableType, "furniture", ((Point)tableLocations.get(i)).getX() + left, rangeX, ((Point)tableLocations.get(i)).getY() + top, rangeY, rotate, 5, viewLevel, true);
            if (tablef == null) continue;
            int endChairs = (int)(tablef.getScaleHtFallbackType() / 75.0);
            double chairDY = tablef.getScaleFallbackType() / (double)endChairs;
            for (int j = 0; j < endChairs; ++j) {
                Feature chairLeft = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, new HashSet<Rectangle>(), -1.0, -1.0, chairType, "furniture", ((Point)tableLocations.get(i)).getX() + left - tablef.getScaleFallbackType() * 0.45 / 100.0, rangeX, ((Point)tableLocations.get(i)).getY() + top - tablef.getScaleHtFallbackType() / 100.0 + ((double)j + 0.5) * chairDY / 100.0, rangeY, rotate + 270.0, 5, viewLevel, true);
                tables.add(chairLeft);
                Feature chairRight = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, new HashSet<Rectangle>(), -1.0, -1.0, chairType, "furniture", ((Point)tableLocations.get(i)).getX() + left + tablef.getScaleFallbackType() * 0.45 / 100.0, rangeX, ((Point)tableLocations.get(i)).getY() + top - tablef.getScaleHtFallbackType() / 100.0 + ((double)j + 0.5) * chairDY / 100.0, rangeY, rotate + 90.0, 5, viewLevel, true);
                tables.add(chairRight);
            }
            int sideChairs = (int)(tablef.getScaleFallbackType() / 75.0);
            double chairDX = (tablef.getScaleFallbackType() - 30.0) / (double)sideChairs;
            for (int j = 0; j < sideChairs; ++j) {
                Feature chairTop = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, new HashSet<Rectangle>(), -1.0, -1.0, chairType, "furniture", ((Point)tableLocations.get(i)).getX() + left + 0.15 + ((double)j + 0.5) * chairDX / 100.0 - tablef.getScaleFallbackType() / 2.0 / 100.0, rangeX, ((Point)tableLocations.get(i)).getY() + top - tablef.getScaleHtFallbackType() * 0.45 / 100.0, rangeY, rotate + 0.0, 5, viewLevel, true);
                tables.add(chairTop);
                Feature chairBottom = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, new HashSet<Rectangle>(), -1.0, -1.0, chairType, "furniture", ((Point)tableLocations.get(i)).getX() + left + 0.15 + ((double)j + 0.5) * chairDX / 100.0 - tablef.getScaleFallbackType() / 2.0 / 100.0, rangeX, ((Point)tableLocations.get(i)).getY() + top + tablef.getScaleHtFallbackType() * 0.45 / 100.0, rangeY, rotate + 180.0, 5, viewLevel, true);
                tables.add(chairBottom);
            }
            tables.add(tablef);
        }
        objects.addAll(tables);
        for (String other : otherFurniture = new String[0]) {
            boolean placed = false;
            for (int tries = 0; tries < 5 && !placed; ++tries) {
                Feature f;
                String[] walls = new String[]{"Top", "Right", "Bottom", "Left"};
                String wall = walls[r.nextInt(4)];
                FeatureType ft = Feature.featureTypes.get("Battlemat/" + other);
                double x = 0.0;
                double y = 0.0;
                double rangeX = 0.0;
                double rangeY = 0.0;
                int rotate = 0;
                double extraOffset = 0.05;
                if (other.contains("Cookery") || other.contains("Fireplace")) {
                    extraOffset = 0.0;
                }
                if (wall.equals("Top") || wall.equals("Bottom")) {
                    x = left + ft.getIconSize() / 2.0 + 0.05;
                    y = wall.equals("Top") ? top + ft.getIconHeight() / 2.0 + extraOffset : bottom - ft.getIconHeight() / 2.0 - extraOffset;
                    rangeX = right - left - ft.getIconSize() - 0.1;
                    if (wall.equals("Bottom")) {
                        rotate = 180;
                    }
                } else {
                    x = wall.equals("Left") ? left + ft.getIconHeight() / 2.0 + extraOffset : right - ft.getIconHeight() / 2.0 - extraOffset;
                    y = top + ft.getIconSize() / 2.0 + 0.05;
                    rangeY = bottom - top - ft.getIconSize() - 0.1;
                    rotate = wall.equals("Right") ? 90 : 270;
                }
                if ((f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/" + other, "furniture", x, rangeX, y, rangeY, rotate, 5, viewLevel, true)) == null) continue;
                objects.add(f);
                placed = true;
            }
        }
        return objects;
    }

    public static List makeKitchen(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, String cookWall, String cookType) {
        String[] otherFurniture;
        if (((String)cookType).equals("Cookery")) {
            cookType = (String)cookType + " A";
        }
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        for (String other : otherFurniture = new String[]{cookType, "Table Rectangle " + furnitureStyle}) {
            boolean placed = false;
            for (int tries = 0; tries < 5 && !placed; ++tries) {
                Feature f;
                String[] walls = new String[]{"Top", "Right", "Bottom", "Left"};
                String wall = walls[r.nextInt(4)];
                if (other.equals(otherFurniture[0])) {
                    wall = cookWall;
                }
                FeatureType ft = Feature.featureTypes.get("Battlemat/" + other);
                double x = 0.0;
                double y = 0.0;
                double rangeX = 0.0;
                double rangeY = 0.0;
                int rotate = 0;
                double extraOffset = 0.05;
                if (other.contains("Cookery") || other.contains("Fireplace")) {
                    extraOffset = 0.0;
                }
                if (wall.equals("Top") || wall.equals("Bottom")) {
                    x = left + ft.getIconSize() / 2.0 + 0.05;
                    y = wall.equals("Top") ? top + ft.getIconHeight() / 2.0 + extraOffset : bottom - ft.getIconHeight() / 2.0 - extraOffset;
                    rangeX = right - left - ft.getIconSize() - 0.1;
                    if (wall.equals("Bottom")) {
                        rotate = 180;
                    }
                } else {
                    x = wall.equals("Left") ? left + ft.getIconHeight() / 2.0 + extraOffset : right - ft.getIconHeight() / 2.0 - extraOffset;
                    y = top + ft.getIconSize() / 2.0 + 0.05;
                    rangeY = bottom - top - ft.getIconSize() - 0.1;
                    rotate = wall.equals("Right") ? 90 : 270;
                }
                if ((f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/" + other, "furniture", x, rangeX, y, rangeY, rotate, 5, viewLevel, true)) == null) continue;
                objects.add(f);
                placed = true;
            }
        }
        return objects;
    }

    public static List makeLibrary(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, String statues, int wallBookcaseChance, int numSofas, int numChairs) {
        Feature statue;
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        Feature rug = BattlematDataGenerator.getFeature(featureLayer, new HashSet<Rectangle>(), 0, left + (right - left) / 2.0, top + (bottom - top) / 2.0, (right - left) / 9.0 * 100.0 * (double)(5 + r.nextInt(3)), (bottom - top) / 9.0 * 100.0 * (double)(5 + r.nextInt(3)), "Battlemat/Rug Square", "rug");
        if (rug != null) {
            objects.add(rug);
        }
        if (numSofas > 0) {
            int sofaAdjust;
            for (int i = sofaAdjust = r.nextInt(4); i < numSofas + sofaAdjust; ++i) {
                double[] xs = new double[]{left + (right - left) / 2.0, left + (right - left) / 2.0, right - 1.35, left + 1.35};
                double[] ys = new double[]{top + 1.35, bottom - 1.35, top + (bottom - top) / 2.0, top + (bottom - top) / 2.0};
                double[] rotates = new double[]{0.0, 180.0, 90.0, 270.0};
                Feature sofa = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, 90.0, -1.0, "Battlemat/Sofa Modern Red", "sofa", xs[i % 4], 0.0, ys[i % 4], 0.0, rotates[i % 4], 1, viewLevel, true);
                if (sofa == null) continue;
                objects.add(sofa);
            }
        }
        if (numChairs > 0) {
            int placed = 0;
            int tries = 0;
            while (placed < numChairs && tries < 20) {
                double[] rotates;
                double[] ys;
                double[] xs = new double[]{left + (right - left) / 2.0 - 1.0, left + (right - left) / 2.0 - 0.35, left + (right - left) / 2.0 + 0.35, left + (right - left) / 2.0 + 1.0, left + (right - left) / 2.0 + 1.1, left + (right - left) / 2.0 + 1.1, left + (right - left) / 2.0 + 1.0, left + (right - left) / 2.0 + 0.35, left + (right - left) / 2.0 - 0.35, left + (right - left) / 2.0 - 1.0, left + (right - left) / 2.0 - 1.1, left + (right - left) / 2.0 - 1.1};
                int i = r.nextInt(12);
                Feature chair = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/Chair Upholstered Red", "chair", xs[i], 0.0, (ys = new double[]{top + (bottom - top) / 2.0 - 1.0, top + (bottom - top) / 2.0 - 1.1, top + (bottom - top) / 2.0 - 1.1, top + (bottom - top) / 2.0 - 1.0, top + (bottom - top) / 2.0 - 0.35, top + (bottom - top) / 2.0 + 0.35, top + (bottom - top) / 2.0 + 1.0, top + (bottom - top) / 2.0 + 1.1, top + (bottom - top) / 2.0 + 1.1, top + (bottom - top) / 2.0 + 1.0, top + (bottom - top) / 2.0 + 0.35, top + (bottom - top) / 2.0 - 0.35})[i], 0.0, (rotates = new double[]{315.0, 0.0, 0.0, 45.0, 90.0, 90.0, 135.0, 180.0, 180.0, 215.0, 270.0, 270.0})[i], 1, viewLevel, true);
                if (chair != null) {
                    objects.add(chair);
                    ++placed;
                    continue;
                }
                ++tries;
            }
        }
        if (statues.equals("Corners")) {
            double[] xs = new double[]{left + 0.5, right - 0.5, right - 0.5, left + 0.5};
            double[] ys = new double[]{top + 0.5, top + 0.5, bottom - 0.5, bottom - 0.5};
            double[] rotates = new double[]{315.0, 45.0, 135.0, 215.0};
            for (int i = 0; i < xs.length; ++i) {
                statue = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, 90.0, -1.0, "Battlemat/Statue", "statue", xs[i], 0.0, ys[i], 0.0, rotates[i], 1, viewLevel, true);
                if (statue == null) continue;
                objects.add(statue);
            }
        } else if (statues.equals("Center of Walls")) {
            double[] xs = new double[]{left + (right - left) / 2.0, right - 0.5, left + (right - left) / 2.0, left + 0.5};
            double[] ys = new double[]{top + 0.5, top + (bottom - top) / 2.0, bottom - 0.5, top + (bottom - top) / 2.0};
            double[] rotates = new double[]{0.0, 90.0, 180.0, 270.0};
            for (int i = 0; i < xs.length; ++i) {
                statue = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, 90.0, -1.0, "Battlemat/Statue", "statue", xs[i], 0.0, ys[i], 0.0, rotates[i], 1, viewLevel, true);
                if (statue == null) continue;
                objects.add(statue);
            }
        } else if (statues.equals("Center of Room") && (statue = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/Statue", "statue", left + (right - left) / 2.0, 0.0, top + (bottom - top) / 2.0, 0.0, r.nextInt(8) * 45, 1, viewLevel, true)) != null) {
            objects.add(statue);
        }
        ArrayList<String> bookcases = new ArrayList<String>();
        bookcases.add("Battlemat/Bookcase " + furnitureStyle);
        BattlematDataGenerator.addItemsAlongWalls(r, left, top, right, bottom, bookcases, "bookcase", featureLayer, featureBoundingBoxes, viewLevel, wallBookcaseChance, objects);
        int i = 0;
        while ((double)i < right - left) {
            Feature chair = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, "Battlemat/Chair Upholstered Red", "chair", left + 0.5, right - left, top + 0.2, 0.0, 0.0, 1, viewLevel, true);
            if (chair != null) {
                objects.add(chair);
            }
            ++i;
        }
        return objects;
    }

    public static List makeBarracks(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, List<String> bedStyles, Integer numBeds) {
        List objects = BattlematDataGenerator.makeRoomWithDoorsAndWindows(r, left, top, right, bottom, strokename, strokewidth, fillname, furnitureStyle, doorsTop, doorsLeft, doorsBottom, doorsRight, windowsTop, windowsLeft, windowsBottom, windowsRight, torchesTop, torchesLeft, torchesBottom, torchesRight, shapelayer, featureLayer, featureBoundingBoxes, false, false);
        BattlematDataGenerator.addItemsAlongWalls(r, left, top, right, bottom, bedStyles, "bed", featureLayer, featureBoundingBoxes, viewLevel, 90, objects);
        return objects;
    }

    private static void addItemsAlongWalls(Random r, double left, double top, double right, double bottom, List<String> itemTypes, String tags, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, int chanceWallHasObject, List objects) {
        if (right - left > bottom - top || right - left == bottom - top && r.nextBoolean()) {
            BattlematDataGenerator.addFeaturesAlongTopBottomWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 0.0);
            BattlematDataGenerator.addFeaturesAlongTopBottomWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 180.0);
            BattlematDataGenerator.addFeaturesAlongLeftRightWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 270.0);
            BattlematDataGenerator.addFeaturesAlongLeftRightWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 90.0);
        } else {
            BattlematDataGenerator.addFeaturesAlongLeftRightWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 270.0);
            BattlematDataGenerator.addFeaturesAlongLeftRightWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 90.0);
            BattlematDataGenerator.addFeaturesAlongTopBottomWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 0.0);
            BattlematDataGenerator.addFeaturesAlongTopBottomWall(r, left, top, right, bottom, itemTypes, tags, featureLayer, featureBoundingBoxes, viewLevel, chanceWallHasObject, objects, 180.0);
        }
    }

    private static void addFeaturesAlongLeftRightWall(Random r, double left, double top, double right, double bottom, List<String> itemTypes, String tags, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, int chanceWallHasObject, List objects, double rotate) {
        int i = 0;
        while ((double)i < bottom - top) {
            if (r.nextInt(100) < chanceWallHasObject) {
                String fName = itemTypes.get(r.nextInt(itemTypes.size()));
                if (fName.toLowerCase().contains("bookcase")) {
                    Feature bookcase = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, 99.0, 42.0, fName, tags, rotate == 270.0 ? left + 0.22 : right - 0.22, 0.0, top + 0.5 + (double)i, 0.0, rotate, 1, viewLevel, true);
                    if (bookcase != null) {
                        objects.add(bookcase);
                        if (i == 0 || (double)i == bottom - top - 1.0) {
                            bookcase.setScale(93.0);
                            bookcase.setScaleHt(42.0);
                            if (i == 0) {
                                bookcase.setLocation(viewLevel, 300.0 * (rotate == 270.0 ? left + 0.22 : right - 0.22), 300.0 * (top + 0.57));
                            } else {
                                bookcase.setLocation(viewLevel, 300.0 * (rotate == 270.0 ? left + 0.22 : right - 0.22), 300.0 * (top - 0.57 + (double)i));
                            }
                        }
                    }
                } else {
                    Feature f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, fName, tags, rotate == 270.0 ? left + Feature.featureTypes.get(fName).getIconHeight() * 0.52 : right - Feature.featureTypes.get(fName).getIconHeight() * 0.52, 0.0, top + 0.5 + (double)i, 0.0, rotate, 1, viewLevel, true);
                    System.out.println("f result:" + String.valueOf(f));
                    if (f != null) {
                        objects.add(f);
                    }
                }
            }
            ++i;
        }
    }

    private static void addFeaturesAlongTopBottomWall(Random r, double left, double top, double right, double bottom, List<String> itemTypes, String tags, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, ViewLevel viewLevel, int chanceWallHasObject, List objects, double rotate) {
        int i = 0;
        while ((double)i < right - left) {
            if (r.nextInt(100) < chanceWallHasObject) {
                String fName = itemTypes.get(r.nextInt(itemTypes.size()));
                if (fName.toLowerCase().contains("bookcase")) {
                    f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, 99.0, 42.0, fName, tags, left + 0.5 + (double)i, 0.0, rotate == 0.0 ? top + 0.22 : bottom - 0.22, 0.0, rotate, 1, viewLevel, true);
                    if (f != null) {
                        objects.add(f);
                        if (i == 0 || (double)i == right - left - 1.0) {
                            f.setScale(93.0);
                            f.setScaleHt(42.0);
                            if (i == 0) {
                                f.setLocation(viewLevel, 300.0 * (left + 0.57), 300.0 * (rotate == 0.0 ? top + 0.22 : bottom - 0.22));
                            } else {
                                f.setLocation(viewLevel, 300.0 * (left - 0.57 + (double)i), 300.0 * (rotate == 0.0 ? top + 0.22 : bottom - 0.22));
                            }
                        }
                    }
                } else {
                    f = BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, fName, tags, left + 0.5 + (double)i, 0.0, rotate == 0.0 ? top + Feature.featureTypes.get(fName).getIconHeight() * 0.52 : bottom - Feature.featureTypes.get(fName).getIconHeight() * 0.52, 0.0, rotate, 1, viewLevel, true);
                    if (f != null) {
                        objects.add(f);
                    }
                }
            }
            ++i;
        }
    }

    public static List makeRoomWithDoorsAndWindows(Random r, double left, double top, double right, double bottom, String strokename, double strokewidth, String fillname, String furnitureStyle, int doorsTop, int doorsLeft, int doorsBottom, int doorsRight, int windowsTop, int windowsLeft, int windowsBottom, int windowsRight, int torchesTop, int torchesLeft, int torchesBottom, int torchesRight, MapLayer shapelayer, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, boolean centerDoors, boolean centerWindows) {
        ArrayList<MapShape> objects = new ArrayList<MapShape>();
        MapShape room = BattlematDataGenerator.makeRoomCreatePolygon(left, top, right, bottom, strokename, strokewidth, fillname, shapelayer, "room");
        objects.add(room);
        BattlematDataGenerator.addDoorsWindowsTorchesToWalls(doorsTop, centerDoors, right, left, r, featureLayer, featureBoundingBoxes, "Battlemat/Door " + furnitureStyle, "door", top, objects, doorsBottom, bottom, doorsLeft, doorsRight);
        BattlematDataGenerator.addDoorsWindowsTorchesToWalls(windowsTop, centerWindows, right, left, r, featureLayer, featureBoundingBoxes, "Battlemat/Window No Light", "window", top, objects, windowsBottom, bottom, windowsLeft, windowsRight);
        BattlematDataGenerator.addDoorsWindowsTorchesToWalls(torchesTop, centerWindows, right, left, r, featureLayer, featureBoundingBoxes, "Battlemat/Torch Lit", "torch", top, objects, torchesBottom, bottom, torchesLeft, torchesRight);
        return objects;
    }

    private static void addDoorsWindowsTorchesToWalls(int numFeaturesTop, boolean centerFeatures, double right, double left, Random r, MapLayer featureLayer, Set<Rectangle> featureBoundingBoxes, String itemType, String itemTags, double top, List objects, int numFeaturesBottom, double bottom, int numFeaturesLeft, int numFeaturesRight) {
        Feature feature;
        int rotate;
        int i;
        for (i = 0; i < numFeaturesTop; ++i) {
            rotate = 0;
            if (itemTags.contains("torch")) {
                rotate = 90;
            }
            feature = null;
            feature = centerFeatures && right - left == 2.0 ? BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, left + 1.0, 0.0, itemTags.contains("torch") ? top + 0.55 : top, 0.0, rotate, 5, null, false) : BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, left + 0.5, right - left, itemTags.contains("torch") ? top + 0.55 : top, 0.0, rotate, 5, null, false);
            if (feature == null) continue;
            objects.add(feature);
        }
        for (i = 0; i < numFeaturesBottom; ++i) {
            rotate = 180;
            if (itemTags.contains("torch")) {
                rotate = 270;
            }
            feature = null;
            feature = centerFeatures && right - left == 2.0 ? BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, left + 1.0, 0.0, itemTags.contains("torch") ? bottom - 0.55 : bottom, 0.0, rotate, 5, null, false) : BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, left + 0.5, right - left, itemTags.contains("torch") ? bottom - 0.55 : bottom, 0.0, rotate, 5, null, false);
            if (feature == null) continue;
            objects.add(feature);
        }
        for (i = 0; i < numFeaturesLeft; ++i) {
            rotate = 270;
            if (itemTags.contains("torch")) {
                rotate = 0;
            }
            feature = null;
            feature = centerFeatures && bottom - top == 2.0 ? BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, itemTags.contains("torch") ? left + 0.55 : left, 0.0, top + 1.0, 0.0, rotate, 5, null, false) : BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, itemTags.contains("torch") ? left + 0.55 : left, 0.0, top + 0.5, bottom - top, rotate, 5, null, false);
            if (feature == null) continue;
            objects.add(feature);
        }
        for (i = 0; i < numFeaturesRight; ++i) {
            rotate = 90;
            if (itemTags.contains("torch")) {
                rotate = 180;
            }
            feature = null;
            feature = centerFeatures && bottom - top == 2.0 ? BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, itemTags.contains("torch") ? right - 0.55 : right, 0.0, top + 1.0, 0.0, rotate, 5, null, false) : BattlematDataGenerator.checkAndPlaceFeature(r, true, featureLayer, featureBoundingBoxes, -1.0, -1.0, itemType, itemTags, itemTags.contains("torch") ? right - 0.55 : right, 0.0, top + 0.5, bottom - top, rotate, 5, null, false);
            if (feature == null) continue;
            objects.add(feature);
        }
    }

    public static void breakUpRoomWallsForDoorsWindows(List objects, MapShape room) {
        ArrayList<Rectangle> doorWindowBoundingBoxes = new ArrayList<Rectangle>();
        for (Object o : objects) {
            double fh;
            Feature f;
            Point2D fpt;
            if (!(o instanceof Feature) || (fpt = (f = (Feature)o).getLocation(ViewLevel.BATTLEMAT)) == null || !f.getTypeName().toLowerCase().contains("door") && !f.getTypeName().toLowerCase().contains("window")) continue;
            double fw = f.getScaleFallbackType() * 1.5;
            if (fw < 5.0) {
                fw = 10.0;
            }
            double fx = fpt.getX() - fw;
            double htFactor = f.getScaleHt();
            if (htFactor <= 0.0 && f.getType().getIconHeight() > 0.0) {
                htFactor = f.getScale() * f.getType().getIconHeight() / f.getType().getIconSize();
            }
            if (htFactor <= 0.0) {
                htFactor = f.getScaleHtFallbackType();
            }
            if (htFactor <= 0.0) {
                htFactor = f.getScaleFallbackType();
            }
            if ((fh = htFactor * 1.5) < 10.0) {
                fh = 10.0;
            }
            double fy = fpt.getY() - fh;
            doorWindowBoundingBoxes.add(new Rectangle(fx, fy, fw, fh));
        }
        ArrayList<MapShape> shapes = new ArrayList<MapShape>();
        shapes.add(room);
        MapLogic.breakUpARoomOrWallForDoorsWindows(shapes, doorWindowBoundingBoxes);
        objects.addAll(shapes);
    }

    public static MapShape makeRoom(double left, double top, double right, double bottom, String strokename, double strokewidth, Object fillname, MapLayer shapelayer) {
        return BattlematDataGenerator.makeRoomCreatePolygon(left, top, right, bottom, strokename, strokewidth, fillname, shapelayer, "room");
    }

    public static MapShape makeRoomCreatePolygon(double left, double top, double right, double bottom, String strokename, double strokewidth, Object fillname, MapLayer shapelayer, String tags) {
        ArrayList<Exit> exits = new ArrayList<Exit>();
        return BattlematDataGenerator.makeRoomCreatePolygon(left, top, right, bottom, strokename, strokewidth, fillname, shapelayer, tags, exits);
    }

    public static MapShape makeRoomCreatePolygon(double left, double top, double right, double bottom, String strokename, double strokewidth, Object fillname, MapLayer shapelayer, String tags, List<Exit> exits) {
        Polygon poly = new Polygon();
        poly.getPoints().addAll((Object[])new Double[]{left * 300.0, top * 300.0, left * 300.0, bottom * 300.0, right * 300.0, bottom * 300.0, right * 300.0, top * 300.0});
        MapShape ms = BattlematDataGenerator.makeRoom((Shape)poly, strokename, fillname, strokewidth, shapelayer, tags, exits);
        if (ms != null) {
            double leftDoorY = top + (double)((int)(Math.random() * (double)((int)(bottom - top - 1.0)))) + 0.5;
            double rightDoorY = top + (double)((int)(Math.random() * (double)((int)(bottom - top - 1.0)))) + 0.5;
            double topDoorX = left + (double)((int)(Math.random() * (double)((int)(right - left - 1.0)))) + 0.5;
            double bottomDoorX = left + (double)((int)(Math.random() * (double)((int)(right - left - 1.0)))) + 0.5;
            System.out.println("left: " + left + " right:" + right + " top:" + top + " bottom:" + bottom);
            boolean isCorridor = Math.abs(top - bottom) <= 2.0 || Math.abs(right - left) <= 2.0;
            exits.add(new Exit(left * 300.0, leftDoorY * 300.0, 270.0, !isCorridor));
            exits.add(new Exit(right * 300.0, rightDoorY * 300.0, 90.0, !isCorridor));
            exits.add(new Exit(topDoorX * 300.0, top * 300.0, 0.0, !isCorridor));
            exits.add(new Exit(bottomDoorX * 300.0, bottom * 300.0, 180.0, !isCorridor));
        }
        return ms;
    }

    public static void makeRoom(List<MapShape> shapes, Polygon kitchenpoly, double kitchenleft, double kitchentop, double kitchenright, double kitchenbottom, String strokename, Object fillname, MapLayer shapelayer, String tags) {
        kitchenpoly.getPoints().addAll((Object[])new Double[]{kitchenleft * 300.0, kitchentop * 300.0, kitchenleft * 300.0, kitchenbottom * 300.0, kitchenright * 300.0, kitchenbottom * 300.0, kitchenright * 300.0, kitchentop * 300.0});
        MapShape kitchenms = BattlematDataGenerator.makeRoom((Shape)kitchenpoly, strokename, fillname, shapelayer, tags);
        shapes.add(kitchenms);
    }

    public static MapShape makeRoom(Shape kitchenpoly, String strokename, Object fillname, MapLayer shapelayer, String tags) {
        return BattlematDataGenerator.makeRoom(kitchenpoly, strokename, fillname, 0.1, shapelayer, tags);
    }

    public static MapShape makeRoom(Shape poly, String strokename, Object fillname, double wallwidth, MapLayer shapelayer, String tags) {
        ArrayList<Exit> exits = new ArrayList<Exit>();
        return BattlematDataGenerator.makeRoom(poly, strokename, fillname, wallwidth, shapelayer, tags, exits);
    }

    public static MapShape makeRoom(Shape poly, String strokename, Object fillname, double wallwidth, MapLayer shapelayer, String tags, List<Exit> exits) {
        MapShape ms = new MapShape(ViewLevel.BATTLEMAT, ViewLevel.BATTLEMAT, poly, MapShape.CreationType.BASIC, MapShape.StrokeType.SIMPLE, false, tags, 0.0, 0.0, 0.0, 0.0, true, true, true, true, shapelayer);
        poly.setStrokeWidth(wallwidth);
        if (strokename != null) {
            ImagePattern stroketexture = new ImagePattern(TextureType.ALL_TEXTURES.get(strokename).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
            ms.setStrokeTexture(TextureType.ALL_TEXTURES.get(strokename));
            poly.setStroke((Paint)stroketexture);
        } else {
            poly.setStroke(null);
        }
        if (fillname != null) {
            if (fillname instanceof Color) {
                poly.setFill((Paint)((Color)fillname));
            } else {
                ImagePattern filltexture = new ImagePattern(TextureType.ALL_TEXTURES.get(fillname).getIcon(), 0.0, 0.0, 50.0, 25.0, false);
                ms.setFillTexture(TextureType.ALL_TEXTURES.get(fillname));
                poly.setFill((Paint)filltexture);
            }
        } else {
            poly.setFill(null);
        }
        return ms;
    }
}

