/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.city;

import com.inkwellideas.ographer.generator.city.SettlementData;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.model.NoteTable;
import com.inkwellideas.ographer.model.TableData;
import com.inkwellideas.ographer.util.Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CityDataGenerator {
    public static final SettlementData settlementData = new SettlementData();
    public static String filename = null;

    public static void parseSettings(InputStream is, boolean clearPriorData) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new InputStreamReader(is, StandardCharsets.UTF_8));
            Document doc = documentBuilder.parse(inputSource);
            HashSet<String> capWords = new HashSet<String>();
            CityDataGenerator.addSimpleKeyValues(CityDataGenerator.settlementData.occupations, doc, "occupations", clearPriorData);
            CityDataGenerator.addSimpleKeyValues(CityDataGenerator.settlementData.adventurerBackgrounds, doc, "adventurer_backgrounds", clearPriorData);
            CityDataGenerator.addSimpleKeyValues(CityDataGenerator.settlementData.quirks, doc, "quirks", clearPriorData);
            CityDataGenerator.addSimpleKeyValues(CityDataGenerator.settlementData.specialBuildingNamesKeys, doc, "special_building_names", clearPriorData);
            TreeSet<String> specialBuildingTabs = new TreeSet<String>();
            CityDataGenerator.addSimpleKeyValues(specialBuildingTabs, doc, "special_buildings", clearPriorData);
            CityDataGenerator.addSimpleKeyValues(CityDataGenerator.settlementData.remainingBuildings, doc, "remaining_buildings", clearPriorData);
            CityDataGenerator.parseBuildings(doc, clearPriorData);
            Set<String> buildingNames = CityDataGenerator.settlementData.specialBuildingNamesKeys;
            for (String b : buildingNames) {
                ArrayList<String> names = new ArrayList<String>();
                String xmlkey = b.toLowerCase().trim();
                xmlkey = xmlkey.replaceAll(" ", "_");
                CityDataGenerator.addSimpleKeyValues(names, doc, xmlkey + "_names", capWords, clearPriorData);
                CityDataGenerator.settlementData.specialBuildingNames.put(b, names);
            }
            TreeSet<String> wordlists = new TreeSet<String>();
            CityDataGenerator.addSimpleKeyValues(wordlists, doc, "wordlists", clearPriorData);
            for (String w : wordlists) {
                ArrayList<String> words = new ArrayList<String>();
                CityDataGenerator.addSimpleKeyValues(words, doc, w.toLowerCase() + "_words", clearPriorData);
                CityDataGenerator.settlementData.wordLists.put(w, words);
            }
            CityDataGenerator.parseRaces(doc, clearPriorData);
            CityDataGenerator.parseNamesets(doc, clearPriorData);
            if (clearPriorData) {
                CityDataGenerator.settlementData.specialBuildingTabInfo.clear();
            }
            for (String s : specialBuildingTabs) {
                s = s.trim();
                CityDataGenerator.parseBuildingTabs(doc, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addSimpleKeyValues(ArrayList<String> stringlist, Document doc, String key, boolean clearpriordata) {
        CityDataGenerator.addSimpleKeyValues(stringlist, doc, key, null, clearpriordata);
    }

    private static void addSimpleKeyValues(ArrayList<String> stringlist, Document doc, String key, Set<String> capwords, boolean clearpriordata) {
        if (clearpriordata) {
            stringlist.clear();
        }
        NodeList nl2 = doc.getElementsByTagName(key);
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el = (Element)nl2.item(ik);
            String s = el.getAttribute("options");
            String[] ss = s.split(",");
            for (int i = 0; i < ss.length; ++i) {
                stringlist.add(ss[i]);
                ss[i] = ss[i].trim();
                String[] words = ss[i].split(" ");
                if (capwords == null) continue;
                for (String w : words) {
                    if (!w.equals(w.toUpperCase())) continue;
                    capwords.add(w);
                }
            }
        }
    }

    private static void addSimpleKeyValues(Set<String> stringlist, Document doc, String key, boolean clearpriordata) {
        CityDataGenerator.addSimpleKeyValues(stringlist, doc, key, null, clearpriordata);
    }

    private static void addSimpleKeyValues(Set<String> stringlist, Document doc, String key, Set<String> capwords, boolean clearpriordata) {
        if (clearpriordata) {
            stringlist.clear();
        }
        NodeList nl2 = doc.getElementsByTagName(key);
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el = (Element)nl2.item(ik);
            String s = el.getAttribute("options");
            String[] ss = s.split(",");
            for (int i = 0; i < ss.length; ++i) {
                stringlist.add(ss[i]);
                ss[i] = ss[i].trim();
                String[] words = ss[i].split(" ");
                if (capwords == null) continue;
                for (String w : words) {
                    if (!w.equals(w.toUpperCase())) continue;
                    capwords.add(w);
                }
            }
        }
    }

    private static void parseNamesets(Document doc, boolean clearpriordata) {
        if (clearpriordata) {
            CityDataGenerator.settlementData.personNamesets.clear();
        }
        NodeList nl2 = doc.getElementsByTagName("person_names");
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el = (Element)nl2.item(ik);
            NodeList nl = el.getElementsByTagName("person_nameset");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element en = (Element)nl.item(i);
                String name = en.getAttribute("name");
                String[] options = en.getAttribute("options").split(",");
                ArrayList<String> names = new ArrayList<String>(Arrays.asList(options));
                CityDataGenerator.settlementData.personNamesets.put(name, names);
            }
        }
    }

    private static void parseBuildingTabs(Document doc, String buildingtype) {
        Map tabinfos = CityDataGenerator.settlementData.specialBuildingTabInfo.computeIfAbsent(buildingtype, k -> new HashMap());
        String buildingxmlkey = buildingtype.trim().toLowerCase();
        NodeList nl2 = doc.getElementsByTagName((buildingxmlkey = buildingxmlkey.replaceAll(" ", "_")) + "_tabs");
        if (nl2.getLength() == 0) {
            buildingxmlkey = buildingtype.trim();
            buildingxmlkey = buildingxmlkey.replaceAll(" ", "_");
            nl2 = doc.getElementsByTagName(buildingxmlkey + "_tabs");
        }
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            SettlementData.SpecialBuildingTabInfo tabinfo;
            String type;
            Element el = (Element)nl2.item(ik);
            NodeList nlContains = el.getElementsByTagName("contains");
            for (int i = 0; i < nlContains.getLength(); ++i) {
                Element en = (Element)nlContains.item(i);
                String chanceString = en.getAttribute("chance");
                double chance = 0.5;
                if (!"".equals(chanceString)) {
                    chance = Double.parseDouble(chanceString) / 100.0;
                }
                type = en.getTextContent().trim();
                tabinfo = new SettlementData.SpecialBuildingContainsTabInfo(type, chance);
                tabinfos.put(type, tabinfo);
            }
            NodeList nl = el.getElementsByTagName(buildingxmlkey + "_tab");
            String[] tabnames = new String[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                Element em;
                int j;
                NodeList nl3;
                String tabname;
                Element en = (Element)nl.item(i);
                tabnames[i] = tabname = en.getAttribute("name");
                type = en.getAttribute("type");
                if (type.equals("person")) {
                    tabinfo = (SettlementData.SpecialBuildingPersonTabInfo)tabinfos.get(tabname);
                    HashMap<String, SettlementData.Person> people = new HashMap();
                    if (tabinfo == null) {
                        tabinfo = new SettlementData.SpecialBuildingPersonTabInfo(tabname, type, people);
                    } else {
                        people = ((SettlementData.SpecialBuildingPersonTabInfo)tabinfo).getPeople();
                    }
                    nl3 = en.getElementsByTagName("person");
                    String[] persontypes = new String[nl3.getLength()];
                    for (j = 0; j < nl3.getLength(); ++j) {
                        String persontype;
                        em = (Element)nl3.item(j);
                        persontypes[j] = persontype = em.getAttribute("type");
                        String co = em.getAttribute("childrenMinAgePercent");
                        int childrenMinAge = -1;
                        if (!"".equals(co)) {
                            childrenMinAge = Integer.parseInt(co);
                        }
                        String sf = em.getAttribute("chancefemale");
                        int chancefemale = 50;
                        if (!"".equals(sf)) {
                            chancefemale = Integer.parseInt(sf);
                        }
                        people.put(em.getAttribute("type"), new SettlementData.Person(em.getAttribute("type"), Integer.parseInt(em.getAttribute("mingroups")), Integer.parseInt(em.getAttribute("maxgroups")), Integer.parseInt(em.getAttribute("minpergroup")), Integer.parseInt(em.getAttribute("maxpergroup")), Integer.parseInt(em.getAttribute("chanceadventurer")), chancefemale, childrenMinAge));
                    }
                    tabinfos.put(tabname, tabinfo);
                    continue;
                }
                if (!type.equals("item")) continue;
                tabinfo = (SettlementData.SpecialBuildingItemTabInfo)tabinfos.get(tabname);
                HashMap<String, SettlementData.Item> items = new HashMap();
                if (tabinfo == null) {
                    tabinfo = new SettlementData.SpecialBuildingItemTabInfo(tabname, type, items);
                } else {
                    items = ((SettlementData.SpecialBuildingItemTabInfo)tabinfo).getItems();
                }
                nl3 = en.getElementsByTagName("item");
                String[] itypes = new String[nl3.getLength()];
                for (j = 0; j < nl3.getLength(); ++j) {
                    String maxquantity;
                    String itype;
                    em = (Element)nl3.item(j);
                    itypes[j] = itype = em.getAttribute("type");
                    String availability = em.getAttribute("availability");
                    if (availability == null || "".equals(availability)) {
                        availability = "25";
                    }
                    if ((maxquantity = em.getAttribute("maxquantity")) == null || "".equals(maxquantity)) {
                        maxquantity = "5";
                    }
                    items.put(em.getAttribute("type"), new SettlementData.Item(em.getAttribute("type"), em.getAttribute("unit"), Integer.parseInt(em.getAttribute("min")), Integer.parseInt(em.getAttribute("max")), Integer.parseInt(availability), Integer.parseInt(maxquantity)));
                }
                tabinfos.put(tabname, tabinfo);
            }
        }
        CityDataGenerator.settlementData.specialBuildingTabInfo.put(buildingtype, tabinfos);
    }

    private static void parseBuildings(Document doc, boolean clearpriordata) {
        NodeList nl2 = doc.getElementsByTagName("buildings");
        StringBuilder types = new StringBuilder();
        ArrayList<String> typenamelist = new ArrayList<String>();
        if (clearpriordata) {
            CityDataGenerator.settlementData.buildings.clear();
        }
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el = (Element)nl2.item(ik);
            NodeList nl = el.getElementsByTagName("building");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element en = (Element)nl.item(i);
                String typename = en.getAttribute("type");
                if (types.toString().equals("")) {
                    types = new StringBuilder(typename);
                } else {
                    types.append("\t").append(typename);
                }
                SettlementData.Building building = new SettlementData.Building(en.getAttribute("type"), Integer.parseInt(en.getAttribute("sv")), Boolean.parseBoolean(en.getAttribute("onroad")), Boolean.parseBoolean(en.getAttribute("isfarm")), en.getAttribute("placement"), Integer.parseInt(en.getAttribute("distance")), Boolean.parseBoolean(en.getAttribute("densepack")));
                CityDataGenerator.settlementData.buildings.put(en.getAttribute("type"), building);
                typenamelist.add(typename);
            }
        }
    }

    private static void parseRaces(Document doc, boolean clearpriordata) {
        if (clearpriordata) {
            CityDataGenerator.settlementData.races.clear();
        }
        NodeList nl2 = doc.getElementsByTagName("races");
        StringBuilder races = new StringBuilder();
        for (int ik = 0; ik < nl2.getLength(); ++ik) {
            Element el = (Element)nl2.item(ik);
            NodeList nl = el.getElementsByTagName("race");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element en = (Element)nl.item(i);
                String racename = en.getAttribute("name");
                if (races.toString().equals("")) {
                    races = new StringBuilder(racename);
                } else {
                    races.append(",").append(racename);
                }
                SettlementData.Race race = new SettlementData.Race(en.getAttribute("name"), Integer.parseInt(en.getAttribute("minAge")), Integer.parseInt(en.getAttribute("maxAge")), Integer.parseInt(en.getAttribute("chance")));
                NodeList nl3 = en.getElementsByTagName("culture");
                StringBuilder racecultures = new StringBuilder();
                for (int j = 0; j < nl3.getLength(); ++j) {
                    Element em = (Element)nl3.item(j);
                    String culturename = em.getAttribute("name");
                    if (j == 0) {
                        racecultures = new StringBuilder(culturename);
                    } else {
                        racecultures.append(",").append(culturename);
                    }
                    SettlementData.Language culture = new SettlementData.Language(em.getAttribute("name"), Integer.parseInt(em.getAttribute("chance")));
                    race.languages.add(culture);
                }
                CityDataGenerator.settlementData.races.put(racename, race);
            }
        }
    }

    public static Map<String, Object> getNoteData(String buildingtype) {
        Map<String, Object> tabsout;
        Map<String, SettlementData.SpecialBuildingTabInfo> tabs = CityDataGenerator.settlementData.specialBuildingTabInfo.get(buildingtype = buildingtype.toLowerCase());
        if (tabs == null) {
            String priorkey = null;
            for (String key : CityDataGenerator.settlementData.specialBuildingTabInfo.keySet()) {
                if (!buildingtype.toLowerCase().contains(key.toLowerCase()) || priorkey != null && key.length() <= priorkey.length()) continue;
                tabs = CityDataGenerator.settlementData.specialBuildingTabInfo.get(key);
                priorkey = key;
            }
        }
        if (tabs == null) {
            tabsout = new HashMap<String, Object>();
            tabsout.put("Description", "");
            return tabsout;
        }
        tabsout = CityDataGenerator.getBuildingTabs(tabs);
        ArrayList<String> toAdd = new ArrayList<String>();
        for (SettlementData.SpecialBuildingTabInfo tab : tabs.values()) {
            if (!(tab instanceof SettlementData.SpecialBuildingContainsTabInfo)) continue;
            toAdd.add(tab.getName());
        }
        for (String contained : toAdd) {
            String[] toremove;
            Map<String, Object> moretabs = CityDataGenerator.getBuildingTabs(CityDataGenerator.settlementData.specialBuildingTabInfo.get(contained));
            contained = contained.toLowerCase();
            for (String tr : toremove = new String[]{"future clean ", "future gritty ", "future retro ", "modern ", "medieval "}) {
                if (!contained.startsWith(tr)) continue;
                contained = contained.substring(tr.length());
            }
            String[] buildingnameparts = contained.split(" ");
            Object buildingName = "";
            for (String bn : buildingnameparts) {
                buildingName = (String)buildingName + bn.substring(0, 1).toUpperCase() + bn.substring(1).toLowerCase() + " ";
            }
            for (String key : moretabs.keySet()) {
                tabsout.put((String)buildingName + key, moretabs.get(key));
            }
        }
        return tabsout;
    }

    private static Map<String, Object> getBuildingTabs(Map<String, SettlementData.SpecialBuildingTabInfo> tabs) {
        HashMap<String, Object> tabsout = new HashMap<String, Object>();
        double pricebasis = Math.random();
        for (SettlementData.SpecialBuildingTabInfo tab : tabs.values()) {
            NoteTable table;
            ObservableList data;
            TableData headings;
            if (tab instanceof SettlementData.SpecialBuildingPersonTabInfo) {
                headings = new TableData("Name", "Race", "Age", "Language", "Sex", "Background", "Personality", "Other");
                data = FXCollections.observableArrayList();
                for (SettlementData.Person person : ((SettlementData.SpecialBuildingPersonTabInfo)tab).people.values()) {
                    int numgroups = (int)(Math.random() * ((double)(person.getMaxgroups() - person.getMingroups()) + 0.999)) + person.getMingroups();
                    for (int i = 0; i < numgroups; ++i) {
                        int numpeople = (int)(Math.random() * ((double)(person.getMaxpergroup() - person.getMinpergroup()) + 0.999)) + person.getMinpergroup();
                        boolean isadv = Math.random() * 100.0 < (double)person.getChanceadventurer();
                        List<TableData> people = CityDataGenerator.getPerson(numpeople, person.getType(), !isadv, person.getChancefemale(), person.getChildrenMinAgePercent());
                        data.addAll(people);
                    }
                }
                table = new NoteTable(headings, (ObservableList<TableData>)data);
                tabsout.put(tab.getName(), table);
                continue;
            }
            if (!(tab instanceof SettlementData.SpecialBuildingItemTabInfo)) continue;
            headings = new TableData("Item", "Price", "#Avail", "Notes", "", "", "", "");
            data = FXCollections.observableArrayList();
            CityDataGenerator.addItems((SettlementData.SpecialBuildingItemTabInfo)tab, (ObservableList<TableData>)data, pricebasis);
            table = new NoteTable(headings, (ObservableList<TableData>)data);
            tabsout.put(tab.getName(), table);
        }
        tabsout.put("Description", "");
        return tabsout;
    }

    public static void addItems(SettlementData.SpecialBuildingItemTabInfo tab, ObservableList<TableData> data, double pricebasis) {
        for (SettlementData.Item item : tab.items.values()) {
            if (!(Math.random() * 100.0 < (double)item.getAvailability())) continue;
            int min = item.getMin();
            int max = item.getMax();
            Object price = "varies";
            String unit = item.getUnit();
            if (item.getMax() != 0) {
                int multiplier = 1;
                if (min % 10 == 0 && max % 10 == 0) {
                    multiplier = 10;
                    min /= 10;
                    max /= 10;
                }
                if (min % 100 == 0 && max % 100 == 0) {
                    multiplier = 100;
                    min /= 100;
                    max /= 100;
                }
                price = "" + (int)(pricebasis * (double)(max - min + 1) + (double)min) * multiplier;
            }
            int numberavail = item.getMaxquantity();
            Object numavailstr = "n/a";
            if (numberavail > 0) {
                numavailstr = "" + ((int)(Math.random() * (double)numberavail) + 1);
            } else {
                numberavail = 1000;
            }
            if (numberavail <= 0) continue;
            data.add((Object)new TableData(item.getType(), (String)price + unit, (String)numavailstr, "", "", "", "", ""));
        }
    }

    public static List<TableData> getPerson(int num, String occupation, boolean iscommon, double chancefemale, int childrenMinAge) {
        int random = (int)(Math.random() * 100.0);
        int subtotal = 0;
        SettlementData.Race selectedrace = null;
        for (SettlementData.Race race : CityDataGenerator.settlementData.races.values()) {
            if (random >= (subtotal += race.chance)) continue;
            selectedrace = race;
            break;
        }
        if (selectedrace == null) {
            selectedrace = CityDataGenerator.settlementData.races.get((int)(Math.random() * (double)CityDataGenerator.settlementData.races.size()));
        }
        random = (int)(Math.random() * 100.0);
        subtotal = 0;
        SettlementData.Language selectedculture = null;
        for (SettlementData.Language cc : selectedrace.languages) {
            if (random >= (subtotal += cc.chance)) continue;
            selectedculture = cc;
            break;
        }
        if (selectedculture == null) {
            selectedculture = selectedrace.languages.get((int)(Math.random() * (double)selectedrace.languages.size()));
        }
        ArrayList<TableData> arrayList = new ArrayList<TableData>();
        for (int k = 1; k < num + 1; ++k) {
            Object background;
            boolean isMale = Math.random() * 100.0 >= chancefemale;
            String name = WorldAndNameData.getNameDynamic(selectedculture.getName(), WorldAndNameData.NameType.PersonName, isMale ? "M" : "F");
            if (iscommon) {
                background = occupation != null ? occupation + "/" + CityDataGenerator.settlementData.occupations.get((int)(Math.random() * (double)CityDataGenerator.settlementData.occupations.size())) : CityDataGenerator.settlementData.occupations.get((int)(Math.random() * (double)CityDataGenerator.settlementData.occupations.size()));
            } else {
                background = CityDataGenerator.settlementData.adventurerBackgrounds.get((int)(Math.random() * (double)CityDataGenerator.settlementData.adventurerBackgrounds.size()));
                if (occupation != null) {
                    background = occupation + "/" + (String)background;
                }
            }
            String quirk1 = CityDataGenerator.settlementData.quirks.get((int)(Math.random() * (double)CityDataGenerator.settlementData.quirks.size()));
            String quirk2 = CityDataGenerator.settlementData.quirks.get((int)(Math.random() * (double)CityDataGenerator.settlementData.quirks.size()));
            while (quirk1.equals(quirk2)) {
                quirk2 = CityDataGenerator.settlementData.quirks.get((int)(Math.random() * (double)CityDataGenerator.settlementData.quirks.size()));
            }
            int age = (int)(Math.random() * (double)(selectedrace.maxAge - selectedrace.minAge)) + selectedrace.minAge;
            if (childrenMinAge >= 0) {
                int revisedMinAge = (int)((double)(selectedrace.minAge * childrenMinAge) * 0.01);
                age = (int)(Math.random() * (double)(selectedrace.minAge - revisedMinAge)) + revisedMinAge;
            }
            arrayList.add(new TableData(name, selectedrace.getName(), "" + age, selectedculture.getName(), isMale ? "Male" : "Female", (String)background, quirk1 + " and " + quirk2, ""));
        }
        return arrayList;
    }

    public static String getName(String buildingtype) {
        String[] selectedsplit;
        if (buildingtype == null) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        String buildingkey = buildingtype.toLowerCase();
        buildingkey = buildingkey.replaceAll(" ", "_");
        List<String> formats = CityDataGenerator.settlementData.specialBuildingNames.get(buildingkey);
        String k = buildingkey.toLowerCase();
        String priorkey = null;
        for (String namelistkey : CityDataGenerator.settlementData.specialBuildingNames.keySet()) {
            if (!k.contains(namelistkey.toLowerCase().replaceAll(" ", "_")) || priorkey != null && namelistkey.length() <= priorkey.length()) continue;
            formats = CityDataGenerator.settlementData.specialBuildingNames.get(namelistkey);
            priorkey = namelistkey;
        }
        if (formats == null || formats.size() == 0) {
            return Util.toCamelCase(buildingtype);
        }
        String selected = formats.get((int)(Math.random() * (double)formats.size()));
        selected = selected.trim();
        for (String ss : selectedsplit = selected.split(" ")) {
            if (ss.equals(ss.toUpperCase())) {
                List<String> sopts = CityDataGenerator.settlementData.wordLists.get(ss.toUpperCase());
                if (sopts == null) {
                    name.append("[").append(ss).append(" not found]");
                } else {
                    String selectedopt = sopts.get((int)(Math.random() * (double)sopts.size()));
                    name.append(selectedopt.trim());
                }
            } else {
                name.append(ss);
            }
            name.append(" ");
        }
        name.append("(").append(k).append(")");
        name = new StringBuilder(name.toString().replaceAll("_", " "));
        return name.toString();
    }
}

