/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.generator.city;

import com.inkwellideas.ographer.map.MapDataIO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SettlementData {
    public final Map<String, Race> races = new HashMap<String, Race>();
    public final Map<String, Building> buildings = new TreeMap<String, Building>((s1, s2) -> {
        if (s1.length() > s2.length()) {
            return -1;
        }
        if (s1.length() < s2.length()) {
            return 1;
        }
        return s1.compareTo((String)s2);
    });
    public ArrayList<String> remainingBuildings = new ArrayList();
    public ArrayList<String> adventurerBackgrounds = new ArrayList();
    public ArrayList<String> occupations = new ArrayList();
    public ArrayList<String> quirks = new ArrayList();
    public final Set<String> specialBuildingNamesKeys = new TreeSet<String>();
    public final Map<String, List<String>> specialBuildingNames = new TreeMap<String, List<String>>();
    public final Map<String, List<String>> wordLists = new HashMap<String, List<String>>();
    public final Map<String, Map<String, SpecialBuildingTabInfo>> specialBuildingTabInfo = new HashMap<String, Map<String, SpecialBuildingTabInfo>>();
    public final Map<String, List<String>> personNamesets = new HashMap<String, List<String>>();

    public Map<String, Race> getRaces() {
        return this.races;
    }

    public String createExportString() {
        String xmlkey;
        StringBuilder sb = new StringBuilder();
        sb.append("<datagen>\n");
        sb.append("<buildings>\n");
        for (String buildingkey : this.buildings.keySet()) {
            Building b = this.buildings.get(buildingkey);
            sb.append("<building type=\"").append(b.getName()).append("\" densepack=\"").append(b.isDense()).append("\" distance=\"").append(b.getDistance()).append("\" isfarm=\"").append(b.isFarm()).append("\" onroad=\"").append(b.isOnRoad()).append("\" sv=\"").append(b.getPerPopulation()).append("\" placement=\"").append(b.getPlacement()).append("\"/>");
        }
        sb.append("</buildings>\n");
        if (this.races.size() > 0) {
            sb.append("<races>\n");
            for (Race r : this.races.values()) {
                sb.append("<race name=\"").append(MapDataIO.toEscapedXML(r.getName())).append("\" minAge=\"").append(r.getMinAge()).append("\" maxAge=\"").append(r.getMaxAge()).append("\" chance=\"").append(r.getChance()).append("\">");
                for (Language c : r.languages) {
                    sb.append("<culture name=\"").append(MapDataIO.toEscapedXML(c.name)).append("\" chance=\"").append(c.chance).append("\"/>\n");
                }
                sb.append("</race>\n");
            }
            sb.append("</races>\n");
        }
        sb.append("<adventurer_backgrounds options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.adventurerBackgrounds))).append("\"/>\n");
        sb.append("<occupations options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.occupations))).append("\"/>\n");
        sb.append("<quirks options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.quirks))).append("\"/>\n");
        sb.append("<remaining_buildings options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.remainingBuildings))).append("\"/>\n");
        sb.append("<special_buildings options=\"").append(MapDataIO.toEscapedXML(this.toStringFromSet(this.specialBuildingTabInfo.keySet()))).append("\"/>\n");
        for (String buildingkey : this.specialBuildingTabInfo.keySet()) {
            String xmlbuildingkey = buildingkey.replaceAll(" ", "_");
            sb.append("\t<").append(xmlbuildingkey).append("_tabs>\n");
            Map<String, SpecialBuildingTabInfo> tabs = this.specialBuildingTabInfo.get(buildingkey);
            for (String tabkey : tabs.keySet()) {
                SpecialBuildingTabInfo tabinfo = tabs.get(tabkey);
                if (tabinfo instanceof SpecialBuildingPersonTabInfo) {
                    sb.append("\t\t<").append(xmlbuildingkey).append("_tab name=\"").append(tabinfo.getName()).append("\" type=\"person\">\n");
                    for (Person p : ((SpecialBuildingPersonTabInfo)tabinfo).people.values()) {
                        sb.append("\t\t\t<person type=\"").append(MapDataIO.toEscapedXML(p.getType())).append("\" mingroups=\"").append(p.getMingroups()).append("\" maxgroups=\"").append(p.getMaxgroups()).append("\" minpergroup=\"").append(p.getMinpergroup()).append("\" maxpergroup=\"").append(p.getMaxpergroup()).append("\" chanceadventurer=\"").append(p.getChanceadventurer()).append("\" chancefemale=\"").append(p.getChancefemale()).append("\" childrenMinAgePercent=\"").append(p.getChildrenMinAgePercent()).append("\"/>\n");
                    }
                } else if (tabinfo instanceof SpecialBuildingItemTabInfo) {
                    sb.append("\t\t<").append(xmlbuildingkey).append("_tab name=\"").append(MapDataIO.toEscapedXML(tabinfo.getName())).append("\" type=\"item\">\n");
                    for (Item i : ((SpecialBuildingItemTabInfo)tabinfo).items.values()) {
                        sb.append("\t\t\t<item type=\"").append(MapDataIO.toEscapedXML(i.getType())).append("\" min=\"").append(i.getMin()).append("\" max=\"").append(i.getMax()).append("\" unit=\"").append(MapDataIO.toEscapedXML(i.getUnit())).append("\" availability=\"").append(i.getAvailability()).append("\" maxquantity=\"").append(i.getMaxquantity()).append("\"/>\n");
                    }
                }
                sb.append("\t\t</").append(xmlbuildingkey).append("_tab>\n");
            }
            sb.append("\t</").append(xmlbuildingkey).append("_tabs>\n");
        }
        sb.append("<special_building_names options=\"").append(MapDataIO.toEscapedXML(this.toStringFromSet(this.specialBuildingNames.keySet()))).append("\"/>\n");
        for (String k : this.specialBuildingNames.keySet()) {
            xmlkey = k.toLowerCase().replaceAll(" ", "_");
            sb.append("<").append(xmlkey).append("_names options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.specialBuildingNames.get(k)))).append("\"/>\n");
        }
        sb.append("<wordlists options=\"").append(MapDataIO.toEscapedXML(this.toStringFromSet(this.wordLists.keySet()))).append("\"/>\n");
        for (String k : this.wordLists.keySet()) {
            xmlkey = k.toLowerCase().replaceAll(" ", "_");
            sb.append("<").append(xmlkey).append("_words options=\"").append(MapDataIO.toEscapedXML(this.toStringFromList(this.wordLists.get(k)))).append("\"/>\n");
        }
        sb.append("</datagen>\n");
        return sb.toString();
    }

    private String toStringFromList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String toStringFromSet(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String s : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static class Building {
        String name;
        int perPopulation;
        public boolean onRoad;
        boolean farm;
        String placement;
        int distance;
        boolean dense;

        public Building(String name, int perPopulation, boolean onRoad, boolean farm, String placement, int distance, boolean dense) {
            this.name = name;
            this.perPopulation = perPopulation;
            this.onRoad = onRoad;
            this.farm = farm;
            this.placement = placement;
            this.distance = distance;
            this.dense = dense;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getPerPopulation() {
            return this.perPopulation;
        }

        public boolean isOnRoad() {
            return this.onRoad;
        }

        public boolean isFarm() {
            return this.farm;
        }

        public String getPlacement() {
            return this.placement;
        }

        public void setPlacement(String placement) {
            this.placement = placement;
        }

        public int getDistance() {
            return this.distance;
        }

        public void setDistance(int distance) {
            this.distance = distance;
        }

        public boolean isDense() {
            return this.dense;
        }
    }

    public static class Race {
        String name;
        public int minAge;
        public int maxAge;
        public int chance;
        public final List<Language> languages = new ArrayList<Language>();

        public Race(String name, int minAge, int maxAge, int chance) {
            this.name = name;
            this.minAge = minAge;
            this.maxAge = maxAge;
            this.chance = chance;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getMinAge() {
            return this.minAge;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public int getChance() {
            return this.chance;
        }

        public void setChance(int chance) {
            this.chance = chance;
        }
    }

    public static class Language {
        String name;
        public int chance;

        public Language(String name, int chance) {
            this.name = name;
            this.chance = chance;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getChance() {
            return this.chance;
        }

        public void setChance(int chance) {
            this.chance = chance;
        }
    }

    public static abstract class SpecialBuildingTabInfo {
        String name;

        public SpecialBuildingTabInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class SpecialBuildingPersonTabInfo
    extends SpecialBuildingTabInfo {
        String type;
        public Map<String, Person> people;

        public SpecialBuildingPersonTabInfo(String name, String type, Map<String, Person> people) {
            super(name);
            this.type = type;
            this.people = people;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, Person> getPeople() {
            return this.people;
        }
    }

    public static class Person {
        String type;
        int mingroups;
        int maxgroups;
        int minpergroup;
        int maxpergroup;
        int chanceadventurer;
        int chancefemale;
        int childrenMinAgePercent;

        public Person(String type, int mingroups, int maxgroups, int minpergroup, int maxpergroup, int chanceadventurer, int chancefemale, int childrenMinAge) {
            this.type = type;
            this.mingroups = mingroups;
            this.maxgroups = maxgroups;
            this.minpergroup = minpergroup;
            this.maxpergroup = maxpergroup;
            this.chanceadventurer = chanceadventurer;
            this.chancefemale = chancefemale;
            this.childrenMinAgePercent = childrenMinAge;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getMingroups() {
            return this.mingroups;
        }

        public void setMingroups(int mingroups) {
            this.mingroups = mingroups;
        }

        public int getMaxgroups() {
            return this.maxgroups;
        }

        public void setMaxgroups(int maxgroups) {
            this.maxgroups = maxgroups;
        }

        public int getMinpergroup() {
            return this.minpergroup;
        }

        public void setMinpergroup(int minpergroup) {
            this.minpergroup = minpergroup;
        }

        public int getMaxpergroup() {
            return this.maxpergroup;
        }

        public void setMaxpergroup(int maxpergroup) {
            this.maxpergroup = maxpergroup;
        }

        public int getChanceadventurer() {
            return this.chanceadventurer;
        }

        public void setChanceadventurer(int chanceadventurer) {
            this.chanceadventurer = chanceadventurer;
        }

        public int getChancefemale() {
            return this.chancefemale;
        }

        public void setChancefemale(int chancefemale) {
            this.chancefemale = chancefemale;
        }

        public int getChildrenMinAgePercent() {
            return this.childrenMinAgePercent;
        }

        public void setChildrenMinAgePercent(int co) {
            this.childrenMinAgePercent = co;
        }
    }

    public static class SpecialBuildingItemTabInfo
    extends SpecialBuildingTabInfo {
        String type;
        public Map<String, Item> items;

        public SpecialBuildingItemTabInfo(String name, String type, Map<String, Item> items) {
            super(name);
            this.type = type;
            this.items = items;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, Item> getItems() {
            return this.items;
        }

        public void setItems(Map<String, Item> items) {
            this.items = items;
        }
    }

    public static class Item {
        String type;
        String unit;
        int min;
        int max;
        int availability;
        int maxquantity;

        public Item(String type, String unit, int min, int max, int availability, int maxquantity) {
            this.type = type;
            this.unit = unit;
            this.min = min;
            this.max = max;
            this.availability = availability;
            this.maxquantity = maxquantity;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getAvailability() {
            return this.availability;
        }

        public void setAvailability(int availability) {
            this.availability = availability;
        }

        public int getMaxquantity() {
            return this.maxquantity;
        }

        public void setMaxquantity(int maxquantity) {
            this.maxquantity = maxquantity;
        }
    }

    public static class SpecialBuildingContainsTabInfo
    extends SpecialBuildingTabInfo {
        double chance;

        public SpecialBuildingContainsTabInfo(String name, double chance) {
            super(name);
            this.chance = chance;
        }

        public double getChance() {
            return this.chance;
        }

        public void setChance(double chance) {
            this.chance = chance;
        }
    }
}

