/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.information;

import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Nation
extends Information {
    private List<Culture> cultures;
    private String government;
    private String[] rulers;
    public static final String[] GOVERNMENTS = new String[]{"Monarchy", "Constitutional Monarchy", "Theocracy", "Representative Democracy", "Republic", "Dictatorial", "Oligarchy (eldest)", "Oligarchy (scholars)", "Oligarchy (military)"};

    public static int numRulers(String governmentType) {
        if (GOVERNMENTS[1].equals(governmentType)) {
            return 2;
        }
        if (GOVERNMENTS[6].equals(governmentType) || GOVERNMENTS[7].equals(governmentType) || GOVERNMENTS[8].equals(governmentType)) {
            return (int)(Math.random() * 4.0) + 3;
        }
        return 1;
    }

    public Nation(String name, List<Culture> cultures, String government, String[] rulers, String text) {
        this(name, cultures, government, rulers, text, UUID.randomUUID());
    }

    public Nation(String name, List<Culture> cultures, String government, String[] rulers, String text, UUID uuid) {
        super(name, text, new ArrayList<Information>());
        this.setName(name);
        this.setGovernment(government);
        this.setCultures(cultures);
        this.setRulers(rulers);
        if (text == null || "".equals(text.trim())) {
            this.setText(this.generateInfo());
        } else {
            this.setText(text);
        }
        this.uuid = uuid;
    }

    public void setCultures(List<Culture> cultures) {
        this.cultures = cultures;
    }

    public List<Culture> getCultures() {
        return this.cultures;
    }

    @Override
    public String generateInfo() {
        int i;
        StringBuilder text = new StringBuilder("<h2>" + this.name + "</h2>\n<ul>\n");
        text.append("<li>Government: ").append(this.government).append("</li>");
        if (this.cultures != null && this.cultures.size() > 0) {
            text.append("<li>Cultures: ");
            for (i = 0; i < this.cultures.size() - 1; ++i) {
                text.append(this.cultures.get(i).getName()).append(", ");
            }
            if (this.cultures.size() > 1) {
                text.append("and ").append(this.cultures.get(this.cultures.size() - 1)).append("</li>\n");
            } else {
                text.append(this.cultures.get(this.cultures.size() - 1)).append("</li>\n");
            }
        }
        if (this.rulers != null && this.rulers.length > 0) {
            text.append("<li>Rulers: ");
            for (i = 0; i < this.rulers.length - 1; ++i) {
                text.append(this.rulers[i]).append(", ");
            }
            if (this.rulers.length > 1) {
                text.append("and ").append(this.rulers[this.rulers.length - 1]).append("</li>\n");
            } else {
                text.append(this.rulers[this.rulers.length - 1]).append("</li>\n");
            }
        }
        text.append("</ul>");
        return text.toString();
    }

    public void setGovernment(String government) {
        this.government = government;
    }

    public void setRulers(String[] rulers) {
        this.rulers = rulers;
    }

    @Override
    public String getAdditionalWriteInfo() {
        StringBuilder cs = new StringBuilder();
        for (Culture c : this.cultures) {
            if (c == null) continue;
            if (cs.toString().equals("")) {
                cs = new StringBuilder(String.valueOf(c.uuid));
                continue;
            }
            cs.append(",").append(c.uuid);
        }
        StringBuilder ruler = new StringBuilder();
        for (int i = 0; i < this.rulers.length; ++i) {
            ruler.append(this.rulers[i]);
            if (i >= this.rulers.length - 1) continue;
            ruler.append(", ");
        }
        return " rulers=\"" + String.valueOf(ruler) + "\" government=\"" + this.government + "\" cultures=\"" + String.valueOf(cs) + "\" ";
    }

    @Override
    public String getXMLString() {
        StringBuilder cs = new StringBuilder();
        for (Culture c : this.cultures) {
            if (cs.toString().equals("")) {
                cs = new StringBuilder(String.valueOf(c.uuid));
                continue;
            }
            cs.append(",").append(c.uuid);
        }
        String generalInfo = super.getXMLString();
        StringBuilder ruler = new StringBuilder();
        for (int i = 0; i < this.rulers.length; ++i) {
            ruler.append(this.rulers[i]);
            if (i >= this.rulers.length - 1) continue;
            ruler.append(", ");
        }
        return generalInfo.substring(0, 12) + " rulers=\"" + String.valueOf(ruler) + "\" government=\"" + this.government + "\" cultures=\"" + String.valueOf(cs) + "\" " + generalInfo.substring(12);
    }
}

