/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.information;

import com.inkwellideas.ographer.information.Culture;
import com.inkwellideas.ographer.information.Information;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Religion
extends Information {
    private String type;
    private String[] domains;
    private String holySymbol;
    private Culture culture;
    public static final String TYPE_MONOTHEISM = "Monotheistic";
    public static final String TYPE_PANTHEON = "Pantheon";
    public static final String TYPE_MYSTICAL = "Mystical";
    public static final String TYPE_DEMON_SECT = "Demon Sect";

    public Religion(String name, String type, Culture cs, String[] domains, String holySymbol, String text) {
        this(name, type, cs, domains, holySymbol, text, new ArrayList<Information>());
    }

    public Religion(String name, String type, Culture cs, String[] domains, String holySymbol, String text, List<Information> children) {
        this(name, type, cs, domains, holySymbol, text, children, UUID.randomUUID());
    }

    public Religion(String name, String type, Culture cs, String[] domains, String holySymbol, String text, List<Information> children, UUID uuid) {
        super(name, text, children);
        this.setName(name);
        this.setType(type);
        this.setCulture(cs);
        this.setDomains(domains);
        this.setHolySymbol(holySymbol);
        if (text == null || "".equals(text.trim())) {
            this.setText(this.generateInfo());
        } else {
            this.setText(text);
        }
        this.uuid = uuid;
    }

    public void setDomains(String[] domains) {
        this.domains = domains;
    }

    @Override
    public String generateInfo() {
        StringBuilder text = new StringBuilder("<h2>" + this.name + " (" + this.type + ")</h2>\n<ul>\n");
        if (this.domains != null && this.domains.length > 0) {
            text.append("<li>Domains: ");
            for (int i = 0; i < this.domains.length - 1; ++i) {
                text.append(this.domains[i]).append(", ");
            }
            text.append("and ").append(this.domains[this.domains.length - 1]).append("</li>\n");
        }
        if (this.holySymbol != null) {
            text.append("<li>Holy Symbol: ").append(this.holySymbol).append("</li>\n");
        }
        if (this.culture != null) {
            text.append("<li>From the ").append(this.culture.getName()).append(" culture.</li>\n");
        }
        text.append("</ul>");
        return text.toString();
    }

    public void setCulture(Culture culture) {
        this.culture = culture;
    }

    public Culture getCulture() {
        return this.culture;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setHolySymbol(String holySymbol) {
        this.holySymbol = holySymbol;
    }

    @Override
    public String getAdditionalWriteInfo() {
        StringBuilder ds = new StringBuilder();
        if (this.domains != null) {
            for (String d : this.domains) {
                if (ds.toString().equals("")) {
                    ds = new StringBuilder(d);
                    continue;
                }
                ds.append(",").append(d);
            }
        }
        return " religionType=\"" + this.type + "\" culture=\"" + String.valueOf(this.culture.uuid) + "\" holySymbol=\"" + this.holySymbol + "\" domains=\"" + String.valueOf(ds) + "\" ";
    }

    @Override
    public String getXMLString() {
        StringBuilder ds = new StringBuilder();
        if (this.domains != null) {
            for (String d : this.domains) {
                if (ds.toString().equals("")) {
                    ds = new StringBuilder(d);
                    continue;
                }
                ds.append(",").append(d);
            }
        }
        String generalInfo = super.getXMLString();
        return generalInfo.substring(0, 12) + " religionType=\"" + this.type + "\" culture=\"" + String.valueOf(this.culture.uuid) + "\" holySymbol=\"" + this.holySymbol + "\" domains=\"" + String.valueOf(ds) + "\" " + generalInfo.substring(12);
    }
}

