/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.io;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.io.Import;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.task.ImportCityTask;
import com.inkwellideas.ographer.task.LoadMapTask;
import com.inkwellideas.ographer.task.SaveMapTask;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.widget.DraggableTab;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Dialog;
import javafx.scene.control.Tab;
import javafx.scene.shape.Rectangle;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class FileSaveLoad {
    public static String loadfile = "";
    private final Worldographer worldographer;

    public FileSaveLoad(Worldographer worldographer) {
        this.worldographer = worldographer;
    }

    public void importCityFile(File f) {
        try {
            MapDataSetup data = ImportCityTask.importCity(this.worldographer.getPrimaryStage(), f);
            FileSaveLoad.updateLastUsedDir(f.getParentFile());
            new StartNewMapDialog().startNewMap(data, this.worldographer);
        }
        catch (Exception e) {
            StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while importing your file.", "The exception stacktrace was:", e);
            e.printStackTrace();
        }
    }

    public void exportImage(MapUI mapUI, File f, Rectangle rect, double converttoblue, double dpi, boolean showdialog) {
        converttoblue *= 255.0;
        try {
            BufferedImage bi = mapUI.getSnapShotMapAsImage(rect);
            if (converttoblue >= 0.0) {
                for (int x = 0; x < bi.getWidth(); ++x) {
                    for (int y = 0; y < bi.getHeight(); ++y) {
                        int rgb = bi.getRGB(x, y);
                        Color c = new Color(rgb);
                        int r = c.getRed();
                        int g = c.getGreen();
                        int b = c.getBlue();
                        c = (double)(b = (b + g + r) / 3) < converttoblue ? new Color(44, 153, 206, 255) : new Color(255, 255, 255, 255);
                        bi.setRGB(x, y, c.getRGB());
                    }
                }
            }
            String formatName = "png";
            Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
            while (iw.hasNext()) {
                ImageWriter writer = iw.next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
                IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                this.setDPI(metadata, dpi);
                try (ImageOutputStream stream = ImageIO.createImageOutputStream(f);){
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(bi, null, metadata), writeParam);
                    break;
                }
            }
            FileSaveLoad.updateLastUsedDir(f.getParentFile());
            if (showdialog) {
                StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Export Complete", "Export Complete", "The map image was successfully exported.", null, null);
            }
        }
        catch (Exception ex) {
            System.err.println("Image not saved to disk");
            ex.printStackTrace();
            StandardDialog.showException(this.worldographer.getPrimaryStage(), "Image Not Saved", "Image Not Saved", "There was an error saving your mapimage.", "The exception stacktrace was:", ex);
        }
    }

    public static void flushPrefs() {
        try {
            Preferences.userRoot().node("ROOT_NODE").flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getLastUsedDir() {
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        String f = prefs.get("lastUsedDir", null);
        try {
            File d = new File(f);
            if (d.exists() && d.canRead()) {
                return new File(f);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean saveFile(File file, boolean configonly, boolean showdialog, boolean isautosave) {
        FileSaveLoad.updateLastUsedDir(file.getParentFile());
        try {
            if (configonly) {
                MapData mapData;
                FileSaveLoad fileSaveLoad = this;
                if (fileSaveLoad.worldographer.getMapUI() != null) {
                    FileSaveLoad fileSaveLoad2 = this;
                    mapData = fileSaveLoad2.worldographer.getMapUI().getMapData();
                } else {
                    mapData = null;
                }
                MapDataIO.saveConfigFile(file, mapData);
            } else {
                this.saveFile(file, showdialog, this.worldographer);
                if (!isautosave) {
                    this.updateRecentFilesProperty(file);
                    this.worldographer.worldographerMenuBar.updateRecentMapsMenu();
                }
            }
            if (!configonly) {
                FileSaveLoad fileSaveLoad = this;
                fileSaveLoad.worldographer.getMapUI().getController().getUndoRedoHandler().setChanged(false);
            }
            return true;
        }
        catch (Throwable e) {
            StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while saving your file! \nPlease send the exception (click the arrow/\"Show Details\" to see it) to support@inkwellideas.com.", "The exception stacktrace was:", e);
            e.printStackTrace();
            return false;
        }
    }

    public void saveFile(File f, boolean showdialog, Worldographer worldographer) {
        if (f != null) {
            StyledDialog d2 = null;
            if (showdialog) {
                d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Save File");
            }
            try {
                this.saveFileHelper(f, d2, worldographer.getMapUI());
            }
            catch (Throwable th) {
                if (d2 != null) {
                    d2.close();
                }
                StandardDialog.showException(worldographer.getPrimaryStage(), "Error", "Error", "There was an error while saving your file! \nPlease send the exception (click the arrow/\"Show Details\" to see it) to support@inkwellideas.com.", "The exception stacktrace was:", th);
            }
        }
    }

    private void saveFileHelper(File f, Dialog<?> d2, MapUI mapUI) {
        Platform.runLater(() -> this.worldographer.addStatus("Saving map..."));
        SaveMapTask task = new SaveMapTask(this.worldographer, f, mapUI.getMapData(), mapUI.viewLevel, mapUI.hScrollBar.getValue(), mapUI.vScrollBar.getValue());
        task.setOnSucceeded(wt -> {
            task.getValue();
            if (d2 != null) {
                d2.close();
            }
        });
        task.setOnFailed(evt -> StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error Saving File", "There was a problem saving your file.", "If this issue occurs again, email support@inkwellideas.com with your prior file and copy the details below.", "Details", task.getException()));
        new Thread((Runnable)((Object)task)).start();
    }

    public void updateRecentFilesProperty(File file) {
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        StringBuilder recents = Optional.ofNullable(prefs.get("recent", "")).map(StringBuilder::new).orElse(null);
        if (recents != null) {
            if (recents.length() > 0) {
                int recentLoc = recents.toString().indexOf(file.toString());
                if (recentLoc == 0) {
                    return;
                }
                if (recentLoc > 0) {
                    recents.replace(recentLoc, recentLoc + file.toString().length() + 1, "");
                }
                recents.insert(0, String.valueOf(file) + "\t");
            } else {
                recents = Optional.ofNullable(file.toString()).map(StringBuilder::new).orElse(null);
            }
        }
        String[] recentmaps = new String[]{};
        if (recents != null) {
            recentmaps = recents.toString().split("\\t");
        }
        recents = Optional.ofNullable(recentmaps[0]).map(StringBuilder::new).orElse(null);
        for (int i = 1; i < recentmaps.length && i < 10; ++i) {
            if (recentmaps[i].equals("None")) continue;
            recents = (recents == null ? new StringBuilder("null") : recents).append("\t").append(recentmaps[i]);
        }
        prefs.put("recent", recents == null ? null : recents.toString());
        FileSaveLoad.flushPrefs();
    }

    public static void updateLastUsedDir(File dir) {
        Preferences prefs = Preferences.userRoot().node("com/inkwellideas/worldographer2025");
        prefs.put("lastUsedDir", dir.getAbsolutePath());
        FileSaveLoad.flushPrefs();
    }

    public boolean saveAsFile(boolean configonly) {
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Worldographer XML (*.wxx)", new String[]{"*.wxx"});
        fc.getExtensionFilters().add((Object)extFilter);
        File d = FileSaveLoad.getLastUsedDir();
        if (d != null) {
            fc.setInitialDirectory(d);
        }
        File f = fc.showSaveDialog(null);
        boolean success = false;
        if (f != null && (success = this.saveFile(f, configonly, true, false)) && !configonly) {
            FileSaveLoad fileSaveLoad = this;
            fileSaveLoad.worldographer.getMapUI().getMapData().setFile(f);
            ((DraggableTab)((Object)this.worldographer.tabPane.getSelectionModel().getSelectedItem())).setLabelText(f.getName());
        }
        return success;
    }

    public void importFile(File f, ViewLevel level, int xadj, int yadj, HexOrientation tileorientation) {
        boolean createnew = false;
        if (xadj == -1 && yadj == -1) {
            xadj = 0;
            yadj = 0;
            createnew = true;
        }
        try {
            MapData mapData;
            if (createnew) {
                mapData = null;
            } else {
                FileSaveLoad fileSaveLoad = this;
                mapData = fileSaveLoad.worldographer.getMapUI().getMapData();
            }
            MapDataSetup setup = Import.importFile(this.worldographer, f, level, xadj, yadj, mapData, tileorientation);
            FileSaveLoad.updateLastUsedDir(f.getParentFile());
            if (createnew) {
                new StartNewMapDialog().startNewMap(setup, this.worldographer);
            } else {
                FileSaveLoad fileSaveLoad = this;
                fileSaveLoad.worldographer.getMapUI().draw();
            }
        }
        catch (Exception e) {
            StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while importing your file.", "The exception stacktrace was:", e);
            e.printStackTrace();
        }
    }

    public void loadFile(File f, boolean configonly, int offsetx, int offsety, int rotate, boolean doublesize) {
        if (f != null) {
            StyledDialog d2 = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Worldographer Load FIle");
            try {
                this.loadFileHelper(f, configonly, d2, offsetx, offsety, rotate, doublesize);
            }
            catch (Throwable th) {
                d2.close();
                StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while loading your file.", "The stacktrace was:", th);
            }
        }
    }

    private void loadFileHelper(final File f, final boolean configonly, Dialog<?> d2, final int offsetx, final int offsety, final int rotate, final boolean doublesize) {
        final LoadMapTask task = new LoadMapTask(this.worldographer, f, configonly, offsetx, offsety, rotate, doublesize);
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(this){
            final /* synthetic */ FileSaveLoad this$0;
            {
                this.this$0 = this$0;
            }

            public void handle(WorkerStateEvent wt) {
                MapDataSetup data = (MapDataSetup)task.getValue();
                data.filename = f;
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
                if (configonly) {
                    FileSaveLoad fileSaveLoad = this.this$0;
                    if (fileSaveLoad.worldographer.getMapUI() != null) {
                        for (String k : data.labelStyles.keySet()) {
                            FileSaveLoad fileSaveLoad2 = this.this$0;
                            fileSaveLoad2.worldographer.getMapUI().getMapData().getLabelStyles().put(k, data.labelStyles.get(k));
                        }
                        for (String k : data.shapeStyles.keySet()) {
                            FileSaveLoad fileSaveLoad3 = this.this$0;
                            fileSaveLoad3.worldographer.getMapUI().getMapData().getShapeStyles().put(k, data.shapeStyles.get(k));
                        }
                        this.this$0.worldographer.viewLevelBox.updateOverviewLabel(true);
                        this.this$0.worldographer.terrainToolbox.updateTerrainButtonsFlow();
                        this.this$0.worldographer.featuresToolbox.updateFeatureButtons();
                        this.this$0.worldographer.shapesToolbox.updateShapeStyleList();
                        this.this$0.worldographer.shapesToolbox.updateTextures();
                        this.this$0.worldographer.labelsToolbox.updateTextStylesList();
                        for (Tab tab : this.this$0.worldographer.tabPane.getTabs()) {
                            ViewLevel[] vls;
                            MapUI mu = (MapUI)tab.getContent();
                            for (ViewLevel vl : vls = new ViewLevel[]{ViewLevel.WORLD, ViewLevel.CONTINENT, ViewLevel.KINGDOM, ViewLevel.PROVINCE, ViewLevel.BATTLEMAT, ViewLevel.SETTLEMENT}) {
                                Terrain[][] t = mu.getMapData().getTerrain(vl);
                                if (t == null) continue;
                                Terrain[][] terrainArray = t;
                                int n = terrainArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Terrain[] terrains;
                                    for (Terrain terrain : terrains = terrainArray[i]) {
                                        if (terrain == null) continue;
                                        terrain.setType(terrain.getTypeName());
                                    }
                                }
                            }
                        }
                        FileSaveLoad fileSaveLoad4 = this.this$0;
                        fileSaveLoad4.worldographer.getMapUI().draw();
                    }
                    return;
                }
                if (offsetx != Integer.MAX_VALUE && offsety != Integer.MAX_VALUE) {
                    FileSaveLoad fileSaveLoad = this.this$0;
                    fileSaveLoad.worldographer.getMapUI().getMapData().getNotes().addAll(data.notes);
                    FileSaveLoad fileSaveLoad5 = this.this$0;
                    fileSaveLoad5.worldographer.getMapUI().getMapData().getFeatures().addAll(data.features);
                    FileSaveLoad fileSaveLoad6 = this.this$0;
                    fileSaveLoad6.worldographer.getMapUI().getMapData().getShapes().addAll(data.shapes);
                    FileSaveLoad fileSaveLoad7 = this.this$0;
                    fileSaveLoad7.worldographer.getMapUI().getMapData().getMapLabels().addAll(data.labels);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.SETTLEMENT, rotate, doublesize);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.BATTLEMAT, rotate, doublesize);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.WORLD, rotate, doublesize);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.CONTINENT, rotate, doublesize);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.KINGDOM, rotate, doublesize);
                    this.addToTerrain(offsetx, offsety, data, ViewLevel.PROVINCE, rotate, doublesize);
                    FileSaveLoad fileSaveLoad8 = this.this$0;
                    fileSaveLoad8.worldographer.getMapUI().draw();
                } else {
                    new StartNewMapDialog().startNewMap(data, this.this$0.worldographer);
                }
                this.this$0.worldographer.viewLevelBox.updateOverviewLabel(true);
                this.this$0.worldographer.terrainToolbox.updateTerrainButtonsFlow();
                this.this$0.worldographer.featuresToolbox.updateFeatureButtons();
                this.this$0.worldographer.shapesToolbox.updateTextures();
                this.this$0.worldographer.labelsToolbox.updateTextStylesList();
                new FileSaveLoad(this.this$0.worldographer).updateRecentFilesProperty(f);
                this.this$0.worldographer.worldographerMenuBar.updateRecentMapsMenu();
                FileSaveLoad fileSaveLoad = this.this$0;
                fileSaveLoad.worldographer.getMapUI().hScrollBar.setValue(data.hScrollBar);
                FileSaveLoad fileSaveLoad9 = this.this$0;
                fileSaveLoad9.worldographer.getMapUI().vScrollBar.setValue(data.vScrollBar);
            }

            private void addToTerrain(int offsetx2, int offsety2, MapDataSetup data, ViewLevel vl, int rotate2, boolean doublesize2) {
                Terrain[][] newterrain = data.getTerrainByViewLevel(vl);
                if (newterrain != null) {
                    FileSaveLoad fileSaveLoad = this.this$0;
                    if (fileSaveLoad.worldographer.getMapUI().getMapData().getTerrain(vl) != null) {
                        int tilesWide = newterrain.length;
                        int tilesHigh = newterrain[0].length;
                        for (int i = 0; i < newterrain.length; ++i) {
                            for (int j = 0; j < newterrain[0].length; ++j) {
                                int x = i;
                                int y = j;
                                if (rotate2 != 0) {
                                    if (rotate2 == 90) {
                                        tx = tilesWide - y - 1;
                                        y = x;
                                        x = tx;
                                    } else if (rotate2 == 180) {
                                        tx = tilesWide - x - 1;
                                        y = tilesHigh - y - 1;
                                        x = tx;
                                    } else if (rotate2 == 270) {
                                        tx = y;
                                        y = tilesHigh - x - 1;
                                        x = tx;
                                    }
                                }
                                if (doublesize2) {
                                    FileSaveLoad fileSaveLoad2 = this.this$0;
                                    if (x * 2 + 1 + offsetx2 >= fileSaveLoad2.worldographer.getMapUI().getMapData().getTerrain(vl).length) continue;
                                    FileSaveLoad fileSaveLoad3 = this.this$0;
                                    if (y * 2 + 1 + offsety2 >= fileSaveLoad3.worldographer.getMapUI().getMapData().getTerrain(vl)[x * 2 + 1 + offsetx2].length) continue;
                                    FileSaveLoad fileSaveLoad4 = this.this$0;
                                    fileSaveLoad4.worldographer.getMapUI().getMapData().getTerrain((ViewLevel)vl)[offsetx2 + x * 2][offsety2 + y * 2] = newterrain[i][j].clone();
                                    FileSaveLoad fileSaveLoad5 = this.this$0;
                                    fileSaveLoad5.worldographer.getMapUI().getMapData().getTerrain((ViewLevel)vl)[offsetx2 + x * 2][offsety2 + y * 2 + 1] = newterrain[i][j].clone();
                                    FileSaveLoad fileSaveLoad6 = this.this$0;
                                    fileSaveLoad6.worldographer.getMapUI().getMapData().getTerrain((ViewLevel)vl)[offsetx2 + x * 2 + 1][offsety2 + y * 2] = newterrain[i][j].clone();
                                    FileSaveLoad fileSaveLoad7 = this.this$0;
                                    fileSaveLoad7.worldographer.getMapUI().getMapData().getTerrain((ViewLevel)vl)[offsetx2 + x * 2 + 1][offsety2 + y * 2 + 1] = newterrain[i][j].clone();
                                    continue;
                                }
                                FileSaveLoad fileSaveLoad8 = this.this$0;
                                if (x + offsetx2 >= fileSaveLoad8.worldographer.getMapUI().getMapData().getTerrain(vl).length) continue;
                                FileSaveLoad fileSaveLoad9 = this.this$0;
                                if (y + offsety2 >= fileSaveLoad9.worldographer.getMapUI().getMapData().getTerrain(vl)[x + offsetx2].length) continue;
                                FileSaveLoad fileSaveLoad10 = this.this$0;
                                fileSaveLoad10.worldographer.getMapUI().getMapData().getTerrain((ViewLevel)vl)[x + offsetx2][y + offsety2] = newterrain[i][j];
                            }
                        }
                    }
                }
            }
        });
        task.setOnFailed(evt -> StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error Loading File", "There was a problem loading your file.", "If this issue occurs again, email support@inkwellideas.com with your file and copy the details below.", "Details", task.getException()));
        new Thread((Runnable)((Object)task)).start();
    }

    private void setDPI(IIOMetadata metadata, double dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = dpi / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

