/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.map;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.mapping.ConvertTerrainMappings;
import com.inkwellideas.ographer.map.mapping.TerrainImportMappings;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapDataSetTerrain {
    public static void setTerrainToClassic(Terrain[][] t, List<Feature> features, ViewLevel vl, UndoRedoHandler urh) {
        UndoActionGroup uag = new UndoActionGroup();
        for (int x = 0; x < t.length; ++x) {
            for (int y = 0; y < t[x].length; ++y) {
                String val;
                String key = t[x][y].getTypeName();
                if (key.length() > 9) {
                    key = key.substring(9);
                }
                if ((val = ConvertTerrainMappings.CONVERT_TERRAIN_MAPPINGS_TO_CLASSIC.get(key)) == null) {
                    val = ConvertTerrainMappings.CONVERT_TERRAIN_MAPPINGS_TO_CLASSIC.get(key.substring(0, key.length() - 2));
                }
                if (val != null) {
                    UndoAction ua = new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, val, t[x][y].getTypeName(), x, y, (Object)vl);
                    uag.addAction(ua);
                    t[x][y].setType(val);
                    continue;
                }
                System.err.println("Converting terrain to classic, terrain not found:" + key);
            }
        }
        for (Feature f : features) {
            if (f.getTypeName().equals("Isometric Region/Other Volcano A") || f.getTypeName().equals("Isometric Region/Other Volcano B")) {
                f.setType("Classic/Natural Volcano");
                continue;
            }
            if (!f.getTypeName().equals("Isometric Region/Other Volcano C")) continue;
            f.setType("Classic/Natural Volcano Dormant");
        }
        urh.push(uag);
    }

    public static void setTerrainToIsometric(Terrain[][] t, List<Feature> features, ViewLevel vl, HexOrientation ho, UndoRedoHandler urh) {
        UndoActionGroup uag = new UndoActionGroup();
        String orientation = HexOrientation.ROWS == ho ? "Rows/" : "Cols/";
        System.out.println("Setting isometric");
        for (int x = 0; x < t.length; ++x) {
            for (int y = 0; y < t[x].length; ++y) {
                String key = t[x][y].getTypeName();
                Object val = "ISO " + orientation + ConvertTerrainMappings.CONVERT_TERRAIN_MAPPINGS.get(key);
                ArrayList<String> alternates = new ArrayList<String>();
                for (String s : Terrain.terrainTypes.keySet()) {
                    if (!s.equals(val) && !s.substring(0, s.length() - 2).equals(val)) continue;
                    alternates.add(s);
                }
                if (key.toLowerCase().contains("volcano")) {
                    System.out.println("key:" + key + ":" + alternates.size());
                }
                if (alternates.size() > 0) {
                    val = (String)alternates.get((int)((double)alternates.size() * Math.random()));
                    UndoAction ua = new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, val, t[x][y].getTypeName(), x, y, (Object)vl);
                    uag.addAction(ua);
                    t[x][y].setType((String)val);
                    continue;
                }
                System.err.println("Converting terrain to isometric, terrain not found:" + key);
            }
        }
        for (Feature f : features) {
            if (f.getTypeName().equals("Classic/Natural Volcano")) {
                if (Math.random() < 0.5) {
                    f.setType("Isometric Region/Other Volcano A");
                    continue;
                }
                f.setType("Isometric Region/Other Volcano B");
                continue;
            }
            if (!f.getTypeName().equals("Classic/Natural Volcano Dormant")) continue;
            f.setType("Isometric Region/Other Volcano C");
        }
        if (urh != null) {
            urh.push(uag);
        }
    }

    public static String convertTerrainType(String terraintype, Map<String, TerrainType> terrainTemplateTerrainTypes) {
        String orig = terraintype;
        if ((terraintype = TerrainImportMappings.TERRAIN_IMPORT_MAPPINGS.get(terraintype)) == null) {
            TerrainType tt = Terrain.terrainTypes.get(orig);
            if (tt != null) {
                return orig;
            }
            terraintype = "Empty";
        }
        return terraintype;
    }
}

