/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.model;

import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.map.MapDataIO;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.util.Base64;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.shape.Polygon;
import javax.imageio.ImageIO;

public class FeatureType {
    String type;
    public Image icon;
    Image alternateIcon;
    public double iconSize;
    private double iconHeight = -1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    public boolean isDefaultAndUnchanged;

    public FeatureType(String type, Image icon, boolean isdefault) {
        this.type = type;
        this.icon = icon;
        this.isDefaultAndUnchanged = isdefault;
    }

    public FeatureType(String type, String imagefilename, boolean isdefault) {
        this.type = type;
        this.icon = LoadImage.image(FeatureType.class, imagefilename);
        this.isDefaultAndUnchanged = isdefault;
    }

    public FeatureType(String type, Image icon, Double iconsize, boolean isdefault) {
        this.type = type;
        this.icon = icon;
        this.iconSize = iconsize;
        this.isDefaultAndUnchanged = isdefault;
    }

    public FeatureType(String type, Image icon, Double iconsize, Double iconht, boolean isdefault) {
        this.type = type;
        this.icon = icon;
        this.iconSize = iconsize;
        this.iconHeight = iconht;
        this.isDefaultAndUnchanged = isdefault;
    }

    public boolean isDefaultAndUnchanged() {
        return this.isDefaultAndUnchanged;
    }

    public void setDefaultAndUnchanged(boolean isDefaultAndUnchanged) {
        this.isDefaultAndUnchanged = isDefaultAndUnchanged;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public Image getAlternateIcon() {
        return this.alternateIcon;
    }

    public void setAlternateIcon(Image aIcon) {
        this.alternateIcon = aIcon;
    }

    public double getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(double iconSize) {
        this.iconSize = iconSize;
    }

    public void setIconHeight(double height) {
        this.iconHeight = height;
    }

    public double getIconHeight() {
        return this.iconHeight;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public static Map<String, FeatureType> setupDefaults() {
        Properties props = FeatureType.loadDefaults();
        TreeMap<String, FeatureType> features = new TreeMap<String, FeatureType>();
        for (Object key : props.keySet()) {
            FeatureType ft = FeatureType.setupOneDefault(key, props);
            if (ft == null) continue;
            features.put((String)key, ft);
        }
        return features;
    }

    public static FeatureType setupOneDefault(Object key, Properties props) {
        System.out.println(key);
        String val = props.getProperty((String)key);
        if (val == null) {
            return null;
        }
        String[] vals = val.split("\t");
        try {
            if (vals.length == 2 || vals.length == 3) {
                double w;
                Image img = null;
                if (!vals[0].trim().equals("x")) {
                    img = new Image(Objects.requireNonNull(FeatureType.class.getResourceAsStream(vals[0])));
                }
                double h = -1.0;
                if (img != null && vals[1].equals("*")) {
                    w = img.getWidth() / 300.0;
                    h = img.getHeight() / 300.0;
                } else if (vals[1].contains("/")) {
                    w = Double.parseDouble(vals[1].substring(0, vals[1].indexOf(47)));
                    h = Double.parseDouble(vals[1].substring(vals[1].indexOf(47) + 1));
                } else {
                    w = Double.parseDouble(vals[1]);
                }
                FeatureType ft = new FeatureType((String)key, img, w, true);
                if (vals.length == 3) {
                    ft.setAlternateIcon(new Image(Objects.requireNonNull(FeatureType.class.getResourceAsStream(vals[2]))));
                }
                if (h > 0.0) {
                    ft.setIconHeight(h);
                }
                return ft;
            }
        }
        catch (Exception e) {
            System.err.println("Feature not loaded:" + String.valueOf(key));
            e.printStackTrace();
        }
        return null;
    }

    public static Properties loadDefaults() {
        Properties prop = new Properties();
        try {
            InputStream in = new LoadGeneratorData().getTerrainProperties();
            prop.load(in);
            in.close();
        }
        catch (Exception e) {
            System.err.println("Default feature properties not found.");
        }
        return prop;
    }

    public static void loadUserFeatures(Map<String, FeatureType> features, String folder) {
        File dir = null;
        try {
            dir = new File(folder + File.separator + "features");
            boolean success = FeatureType.loadUserFeaturesHelper("", dir, features);
            if (success && !Worldographer.featureCategories.contains((Object)folder)) {
                Worldographer.featureCategories.add((Object)folder);
            }
        }
        catch (Exception e) {
            System.err.println("Custom Features folder not found: " + String.valueOf(dir));
        }
    }

    public static boolean loadUserFeaturesHelper(String prefix, File dir, Map<String, FeatureType> features) {
        boolean success = false;
        for (File f : Objects.requireNonNull(dir.listFiles())) {
            if (f.isDirectory()) {
                FeatureType.loadUserFeaturesHelper(prefix + f.getName() + " ", f, features);
                continue;
            }
            boolean loadedFile = FeatureType.loadUserFeatureSingleFile(prefix, features, f);
            if (!loadedFile) continue;
            success = true;
        }
        return success;
    }

    public static boolean loadUserFeatureSingleFile(String prefix, Map<String, FeatureType> features, File f) {
        return FeatureType.loadUserFeatureSingleFile(prefix, features, f, null, -1.0, -1.0, 0.0, 0.0, "");
    }

    public static boolean loadUserFeatureSingleFile(String prefix, Map<String, FeatureType> features, final File f, String key, double width, double height, double offsetX, double offsetY, String polygonString) {
        double sizeht;
        double size;
        Object name;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Worldographer.getWorldographer().addStatus("Loading feature: " + f.getName() + " from " + f.getAbsolutePath(), false);
            }
        });
        if (prefix == null) {
            prefix = "";
        }
        if (((String)prefix).endsWith(" ")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        if (((String)prefix).length() > 0 && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        System.out.println("load feature single file:" + (String)prefix + ":" + String.valueOf(f));
        Image image = new Image(f.toURI().toString());
        if (!polygonString.isEmpty()) {
            String[] points = polygonString.split(",");
            Object[] pointInts = new Double[points.length];
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (int i = 0; i < points.length; i += 2) {
                double pt = Double.parseDouble(points[i].trim());
                if (pt < minX) {
                    minX = pt;
                }
                if (pt > maxX) {
                    maxX = pt;
                }
                pointInts[i] = pt;
                double pt2 = Double.parseDouble(points[i + 1].trim());
                if (pt2 < minY) {
                    minY = pt2;
                }
                if (pt2 > maxY) {
                    maxY = pt2;
                }
                pointInts[i + 1] = pt2;
            }
            PixelReader pr = image.getPixelReader();
            WritableImage writableImage = new WritableImage((int)(maxX - minX - 2.0), (int)(maxY - minY - 2.0));
            PixelWriter pw = writableImage.getPixelWriter();
            Polygon polygon = new Polygon();
            polygon.getPoints().addAll(pointInts);
            int x = 0;
            while ((double)x < maxX - minX - 2.0) {
                int y = 0;
                while ((double)y < maxY - minY - 2.0) {
                    if (polygon.contains((double)x + minX + 1.0, (double)y + minY + 1.0)) {
                        pw.setColor(x, y, pr.getColor(x + (int)minX + 1, y + (int)minY + 1));
                    }
                    ++y;
                }
                ++x;
            }
            image = writableImage;
        }
        if (!(((String)(name = f.getName())).toLowerCase().endsWith(".gif") || ((String)name).toLowerCase().endsWith(".jpg") || ((String)name).toLowerCase().endsWith(".png"))) {
            return false;
        }
        if (((String)(name = ((String)name).substring(0, f.getName().lastIndexOf(46)))).contains("-")) {
            try {
                size = Integer.parseInt(((String)name).substring(((String)name).lastIndexOf(45) + 1));
                sizeht = size * image.getHeight() / image.getWidth();
            }
            catch (Exception e) {
                size = image.getWidth() / 3.0;
                sizeht = image.getHeight() / 3.0;
            }
        } else {
            size = image.getWidth() / 3.0;
            sizeht = image.getHeight() / 3.0;
        }
        if (width > 0.0) {
            size = width;
        }
        if (height > 0.0) {
            sizeht = height;
        }
        String structure = "";
        if (f.getAbsolutePath().toLowerCase().contains("structure") && !((String)prefix).toLowerCase().contains("structure")) {
            structure = "Structure/";
        }
        if (((String)name).startsWith("FD-")) {
            name = "Dwarf " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FE-")) {
            name = "Elf " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FH-")) {
            name = "Halfling " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FO-")) {
            name = "Orc " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FT-")) {
            name = "Tree " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FW-")) {
            name = "Wizard " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FC-")) {
            name = "Future Clean " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FG-")) {
            name = "Future Gritty " + ((String)name).substring(3);
        } else if (((String)name).startsWith("FR-")) {
            name = "Future Retro " + ((String)name).substring(3);
        } else if (((String)name).startsWith("F-")) {
            name = "Fantasy " + ((String)name).substring(2);
        } else if (((String)name).startsWith("M-")) {
            name = "Modern " + ((String)name).substring(2);
        } else if (((String)name).startsWith("W-")) {
            name = "Western " + ((String)name).substring(2);
        } else if (((String)name).startsWith("P-")) {
            name = "Post-Apocalypse " + ((String)name).substring(2);
        } else if (((String)name).startsWith("R-")) {
            name = "Rubble " + ((String)name).substring(2);
        }
        name = structure + (String)name;
        if (key == null) {
            key = (String)prefix + (String)name;
        }
        if (((String)key).contains("--")) {
            key = ((String)key).substring(0, ((String)key).indexOf("--"));
        }
        FeatureType ft = sizeht == -1.0 ? new FeatureType((String)key, image, size / 100.0, false) : new FeatureType((String)key, image, size / 100.0, sizeht / 100.0, false);
        ft.setOffsetX(offsetX);
        ft.setOffsetY(offsetY);
        features.put((String)key, ft);
        return true;
    }

    public void writeXMLString(Writer w) throws IOException {
        ByteArrayOutputStream bas;
        w.write("<featuretype type=\"" + MapDataIO.toEscapedXML(this.type) + "\" iconSize=\"" + this.iconSize + "\" iconHeight=\"" + this.iconHeight + "\" offsetX=\"" + this.offsetX + "\" offsetY=\"" + this.offsetY + "\" isDefault=\"" + this.isDefaultAndUnchanged + "\"");
        if (this.alternateIcon != null) {
            w.write(" alternateIcon=\"");
            bas = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)this.alternateIcon, null), "png", bas);
            w.write(Base64.encodeObject((Serializable)bas.toByteArray()));
            w.write("\"");
        }
        w.write(">");
        if (this.icon != null) {
            bas = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)this.icon, null), "png", bas);
            w.write(Base64.encodeObject((Serializable)bas.toByteArray()));
        }
        w.write("</featuretype>\n");
    }
}

