/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.ResourceType;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.util.Pair;

public class ChildMapTask
extends Task<MapData> {
    final MapData mapData;
    final MapUI mapUI;
    final ViewLevel oldViewLevel;
    final ViewLevel newViewLevel;
    int continentFactor;
    int kingdomFactor;
    int provinceFactor;
    final int numChildHexes;
    final boolean addRandomnessToNewTerrain;

    public ChildMapTask(MapUI mapUI, ViewLevel oldViewLevel, ViewLevel newViewLevel, Label status, int numChildHexes, boolean addRandomnessToNewTerrain) {
        this.mapData = mapUI.getMapData();
        this.mapUI = mapUI;
        this.oldViewLevel = oldViewLevel;
        this.newViewLevel = newViewLevel;
        this.numChildHexes = numChildHexes;
        this.addRandomnessToNewTerrain = addRandomnessToNewTerrain;
        status.textProperty().bind((ObservableValue)this.messageProperty());
    }

    protected MapData call() throws InterruptedException {
        this.updateMessage("Starting . . .");
        Terrain[][] before = this.mapData.getTerrain(this.oldViewLevel);
        this.mapUI.setViewLevel(this.newViewLevel);
        if (this.oldViewLevel == ViewLevel.WORLD && this.newViewLevel == ViewLevel.CONTINENT || this.oldViewLevel == ViewLevel.WORLD && this.newViewLevel == ViewLevel.KINGDOM || this.oldViewLevel == ViewLevel.CONTINENT && this.newViewLevel == ViewLevel.KINGDOM || this.oldViewLevel == ViewLevel.KINGDOM && this.newViewLevel == ViewLevel.PROVINCE) {
            this.makeChildMapTEST(before, this.oldViewLevel, this.newViewLevel, this.numChildHexes, this.addRandomnessToNewTerrain);
            this.updateMessage("Made Child Map");
        }
        if (this.oldViewLevel == ViewLevel.CONTINENT && this.newViewLevel == ViewLevel.WORLD || this.oldViewLevel == ViewLevel.KINGDOM && this.newViewLevel == ViewLevel.WORLD || this.oldViewLevel == ViewLevel.KINGDOM && this.newViewLevel == ViewLevel.CONTINENT || this.oldViewLevel == ViewLevel.PROVINCE && this.newViewLevel == ViewLevel.KINGDOM) {
            this.makeParentMapTEST(before, this.oldViewLevel, this.newViewLevel, this.numChildHexes);
            this.updateMessage("Made Parent Map");
        }
        this.mapUI.recaclulateMapSize();
        this.updateMessage("Overall Map size Recalculated.");
        this.mapUI.draw();
        this.updateMessage("Finished.");
        return this.mapData;
    }

    public void makeParentMapTEST(Terrain[][] input, ViewLevel priorvl, ViewLevel vl, int expansionRatio) {
        this.setOffset(priorvl, vl, expansionRatio);
        this.updateMessage("Updating features...");
        for (Feature f : this.mapData.getFeatures()) {
            this.mapData.updateFeatureLocationNewLevel(priorvl, vl, f);
        }
        this.updateMessage("Updating labels...");
        for (MapLabel ml : this.mapData.getMapLabels()) {
            this.mapData.updateMapLabelLocationNewLevel(priorvl, vl, ml);
        }
        for (Note n : this.mapData.getNotes()) {
            this.mapData.updateNoteLocationNewLevel(priorvl, vl, n);
        }
        this.updateMessage("Setting up new terrain level...");
        Terrain[][] t2 = null;
        int halfexpansion = expansionRatio / 2;
        if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
            numcols = input.length / expansionRatio;
            if (input.length % numcols > 0) {
                ++numcols;
            }
            if (input[0].length % (numrows = input[0].length / expansionRatio) > halfexpansion) {
                ++numrows;
            }
            t2 = new Terrain[numcols][numrows];
            count = 0;
            count = 0;
            for (col = 0; col < t2.length; ++col) {
                for (row = 0; row < t2[0].length; ++row) {
                    oldx = col * expansionRatio;
                    oldy = row * expansionRatio + (col % 2 == 0 ? 0 : halfexpansion);
                    t2[col][row] = input[oldx][oldy].clone();
                    this.updateMessage("Creating: " + ++count + "/" + t2.length * t2[0].length);
                }
            }
        } else {
            numcols = input.length / expansionRatio;
            if (input.length % numcols > halfexpansion) {
                ++numcols;
            }
            if (input[0].length % (numrows = input[0].length / expansionRatio) > 0) {
                ++numrows;
            }
            t2 = new Terrain[numcols][numrows];
            count = 0;
            count = 0;
            for (col = 0; col < t2.length; ++col) {
                for (row = 0; row < t2[0].length; ++row) {
                    oldx = col * expansionRatio + (row % 2 == 0 ? 0 : halfexpansion);
                    oldy = row * expansionRatio;
                    t2[col][row] = input[oldx][oldy].clone();
                    this.updateMessage("Creating: " + ++count + "/" + t2.length * t2[0].length);
                }
            }
        }
        this.mapData.setTerrain(t2, this.newViewLevel);
        HashMap extraTerrainNew = new HashMap();
        for (MapLayer ml : this.mapData.getExtraTerrainByLayer().keySet()) {
            Map<Point, Terrain> map = this.mapData.getExtraTerrainByLayer().get(ml);
            HashMap<Point, Terrain> newMap = new HashMap<Point, Terrain>();
            for (Point pt : map.keySet()) {
                Point newPt = new Point(pt.getX() / (double)expansionRatio, pt.getY() / (double)expansionRatio);
                newMap.put(newPt, map.get(pt));
            }
            map.clear();
            extraTerrainNew.put(ml, newMap);
        }
        this.mapData.getExtraTerrainByLayer().clear();
        this.mapData.getExtraTerrainByLayer().putAll(extraTerrainNew);
        this.newViewLevel.setTriangleSize(this.mapData.getView().getTriangleSize(this.oldViewLevel) * expansionRatio, this.mapData);
    }

    public void makeChildMapTEST(Terrain[][] input, ViewLevel priorvl, ViewLevel vl, int expansionRatio, boolean addRandomnessToNewTerrain) {
        int newx;
        Terrain[][] terrainForFeatures = null;
        boolean hasMountains = false;
        boolean hasShores = false;
        ArrayList<String> mountainTypes = new ArrayList<String>();
        ArrayList<String> mountainDeciduousTypes = new ArrayList<String>();
        ArrayList<String> mountainEvergreenTypes = new ArrayList<String>();
        ArrayList<String> mountainJungleTypes = new ArrayList<String>();
        ArrayList<String> mountainMixedTypes = new ArrayList<String>();
        ArrayList<String> mountainArcticTypes = new ArrayList<String>();
        ArrayList<String> volcanoTypes = new ArrayList<String>();
        ArrayList<String> deciduousTerrainTypes = new ArrayList<String>();
        ArrayList<String> evergreenTerrainTypes = new ArrayList<String>();
        ArrayList<String> jungleTerrainTypes = new ArrayList<String>();
        ArrayList<String> mixedTerrainTypes = new ArrayList<String>();
        ArrayList<String> arcticTerrainTypes = new ArrayList<String>();
        ArrayList<String> volcanoTerrainTypes = new ArrayList<String>();
        for (MapLayer mapLayer : this.mapData.getMapLayers()) {
            if (!mapLayer.getName().equals("Mountains")) continue;
            hasMountains = true;
        }
        if (hasMountains) {
            MapLogic.replaceMountainsSetupFeatures(mountainTypes, mountainArcticTypes, mountainDeciduousTypes, mountainEvergreenTypes, mountainJungleTypes, mountainMixedTypes, volcanoTypes);
            MapLogic.replaceMountainsSetupTerrain(this.mapData, arcticTerrainTypes, deciduousTerrainTypes, evergreenTerrainTypes, jungleTerrainTypes, mixedTerrainTypes, volcanoTerrainTypes);
            terrainForFeatures = new Terrain[input.length][input[0].length];
            for (int i = 0; i < terrainForFeatures.length; ++i) {
                for (int j = 0; j < terrainForFeatures[0].length; ++j) {
                    terrainForFeatures[i][j] = null;
                }
            }
        }
        for (Feature feature : this.mapData.getFeatures()) {
            if (feature.getTypeName().startsWith("Isometric Shore ")) {
                hasShores = true;
            }
            if (!feature.getMapLayer().getName().equals("Mountains")) continue;
            Point2D pt = feature.getLocation(priorvl);
            Pair<Integer, Integer> loc = this.mapData.getTerrainFromModelPt(pt.getX(), pt.getY());
            String[] forestTypes = new String[]{"Deciduous", "Evergreen", "Mixed", "Jungle"};
            for (int k = 0; k < forestTypes.length; ++k) {
                System.out.println("got a forest mountain");
                if (!feature.getTypeName().contains(forestTypes[k])) continue;
                terrainForFeatures[((Integer)loc.getKey()).intValue()][((Integer)loc.getValue()).intValue()] = new Terrain("ISO " + (this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? "Cols" : "Rows") + " Mountain " + forestTypes[k] + " Forest A", true);
            }
            if (terrainForFeatures[(Integer)loc.getKey()][(Integer)loc.getValue()] == null) {
                System.out.println("got a plain mountain");
                terrainForFeatures[((Integer)loc.getKey()).intValue()][((Integer)loc.getValue()).intValue()] = new Terrain("ISO " + (this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? "Cols" : "Rows") + " Mountain Base A", true);
            }
            if (priorvl != ViewLevel.WORLD) {
                feature.setWorld(false);
            }
            if (priorvl != ViewLevel.CONTINENT) {
                feature.setContinent(false);
            }
            if (priorvl != ViewLevel.KINGDOM) {
                feature.setKingdom(false);
            }
            if (priorvl == ViewLevel.PROVINCE) continue;
            feature.setProvince(false);
        }
        this.setOffset(priorvl, vl, expansionRatio);
        this.updateMessage("Updating Feature Locations...");
        for (Feature feature : this.mapData.getFeatures()) {
            this.mapData.updateFeatureLocationNewLevel(priorvl, vl, feature);
        }
        this.updateMessage("Updating MapLabel Locations...");
        for (MapLabel mapLabel : this.mapData.getMapLabels()) {
            this.mapData.updateMapLabelLocationNewLevel(priorvl, vl, mapLabel);
        }
        for (Note note : this.mapData.getNotes()) {
            this.mapData.updateNoteLocationNewLevel(priorvl, vl, note);
        }
        Terrain[][] t2 = null;
        int n = 0;
        int startrow = 0;
        this.updateProgress(0L, input.length * input[0].length);
        int halfexpansion = expansionRatio / 2;
        if (this.mapData.getTileOrientation() == HexOrientation.COLUMNS) {
            endcol = input.length;
            endrow = input[0].length;
            t2 = new Terrain[(endcol - n) * expansionRatio][(endrow - startrow) * expansionRatio];
            count = 0;
            for (col = 0; col < t2.length; ++col) {
                for (row = 0; row < t2[0].length; ++row) {
                    t2[col][row] = vl == ViewLevel.PROVINCE ? null : new Terrain("Blank", false);
                    this.updateProgress(++count, t2.length * t2[0].length);
                    this.updateMessage("Allocating " + count + "/" + t2.length * t2[0].length * 2);
                }
            }
            count = 0;
            for (int row = 0; row < input[0].length; ++row) {
                for (int col = 0; col < input.length; ++col) {
                    int newx2 = col * expansionRatio;
                    int newy = row * expansionRatio + (col % 2 == 0 ? 0 : halfexpansion);
                    t2[newx2][newy] = input[col][row].clone();
                    if (terrainForFeatures != null && terrainForFeatures[col][row] != null) {
                        t2[newx2][newy] = terrainForFeatures[col][row].clone();
                    }
                    this.updateMessage("Creating: " + ++count + "/" + input.length * input[0].length);
                }
            }
        } else {
            endcol = input.length;
            endrow = input[0].length;
            t2 = new Terrain[(endcol - n) * expansionRatio][(endrow - startrow) * expansionRatio];
            count = 0;
            for (col = 0; col < t2.length; ++col) {
                for (row = 0; row < t2[0].length; ++row) {
                    t2[col][row] = vl == ViewLevel.PROVINCE ? null : new Terrain("Blank", false);
                    this.updateProgress(++count, t2.length * t2[0].length * 2);
                    this.updateMessage("Allocating " + count + "/" + t2.length * t2[0].length * 2);
                }
            }
            count = 0;
            for (col = 0; col < input.length; ++col) {
                for (row = 0; row < input[0].length; ++row) {
                    int newy = row * expansionRatio;
                    newx = col * expansionRatio + (row % 2 == 0 ? 0 : halfexpansion);
                    t2[newx][newy] = input[col][row].clone();
                    if (terrainForFeatures != null && terrainForFeatures[col][row] != null) {
                        t2[newx][newy] = terrainForFeatures[col][row].clone();
                    }
                    this.updateMessage("Creating: " + ++count + "/" + input.length * input[0].length);
                }
            }
        }
        if (this.newViewLevel != ViewLevel.PROVINCE) {
            this.runNearestNeighborFill(t2, expansionRatio, addRandomnessToNewTerrain);
        }
        this.newViewLevel.setTriangleSize(this.mapData.getView().getTriangleSize(this.oldViewLevel) * expansionRatio, this.mapData);
        this.mapData.setTerrain(t2, this.newViewLevel);
        if (hasMountains) {
            MapLogic.replaceMountains(new UndoActionGroup(), this.newViewLevel, this.mapData, t2, this.mapData.getMapLayer("Mountains"));
        }
        if (hasShores) {
            String colsOrRows = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? "Cols" : "Rows";
            for (Feature f : this.mapData.getFeatures()) {
                Point2D pt = f.getLocation(this.oldViewLevel);
                if (pt == null || !f.getTypeName().startsWith("Isometric Shore ")) continue;
                if (f.isWorld() && this.oldViewLevel != ViewLevel.WORLD) {
                    f.setWorld(false);
                }
                if (f.isContinent() && this.oldViewLevel != ViewLevel.CONTINENT) {
                    f.setContinent(false);
                }
                if (f.isKingdom() && this.oldViewLevel != ViewLevel.KINGDOM) {
                    f.setKingdom(false);
                }
                if (f.isProvince() && this.oldViewLevel != ViewLevel.PROVINCE) {
                    f.setProvince(false);
                }
                Image image = f.getType().getIcon();
                Pair<Integer, Integer> terrainCoordinate = this.mapData.getTerrainFromModelPt(pt.getX(), pt.getY());
                newx = (Integer)terrainCoordinate.getKey() * expansionRatio;
                int newy = (Integer)terrainCoordinate.getValue() * expansionRatio + ((Integer)terrainCoordinate.getKey() % 2 == 0 ? 0 : halfexpansion);
                double imageSectionWidth = image.getWidth() / (double)(expansionRatio * 4 / 3 - 1);
                double imageSectionHeight = image.getHeight() / (double)expansionRatio;
                for (int x = 0; x < expansionRatio * 4 / 3; ++x) {
                    for (int y = 0; y < expansionRatio; ++y) {
                        int row;
                        boolean isWater = true;
                        for (int i = 0; i < 2; ++i) {
                            double imageX = imageSectionWidth * (double)x - imageSectionWidth / 2.0 + imageSectionWidth * (double)(i + 1) / 3.0;
                            if (imageX < 0.0 || imageX > image.getWidth() - 1.0) continue;
                            for (int j = 0; j < 2; ++j) {
                                PixelReader pr;
                                double imageY = imageSectionHeight * (double)y - imageSectionHeight / 2.0 + imageSectionHeight * (double)(j + 1) / 3.0;
                                if (imageY < 0.0 || imageY > image.getHeight() - 1.0) continue;
                                if (f.isHorizontalFlip()) {
                                    imageX = image.getWidth() - imageX;
                                }
                                if (f.isVerticalFlip()) {
                                    imageY = image.getHeight() - imageY;
                                }
                                if (!((pr = image.getPixelReader()).getColor((int)imageX, (int)imageY).getOpacity() < 0.5)) continue;
                                isWater = false;
                                break;
                            }
                            if (!isWater) break;
                        }
                        if (!isWater) continue;
                        int col = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? newx + x - (expansionRatio * 4 / 3 - 1) / 2 : newx + x - expansionRatio / 2;
                        int n2 = row = this.mapData.getTileOrientation() == HexOrientation.COLUMNS ? newy + y - expansionRatio / 2 : newy + y - (expansionRatio * 4 / 3 - 1) / 2;
                        if (col < 0 || col >= t2.length || row < 0 || row >= t2[0].length) continue;
                        Terrain t = new Terrain("ISO " + colsOrRows + " Water Sea", true);
                        ArrayList<Terrain> tl = new ArrayList<Terrain>();
                        tl.add(t);
                        this.mapData.changeTerrain(new UndoActionGroup(), tl, new Point2D((double)col, (double)row), this.newViewLevel, this.newViewLevel, false, null, false, false, false, 100, t2[col][row].getExtraInfo().getResources());
                    }
                }
            }
        }
        HashMap extraTerrainNew = new HashMap();
        for (MapLayer ml : this.mapData.getExtraTerrainByLayer().keySet()) {
            Map<Point, Terrain> map = this.mapData.getExtraTerrainByLayer().get(ml);
            HashMap<Point, Terrain> newMap = new HashMap<Point, Terrain>();
            for (Point pt : map.keySet()) {
                Point newPt = new Point(pt.getX() * (double)expansionRatio, pt.getY() * (double)expansionRatio);
                newMap.put(newPt, map.get(pt));
            }
            map.clear();
            extraTerrainNew.put(ml, newMap);
        }
        this.mapData.getExtraTerrainByLayer().clear();
        this.mapData.getExtraTerrainByLayer().putAll(extraTerrainNew);
    }

    private void setOffset(ViewLevel priorvl, ViewLevel newvl, int spi) {
        switch (priorvl) {
            case WORLD: {
                switch (newvl) {
                    case WORLD: {
                        return;
                    }
                    case CONTINENT: {
                        this.continentFactor = spi;
                        this.mapData.getView().setContinentFactor(this.continentFactor);
                        Pair<Double, Double> p1 = this.computeOffsets(this.continentFactor);
                        this.mapData.getView().setWorldToContinentHOffset((Double)p1.getKey());
                        this.mapData.getView().setWorldToContinentVOffset((Double)p1.getValue());
                        return;
                    }
                    case KINGDOM: {
                        this.kingdomFactor = spi;
                        this.mapData.getView().setKingdomFactor(this.kingdomFactor);
                        Pair<Double, Double> p2 = this.computeOffsets(this.mapData.getView().getContinentFactor() * this.kingdomFactor);
                        this.mapData.getView().setContinentToKingdomHOffset((Double)p2.getKey());
                        this.mapData.getView().setContinentToKingdomVOffset((Double)p2.getValue());
                        return;
                    }
                    case PROVINCE: {
                        this.provinceFactor = spi;
                        this.mapData.getView().setProvinceFactor(this.provinceFactor);
                        Pair<Double, Double> p3 = this.computeOffsets(this.mapData.getView().getProvinceFactor() * this.mapData.getView().getContinentFactor() * this.kingdomFactor);
                        this.mapData.getView().setKingdomToProvinceHOffset((Double)p3.getKey());
                        this.mapData.getView().setKingdomToProvinceVOffset((Double)p3.getValue());
                        return;
                    }
                }
            }
            case CONTINENT: {
                switch (newvl) {
                    case WORLD: {
                        this.continentFactor = spi;
                        this.mapData.getView().setContinentFactor(this.continentFactor);
                        Pair<Double, Double> p1 = this.computeOffsets(this.continentFactor);
                        this.mapData.getView().setWorldToContinentHOffset((Double)p1.getKey());
                        this.mapData.getView().setWorldToContinentVOffset((Double)p1.getValue());
                        return;
                    }
                    case CONTINENT: {
                        return;
                    }
                    case KINGDOM: {
                        this.kingdomFactor = spi;
                        this.mapData.getView().setKingdomFactor(this.kingdomFactor);
                        Pair<Double, Double> p2 = this.computeOffsets(this.kingdomFactor);
                        this.mapData.getView().setContinentToKingdomHOffset((Double)p2.getKey());
                        this.mapData.getView().setContinentToKingdomVOffset((Double)p2.getValue());
                        return;
                    }
                    case PROVINCE: {
                        this.provinceFactor = spi;
                        this.mapData.getView().setProvinceFactor(this.provinceFactor);
                        Pair<Double, Double> p3 = this.computeOffsets(this.mapData.getView().getProvinceFactor() * this.kingdomFactor);
                        this.mapData.getView().setKingdomToProvinceHOffset((Double)p3.getKey());
                        this.mapData.getView().setKingdomToProvinceVOffset((Double)p3.getValue());
                        return;
                    }
                }
            }
            case KINGDOM: {
                switch (newvl) {
                    case WORLD: {
                        this.continentFactor = spi;
                        this.mapData.getView().setContinentFactor(this.continentFactor);
                        Pair<Double, Double> p1 = this.computeOffsets(this.mapData.getView().getKingdomFactor() * this.continentFactor);
                        this.mapData.getView().setWorldToContinentHOffset((Double)p1.getKey());
                        this.mapData.getView().setWorldToContinentVOffset((Double)p1.getValue());
                        return;
                    }
                    case CONTINENT: {
                        this.kingdomFactor = spi;
                        this.mapData.getView().setKingdomFactor(this.kingdomFactor);
                        Pair<Double, Double> p2 = this.computeOffsets(this.kingdomFactor);
                        this.mapData.getView().setContinentToKingdomHOffset((Double)p2.getKey());
                        this.mapData.getView().setContinentToKingdomVOffset((Double)p2.getValue());
                        return;
                    }
                    case KINGDOM: {
                        return;
                    }
                    case PROVINCE: {
                        this.provinceFactor = spi;
                        this.mapData.getView().setProvinceFactor(this.provinceFactor);
                        Pair<Double, Double> p3 = this.computeOffsets(this.provinceFactor);
                        this.mapData.getView().setKingdomToProvinceHOffset((Double)p3.getKey());
                        this.mapData.getView().setKingdomToProvinceVOffset((Double)p3.getValue());
                        return;
                    }
                }
            }
            case PROVINCE: {
                switch (newvl) {
                    case WORLD: {
                        this.continentFactor = spi;
                        this.mapData.getView().setContinentFactor(this.mapData.getView().getContinentFactor());
                        Pair<Double, Double> p1 = this.computeOffsets(this.mapData.getView().getProvinceFactor() * this.mapData.getView().getKingdomFactor() * this.continentFactor);
                        this.mapData.getView().setWorldToContinentHOffset((Double)p1.getKey());
                        this.mapData.getView().setWorldToContinentVOffset((Double)p1.getValue());
                        return;
                    }
                    case CONTINENT: {
                        this.kingdomFactor = spi;
                        this.mapData.getView().setKingdomFactor(this.kingdomFactor);
                        Pair<Double, Double> p2 = this.computeOffsets(this.mapData.getView().getProvinceFactor() * this.kingdomFactor);
                        this.mapData.getView().setContinentToKingdomHOffset((Double)p2.getKey());
                        this.mapData.getView().setContinentToKingdomVOffset((Double)p2.getValue());
                        return;
                    }
                    case KINGDOM: {
                        this.provinceFactor = spi;
                        this.mapData.getView().setProvinceFactor(this.provinceFactor);
                        Pair<Double, Double> p = this.computeOffsets(this.provinceFactor);
                        this.mapData.getView().setKingdomToProvinceHOffset((Double)p.getKey());
                        this.mapData.getView().setKingdomToProvinceVOffset((Double)p.getValue());
                        return;
                    }
                    case PROVINCE: {
                        return;
                    }
                }
            }
        }
    }

    private Pair<Double, Double> computeOffsets(int factor) {
        return new Pair((Object)(((double)factor - 1.0) / 2.0), (Object)(((double)factor - 1.0) / 2.0));
    }

    protected void runNearestNeighborFill(Terrain[][] terrainorig, int expansionRatio, boolean addRandomnessToNewTerrain) {
        int y;
        int x;
        Terrain[][] terrainCopy = new Terrain[terrainorig.length][terrainorig[0].length];
        this.updateMessage("Copying");
        int count = 0;
        int total = terrainorig.length * terrainorig[0].length;
        for (x = 0; x < terrainorig.length; ++x) {
            for (y = 0; y < terrainorig[0].length; ++y) {
                terrainCopy[x][y] = terrainorig[x][y] == null ? null : new Terrain(terrainorig[x][y].getTypeName(), false);
                this.updateMessage("Copying: " + ++count + "/" + total);
            }
        }
        count = 0;
        for (x = 0; x < terrainorig.length; ++x) {
            for (y = 0; y < terrainorig[0].length; ++y) {
                ChildMapTask.runNearestNeighborFillSingle(this.mapData, terrainorig, terrainCopy, x, y, expansionRatio, addRandomnessToNewTerrain, 0, 0);
                this.updateMessage("Fill in hexes: " + ++count + "/" + total);
            }
        }
    }

    public static void runNearestNeighborFillSingle(MapData md, Terrain[][] terrainOrig, Terrain[][] terrainCopy, int x, int y, int levelFacter, boolean addRandomnessToNewTerrain, int xStart, int yStart) {
        if (terrainCopy[x - xStart][y - yStart] == null || terrainCopy[x - xStart][y - yStart].getTypeName().equals("Blank")) {
            TreeMap<Double, Point> distancesToClosestHexes = new TreeMap<Double, Point>();
            TreeMap<Double, String> distancesToTerrainNames = new TreeMap<Double, String>();
            TreeSet<Double> distances = new TreeSet<Double>();
            int maxx = Math.min(terrainOrig.length, x + levelFacter);
            for (int x2 = Math.max(0, x - levelFacter); x2 < maxx; ++x2) {
                double adjx2 = md.getTileOrientation() == HexOrientation.COLUMNS ? (double)x2 : (double)x2 - 0.4;
                int maxy = Math.min(terrainOrig[0].length, y + levelFacter);
                for (int y2 = Math.max(0, y - levelFacter); y2 < maxy; ++y2) {
                    double adjy2;
                    double d = adjy2 = md.getTileOrientation() == HexOrientation.COLUMNS ? (double)y2 - 0.4 : (double)y2;
                    if (x2 - xStart < 0 || y2 - yStart < 0 || terrainCopy[x2 - xStart][y2 - yStart] == null || terrainCopy[x2 - xStart][y2 - yStart].getTypeName().equals("Blank") || !terrainCopy[x2 - xStart][y2 - yStart].isSavable()) continue;
                    double rand = 0.0;
                    double distance = Math.abs((double)x - adjx2) + Math.abs((double)y - adjy2) + rand;
                    if (terrainCopy[x2 - xStart][y2 - yStart].getTypeName().equals("Empty")) continue;
                    Double d2 = distance + Math.random() / 1000.0;
                    distances.add(d2);
                    distancesToClosestHexes.put(d2, new Point(x2, y2));
                    distancesToTerrainNames.put(d2, terrainCopy[x2 - xStart][y2 - yStart].getTypeName());
                }
            }
            if (distancesToClosestHexes.size() == 0) {
                return;
            }
            if (terrainOrig[x][y] == null) {
                terrainOrig[x][y] = new Terrain("Blank", false);
            }
            boolean tries = false;
            double totalDistances = 0.0;
            Iterator maxy = distances.iterator();
            while (maxy.hasNext()) {
                double d = (Double)maxy.next();
                totalDistances += d;
            }
            Point chosenHex = null;
            double randomDistance = Math.random() * totalDistances;
            double priorDistance = 0.0;
            Double[] distancesArray = distances.toArray(new Double[0]);
            for (int i = 0; i < distancesArray.length; ++i) {
                double d = distancesArray[i];
                double distanceToCompare = distancesArray[distancesArray.length - 1 - i] + priorDistance;
                if (randomDistance < distanceToCompare) {
                    chosenHex = (Point)distancesToClosestHexes.get(d);
                    break;
                }
                priorDistance = priorDistance + (Double)distances.last() - d;
            }
            if (chosenHex == null) {
                chosenHex = (Point)distancesToClosestHexes.get(distances.first());
            }
            terrainOrig[x][y].setType(MapLogic.getNewType(terrainOrig[(int)chosenHex.getX()][(int)chosenHex.getY()].getTypeName(), addRandomnessToNewTerrain), false);
            terrainOrig[x][y].setIcy(terrainOrig[(int)chosenHex.getX()][(int)chosenHex.getY()].isIcy());
            terrainOrig[x][y].setBackgroundColor(terrainOrig[(int)chosenHex.getX()][(int)chosenHex.getY()].getBackgroundColor());
            int elev = terrainOrig[(int)chosenHex.getX()][(int)chosenHex.getY()].getElevation();
            terrainOrig[x][y].setElevation((int)((double)elev * 0.9 + Math.random() * (double)elev * 0.2));
            for (ResourceType k : ResourceType.values()) {
                byte b = terrainOrig[(int)chosenHex.getX()][(int)chosenHex.getY()].getExtraInfo().getOneResource(k.name());
                b = (byte)((double)b * 0.9 + Math.random() * (double)b * 0.2);
                terrainOrig[x][y].setOneResource(k.name(), b);
            }
        } else {
            if (terrainOrig[x][y] == null) {
                terrainOrig[x][y] = new Terrain("Blank", false);
            }
            terrainOrig[x][y].setType(terrainOrig[x][y].getTypeName(), false);
            terrainOrig[x][y].setElevation(terrainOrig[x][y].getElevation());
            int elev = terrainOrig[x][y].getElevation();
            terrainOrig[x][y].setElevation((int)((double)elev * 0.9 + Math.random() * (double)elev * 0.2));
            for (ResourceType k : ResourceType.values()) {
                byte b = terrainOrig[x][y].getExtraInfo().getOneResource(k.name());
                b = (byte)((double)b * 0.9 + Math.random() * (double)b * 0.2);
                terrainOrig[x][y].setOneResource(k.name(), b);
            }
        }
    }

    public static void runNearestNeighborFillProvinceSingle(MapData md, Terrain[][] terrain, int x, int y, int levelFactor, boolean addRandomnessToNewTerrain) {
        if (terrain[x][y] == null || terrain[x][y].getTypeName().equals("Blank")) {
            double closestdistance = Double.MAX_VALUE;
            Point closestHex = null;
            int maxx = Math.min(terrain.length, x + levelFactor);
            for (int x2 = Math.max(0, x - levelFactor); x2 < maxx; ++x2) {
                double adjx2 = md.getTileOrientation() == HexOrientation.COLUMNS ? (double)x2 - 0.5 : (double)x2 - 0.5;
                int maxy = Math.min(terrain[0].length, y + levelFactor);
                for (int y2 = Math.max(0, y - levelFactor); y2 < maxy; ++y2) {
                    double adjy2;
                    double d = adjy2 = md.getTileOrientation() == HexOrientation.COLUMNS ? (double)y2 - 0.5 : (double)y2;
                    if (x2 < 0 || y2 < 0 || md.getTileOrientation() == HexOrientation.COLUMNS && (x2 % levelFactor != 0 || x2 / levelFactor % 2 == 0 && y2 % levelFactor != 0 || x2 / levelFactor % 2 == 1 && y2 % levelFactor != levelFactor / 2) || md.getTileOrientation() == HexOrientation.ROWS && (y2 % levelFactor != 0 || y2 / levelFactor % 2 == 0 && x2 % levelFactor != 0 || y2 / levelFactor % 2 == 1 && x2 % levelFactor != levelFactor / 2) || terrain[x2][y2] == null || terrain[x2][y2].getTypeName().equals("Blank") || !terrain[x2][y2].isSavable()) continue;
                    double distance = Math.abs((double)x - adjx2) + Math.abs((double)y - adjy2);
                    if (terrain[x2][y2].getTypeName().equals("Empty") || !(distance < closestdistance)) continue;
                    closestdistance = distance;
                    closestHex = new Point(x2, y2);
                }
            }
            if (closestdistance == Double.MAX_VALUE) {
                return;
            }
            if (terrain[x][y] == null) {
                terrain[x][y] = new Terrain("Blank", false);
            }
            if (closestHex == null || terrain[x][y] == null) {
                System.out.println("closesthex null");
            }
            int closestHexX = (int)closestHex.getX();
            int closestHexY = (int)closestHex.getY();
            terrain[x][y].setType(MapLogic.getNewType(terrain[closestHexX][closestHexY].getTypeName(), addRandomnessToNewTerrain), false);
            terrain[x][y].setIcy(terrain[closestHexX][closestHexY].isIcy());
            terrain[x][y].setBackgroundColor(terrain[closestHexX][closestHexY].getBackgroundColor());
            int elev = terrain[closestHexX][closestHexY].getElevation();
            terrain[x][y].setElevation((int)((double)elev * 0.9 + Math.random() * (double)elev * 0.2));
            for (ResourceType k : ResourceType.values()) {
                byte b = terrain[closestHexX][closestHexY].getExtraInfo().getOneResource(k.name());
                b = (byte)((double)b * 0.9 + Math.random() * (double)b * 0.2);
                terrain[x][y].setOneResource(k.name(), b);
            }
            terrain[x][y].setSavable(false);
        } else {
            if (terrain[x][y] == null) {
                terrain[x][y] = new Terrain("Blank", false);
            }
            terrain[x][y].setType(terrain[x][y].getTypeName(), false);
            terrain[x][y].setElevation(terrain[x][y].getElevation());
            int elev = terrain[x][y].getElevation();
            terrain[x][y].setElevation((int)((double)elev * 0.9 + Math.random() * (double)elev * 0.2));
            for (ResourceType k : ResourceType.values()) {
                byte b = terrain[x][y].getExtraInfo().getOneResource(k.name());
                b = (byte)((double)b * 0.9 + Math.random() * (double)b * 0.2);
                terrain[x][y].setOneResource(k.name(), b);
            }
        }
    }
}

