/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.information.Information;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javafx.concurrent.Task;
import javafx.scene.paint.Color;
import javafx.util.Pair;

public class GenerateEmpiresTask
extends Task<MapData> {
    final MapUI mapUI;
    final Worldographer worldographer;
    List<Information> nations;
    ViewLevel vl;
    MapData mapData;
    UndoActionGroup uag;
    int numberEmpiresToAdd;
    int distanceBetweenFeatures;
    Color oneColor;
    boolean fill;
    Set<Note> notes;
    int sizeLimit;
    Random random;
    double hexCrawlLandFreq;
    double hexCrawlWaterFreq;
    boolean includeVillages;
    boolean includeRuins;
    boolean useCurves;
    boolean fractalize;
    Color mainRoadColor;
    Color secondRoadColor;
    String coastType;
    boolean convertOceanToSea;
    int numberRivers;
    String riverType;
    boolean coasts;
    boolean rivers;
    boolean empires;
    boolean hexCrawl;
    boolean roads;

    public GenerateEmpiresTask(Worldographer worldographer, MapUI mapUI, List<Information> nations, UndoActionGroup uag, int numberToAdd, Color oneColor, boolean fill, Set<Note> notes, int sizeLimit, int distanceBetweenFeatures) {
        this(false, false, true, false, false, worldographer, mapUI, nations, uag, "", false, 0, "", numberToAdd, oneColor, fill, notes, sizeLimit, null, 0.0, 0.0, false, false, false, false, null, null, distanceBetweenFeatures);
    }

    public GenerateEmpiresTask(boolean coasts, boolean rivers, boolean empires, boolean hexCrawl, boolean roads, Worldographer worldographer, MapUI mapUI, List<Information> nations, UndoActionGroup uag, String coastType, boolean convertOceanToSea, int numRivers, String riverType, int numberEmpiresToAdd, Color oneColor, boolean fill, Set<Note> notes, int sizeLimit, Random r, double hexCrawlLandFreq, double hexCrawlWaterFreq, boolean includeVillages, boolean includeRuins, boolean useCurves, boolean fractalize, Color mainRoadColor, Color secondRoadColor, int distanceBetweenFeatures) {
        this.coasts = coasts;
        this.rivers = rivers;
        this.empires = empires;
        this.hexCrawl = hexCrawl;
        this.roads = roads;
        this.worldographer = worldographer;
        this.mapUI = mapUI;
        this.mapData = mapUI.getMapData();
        this.nations = nations;
        this.uag = uag;
        this.coastType = coastType;
        this.convertOceanToSea = convertOceanToSea;
        this.numberEmpiresToAdd = numberEmpiresToAdd;
        this.numberRivers = numRivers;
        this.riverType = riverType;
        this.oneColor = oneColor;
        this.fill = fill;
        this.notes = notes;
        this.sizeLimit = sizeLimit;
        this.random = r;
        this.hexCrawlLandFreq = hexCrawlLandFreq;
        this.hexCrawlWaterFreq = hexCrawlWaterFreq;
        this.includeVillages = includeVillages;
        this.includeRuins = includeRuins;
        this.useCurves = useCurves;
        this.fractalize = fractalize;
        this.mainRoadColor = mainRoadColor;
        this.secondRoadColor = secondRoadColor;
        this.distanceBetweenFeatures = distanceBetweenFeatures;
        this.messageProperty().addListener((observable, oldValue, newValue) -> worldographer.addStatus((String)newValue));
    }

    public void updateMessage(String message) {
        super.updateMessage(message);
    }

    protected MapData call() throws InterruptedException {
        if (this.coasts) {
            MapLogic.addCoastlines(this.uag, this.worldographer, this.mapUI.getMapData(), this.mapUI.viewLevel, this, this.coastType, this.convertOceanToSea);
            this.updateMessage("Coastline generated.");
        }
        if (this.rivers) {
            this.updateMessage("Starting rivers:" + this.numberRivers);
            this.worldographer.getCancelButton().setDisable(false);
            this.worldographer.getCancelButton().setOnAction(e -> {
                MapLogic.canceled = true;
                this.worldographer.getCancelButton().setDisable(true);
                GenerateEmpiresTask generateEmpiresTask = this;
                generateEmpiresTask.worldographer.getMapUI().draw();
            });
            int numRivers = this.numberRivers * this.mapUI.getMapData().getTerrain(this.mapUI.getViewLevel()).length * this.mapUI.getMapData().getTerrain(this.mapUI.getViewLevel())[0].length / 10000;
            this.updateMessage("Getting layer.");
            MapLayer riversML = this.mapData.getMapLayer("Rivers");
            if (riversML == null) {
                int found = 0;
                for (int i = 0; i < this.worldographer.observableLayers.size(); ++i) {
                    if (!((MapLayer)this.worldographer.observableLayers.get(i)).getName().equalsIgnoreCase("Features")) continue;
                    found = i + 1;
                    break;
                }
                riversML = new MapLayer("Rivers");
                this.worldographer.observableLayers.add(found, (Object)riversML);
                this.mapData.getMapLayers().add(found, riversML);
            }
            this.updateMessage("Setup rivers done.");
            MapLogic.addRivers(this.uag, this.mapUI.getMapData().getTerrain(this.mapUI.getViewLevel()), this.mapUI.getViewLevel(), this.mapData.getTileOrientation(), this, this.riverType, this.mapData.getFeatures(), this.mapData.getShapes(), numRivers, riversML);
            this.updateMessage("Rivers generated.");
            this.worldographer.getCancelButton().setDisable(true);
        }
        if (this.empires) {
            Pair<Integer, MapLayer> newml = MapLogic.addEmpires(this, this.worldographer, this.nations, this.mapUI.getViewLevel(), this.mapUI.getMapData(), this.uag, this.numberEmpiresToAdd, this.oneColor, this.fill, this.mapUI.getMapData().getNotes(), this.sizeLimit, this.distanceBetweenFeatures);
            if (newml != null) {
                this.worldographer.layersToolbox.layersTableView.getItems().add(((Integer)newml.getKey()).intValue(), (Object)((MapLayer)newml.getValue()));
            }
            this.mapUI.draw();
        }
        if (this.hexCrawl) {
            MapLogic.genHexCrawlLocations(this.worldographer, this, this.mapUI, this.uag, this.random, this.hexCrawlLandFreq, this.hexCrawlWaterFreq);
        }
        if (this.roads) {
            MapLogic.generateRegionRoads(this, this.worldographer, this.mapUI, this.uag, null, false, false, this.useCurves, this.fractalize, this.mainRoadColor);
            if (this.includeVillages || this.includeRuins) {
                MapLogic.generateRegionRoads(this, this.worldographer, this.mapUI, this.uag, null, this.includeVillages, this.includeRuins, this.useCurves, this.fractalize, this.secondRoadColor);
            }
        }
        return this.mapData;
    }
}

