/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.task;

import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapLogic;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import javafx.concurrent.Task;

public class TerrainWizardTask
extends Task<Boolean> {
    final UndoRedoHandler undoRedoHandler;
    final ViewLevel vl;
    final Terrain[][] terrain;
    final boolean addRandomnessToNewTerrain;
    final Worldographer worldographer;

    public TerrainWizardTask(Worldographer w, UndoRedoHandler undoRedoHandler, ViewLevel vl, Terrain[][] terrain, boolean addRandomnessToNewTerrain) {
        this.worldographer = w;
        this.undoRedoHandler = undoRedoHandler;
        this.vl = vl;
        this.terrain = terrain;
        this.addRandomnessToNewTerrain = addRandomnessToNewTerrain;
        this.messageProperty().addListener((observable, oldValue, newValue) -> this.worldographer.addStatus((String)newValue));
    }

    protected Boolean call() throws InterruptedException {
        Terrain[][] terrainorig = new Terrain[this.terrain.length][this.terrain[0].length];
        for (int x = 0; x < this.terrain.length; ++x) {
            for (int y = 0; y < this.terrain[0].length; ++y) {
                terrainorig[x][y] = new Terrain(this.terrain[x][y].getTypeName(), true);
            }
        }
        UndoActionGroup uag = new UndoActionGroup();
        if (this.undoRedoHandler != null) {
            this.undoRedoHandler.push(uag);
        }
        for (int x = 0; x < this.terrain.length; ++x) {
            this.updateMessage("Terrain Wizard: " + (int)((double)x + 100.0 / (double)this.terrain.length) + "%");
            for (int y = 0; y < this.terrain[0].length; ++y) {
                if (!this.terrain[x][y].getTypeName().equals("Blank")) continue;
                double closestdistance = Double.MAX_VALUE;
                Terrain t = null;
                for (int xdiff = 0; xdiff < this.terrain.length; ++xdiff) {
                    for (int ydiff = 0; ydiff < this.terrain[0].length; ++ydiff) {
                        double tempcd;
                        if (x + xdiff < this.terrain.length && y + ydiff < this.terrain[0].length && !terrainorig[x + xdiff][y + ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x + xdiff][y + ydiff];
                        }
                        if (x - xdiff >= 0 && y - ydiff >= 0 && !terrainorig[x - xdiff][y - ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x - xdiff][y - ydiff];
                        }
                        if (x + xdiff < this.terrain.length && y - ydiff >= 0 && !terrainorig[x + xdiff][y - ydiff].getTypeName().equals("Blank") && (tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance) {
                            closestdistance = tempcd;
                            t = terrainorig[x + xdiff][y - ydiff];
                        }
                        if (x - xdiff < 0 || y + ydiff >= this.terrain[0].length || terrainorig[x - xdiff][y + ydiff].getTypeName().equals("Blank") || !((tempcd = Math.sqrt(xdiff * xdiff + ydiff * ydiff)) < closestdistance)) continue;
                        closestdistance = tempcd;
                        t = terrainorig[x - xdiff][y + ydiff];
                    }
                }
                System.out.println("t:" + t.getTypeName());
                if (t == null) continue;
                Terrain oldt = this.terrain[x][y];
                this.terrain[x][y] = new Terrain(MapLogic.getNewType(t.getTypeName(), this.addRandomnessToNewTerrain), true);
                uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, this.terrain[x][y], oldt, x, y, (Object)this.vl));
            }
        }
        this.updateMessage("Terrain Wizard: Complete");
        return true;
    }
}

