/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui;

import java.util.Collection;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.PathTransition;
import javafx.animation.Transition;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;

public class CurvedText
extends Application {
    private static final String CURVED_TEXT = "Bezier Curve";

    public static void main(String[] args) throws Exception {
        CurvedText.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        CubicCurve curve = this.createStartingCurve();
        BoundLine controlLine1 = new BoundLine(curve.controlX1Property(), curve.controlY1Property(), curve.startXProperty(), curve.startYProperty());
        BoundLine controlLine2 = new BoundLine(curve.controlX2Property(), curve.controlY2Property(), curve.endXProperty(), curve.endYProperty());
        Anchor start = new Anchor(Color.PALEGREEN, curve.startXProperty(), curve.startYProperty());
        Anchor control1 = new Anchor(Color.GOLD, curve.controlX1Property(), curve.controlY1Property());
        Anchor control2 = new Anchor(Color.GOLDENROD, curve.controlX2Property(), curve.controlY2Property());
        Anchor end = new Anchor(Color.TOMATO, curve.endXProperty(), curve.endYProperty());
        Text text = new Text(CURVED_TEXT);
        text.setStyle("-fx-font-size: 40px");
        text.setEffect((Effect)new Glow());
        ObservableList parts = FXCollections.observableArrayList();
        ObservableList transitions = FXCollections.observableArrayList();
        for (char character : ((String)text.textProperty().get()).toCharArray()) {
            Text part = new Text("" + character);
            part.setEffect(text.getEffect());
            part.setStyle(text.getStyle());
            parts.add((Object)part);
            part.setVisible(false);
            transitions.add((Object)this.createPathTransition(curve, part));
        }
        ObservableList controls = FXCollections.observableArrayList();
        controls.setAll((Object[])new Node[]{controlLine1, controlLine2, curve, start, control1, control2, end});
        ToggleButton plot = new ToggleButton("Plot Text");
        plot.setOnAction((EventHandler)new PlotHandler(plot, (ObservableList<Text>)parts, (ObservableList<PathTransition>)transitions, (ObservableList<Node>)controls));
        Group content = new Group(new Node[]{controlLine1, controlLine2, curve, start, control1, control2, end, plot});
        content.getChildren().addAll((Collection)parts);
        stage.setTitle("Cubic Curve Manipulation Sample");
        stage.setScene(new Scene((Parent)content, 400.0, 400.0, (Paint)Color.ALICEBLUE));
        stage.show();
    }

    private PathTransition createPathTransition(CubicCurve curve, Text text) {
        PathTransition transition = new PathTransition(Duration.seconds((double)10.0), (Shape)curve, (Node)text);
        transition.setAutoReverse(false);
        transition.setCycleCount(-1);
        transition.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        transition.setInterpolator(Interpolator.LINEAR);
        return transition;
    }

    private CubicCurve createStartingCurve() {
        CubicCurve curve = new CubicCurve();
        curve.setStartX(50.0);
        curve.setStartY(200.0);
        curve.setControlX1(150.0);
        curve.setControlY1(300.0);
        curve.setControlX2(250.0);
        curve.setControlY2(50.0);
        curve.setEndX(350.0);
        curve.setEndY(150.0);
        curve.setStroke((Paint)Color.FORESTGREEN);
        curve.setStrokeWidth(4.0);
        curve.setStrokeLineCap(StrokeLineCap.ROUND);
        curve.setFill((Paint)Color.CORNSILK.deriveColor(0.0, 1.2, 1.0, 0.6));
        return curve;
    }

    static class BoundLine
    extends Line {
        BoundLine(DoubleProperty startX, DoubleProperty startY, DoubleProperty endX, DoubleProperty endY) {
            this.startXProperty().bind((ObservableValue)startX);
            this.startYProperty().bind((ObservableValue)startY);
            this.endXProperty().bind((ObservableValue)endX);
            this.endYProperty().bind((ObservableValue)endY);
            this.setStrokeWidth(2.0);
            this.setStroke((Paint)Color.GRAY.deriveColor(0.0, 1.0, 1.0, 0.5));
            this.setStrokeLineCap(StrokeLineCap.BUTT);
            this.getStrokeDashArray().setAll((Object[])new Double[]{10.0, 5.0});
        }
    }

    static class Anchor
    extends Circle {
        Anchor(Color color, DoubleProperty x, DoubleProperty y) {
            super(x.get(), y.get(), 10.0);
            this.setFill((Paint)color.deriveColor(1.0, 1.0, 1.0, 0.5));
            this.setStroke((Paint)color);
            this.setStrokeWidth(2.0);
            this.setStrokeType(StrokeType.OUTSIDE);
            x.bind((ObservableValue)this.centerXProperty());
            y.bind((ObservableValue)this.centerYProperty());
            this.enableDrag();
        }

        private void enableDrag() {
            Delta dragDelta = new Delta();
            this.setOnMousePressed(mouseEvent -> {
                dragDelta.x = this.getCenterX() - mouseEvent.getX();
                dragDelta.y = this.getCenterY() - mouseEvent.getY();
                this.getScene().setCursor(Cursor.MOVE);
            });
            this.setOnMouseReleased(mouseEvent -> this.getScene().setCursor(Cursor.HAND));
            this.setOnMouseDragged(mouseEvent -> {
                double newY;
                double newX = mouseEvent.getX() + dragDelta.x;
                if (newX > 0.0 && newX < this.getScene().getWidth()) {
                    this.setCenterX(newX);
                }
                if ((newY = mouseEvent.getY() + dragDelta.y) > 0.0 && newY < this.getScene().getHeight()) {
                    this.setCenterY(newY);
                }
            });
            this.setOnMouseEntered(mouseEvent -> {
                if (!mouseEvent.isPrimaryButtonDown()) {
                    this.getScene().setCursor(Cursor.HAND);
                }
            });
            this.setOnMouseExited(mouseEvent -> {
                if (!mouseEvent.isPrimaryButtonDown()) {
                    this.getScene().setCursor(Cursor.DEFAULT);
                }
            });
        }

        private static class Delta {
            double x;
            double y;

            private Delta() {
            }
        }
    }

    private static class PlotHandler
    implements EventHandler<ActionEvent> {
        private final ToggleButton plot;
        private final ObservableList<Text> parts;
        private final ObservableList<PathTransition> transitions;
        private final ObservableList<Node> controls;

        public PlotHandler(ToggleButton plot, ObservableList<Text> parts, ObservableList<PathTransition> transitions, ObservableList<Node> controls) {
            this.plot = plot;
            this.parts = parts;
            this.transitions = transitions;
            this.controls = controls;
        }

        public void handle(ActionEvent actionEvent) {
            if (this.plot.isSelected()) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    ((Text)this.parts.get(i)).setVisible(true);
                    final Transition transition = (Transition)this.transitions.get(i);
                    transition.stop();
                    transition.jumpTo(Duration.seconds((double)10.0).multiply(((double)i + 0.5) * 1.0 / (double)this.parts.size()));
                    AnimationTimer timer = new AnimationTimer(this){
                        int frameCounter = 0;

                        public void handle(long l) {
                            ++this.frameCounter;
                            if (this.frameCounter == 1) {
                                transition.stop();
                                this.stop();
                            }
                        }
                    };
                    timer.start();
                    transition.play();
                }
                this.plot.setText("Show Controls");
            } else {
                this.plot.setText("Plot Text");
            }
            for (Node control : this.controls) {
                control.setVisible(!this.plot.isSelected());
            }
            for (Node part : this.parts) {
                part.setVisible(this.plot.isSelected());
            }
        }
    }
}

