/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.generator.world.DynamicTerrainSetting;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConfigureDynamicTerrainScreen
extends ConfigureScreen {
    Map<String, TextField> terrainToFeatureFilterTF1 = new HashMap<String, TextField>();
    Map<String, TextField> terrainToFeatureFilterTF2 = new HashMap<String, TextField>();
    Map<String, TextField> terrainToFeatureFilterTF3 = new HashMap<String, TextField>();
    Map<String, Spinner<Integer>> terrainToFeatureFilterSpinnerMax = new TreeMap<String, Spinner<Integer>>();
    Map<String, Spinner<Integer>> terrainToFeatureFilterSpinner1 = new TreeMap<String, Spinner<Integer>>();
    Map<String, Spinner<Integer>> terrainToFeatureFilterSpinner2 = new TreeMap<String, Spinner<Integer>>();
    Map<String, Spinner<Integer>> terrainToFeatureFilterSpinner3 = new TreeMap<String, Spinner<Integer>>();
    GridPane gridPane = new GridPane();

    public ConfigureDynamicTerrainScreen(Worldographer ms) {
        super(ms, 1060, 400);
    }

    @Override
    public void setValues() {
        this.title = "Configure Dynamic Terrain";
        this.configureLabel = "";
        this.configureTitle = "Configure Dynamic Terrain Instructions";
        this.configureHeader = "Configure Dynamic Terrain Instructions";
        this.configureScreenHelpText = "<p>This window lets you configure 'dynamic' terrain--terrain which automatically adds features\nto an 'Above Terrain Y-Ordered' layer on the map.</p>\n<p>Note: You must click 'apply' for the changes to take effect.</p>\n<p>'Save Configuration' performs an 'apply' before saving.</p>\n\n<h3>General Info</h3>\n<p>When placing terrain, select the 'Dynamic Terrain' button to use this functionality when placing\nterrain.  If that toggle button is on and the terrain you choose to place is listed in the Terrain\nsection below, then any features that have the words in the 1st Match, 2nd Match, or 3rd Match columns\nwill be added to the map to the 'Above Terrain Y-Ordered' map layer.  The number of features is limited\nby the 'Max Pts' field, and each match has a point value.</p>\n\n<p>For example, if a Deciduous Forest terrain type is added to the list of Dynamic Terrain, and the\nMax Points is 10, and 1st Match is 'Parchment Deciduous Forest Small' with 1st Pts set to 2, 2nd Match\nset to 'Parchment Deciduous Forest Medium' and 2nd Pts set to 4, and 3rd Match left empty, then the system\nwill randomly select some features that have the words 'Parchment' 'Deciduous' 'Forest' as well as\n'Small' or 'Medium' such that it places up to 10 points word.  (Perhaps 2 Mediums of 4 points each and 1\nsmall for 2 more points totaling 10; or 5 small ones for 10 points.)\n\n\n<h3>Explanations For Each Field</h3>\n<ul>\n<li>Filter Terrain List/Update Matching Terrain: Type text here and click 'Update Matching Terrain' to limit the number of\nterrain types in the list of terrain below.</li>\n<li>Terrain List/Add Selected: Select a terrain type in the list, then click the 'Add Selected' button to\nadd data rows to customize on the right side.</li>\n<li>Terrain: Name of terrain to make dynamic.</li>\n<li>Max Points: Total number of points to use to spend to place features.</li>\n<li>1st, 2nd, 3rd Match: These fields can have several words (word order and upper/lowercase doesn't matter) which will be used to filter features to use\nwhen placing dynamic terrain. Ex: 'Deciduous Forest' will match features named 'isometric forest deciduous a'\nas well as 'parchment deciduous forest' and 'parchment mountains deciduous forest'.  Add a '-'in front\nof a word to exclude that.  Also note that partial words also will filter.  So adding '-mountain' will\nexclude any feature with the word mountain or mountains.</li>\n<li>1st, 2nd, 3rd Pts: Use these selectors to specify the 'cost' of that feature being added to the map.</li>\n</ul>\n<h3>Load/Save/Close/Apply</h3>\n<ul>\n<li>Load Configuration: Load saved dynamic terrain configuration\ndata.</li>\n<li>Save Configuration: Save the current dynamic terrain configuration data. Implicitly calls\n'Apply' in case there are unsaved changes.</li>\n<li>Close: Closes the dialog without saving.</li>\n<li>Apply: Stores the configuration changes for use with the map currently displayed.</li></ul>";
    }

    @Override
    protected HBox createBottomBar() {
        HBox bottombar = super.createBottomBar();
        bottombar.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        Button loadButton = new Button("Load Configuration");
        loadButton.setOnAction(t -> {
            File f;
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" XML (*.xml)", new String[]{"*.xml"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog(null)) != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    InputSource inputSource = new InputSource();
                    inputSource.setCharacterStream(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
                    Document doc = documentBuilder.parse(inputSource);
                    NodeList nodes = doc.getElementsByTagName("TerrainFeatureMatches");
                    TreeMap<String, DynamicTerrainSetting> dynamicTerrainSettingMap = new TreeMap<String, DynamicTerrainSetting>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element el = (Element)nodes.item(i);
                        String terrain = el.getAttribute("Terrain");
                        Integer max = Integer.parseInt(el.getAttribute("max"));
                        String filter1 = el.getAttribute("filter1");
                        Integer pts1 = Integer.parseInt(el.getAttribute("pts1"));
                        String filter2 = el.getAttribute("filter2");
                        Integer pts2 = Integer.parseInt(el.getAttribute("pts2"));
                        String filter3 = el.getAttribute("filter3");
                        Integer pts3 = Integer.parseInt(el.getAttribute("pts3"));
                        DynamicTerrainSetting dts = new DynamicTerrainSetting();
                        dts.setTerrainName(terrain);
                        dts.setMaxPts(max);
                        HashMap<String, Integer> featureFilters = new HashMap<String, Integer>();
                        featureFilters.put(filter1, pts1);
                        featureFilters.put(filter2, pts2);
                        featureFilters.put(filter3, pts3);
                        dts.setFeatureFilters(featureFilters);
                        dynamicTerrainSettingMap.put(terrain, dts);
                        this.createGridRow(terrain, max, filter1, pts1, filter2, pts2, filter3, pts3);
                    }
                    Worldographer.getMapUI().dynamicTerrainSettingMap = dynamicTerrainSettingMap;
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    this.primaryStage.close();
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Loaded", "Settlement Configuration Loaded", "Reopen the settlement configuration to see the changes", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while loading your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(2, (Object)loadButton);
        Button saveButton = new Button("Save Configuration");
        saveButton.setOnAction(event -> {
            File f;
            this.applyChanges(true);
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" XML (*.xml)", new String[]{"*.xml"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showSaveDialog(null)) != null) {
                try {
                    Object exportconfig = "<dynamicTerrain>\n";
                    for (String terrain : this.terrainToFeatureFilterSpinnerMax.keySet()) {
                        exportconfig = (String)exportconfig + "<TerrainFeatureMatches Terrain=\"" + terrain + "\" max=\"" + String.valueOf(this.terrainToFeatureFilterSpinnerMax.get(terrain).getValue()) + "\" filter1=\"" + this.terrainToFeatureFilterTF1.get(terrain).getText() + "\" pts1=\"" + String.valueOf(this.terrainToFeatureFilterSpinner1.get(terrain).getValue()) + "\" filter2=\"" + this.terrainToFeatureFilterTF2.get(terrain).getText() + "\" pts2=\"" + String.valueOf(this.terrainToFeatureFilterSpinner2.get(terrain).getValue()) + "\" filter3=\"" + this.terrainToFeatureFilterTF3.get(terrain).getText() + "\" pts3=\"" + String.valueOf(this.terrainToFeatureFilterSpinner3.get(terrain).getValue()) + "\"/>\n";
                    }
                    FileOutputStream fos = new FileOutputStream(f);
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                    w.write("<?xml version='1.0' encoding='utf-8'?>\n");
                    w.write((String)exportconfig + "</dynamicTerrain>");
                    w.flush();
                    w.close();
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Saved", "Settlement Configuration Saved", "The settlement configuration was successfully saved.", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while saving your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(3, (Object)saveButton);
        bottombar.getChildren().add(4, (Object)new Label("    "));
        return bottombar;
    }

    private void loadCityDataAndShowDialog(InputStream is) {
        this.primaryStage.close();
        StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Loaded", "Settlement Configuration Loaded", "Reopen the settlement configuration to see the changes.", null, null);
    }

    @Override
    protected void applyChanges(boolean userInitiated) {
        HashMap<String, DynamicTerrainSetting> dynamicTerrainSettingMap = new HashMap<String, DynamicTerrainSetting>();
        for (String tName : this.terrainToFeatureFilterTF1.keySet()) {
            DynamicTerrainSetting dts = new DynamicTerrainSetting();
            dts.setTerrainName(tName);
            dts.setMaxPts((Integer)this.terrainToFeatureFilterSpinnerMax.get(tName).getValue());
            HashMap<String, Integer> featureFilters = new HashMap<String, Integer>();
            featureFilters.put(this.terrainToFeatureFilterTF1.get(tName).getText(), (Integer)this.terrainToFeatureFilterSpinner1.get(tName).getValue());
            featureFilters.put(this.terrainToFeatureFilterTF2.get(tName).getText(), (Integer)this.terrainToFeatureFilterSpinner2.get(tName).getValue());
            featureFilters.put(this.terrainToFeatureFilterTF3.get(tName).getText(), (Integer)this.terrainToFeatureFilterSpinner3.get(tName).getValue());
            dts.setFeatureFilters(featureFilters);
            dynamicTerrainSettingMap.put(tName, dts);
        }
        Worldographer.getMapUI().dynamicTerrainSettingMap = dynamicTerrainSettingMap;
    }

    @Override
    protected Node createGrid() {
        VBox left = new VBox();
        Label terrainLabel = new Label("Filter Terrain List:");
        TextField terrainTF = new TextField("");
        Button terrainButton = new Button("Update Matching Terrain");
        left.getChildren().add((Object)terrainLabel);
        left.getChildren().add((Object)terrainTF);
        left.getChildren().add((Object)terrainButton);
        ListView terrainListView = new ListView();
        terrainListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        terrainListView.getItems().addAll(Terrain.terrainTypes.keySet());
        left.getChildren().add((Object)terrainListView);
        Button addSelectedButton = new Button("Add Selected");
        left.getChildren().add((Object)addSelectedButton);
        BorderPane bp = new BorderPane();
        bp.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        bp.setLeft((Node)left);
        this.gridPane.add((Node)new Label("Terrain    "), 0, 0);
        this.gridPane.add((Node)new Label("Max Pts  "), 1, 0);
        this.gridPane.add((Node)new Label("1st Match    "), 2, 0);
        this.gridPane.add((Node)new Label("1st Pts  "), 3, 0);
        this.gridPane.add((Node)new Label("2nd Match    "), 4, 0);
        this.gridPane.add((Node)new Label("2nd Pts  "), 5, 0);
        this.gridPane.add((Node)new Label("3rd Match    "), 6, 0);
        this.gridPane.add((Node)new Label("3rd Pts"), 7, 0);
        for (String key : Worldographer.getMapUI().dynamicTerrainSettingMap.keySet()) {
            DynamicTerrainSetting dts = Worldographer.getMapUI().dynamicTerrainSettingMap.get(key);
            Object[] filters = dts.getFeatureFilters().keySet().toArray();
            this.createGridRow(key, dts.getMaxPts(), filters.length > 0 ? (String)filters[0] : "", filters.length > 0 ? dts.getFeatureFilters().get(filters[0]) : 1, filters.length > 1 ? (String)filters[1] : "", filters.length > 1 ? dts.getFeatureFilters().get(filters[1]) : 1, filters.length > 2 ? (String)filters[2] : "", filters.length > 2 ? dts.getFeatureFilters().get(filters[2]) : 1);
        }
        ScrollPane sp = new ScrollPane((Node)this.gridPane);
        bp.setCenter((Node)sp);
        terrainButton.setOnAction(event -> {
            terrainListView.getItems().clear();
            String[] matchCriteria = terrainTF.getText().toLowerCase().split(" ");
            for (String tName : Terrain.terrainTypes.keySet()) {
                String tNameLower = tName.toLowerCase();
                boolean match = true;
                for (String matchFactor : matchCriteria) {
                    if (tNameLower.contains(matchFactor)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                terrainListView.getItems().add((Object)tName);
            }
        });
        addSelectedButton.setOnAction(event -> {
            ObservableList terrainList = terrainListView.getSelectionModel().getSelectedItems();
            for (String tName : terrainList) {
                this.createGridRow(tName, 10, "", 6, "", 3, "", 1);
            }
        });
        return bp;
    }

    public void createGridRow(String tName, int initialMax, String filter1, int pts1, String filter2, int pts2, String filter3, int pts3) {
        int row = this.gridPane.getRowCount();
        this.gridPane.add((Node)new Label(tName), 0, row);
        Spinner total = new Spinner(1, 20, initialMax);
        this.terrainToFeatureFilterSpinnerMax.put(tName, (Spinner<Integer>)total);
        total.setMaxWidth(70.0);
        this.gridPane.add((Node)total, 1, row);
        TextField featureFieldTF1 = new TextField(filter1);
        this.terrainToFeatureFilterTF1.put(tName, featureFieldTF1);
        this.gridPane.add((Node)featureFieldTF1, 2, row);
        Spinner spinner1 = new Spinner(1, 10, pts1);
        spinner1.setMaxWidth(70.0);
        this.terrainToFeatureFilterSpinner1.put(tName, (Spinner<Integer>)spinner1);
        this.gridPane.add((Node)spinner1, 3, row);
        TextField featureFieldTF2 = new TextField(filter2);
        this.terrainToFeatureFilterTF2.put(tName, featureFieldTF2);
        this.gridPane.add((Node)featureFieldTF2, 4, row);
        Spinner spinner2 = new Spinner(1, 10, pts2);
        spinner2.setMaxWidth(70.0);
        this.terrainToFeatureFilterSpinner2.put(tName, (Spinner<Integer>)spinner2);
        this.gridPane.add((Node)spinner2, 5, row);
        TextField featureFieldTF3 = new TextField(filter3);
        this.terrainToFeatureFilterTF3.put(tName, featureFieldTF3);
        this.gridPane.add((Node)featureFieldTF3, 6, row);
        Spinner spinner3 = new Spinner(1, 10, pts3);
        spinner3.setMaxWidth(70.0);
        this.terrainToFeatureFilterSpinner3.put(tName, (Spinner<Integer>)spinner3);
        this.gridPane.add((Node)spinner3, 7, row);
    }
}

