/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class ConfigureLabelStylesScreen
extends ConfigureScreen {
    final Map<String, Spinner<Double>> sizeSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, CheckBox> removeCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> keyTFsMap = new HashMap<String, TextField>();
    final Map<String, ComboBox<String>> labelFontCombosMap = new HashMap<String, ComboBox<String>>();
    final Map<String, ColorPicker> labelColorBGCPsMap = new HashMap<String, ColorPicker>();
    final Map<String, Spinner<Double>> labelOutlineSizeSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, ColorPicker> labelOutlineColorBGCPsMap = new HashMap<String, ColorPicker>();
    final Map<String, CheckBox> labelBoldCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> labelItalicCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> labelBackgroundCBsMap = new HashMap<String, CheckBox>();
    final Map<String, ColorPicker> labelBackgroundColorCPsMap = new HashMap<String, ColorPicker>();
    final Map<String, CheckBox> labelDropShadowCBsMap = new HashMap<String, CheckBox>();
    final Map<String, ColorPicker> labelDropShadowColorCPsMap = new HashMap<String, ColorPicker>();
    final Map<String, Spinner<Double>> labelDropShadowRadiusSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, Spinner<Double>> labelDropShadowSpreadSpinnersMap = new HashMap<String, Spinner<Double>>();
    int numTextRows;

    public ConfigureLabelStylesScreen(Worldographer ms) {
        super(ms, 1060, 400);
    }

    @Override
    public void setValues() {
        this.title = "Configure Label Styles";
        this.configureLabel = "";
        this.configureTitle = "Configure Label Styles Instructions";
        this.configureHeader = "Configure Label Styles Instructions";
        this.configureScreenHelpText = "<p>This dialog allows you to add, configure, and remove label styles. Note for all color pickers, you can set the color to be semi-transparent by going to 'custom color' after you click the color picker.</p><p>Remember to click the 'Apply' button at the bottom to save changes.  'Close' only closes the dialog--it does not save your changes.</p><h3>Add</h3><p>Click the 'Add Row' button at the bottom of the configuration window. A new line will appear at the bottom of the main area's grid.(You may have to scroll down to see it.) See the 'Configure' section below for details about each column for the new row.</p><h3>Configure</h3><p>Each line of the main grid corresponds to a label style.</li><ul><li>Key: Name of this label style.</li><li>Font: Name of the font to use for this label style.</li><li>Color: The main color of the text that uses this style.</li><li>Outline Size &amp; Color: The thickness of any outline for the text, as a percentage of the font's size, as well as a color picker to choose the color.</li><li>Size: The style's font size, as a percentage of a tile's (hex or square) height.</li><li>Bold: Check this box to make the style bold.</li><li>Italic: Check this box to make the style italic.</li><li>Has Background &amp; Color: Check this box if you'd like a colored box to appear under the text, and use the color picker to choose the color.</li></ul><h3>Remove</h3><p>To remove any style from the system, check the 'Remove' checkbox (last column) for that style's row.  Then click 'Apply' on the bottom.</p>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        CheckBox cb;
        for (String key : this.sizeSpinnersMap.keySet()) {
            if (key.startsWith("temptext###")) {
                cb = this.removeCBsMap.get(key);
                if (cb.isSelected()) continue;
                String name = this.keyTFsMap.get(key).getText();
                LabelStyle ls = new LabelStyle(name, (String)this.labelFontCombosMap.get(key).getValue(), (Color)this.labelColorBGCPsMap.get(key).getValue(), (Double)this.labelOutlineSizeSpinnersMap.get(key).getValue(), (Color)this.labelOutlineColorBGCPsMap.get(key).getValue(), (Double)this.sizeSpinnersMap.get(key).getValue(), this.labelBoldCBsMap.get(key).isSelected(), this.labelItalicCBsMap.get(key).isSelected(), this.labelBackgroundCBsMap.get(key).isSelected() ? (Color)this.labelBackgroundColorCPsMap.get(key).getValue() : null, this.labelDropShadowCBsMap.get(key).isSelected() ? (Color)this.labelDropShadowColorCPsMap.get(key).getValue() : null, (Double)this.labelDropShadowRadiusSpinnersMap.get(key).getValue(), (Double)this.labelDropShadowSpreadSpinnersMap.get(key).getValue());
                Worldographer.getMapUI().getMapData().getLabelStyles().put(name, ls);
                continue;
            }
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setScale((Double)this.sizeSpinnersMap.get(key).getValue());
        }
        for (String key : this.removeCBsMap.keySet()) {
            if (key.startsWith("temp###") || key.startsWith("tempfeature###") || key.startsWith("temptext###") || !(cb = this.removeCBsMap.get(key)).isSelected()) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().remove(key);
        }
        for (String key : this.labelBoldCBsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setBold(this.labelBoldCBsMap.get(key).isSelected());
        }
        for (String key : this.labelItalicCBsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setItalic(this.labelItalicCBsMap.get(key).isSelected());
        }
        for (String key : this.labelFontCombosMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setFontFace((String)this.labelFontCombosMap.get(key).getValue());
        }
        for (String key : this.labelColorBGCPsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setColor((Color)this.labelColorBGCPsMap.get(key).getValue());
        }
        for (String key : this.labelOutlineSizeSpinnersMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setOutlineSize((Double)this.labelOutlineSizeSpinnersMap.get(key).getValue());
        }
        for (String key : this.labelOutlineColorBGCPsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setOutlineColor((Color)this.labelOutlineColorBGCPsMap.get(key).getValue());
        }
        for (String key : this.labelBackgroundCBsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            boolean selected = this.labelBackgroundCBsMap.get(key).isSelected();
            if (selected) {
                Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setBackgroundColor((Color)this.labelBackgroundColorCPsMap.get(key).getValue());
                continue;
            }
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setBackgroundColor(null);
        }
        for (String key : this.labelDropShadowCBsMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            boolean selected = this.labelDropShadowCBsMap.get(key).isSelected();
            if (selected) {
                Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setDropShadowColor((Color)this.labelDropShadowColorCPsMap.get(key).getValue());
                continue;
            }
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setDropShadowColor(null);
        }
        for (String key : this.labelDropShadowRadiusSpinnersMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setDropShadowRadius((Double)this.labelDropShadowRadiusSpinnersMap.get(key).getValue());
        }
        for (String key : this.labelDropShadowSpreadSpinnersMap.keySet()) {
            if (key.startsWith("temptext###") || Worldographer.getMapUI().getMapData().getLabelStyles().get(key) == null) continue;
            Worldographer.getMapUI().getMapData().getLabelStyles().get(key).setDropShadowSpread((Double)this.labelDropShadowSpreadSpinnersMap.get(key).getValue());
        }
        this.worldographer.labelsToolbox.updateTextStylesList();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gp1.setHgap(3.0);
        Label l1 = new Label("Key");
        l1.setMinWidth(80.0);
        l1.setMaxWidth(80.0);
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("Font");
        l2.setMinWidth(95.0);
        l2.setMaxWidth(95.0);
        gp1.add((Node)l2, 1, 0);
        Label l3 = new Label("Color");
        l3.setMinWidth(90.0);
        l3.setMaxWidth(90.0);
        gp1.add((Node)l3, 2, 0);
        Label l4 = new Label("Outline Size (ht%) & Color");
        l4.setMinWidth(160.0);
        l4.setMaxWidth(160.0);
        gp1.add((Node)l4, 4, 0);
        Label l5 = new Label("Size (ht%)");
        l5.setMinWidth(70.0);
        l5.setMaxWidth(70.0);
        gp1.add((Node)l5, 5, 0);
        Label l6 = new Label("Bold");
        Font f = l6.getFont();
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        l6.setFont(f);
        l6.setMinWidth(30.0);
        l6.setMaxWidth(30.0);
        gp1.add((Node)l6, 6, 0);
        Label l7 = new Label("Italic");
        Font f2 = l7.getFont();
        f2 = Font.font((String)f2.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f2.getSize());
        l7.setFont(f2);
        l7.setMinWidth(35.0);
        l7.setMinWidth(35.0);
        gp1.add((Node)l7, 7, 0);
        Label l8 = new Label("Background Color");
        l8.setMinWidth(105.0);
        gp1.add((Node)l8, 8, 0);
        Label l9 = new Label("Drop Shadow, Color, Radius (ht%), Spread");
        l9.setMinWidth(265.0);
        gp1.add((Node)l9, 9, 0);
        Label l10 = new Label("Remove");
        l10.setMinWidth(40.0);
        gp1.add((Node)l10, 10, 0);
        GridPane gp2 = new GridPane();
        gp2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        int count = 0;
        for (String key : Worldographer.getMapUI().getMapData().getLabelStyles().keySet()) {
            count = this.createTextRow(gp2, count, key);
        }
        this.numTextRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            this.numTextRows = this.createTextRow(gp2, this.numTextRows, "temptext###" + Math.random());
            scrollpane.setVvalue(1.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private int createTextRow(GridPane gp2, int count, String key) {
        LabelStyle ls = Worldographer.getMapUI().getMapData().getLabelStyles().get(key);
        if (ls != null) {
            TextField keylabel = new TextField(key);
            keylabel.setMaxWidth(70.0);
            keylabel.setMinWidth(70.0);
            keylabel.setEditable(false);
            gp2.add((Node)keylabel, 0, count);
        } else {
            TextField tf = new TextField("");
            tf.setMaxWidth(70.0);
            tf.setMinWidth(70.0);
            gp2.add((Node)tf, 0, count);
            this.keyTFsMap.put(key, tf);
        }
        ObservableList foptions = FXCollections.observableArrayList((Collection)Font.getFamilies());
        ComboBox labelFontCombo = new ComboBox(foptions);
        labelFontCombo.getSelectionModel().select(0);
        this.labelFontCombosMap.put(key, (ComboBox<String>)labelFontCombo);
        if (ls != null) {
            labelFontCombo.getSelectionModel().select((Object)ls.getFontFace());
        }
        labelFontCombo.setMaxWidth(95.0);
        labelFontCombo.setMinWidth(95.0);
        gp2.add((Node)labelFontCombo, 1, count);
        ColorPicker labelColorBGCP = new ColorPicker(ls == null ? Color.YELLOW : ls.getColor());
        if (labelColorBGCP.getCustomColors().size() <= 1) {
            labelColorBGCP.getCustomColors().addAll((Object[])Worldographer.customColors);
        }
        this.labelColorBGCPsMap.put(key, labelColorBGCP);
        labelColorBGCP.setMaxWidth(90.0);
        labelColorBGCP.setMinWidth(90.0);
        gp2.add((Node)labelColorBGCP, 2, count);
        FocusSpinner labelOutlineSizeSpinner = new FocusSpinner(0.0, 100.0, ls == null ? 0.0 : ls.getOutlineSize());
        this.labelOutlineSizeSpinnersMap.put(key, labelOutlineSizeSpinner);
        labelOutlineSizeSpinner.setMaxWidth(70.0);
        labelOutlineSizeSpinner.setMinWidth(70.0);
        gp2.add(labelOutlineSizeSpinner, 3, count);
        ColorPicker labelOutlineColorBGCP = new ColorPicker();
        this.labelOutlineColorBGCPsMap.put(key, labelOutlineColorBGCP);
        labelOutlineColorBGCP.setMaxWidth(90.0);
        labelOutlineColorBGCP.setMinWidth(90.0);
        if (ls != null && ls.getOutlineColor() != null) {
            labelOutlineColorBGCP.setValue((Object)ls.getOutlineColor());
        }
        if (labelOutlineColorBGCP.getCustomColors().size() <= 1) {
            // empty if block
        }
        gp2.add((Node)labelOutlineColorBGCP, 4, count);
        FocusSpinner labelScaleSpinner = new FocusSpinner(1.0, 1000.0, 75.0);
        this.sizeSpinnersMap.put(key, labelScaleSpinner);
        labelScaleSpinner.setMaxWidth(70.0);
        labelScaleSpinner.setMinWidth(70.0);
        if (ls != null) {
            labelScaleSpinner.getValueFactory().setValue((Object)ls.getScale());
        }
        gp2.add(labelScaleSpinner, 5, count);
        labelScaleSpinner.setEditable(true);
        CheckBox labelBoldCB = new CheckBox("");
        if (ls != null) {
            labelBoldCB.setSelected(ls.isBold());
        }
        Font f = labelBoldCB.getFont();
        labelBoldCB.setMaxWidth(30.0);
        labelBoldCB.setMinWidth(30.0);
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)f.getSize());
        labelBoldCB.setFont(f);
        this.labelBoldCBsMap.put(key, labelBoldCB);
        gp2.add((Node)labelBoldCB, 6, count);
        CheckBox labelItalicCB = new CheckBox("");
        if (ls != null) {
            labelItalicCB.setSelected(ls.isItalic());
        }
        f = labelItalicCB.getFont();
        labelItalicCB.setMaxWidth(35.0);
        labelItalicCB.setMinWidth(35.0);
        f = Font.font((String)f.getFamily(), (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.ITALIC, (double)f.getSize());
        labelItalicCB.setFont(f);
        this.labelItalicCBsMap.put(key, labelItalicCB);
        gp2.add((Node)labelItalicCB, 7, count);
        CheckBox labelBackgroundCB = new CheckBox("");
        this.labelBackgroundCBsMap.put(key, labelBackgroundCB);
        labelBackgroundCB.setMaxWidth(15.0);
        labelBackgroundCB.setMinWidth(15.0);
        if (ls != null && ls.getBackgroundColor() != null) {
            labelBackgroundCB.setSelected(true);
        }
        gp2.add((Node)labelBackgroundCB, 8, count);
        ColorPicker labelBackgroundColorBGCP = new ColorPicker(Color.WHEAT);
        this.labelBackgroundColorCPsMap.put(key, labelBackgroundColorBGCP);
        labelBackgroundColorBGCP.setMaxWidth(90.0);
        labelBackgroundColorBGCP.setMinWidth(90.0);
        if (ls != null && ls.getBackgroundColor() != null) {
            labelBackgroundColorBGCP.setValue((Object)ls.getBackgroundColor());
        }
        gp2.add((Node)labelBackgroundColorBGCP, 9, count);
        CheckBox labelDropShadowCB = new CheckBox("");
        this.labelDropShadowCBsMap.put(key, labelDropShadowCB);
        labelDropShadowCB.setMaxWidth(15.0);
        labelDropShadowCB.setMinWidth(15.0);
        if (ls != null && ls.getDropShadowColor() != null) {
            labelDropShadowCB.setSelected(true);
        }
        gp2.add((Node)labelDropShadowCB, 10, count);
        ColorPicker labelDropShadowColorBGCP = new ColorPicker(Color.WHEAT);
        this.labelDropShadowColorCPsMap.put(key, labelDropShadowColorBGCP);
        labelDropShadowColorBGCP.setMaxWidth(90.0);
        labelDropShadowColorBGCP.setMinWidth(90.0);
        if (ls != null && ls.getDropShadowColor() != null) {
            labelDropShadowColorBGCP.setValue((Object)ls.getDropShadowColor());
        }
        gp2.add((Node)labelDropShadowColorBGCP, 11, count);
        FocusSpinner labelDropShadowRadiusSpinner = new FocusSpinner(0.0, 100.0, ls == null ? 5.0 : ls.getDropShadowRadius());
        this.labelDropShadowRadiusSpinnersMap.put(key, labelDropShadowRadiusSpinner);
        labelDropShadowRadiusSpinner.setMaxWidth(70.0);
        labelDropShadowRadiusSpinner.setMinWidth(70.0);
        gp2.add(labelDropShadowRadiusSpinner, 12, count);
        FocusSpinner labelDropShadowSpreadSpinner = new FocusSpinner(0.0, 1.0, ls == null ? 0.2 : ls.getDropShadowSpread(), 0.1);
        this.labelDropShadowSpreadSpinnersMap.put(key, labelDropShadowSpreadSpinner);
        labelDropShadowSpreadSpinner.setMaxWidth(70.0);
        labelDropShadowSpreadSpinner.setMinWidth(70.0);
        gp2.add(labelDropShadowSpreadSpinner, 13, count);
        Button resetbutton = new Button("Reset");
        resetbutton.setMaxWidth(65.0);
        resetbutton.setMinWidth(65.0);
        gp2.add((Node)resetbutton, 14, count);
        gp2.add((Node)new Label("  "), 15, count);
        CheckBox removeCB = new CheckBox("");
        removeCB.setMaxWidth(30.0);
        removeCB.setMinWidth(30.0);
        this.removeCBsMap.put(key, removeCB);
        gp2.add((Node)removeCB, 16, count);
        return ++count;
    }
}

