/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.TerrainType;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.widget.ColorPickerWithSelector;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ConfigureTerrainScreen
extends ConfigureScreen {
    final Map<String, ColorPicker> backgroundCPsMap = new HashMap<String, ColorPicker>();
    final Map<String, Image> changedImagesMap = new HashMap<String, Image>();
    final Map<String, Spinner<Double>> sizeSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, Spinner<Double>> offsetXSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, Spinner<Double>> offsetYSpinnersMap = new HashMap<String, Spinner<Double>>();
    final Map<String, TextField> elevationTFsMap = new HashMap<String, TextField>();
    final Map<String, ListView<String>> similarTerrainListViewMap = new HashMap<String, ListView<String>>();
    final Map<String, CheckBox> removeImageCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> removeCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> keyTFsMap = new HashMap<String, TextField>();
    final String filter;
    int numTerrainRows;

    public ConfigureTerrainScreen(Worldographer ms, String filter) {
        super(ms, 1060, 400);
        switch (filter) {
            case "Isometric Columns": {
                this.filter = "iso cols";
                break;
            }
            case "Isometric Rows": {
                this.filter = "iso rows";
                break;
            }
            case "Isometric": {
                this.filter = "iso ";
                break;
            }
            default: {
                this.filter = filter.toLowerCase();
            }
        }
        this.worldographer.colorPickerWithSelectorList.clear();
    }

    @Override
    public void setValues() {
        this.title = "Configure Terrain";
        this.configureLabel = "";
        this.configureTitle = "Configure Terrain Instructions";
        this.configureHeader = "Bulk Edit Terrain Data/Settings.";
        this.configureScreenHelpText = "<p>Note you may also right click on a Terrain button (on the Terrain tab/toolbox) and choose 'Configure' to edit individual terrain.</p>\n<h3>Add</h3><p>Click the 'Add Row' button to add a new terrain type to the system. You may have to scroll down to the new row.</p><h3>Configure</h3>\n<ul><li>Key: System name and usually the name of the terrain shown to the user in tooltips and such.</li>\n<li>BG Color: The background color of the terrain.  If the icon covers the full tile area, you won't see the background.</li>\n<li>--The adjacent medicine dropper lets you select a color by clicking anywhere in Worldgrapher's windows.</li>\n<li>Icon: The current icon for the terrain is displayed below. Change it to another file on your computer with the 'Choose File' button.</li>\n<li>Remove: If you want to remove the icon and no longer have an icon for this terrain, select this.</li>\n<li>Elevation: Set an elevation for the terrain. The defaults are in feet and when specific terrain is placed, it uses this number as well as the adjacent terrain's     elevation on the map to randomly set a new value. The final number can vary wildly in a thick mountain area for example.</li>\n<li>Offset X: You can shift the location of the icon within the terrain's tile.  This is a percentage of a tile with 0 being centered. Negative values will move it left, positive go right.</li>\n<li>Offset Y: As Offset X, but vertically. Negative values will move the icon up, positive down.</li>\n<li>Related Terrain: Select any number of terrain that may be randomly substituted with this terrain for placing terrain when the 'Shuffle' button on the Terrain toolbox/tab is on.    (Note: Configuring this on the edit individual terrain is easier for this--it has a larger list.)</li>\n<li>Reset: Reset's this row's data to what was here when you opened this window.</li></ul>\n<h3>Remove</h3>\n<p>Use the 'Remove' checkbox to remove that row's terrain from Worldographer then click 'Apply' on the bottom..  (Note: Default/built-in terrain will come back when Worldographer is re-launched.)</p>";
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        TerrainType tt;
        TerrainType tt2;
        Object name;
        CheckBox cb;
        for (String key : this.changedImagesMap.keySet()) {
            if (key.startsWith("temp###")) {
                cb = this.removeCBsMap.get(key);
                if (cb.isSelected()) continue;
                name = this.keyTFsMap.get(key).getText();
                if (((String)name).trim().equals("")) {
                    name = "No Name " + key.substring(6);
                    this.keyTFsMap.get(key).setText((String)name);
                }
                tt2 = new TerrainType((String)name, this.changedImagesMap.get(key), (Double)this.sizeSpinnersMap.get(key).getValue() / 100.0, (Color)this.backgroundCPsMap.get(key).getValue(), Integer.parseInt(this.elevationTFsMap.get(key).getText()), false);
                tt2.setOffsetXDecimal((Double)this.offsetXSpinnersMap.get(key).getValue() / 100.0);
                tt2.setOffsetYDecimal((Double)this.offsetYSpinnersMap.get(key).getValue() / 100.0);
                Terrain.terrainTypes.put((String)name, tt2);
                continue;
            }
            Terrain.terrainTypes.get(key).setDefaultAndUnchanged(false);
            Terrain.terrainTypes.get(key).setIcon(this.changedImagesMap.get(key));
        }
        for (String key : this.removeImageCBsMap.keySet()) {
            CheckBox ricb = this.removeImageCBsMap.get(key);
            if (!ricb.isSelected()) continue;
            TerrainType tt3 = Terrain.terrainTypes.get(key);
            tt3.setIcon(null);
            tt3.setDefaultAndUnchanged(false);
        }
        for (String key : this.backgroundCPsMap.keySet()) {
            if (!key.startsWith("temp###")) {
                tt = Terrain.terrainTypes.get(key);
                if (tt.getBgColor() != null && !tt.getBgColor().equals(this.backgroundCPsMap.get(key).getValue())) {
                    tt.setBgColor((Color)this.backgroundCPsMap.get(key).getValue());
                    tt.setDefaultAndUnchanged(false);
                }
                tt.setBgColor((Color)this.backgroundCPsMap.get(key).getValue());
                continue;
            }
            if (this.changedImagesMap.containsKey(key) || (cb = this.removeCBsMap.get(key)).isSelected()) continue;
            name = this.keyTFsMap.get(key).getText();
            if (((String)name).trim().equals("")) {
                name = "No Name " + key.substring(6);
                this.keyTFsMap.get(key).setText((String)name);
            }
            tt2 = new TerrainType((String)name, this.changedImagesMap.get(key), (Double)this.sizeSpinnersMap.get(key).getValue() / 100.0, (Color)this.backgroundCPsMap.get(key).getValue(), Integer.parseInt(this.elevationTFsMap.get(key).getText()), false);
            Terrain.terrainTypes.put((String)name, tt2);
        }
        for (String key : this.sizeSpinnersMap.keySet()) {
            if (key.startsWith("temp###") || (tt = Terrain.terrainTypes.get(key)).getIconSize() == (Double)this.sizeSpinnersMap.get(key).getValue() / 100.0) continue;
            tt.setIconSize((Double)this.sizeSpinnersMap.get(key).getValue() / 100.0);
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.offsetXSpinnersMap.keySet()) {
            if (key.startsWith("temp###") || (tt = Terrain.terrainTypes.get(key)).getOffsetXDecimal() == (Double)this.offsetXSpinnersMap.get(key).getValue() / 100.0) continue;
            tt.setOffsetXDecimal((Double)this.offsetXSpinnersMap.get(key).getValue() / 100.0);
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.offsetYSpinnersMap.keySet()) {
            if (key.startsWith("temp###") || (tt = Terrain.terrainTypes.get(key)).getOffsetYDecimal() == (Double)this.offsetYSpinnersMap.get(key).getValue() / 100.0) continue;
            tt.setOffsetYDecimal((Double)this.offsetYSpinnersMap.get(key).getValue() / 100.0);
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.elevationTFsMap.keySet()) {
            if (key.startsWith("temp###") || (tt = Terrain.terrainTypes.get(key)).getElevation() == Integer.parseInt(this.elevationTFsMap.get(key).getText())) continue;
            tt.setElevation(Integer.parseInt(this.elevationTFsMap.get(key).getText()));
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.similarTerrainListViewMap.keySet()) {
            if (key.startsWith("temp###")) continue;
            tt = Terrain.terrainTypes.get(key);
            ObservableList items = this.similarTerrainListViewMap.get(key).getSelectionModel().getSelectedItems();
            boolean terrainChanged = false;
            if (tt.getSimilarTerrain() == null) {
                if (items.size() > 0) {
                    terrainChanged = true;
                }
            } else if (items.size() != tt.getSimilarTerrain().length) {
                terrainChanged = true;
            } else {
                for (int i = 0; i < items.size(); ++i) {
                    if (items.contains(tt.getSimilarTerrain()[i])) continue;
                    terrainChanged = true;
                }
            }
            if (!terrainChanged) continue;
            tt.setSimilarTerrain(items.toArray(new String[0]));
            tt.setDefaultAndUnchanged(false);
        }
        for (String key : this.removeCBsMap.keySet()) {
            if (key.startsWith("temp###") || key.startsWith("tempfeature###") || key.startsWith("temptext###") || !(cb = this.removeCBsMap.get(key)).isSelected()) continue;
            Terrain.terrainTypes.remove(key);
        }
        this.worldographer.terrainToolbox.clearTerrainButtons();
        this.worldographer.terrainToolbox.updateTerrainButtonsFlow();
    }

    @Override
    protected Node createGrid() {
        GridPane gp1 = new GridPane();
        gp1.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        Label l1 = new Label("Key");
        l1.setMinWidth(150.0);
        gp1.add((Node)l1, 0, 0);
        Label l2 = new Label("BG Color");
        l2.setMinWidth(120.0);
        gp1.add((Node)l2, 1, 0);
        Label l3 = new Label("Icon");
        l3.setMinWidth(160.0);
        gp1.add((Node)l3, 2, 0, 2, 1);
        Label l6 = new Label("Remove");
        l6.setMinWidth(80.0);
        gp1.add((Node)l6, 4, 0);
        Label l4 = new Label("Size");
        l4.setMinWidth(70.0);
        gp1.add((Node)l4, 5, 0);
        Label l5 = new Label("Elevation");
        l5.setMinWidth(60.0);
        gp1.add((Node)l5, 6, 0);
        Label offX = new Label("Offset X");
        offX.setMinWidth(70.0);
        gp1.add((Node)offX, 7, 0);
        Label offY = new Label("Offset Y");
        offY.setMinWidth(70.0);
        gp1.add((Node)offY, 8, 0);
        Label l7 = new Label("Related Terrain");
        l7.setMinWidth(100.0);
        gp1.add((Node)l7, 9, 0);
        GridPane gp2 = new GridPane();
        gp2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        int count = 0;
        ArrayList<String> filteredTerrain = new ArrayList<String>();
        for (String key : Terrain.terrainTypes.keySet()) {
            if (!this.filter.equals("all terrain") && !key.toLowerCase().contains(this.filter) && (!this.filter.equals("classic") || key.toLowerCase().contains("cosmic") || key.toLowerCase().contains("floor") || key.toLowerCase().contains("iso cols") || key.toLowerCase().contains("iso rows"))) continue;
            filteredTerrain.add(key);
        }
        for (String key : filteredTerrain) {
            count = this.createTerrainRow(gp2, count, key, filteredTerrain);
        }
        this.numTerrainRows = count;
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        HBox bottombox = new HBox();
        Button addrowbutton = new Button("Add Row");
        addrowbutton.setOnAction(event -> {
            this.numTerrainRows = this.createTerrainRow(gp2, this.numTerrainRows, "temp###" + Math.random(), filteredTerrain);
            scrollpane.setVvalue(scrollpane.getVmax() + 20.0);
        });
        bottombox.getChildren().add((Object)addrowbutton);
        bp.setBottom((Node)bottombox);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private int createTerrainRow(GridPane gp2, int count, String key, List<String> filteredTerrain) {
        TerrainType tt = Terrain.terrainTypes.get(key);
        TextField tf = new TextField("");
        tf.setMaxWidth(150.0);
        tf.setMinWidth(150.0);
        gp2.add((Node)tf, 0, count);
        this.keyTFsMap.put(key, tf);
        if (tt != null) {
            tf.setText(key);
            tf.setEditable(false);
        }
        ColorPicker terrainBGCP = new ColorPicker(tt == null ? Color.BLUE : tt.getBgColor());
        this.backgroundCPsMap.put(key, terrainBGCP);
        ColorPickerWithSelector terrainColorPickerWSelector = new ColorPickerWithSelector(terrainBGCP);
        terrainColorPickerWSelector.setMaxWidth(120.0);
        gp2.add(terrainColorPickerWSelector.getNode(), 1, count);
        this.worldographer.colorPickerWithSelectorList.add(terrainColorPickerWSelector);
        ImageView iv = new ImageView(tt == null ? null : tt.getIcon());
        iv.setFitWidth(60.0);
        iv.setFitHeight(60.0);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        iv.setCache(true);
        Label imagelabel = new Label("", (Node)iv);
        gp2.add((Node)imagelabel, 2, count);
        Button iconfilebutton = new Button("Choose File");
        iconfilebutton.setMaxWidth(100.0);
        iconfilebutton.setOnAction(event -> {
            File d = FileSaveLoad.getLastUsedDir();
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("Graphic Interchange Format (*.gif)", new String[]{"*.gif"});
            FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPeG Graphics (*.jpg)", new String[]{"*.jpg"});
            FileChooser.ExtensionFilter extFilter3 = new FileChooser.ExtensionFilter("Portable Network Graphics (*.png)", new String[]{"*.png"});
            fc.getExtensionFilters().add((Object)extFilter3);
            fc.getExtensionFilters().add((Object)extFilter2);
            fc.getExtensionFilters().add((Object)extFilter1);
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            fc.setTitle("Select Image");
            File f = fc.showOpenDialog((Window)this.primaryStage);
            if (f != null) {
                Image image = new Image("file:" + f.getAbsolutePath());
                iv.setImage(image);
                this.changedImagesMap.put(key, image);
                FileSaveLoad.updateLastUsedDir(f.getParentFile());
            }
        });
        gp2.add((Node)iconfilebutton, 3, count);
        CheckBox removeImageCB = new CheckBox("Remove\nImage");
        removeImageCB.setMaxWidth(80.0);
        this.removeImageCBsMap.put(key, removeImageCB);
        gp2.add((Node)removeImageCB, 4, count);
        FocusSpinner sizespinner = new FocusSpinner(1.0, 400.0, tt == null ? 85.0 : tt.getIconSize() * 100.0);
        sizespinner.setMaxWidth(70.0);
        gp2.add(sizespinner, 5, count);
        sizespinner.setEditable(true);
        this.sizeSpinnersMap.put(key, sizespinner);
        TextField elevationTF = new TextField();
        DecimalFormat format = new DecimalFormat("######");
        format.setParseIntegerOnly(true);
        elevationTF.setText(Integer.toString(tt == null ? 0 : tt.getElevation()));
        elevationTF.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Number object = format.parse(c.getControlNewText(), parsePosition);
            if (object == null || parsePosition.getIndex() < c.getControlNewText().length()) {
                return null;
            }
            return c;
        }));
        elevationTF.setMaxWidth(60.0);
        gp2.add((Node)elevationTF, 6, count);
        this.elevationTFsMap.put(key, elevationTF);
        Spinner offsetXSpinner = new Spinner(-1000.0, 1000.0, tt.getOffsetXDecimal() * 100.0);
        offsetXSpinner.setEditable(true);
        offsetXSpinner.setMaxWidth(70.0);
        gp2.add((Node)offsetXSpinner, 7, count);
        this.offsetXSpinnersMap.put(key, (Spinner<Double>)offsetXSpinner);
        Spinner offsetYSpinner = new Spinner(-1000.0, 1000.0, tt.getOffsetYDecimal() * 100.0);
        offsetYSpinner.setEditable(true);
        offsetYSpinner.setMaxWidth(70.0);
        gp2.add((Node)offsetYSpinner, 8, count);
        this.offsetYSpinnersMap.put(key, (Spinner<Double>)offsetYSpinner);
        ListView similarTerrainListView = new ListView();
        ObservableList items = FXCollections.observableArrayList(filteredTerrain);
        similarTerrainListView.setItems(items);
        similarTerrainListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        if (tt != null && tt.getSimilarTerrain() != null) {
            for (String similar : tt.getSimilarTerrain()) {
                similarTerrainListView.getSelectionModel().select((Object)similar);
            }
        }
        similarTerrainListView.setMaxSize(140.0, 80.0);
        this.similarTerrainListViewMap.put(key, (ListView<String>)similarTerrainListView);
        gp2.add((Node)similarTerrainListView, 9, count);
        Button resetbutton = new Button("Reset");
        resetbutton.setMaxWidth(60.0);
        resetbutton.setMinWidth(60.0);
        resetbutton.setOnAction(event -> {
            Map<String, TerrainType> terraindefaults = TerrainType.setupDefaults();
            TerrainType tt2 = terraindefaults.get(key);
            if (tt2 != null) {
                terrainBGCP.setValue((Object)tt2.getBgColor());
                iv.setImage(tt2.getIcon());
                this.changedImagesMap.put(key, tt2.getIcon());
                elevationTF.setText(Integer.toString(tt2.getElevation()));
                sizespinner.getValueFactory().setValue((Object)(tt2.getIconSize() * 100.0));
                offsetXSpinner.getValueFactory().setValue((Object)(tt2.getOffsetXDecimal() * 100.0));
                offsetYSpinner.getValueFactory().setValue((Object)(tt2.getOffsetYDecimal() * 100.0));
            }
        });
        VBox resetRemoveBox = new VBox();
        resetRemoveBox.setAlignment(Pos.CENTER_LEFT);
        Button resetToDefaultButton = new Button("Reset to Orig.");
        resetToDefaultButton.setOnAction(event -> {
            Map<String, TerrainType> terraindefaults = TerrainType.setupDefaults();
            TerrainType tt2 = terraindefaults.get(key);
            if (tt2 != null) {
                terrainBGCP.setValue((Object)tt2.getBgColor());
                iv.setImage(tt2.getIcon());
                this.changedImagesMap.put(key, tt2.getIcon());
                elevationTF.setText(Integer.toString(tt2.getElevation()));
                sizespinner.getValueFactory().setValue((Object)(tt2.getIconSize() * 100.0));
                offsetXSpinner.getValueFactory().setValue((Object)(tt2.getOffsetXDecimal() * 100.0));
                offsetYSpinner.getValueFactory().setValue((Object)(tt2.getOffsetYDecimal() * 100.0));
                ObservableList similarItems = FXCollections.observableArrayList(Terrain.terrainTypes.keySet());
                similarTerrainListView.setItems(similarItems);
                similarTerrainListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                if (tt2 != null && tt2.getSimilarTerrain() != null) {
                    for (String similar : tt2.getSimilarTerrain()) {
                        similarTerrainListView.getSelectionModel().select((Object)similar);
                    }
                }
            }
        });
        gp2.add((Node)resetRemoveBox, 10, count);
        CheckBox removeCB = new CheckBox("Remove");
        this.removeCBsMap.put(key, removeCB);
        resetRemoveBox.getChildren().addAll((Object[])new Node[]{resetToDefaultButton, resetbutton, removeCB});
        return ++count;
    }
}

