/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.configure;

import com.inkwellideas.ographer.generator.city.CityDataGenerator;
import com.inkwellideas.ographer.generator.city.SettlementData;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.io.FileSaveLoad;
import com.inkwellideas.ographer.io.LoadGeneratorData;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.configure.ConfigureScreen;
import com.inkwellideas.ographer.ui.dialog.StandardDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Pair;

public class ConfigureWorldAndNamesDataScreen
extends ConfigureScreen {
    Tab languagesTab;
    Tab featuresTab;
    Tab religionsTab;
    Tab culturesTab;
    Tab encountersTab;
    final ComboBox<String> languagesListCombo = new ComboBox();
    final Map<String, TextField> conRuleTFs = new HashMap<String, TextField>();
    final Map<String, Spinner<Integer>> conRuleSpinners = new HashMap<String, Spinner<Integer>>();
    final Map<String, TextField> syllableTFs = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeConRuleCBsMap = new HashMap<String, CheckBox>();
    final Map<String, CheckBox> removeSyllableSetCBsMap = new HashMap<String, CheckBox>();
    final ComboBox<String> featuresListCombo = new ComboBox();
    final Map<String, TextField> featureTFs = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeFeatureCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> religionTFs = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeReligionCBsMap = new HashMap<String, CheckBox>();
    final Map<String, TextField> cultureTFs = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeCultureCBsMap = new HashMap<String, CheckBox>();
    String[] levels = new String[]{"Major", "Medium", "Minor"};
    final ComboBox<String> terrainListCombo = new ComboBox();
    final ComboBox<String> encounterLevelListCombo = new ComboBox(FXCollections.observableList(Arrays.stream(this.levels).toList()));
    final Map<String, TextField> encounterKeyTFs = new HashMap<String, TextField>();
    final Map<String, TextField> encounterValueTFs = new HashMap<String, TextField>();
    final Map<String, CheckBox> removeEncounterCBsMap = new HashMap<String, CheckBox>();
    int numBuildingRows;

    public ConfigureWorldAndNamesDataScreen(Worldographer ms) {
        super(ms, 1060, 400);
    }

    @Override
    public void setValues() {
        this.title = "Configure World & Name Data";
        this.configureLabel = "";
        this.configureTitle = "Configure World & Name Data Instructions";
        this.configureHeader = "Configure World & Name Data Data Instructions";
        this.configureScreenHelpText = "<p>These tabs control how names and feature, religion, and culture information are generated.</p>\n<p>Note: Some things (such as adding new rows of info) will automatically apply changes made so\nfar.  But you must click 'apply' for any changes after to take effect otherwise.</p>\n<p>'Save Configuration' also performs an 'apply' before saving.</p>\n\n<h3>Names By Language Tab</h3>\n<p>The most complex tab of this configuration dialog, start by selecting a language in the\ndrop-down or adding one with the 'Add' Language button. You may also remove a language with the\n 'Remove Selected' button after selecting a language.</p>\n<p>The tab has two main sections: one for Location Naming and another for Person Naming. The\ntwo sections are very similar.  However, note that the keys for person name syllable lists must\nstart with 'M' and 'F' and each person name list must have at least one of each.</p>\n<ul>\n<li>'Add Construction Rule' and 'Add Syllable Set': Each button adds a new row for the chosen\npurpose.  This automatically applies your changes to date.</li>\n<li>A construction rule simply lists the syllable keys to combine, separated by commas. For\nexample, if the rule is 'F1,F2' the system will look at the Fl and F2 syllables lists, pick one of each and combine them. So if F1 has \"Ash\" in the list and F2 has \"wyn\" in the Ashwyn is one possible name.</li>\n<li>The percentage represents the likelihood that rule is used. They must add up to 100%.\nYou'll want to make sure there is some chance of male and female person names because the\nperson generator may randomly create men or women. Male syllable lists have keys that start\nwith 'M' and female lists have keys starting with 'F'.</li>\n<li>Syllable sets are simple lists of syllables (or full names with the construction rule\nset to just one \"syllable\" which is actually a full name) separated by commas.</li>\n<li>'Remove Rule' and 'Remove Set' will remove that line from the possibilities when changes\n are next applied.</li>\n</ul>\n<h3>Feature Infomation Tab</h3>\n<p>Every feature added to the map can have details generated about it.  (Place the feature on\nthe map, then select the feature, then click the 'Notes of Selected' button the first time.  \nThereafter, you can open the note the same way or by clicking on it on the map with the\n 'Add/Edit/View Note' button on the 'View Options' drawer.</p>\n<p>The information generated is chosen based on the values here. Start by selecting a feature\n in the drop-down or adding one with the 'Add New Feature Type' button. (Remove a Feature Type's data generation settings with the 'Remove Selected' button after selecting a feature.)</p>\n<p>'Add New Attribute' will add a new attribute to this Feature Type. For example: Condition.\n This will apply changes made so far. Then a new row will appear for 'Condition' and a blank field.  As the text above the fields lists, options should be separated by semicolons. \nEach option can contain some value to vary where the variations are separated by commas and\nsurrounded by brackets.  For example \"In ruins covered in [vines,ivy,dust].\"</p>\n<p>'Remove Option' removes that row of info when changes are next applied.\n<h3>Religions Tab</h3>\n<p>This simply allows you to add domains and options for their holy symbols. The religions\nand domains are generated when you create a world/kingdom map.  Go to 'Data' in the menu bar and select 'World Info' to see it. You may also re-generate it.</p>\n<p>The 'Add Domain' button will add a new row for another religion and its holy symbols.</p>\n<p>Each domain has its own row with a textfield for various holy symbol options separated\nby commas.</p>\n<p>A remove checkbox will remove that domain when changes are next applied.</p>\n<h3>Cultures Tab</h3>\n<p>As with religion information, the cultures data is used to create World Information\n(see above).</p>\n<p>This tab allows you to list attributes for each culture, and one of the comma separated\nvalues is randomly chosen.</p>\n<p>The 'Add New Attribute' button creates a new row for a new attribute. A remove checkbox\nwill remove that attribute when changes are next applied.</p>\n<h3>Load/Save/Close/Apply</h3>\n<ul>\n<li>Load Configuration: Load saved settlement configuration data.</li>\n<li>Save Configuration: Save the current settlement configuration data. Implicitly calls\n'Apply' in case there are unsaved changes.</li>\n<li>Close: Closes the dialog without saving.</li>\n<li>Apply: Stores the configuration changes for use until Worldographer restarts.</li>\n</ul>";
    }

    @Override
    protected HBox createBottomBar() {
        HBox bottombar = super.createBottomBar();
        Button loadButton = new Button("Load Configuration");
        loadButton.setOnAction(t -> {
            File f;
            StyledDialog numhexesdialog = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Worldographer World/Name Configuration Data Load");
            numhexesdialog.setHeaderText("Should the old data be kept/added to or cleared/remvoed?");
            RadioButton rb1 = new RadioButton("Keep/Add to prior data ");
            RadioButton rb2 = new RadioButton("Clear prior data");
            ToggleGroup bg = new ToggleGroup();
            bg.getToggles().add((Object)rb1);
            bg.getToggles().add((Object)rb2);
            rb2.setSelected(true);
            HBox hbox = new HBox();
            hbox.getChildren().add((Object)rb1);
            hbox.getChildren().add((Object)rb2);
            numhexesdialog.getDialogPane().setContent((Node)hbox);
            ButtonType ok1 = new ButtonType("OK");
            ButtonType cancel = new ButtonType("Cancel");
            numhexesdialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1, cancel});
            Optional result = numhexesdialog.showAndWait();
            if (result.isPresent() && result.get() == cancel) {
                return;
            }
            if (rb2.isSelected()) {
                WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.clear();
                WorldAndNameData.DOMAINS_TO_SYMBOLS.clear();
                WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.clear();
                WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.clear();
                WorldAndNameData.LOCATION_NAME_TYPES.clear();
                WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.clear();
                WorldAndNameData.NAME_TYPES_TO_SYLLABLES.clear();
                WorldAndNameData.PERSON_NAME_TYPES.clear();
                WorldAndNameData.ENCOUNTERS_BY_TERRAIN.clear();
            }
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" Properties File (*.properties)", new String[]{"*.prop*"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showOpenDialog(null)) != null) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    WorldAndNameData.loadProps(fis);
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    this.primaryStage.close();
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Loaded", "World and Name Data Loaded", "Reopen the world and name configuration screen to\nsee the changes", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while loading your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(1, (Object)loadButton);
        Button saveButton = new Button("Save Configuration");
        saveButton.setOnAction(event -> {
            File f;
            this.applyChanges(true);
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(" Properties File (*.properties)", new String[]{"*.properties"});
            fc.getExtensionFilters().add((Object)extFilter);
            File d = FileSaveLoad.getLastUsedDir();
            if (d != null) {
                fc.setInitialDirectory(d);
            }
            if ((f = fc.showSaveDialog(null)) != null) {
                try {
                    String exportconfig = WorldAndNameData.createExportString();
                    FileOutputStream fos = new FileOutputStream(f);
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                    w.write(exportconfig);
                    w.flush();
                    w.close();
                    FileSaveLoad.updateLastUsedDir(f.getParentFile());
                    StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Configuration Saved", "World/Name Configuration Saved", "The world and name configuration was successfully saved.", null, null);
                }
                catch (Exception e) {
                    StandardDialog.showException(this.worldographer.getPrimaryStage(), "Error", "Error", "There was an error while saving your file.", "The stacktrace was:", e);
                }
            }
        });
        bottombar.getChildren().add(2, (Object)saveButton);
        return bottombar;
    }

    @Override
    protected void applyChanges(boolean userinitiated) {
        Set<String> l;
        String endkey;
        String topkey;
        CheckBox cb;
        TreeSet<String> al;
        ArrayList<String> personsubkeys = new ArrayList<String>();
        ArrayList<String> locationsubkeys = new ArrayList<String>();
        for (String conrulekey : this.conRuleTFs.keySet()) {
            if (conrulekey.startsWith("PersonName")) {
                personsubkeys.add(conrulekey.substring(conrulekey.lastIndexOf(".") + 1));
                continue;
            }
            locationsubkeys.add(conrulekey.substring(conrulekey.lastIndexOf(".") + 1));
        }
        HashMap overallrulemap = new HashMap();
        int personsubkeycount = 0;
        int locationsubkeycount = 0;
        for (String conrulekey : this.conRuleTFs.keySet()) {
            String overallkey = conrulekey.substring(0, conrulekey.lastIndexOf("."));
            if (conrulekey.startsWith("PersonName")) {
                if (!overallrulemap.containsKey(overallkey)) {
                    overallrulemap.put(overallkey, new TreeSet());
                }
                ((Set)overallrulemap.get(overallkey)).add((String)personsubkeys.get(personsubkeycount) + ":" + (double)((Integer)this.conRuleSpinners.get(conrulekey).getValue()).intValue() / 100.0);
                ++personsubkeycount;
            } else {
                if (!overallrulemap.containsKey(overallkey)) {
                    overallrulemap.put(overallkey, new TreeSet());
                }
                ((Set)overallrulemap.get(overallkey)).add((String)locationsubkeys.get(locationsubkeycount) + ":" + (double)((Integer)this.conRuleSpinners.get(conrulekey).getValue()).intValue() / 100.0);
                ++locationsubkeycount;
            }
            TreeSet<String> al2 = new TreeSet<String>();
            al2.add(this.conRuleTFs.get(conrulekey).getText());
            WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put(conrulekey, al2);
        }
        for (String k : overallrulemap.keySet()) {
            WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.remove(k);
            WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put(k, (Set)overallrulemap.get(k));
        }
        ArrayList<String> personsubsyllkeys = new ArrayList<String>();
        ArrayList<String> locationsubsyllkeys = new ArrayList<String>();
        for (String syllkey : this.syllableTFs.keySet()) {
            if (syllkey.startsWith("PersonName")) {
                personsubsyllkeys.add(syllkey.substring(syllkey.lastIndexOf(".") + 1));
                continue;
            }
            locationsubsyllkeys.add(syllkey.substring(syllkey.lastIndexOf(".") + 1));
        }
        StringBuilder personoverallsyll = new StringBuilder();
        int personsubsyllkeycount = 0;
        StringBuilder locationoverallsyll = new StringBuilder();
        int locationsubsyllkeycount = 0;
        for (String syllkey : this.syllableTFs.keySet()) {
            if (syllkey.startsWith("PersonName")) {
                if (personoverallsyll.length() > 0) {
                    personoverallsyll.append(",");
                }
                personoverallsyll.append((String)personsubsyllkeys.get(personsubsyllkeycount));
                ++personsubsyllkeycount;
            } else {
                if (locationoverallsyll.length() > 0) {
                    locationoverallsyll.append(",");
                }
                locationoverallsyll.append((String)locationsubsyllkeys.get(locationsubsyllkeycount));
                ++locationsubsyllkeycount;
            }
            al = new TreeSet<String>(Arrays.asList(this.syllableTFs.get(syllkey).getText().split(",")));
            WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put(syllkey, al);
        }
        if (this.syllableTFs.size() > 0) {
            Object overallsyllkey = this.syllableTFs.keySet().iterator().next();
            overallsyllkey = ((String)overallsyllkey).substring(0, ((String)overallsyllkey).lastIndexOf("."));
            TreeSet al3 = new TreeSet();
            if (((String)overallsyllkey).startsWith("PersonName")) {
                Collections.addAll(al3, personoverallsyll.toString().split(","));
            } else {
                Collections.addAll(al3, locationoverallsyll.toString().split(","));
            }
            WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put((String)overallsyllkey, al3);
        }
        for (String domain : this.religionTFs.keySet()) {
            al = new TreeSet<String>(Arrays.asList(this.religionTFs.get(domain).getText().split(",")));
            WorldAndNameData.DOMAINS_TO_SYMBOLS.put(domain, al);
        }
        for (String cultureattr : this.cultureTFs.keySet()) {
            al = new TreeSet<String>(Arrays.asList(this.cultureTFs.get(cultureattr).getText().split(",")));
            WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.put(cultureattr, al);
        }
        HashMap featureattributes = new HashMap();
        for (String key : this.featureTFs.keySet()) {
            String keynotab = key.replace('\t', '.');
            TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.featureTFs.get(key).getText().split(";")));
            WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.put(keynotab, set);
            String fe = key.substring(0, key.indexOf("\t"));
            String attr = key.substring(key.indexOf("\t") + 1);
            if (featureattributes.containsKey(fe)) {
                ((Set)featureattributes.get(fe)).add(attr);
                continue;
            }
            TreeSet<String> al4 = new TreeSet<String>();
            al4.add(attr);
            featureattributes.put(fe, al4);
        }
        for (String key : featureattributes.keySet()) {
            WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.put(key, (Set)featureattributes.get(key));
        }
        for (String key : this.encounterKeyTFs.keySet()) {
            if (this.removeEncounterCBsMap.get(key).isSelected()) continue;
            String[] splitkey = key.split("\t");
            Map<String, Map<String, Pair<String, String>>> terrainEncounters = WorldAndNameData.ENCOUNTERS_BY_TERRAIN.get(splitkey[0]);
            Map<String, Pair<String, String>> terrainLevelEncounters = terrainEncounters.get(splitkey[1]);
            if (!splitkey[2].equals(this.encounterKeyTFs.get(key).getText())) {
                terrainLevelEncounters.remove(splitkey[2]);
            }
            Pair pair = new Pair((Object)this.encounterKeyTFs.get(key).getText(), (Object)this.encounterValueTFs.get(key).getText());
            terrainLevelEncounters.put(this.encounterKeyTFs.get(key).getText(), (Pair<String, String>)pair);
        }
        for (String key : this.removeConRuleCBsMap.keySet()) {
            cb = this.removeConRuleCBsMap.get(key);
            if (!cb.isSelected()) continue;
            WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.remove(key);
            topkey = key.substring(0, key.lastIndexOf("."));
            endkey = key.substring(key.lastIndexOf(".") + 1);
            l = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get(topkey);
            String toremove = null;
            for (String k : l) {
                if (!endkey.equals(k.substring(0, k.indexOf(":")))) continue;
                toremove = k;
            }
            if (toremove == null) continue;
            l.remove(toremove);
        }
        for (String key : this.removeSyllableSetCBsMap.keySet()) {
            cb = this.removeSyllableSetCBsMap.get(key);
            if (!cb.isSelected()) continue;
            WorldAndNameData.NAME_TYPES_TO_SYLLABLES.remove(key);
            topkey = key.substring(0, key.lastIndexOf("."));
            endkey = key.substring(key.lastIndexOf(".") + 1);
            l = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get(topkey);
            l.remove(endkey);
        }
        for (String key : this.removeCultureCBsMap.keySet()) {
            cb = this.removeCultureCBsMap.get(key);
            if (!cb.isSelected()) continue;
            WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.remove(key);
        }
        for (String key : this.removeReligionCBsMap.keySet()) {
            cb = this.removeReligionCBsMap.get(key);
            if (!cb.isSelected()) continue;
            WorldAndNameData.DOMAINS_TO_SYMBOLS.remove(key);
        }
        for (String key : this.removeFeatureCBsMap.keySet()) {
            cb = this.removeFeatureCBsMap.get(key);
            if (!cb.isSelected()) continue;
            String fe = key.substring(0, key.indexOf("\t"));
            String attr = key.substring(key.indexOf("\t") + 1);
            Set<String> attrs = WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.get(fe);
            attrs.remove(attr);
            WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.remove(fe + "." + attr);
        }
        for (String key : this.removeEncounterCBsMap.keySet()) {
            cb = this.removeEncounterCBsMap.get(key);
            if (!cb.isSelected()) continue;
            String[] keys = key.split("\t");
            Map<String, Map<String, Pair<String, String>>> terrainEncounters = WorldAndNameData.ENCOUNTERS_BY_TERRAIN.get(keys[0]);
            Map<String, Pair<String, String>> encountersById = terrainEncounters.get(keys[1]);
            encountersById.remove(keys[2]);
        }
        this.languagesTab.setContent(this.createLanguageGrid(null));
        this.featuresTab.setContent(this.createFeaturesGrid(null));
        this.religionsTab.setContent(this.createReligionsGrid());
        this.culturesTab.setContent(this.createCulturesGrid());
        this.encountersTab.setContent(this.createEncountersGrid(null));
        if (userinitiated) {
            this.verifyLanguages();
        }
    }

    private void verifyLanguages() {
        if (CityDataGenerator.settlementData.getRaces().size() == 0) {
            CityDataGenerator.parseSettings(new LoadGeneratorData().getCityMedieval(), false);
        }
        StringBuilder verify = new StringBuilder(WorldAndNameData.verify());
        StringBuilder languagematches = new StringBuilder();
        TreeSet<String> languagemisses = new TreeSet<String>();
        for (String s : CityDataGenerator.settlementData.races.keySet()) {
            SettlementData.Race r = CityDataGenerator.settlementData.races.get(s);
            for (SettlementData.Language l : r.languages) {
                boolean found = false;
                for (String nametype : WorldAndNameData.PERSON_NAME_TYPES) {
                    if (!nametype.equalsIgnoreCase(l.getName())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    if (languagematches.toString().equals("")) {
                        languagematches = new StringBuilder("The following languages used for names (race languages in the Configure \nSettlement Data dialog had matching entries in World & Name Data: \n" + l.getName());
                        continue;
                    }
                    languagematches.append(", ").append(l.getName());
                    continue;
                }
                languagemisses.add(l.getName());
            }
        }
        if (languagemisses.size() > 0) {
            verify.append("\n").append("The following languages used for names (race languages in the Configure Settlement ").append("Data dialog) had no matching entries in World & Name Data: ");
            boolean first = true;
            for (String s : languagemisses) {
                if (first) {
                    verify.append(s);
                    first = false;
                    continue;
                }
                verify.append(", ").append(s);
            }
        }
        boolean empty = false;
        if (verify.toString().trim().equals("")) {
            verify = new StringBuilder("No problems found with naming information.");
            empty = true;
        }
        StandardDialog.showDialog(this.worldographer.getPrimaryStage(), "Language Names Verification", "Language Names Verification", "The system has checked over your language naming settings:\n" + (empty ? "No obvious errors found." : "Expand for errors:"), empty ? null : verify.toString(), "");
    }

    @Override
    protected Node createGrid() {
        TabPane tabPane = new TabPane();
        this.languagesTab = new Tab("Names by Language", this.createLanguageGrid(null));
        tabPane.getTabs().add((Object)this.languagesTab);
        this.featuresTab = new Tab("Feature Information", this.createFeaturesGrid(null));
        tabPane.getTabs().add((Object)this.featuresTab);
        this.religionsTab = new Tab("Religions", this.createReligionsGrid());
        tabPane.getTabs().add((Object)this.religionsTab);
        this.culturesTab = new Tab("Cultures", this.createCulturesGrid());
        tabPane.getTabs().add((Object)this.culturesTab);
        this.encountersTab = new Tab("Encounters", this.createEncountersGrid(null));
        tabPane.getTabs().add((Object)this.encountersTab);
        return tabPane;
    }

    private Node createFeaturesGrid(String selectedfeature) {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Label l1 = new Label("Select Feature:");
        gp1.add((Node)l1, 0, 0);
        this.featuresListCombo.getItems().removeAll((Collection)this.featuresListCombo.getItems());
        TreeSet<String> treeset = new TreeSet<String>(WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.keySet());
        this.featuresListCombo.getItems().addAll(treeset);
        gp1.add(this.featuresListCombo, 1, 0);
        this.featuresListCombo.setOnAction(event -> {
            gp2.getChildren().removeAll((Collection)gp2.getChildren());
            if (this.featuresListCombo.getSelectionModel().getSelectedItem() != null) {
                this.createFeatureSectionWrapper(gp2, 0, (String)this.featuresListCombo.getSelectionModel().getSelectedItem());
            }
        });
        if (selectedfeature != null) {
            this.featuresListCombo.getSelectionModel().select((Object)selectedfeature);
        }
        Button removeSelected = new Button("Remove Selected");
        gp1.add((Node)removeSelected, 2, 0);
        removeSelected.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirm Remove Selected");
            alert.setHeaderText("Confirm Remove Selected");
            alert.setContentText("Are you sure you wish to delete '" + (String)this.featuresListCombo.getSelectionModel().getSelectedItem() + "'?");
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == ButtonType.OK) {
                String fe = (String)this.featuresListCombo.getSelectionModel().getSelectedItem();
                Set<String> attrs = WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.remove(fe);
                for (String attr : attrs) {
                    WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.remove(fe + "." + attr);
                }
                this.featuresListCombo.getItems().removeAll((Collection)this.featuresListCombo.getItems());
                TreeSet<String> ts = new TreeSet<String>(WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.keySet());
                this.featuresListCombo.getItems().addAll(ts);
                this.featuresListCombo.getSelectionModel().select(0);
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String key : this.featureTFs.keySet()) {
                    if (!key.startsWith(fe + "\t")) continue;
                    toRemove.add(key);
                }
                toRemove.forEach(this.featureTFs.keySet()::remove);
            }
        });
        Button addtablebutton = new Button("Add New Feature Type");
        addtablebutton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Add Feature Type");
            dialog.setHeaderText("Enter New Feature Name");
            dialog.setContentText("Feature Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                this.featuresTab.setContent(this.createFeaturesGrid((String)result.get()));
            }
        });
        gp1.add((Node)addtablebutton, 4, 0);
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        scrollpane.setVvalue(0.0);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private Node createReligionsGrid() {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Button addtablebutton = new Button("Add Domain");
        gp2.add((Node)addtablebutton, 0, count);
        addtablebutton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Add Domain");
            dialog.setHeaderText("Enter New Domain Name");
            dialog.setContentText("Domain Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                WorldAndNameData.DOMAINS_TO_SYMBOLS.put((String)result.get(), new TreeSet());
                this.applyChanges(false);
                this.religionsTab.setContent(this.createReligionsGrid());
            }
        });
        ++count;
        for (String domain : WorldAndNameData.DOMAINS_TO_SYMBOLS.keySet()) {
            Label name = new Label(domain + " symbols:");
            gp2.add((Node)name, 0, count);
            StringBuilder optionstring = new StringBuilder();
            for (String opt : WorldAndNameData.DOMAINS_TO_SYMBOLS.get(domain)) {
                if (optionstring.length() > 0) {
                    optionstring.append(",");
                }
                optionstring.append(opt);
            }
            TextField ftf = new TextField(optionstring.toString());
            ftf.setMinWidth(400.0);
            this.religionTFs.put(domain, ftf);
            gp2.add((Node)ftf, 1, count);
            CheckBox removecb = new CheckBox("Remove");
            gp2.add((Node)removecb, 2, count);
            this.removeReligionCBsMap.put(domain, removecb);
            ++count;
        }
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private Node createEncountersGrid(String selectedTerrain) {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Label l1 = new Label("Select Terrain & Level:");
        gp1.add((Node)l1, 0, 0);
        this.terrainListCombo.getItems().removeAll((Collection)this.terrainListCombo.getItems());
        TreeSet<String> treeset = new TreeSet<String>(WorldAndNameData.ENCOUNTERS_BY_TERRAIN.keySet());
        this.terrainListCombo.getItems().addAll(treeset);
        gp1.add(this.terrainListCombo, 1, 0);
        this.terrainListCombo.setOnAction(event -> {
            gp2.getChildren().removeAll((Collection)gp2.getChildren());
            if (this.terrainListCombo.getSelectionModel().getSelectedItem() != null) {
                this.createEncounterSectionWrapper(gp2, 0, (String)this.terrainListCombo.getSelectionModel().getSelectedItem(), (String)this.encounterLevelListCombo.getSelectionModel().getSelectedItem());
            }
        });
        if (selectedTerrain != null) {
            this.terrainListCombo.getSelectionModel().select((Object)selectedTerrain);
        }
        gp1.add(this.encounterLevelListCombo, 2, 0);
        this.encounterLevelListCombo.getSelectionModel().select(1);
        this.encounterLevelListCombo.setOnAction(event -> {
            gp2.getChildren().removeAll((Collection)gp2.getChildren());
            if (this.terrainListCombo.getSelectionModel().getSelectedItem() != null) {
                this.createEncounterSectionWrapper(gp2, 0, (String)this.terrainListCombo.getSelectionModel().getSelectedItem(), (String)this.encounterLevelListCombo.getSelectionModel().getSelectedItem());
            }
        });
        if (selectedTerrain != null) {
            this.terrainListCombo.getSelectionModel().select((Object)selectedTerrain);
        }
        Button removeSelected = new Button("Remove Selected");
        gp1.add((Node)removeSelected, 3, 0);
        removeSelected.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirm Remove Selected");
            alert.setHeaderText("Confirm Remove Selected");
            alert.setContentText("Are you sure you wish to delete '" + (String)this.terrainListCombo.getSelectionModel().getSelectedItem() + "'?");
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == ButtonType.OK) {
                String fe = (String)this.terrainListCombo.getSelectionModel().getSelectedItem();
                WorldAndNameData.ENCOUNTERS_BY_TERRAIN.remove(fe);
                this.terrainListCombo.getItems().removeAll((Collection)this.featuresListCombo.getItems());
                TreeSet<String> ts = new TreeSet<String>(WorldAndNameData.ENCOUNTERS_BY_TERRAIN.keySet());
                this.terrainListCombo.getItems().addAll(ts);
                this.terrainListCombo.getSelectionModel().select(0);
            }
        });
        Button addTerrainButton = new Button("Add New Terrain Type");
        addTerrainButton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Add Terrain Type");
            dialog.setHeaderText("Enter New Terrain Name");
            dialog.setContentText("Terrain Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                this.encountersTab.setContent(this.createEncountersGrid((String)result.get()));
                this.terrainListCombo.getItems().add((Object)((String)result.get()));
                this.terrainListCombo.getSelectionModel().select((Object)((String)result.get()));
            }
        });
        gp1.add((Node)addTerrainButton, 4, 0);
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        scrollpane.setVvalue(0.0);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private Node createCulturesGrid() {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Button addtablebutton = new Button("Add New Attribute");
        addtablebutton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Add Culture Attribute");
            dialog.setHeaderText("Enter New Culture Attribute");
            dialog.setContentText("Attribute Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.put("CultureData." + ((String)result.get()).trim(), new TreeSet());
                this.applyChanges(false);
                this.culturesTab.setContent(this.createCulturesGrid());
            }
        });
        gp1.add((Node)addtablebutton, 1, count);
        for (String key : WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.keySet()) {
            String k = key.substring(12);
            Label name = new Label(k + ":");
            gp2.add((Node)name, 0, count);
            StringBuilder optionstring = new StringBuilder();
            for (String opt : WorldAndNameData.CULTURE_ATTRRIBUTE_OPTIONS.get(key)) {
                if (optionstring.length() > 0) {
                    optionstring.append(",");
                }
                optionstring.append(opt);
            }
            TextField ftf = new TextField(optionstring.toString());
            ftf.setMinWidth(400.0);
            this.cultureTFs.put(key, ftf);
            gp2.add((Node)ftf, 1, count);
            CheckBox removecb = new CheckBox("Remove");
            gp2.add((Node)removecb, 2, count);
            this.removeCultureCBsMap.put(key, removecb);
            ++count;
        }
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private Node createLanguageGrid(String selectedlanguage) {
        GridPane gp2 = new GridPane();
        ScrollPane scrollpane = new ScrollPane();
        GridPane gp1 = new GridPane();
        gp1.setHgap(3.0);
        gp1.setVgap(3.0);
        int count = 0;
        Label l1 = new Label("Select Language:");
        gp1.add((Node)l1, 0, 0);
        this.languagesListCombo.getItems().removeAll((Collection)this.languagesListCombo.getItems());
        TreeSet<String> languages = new TreeSet<String>();
        languages.addAll(WorldAndNameData.LOCATION_NAME_TYPES);
        languages.addAll(WorldAndNameData.PERSON_NAME_TYPES);
        this.languagesListCombo.getItems().addAll(languages);
        gp1.add(this.languagesListCombo, 1, 0);
        this.languagesListCombo.setOnAction(event -> {
            gp2.getChildren().removeAll((Collection)gp2.getChildren());
            if (this.languagesListCombo.getSelectionModel().getSelectedItem() != null) {
                this.createLanguageSectionWrapper(gp2, 0, (String)this.languagesListCombo.getSelectionModel().getSelectedItem());
            }
        });
        if (selectedlanguage != null) {
            this.languagesListCombo.getSelectionModel().select((Object)selectedlanguage);
        }
        Button removeSelected = new Button("Remove Selected");
        gp1.add((Node)removeSelected, 2, 0);
        removeSelected.setOnAction(event -> {
            if (this.languagesListCombo.getSelectionModel().getSelectedItem() != null) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Remove Selected");
                alert.setHeaderText("Confirm Remove Selected");
                alert.setContentText("Are you sure you wish to delete '" + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + "'?");
                Optional result = alert.showAndWait();
                if (result.isPresent() && result.get() == ButtonType.OK) {
                    Iterator<String> nameiter = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.keySet().iterator();
                    while (nameiter.hasNext()) {
                        String k = nameiter.next();
                        if (k.equals("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) || k.startsWith("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) {
                            nameiter.remove();
                            continue;
                        }
                        if (!k.equals("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) && !k.startsWith("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) continue;
                        nameiter.remove();
                    }
                    Iterator<String> syllableiter = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.keySet().iterator();
                    while (syllableiter.hasNext()) {
                        String k = syllableiter.next();
                        if (k.equals("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) || k.startsWith("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) {
                            syllableiter.remove();
                            continue;
                        }
                        if (!k.equals("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) && !k.startsWith("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) continue;
                        syllableiter.remove();
                    }
                    WorldAndNameData.LOCATION_NAME_TYPES.remove(this.languagesListCombo.getSelectionModel().getSelectedItem());
                    WorldAndNameData.PERSON_NAME_TYPES.remove(this.languagesListCombo.getSelectionModel().getSelectedItem());
                    this.languagesListCombo.getItems().remove(this.languagesListCombo.getSelectionModel().getSelectedItem());
                    this.languagesListCombo.getSelectionModel().select(0);
                }
            }
        });
        Button cloneSelected = new Button("Clone Selected");
        cloneSelected.setOnAction(event -> {
            if (this.languagesListCombo.getSelectionModel().getSelectedItem() != null) {
                TextInputDialog dialog = new TextInputDialog("");
                dialog.setTitle("Clone Language");
                dialog.setHeaderText("Clone Language");
                dialog.setContentText("Enter the language name:");
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    System.out.println("clone new name:" + (String)result.get());
                    TreeMap<CallSite, Set<String>> toaddsyllablesets = new TreeMap<CallSite, Set<String>>();
                    for (String k : WorldAndNameData.NAME_TYPES_TO_SYLLABLES.keySet()) {
                        String restofkey = k.substring(k.indexOf((String)this.languagesListCombo.getSelectionModel().getSelectedItem()) + ((String)this.languagesListCombo.getSelectionModel().getSelectedItem()).length());
                        if (k.equals("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) || k.startsWith("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) {
                            toaddsyllablesets.put((CallSite)((Object)("LocationName." + (String)result.get() + restofkey)), WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get(k));
                            continue;
                        }
                        if (!k.equals("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) && !k.startsWith("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) continue;
                        toaddsyllablesets.put((CallSite)((Object)("PersonName." + (String)result.get() + restofkey)), WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get(k));
                    }
                    for (String k : toaddsyllablesets.keySet()) {
                        WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put(k, (Set)toaddsyllablesets.get(k));
                    }
                    TreeMap<CallSite, Set<String>> toaddconrules = new TreeMap<CallSite, Set<String>>();
                    for (String k : WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.keySet()) {
                        String restofkey = k.substring(k.indexOf((String)this.languagesListCombo.getSelectionModel().getSelectedItem()) + ((String)this.languagesListCombo.getSelectionModel().getSelectedItem()).length());
                        if (k.equals("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) || k.startsWith("LocationName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) {
                            toaddconrules.put((CallSite)((Object)("LocationName." + (String)result.get() + restofkey)), WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get(k));
                            continue;
                        }
                        if (!k.equals("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem()) && !k.startsWith("PersonName." + (String)this.languagesListCombo.getSelectionModel().getSelectedItem() + ".")) continue;
                        toaddconrules.put((CallSite)((Object)("PersonName." + (String)result.get() + restofkey)), WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get(k));
                    }
                    for (String k : toaddconrules.keySet()) {
                        WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put(k, (Set)toaddconrules.get(k));
                    }
                    WorldAndNameData.LOCATION_NAME_TYPES.add((String)result.get());
                    WorldAndNameData.PERSON_NAME_TYPES.add((String)result.get());
                    this.languagesListCombo.getItems().add((Object)((String)result.get()));
                    this.languagesListCombo.getSelectionModel().select((Object)((String)result.get()));
                }
            }
        });
        gp1.add((Node)cloneSelected, 3, 0);
        Button addtablebutton = new Button("Add Language");
        addtablebutton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("New Language");
            dialog.setHeaderText("Enter New Language Name");
            dialog.setContentText("Langauge Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                WorldAndNameData.LOCATION_NAME_TYPES.add((String)result.get());
                WorldAndNameData.PERSON_NAME_TYPES.add((String)result.get());
                this.languagesListCombo.getItems().removeAll((Collection)this.languagesListCombo.getItems());
                this.languagesListCombo.getItems().addAll(WorldAndNameData.LOCATION_NAME_TYPES);
                this.languagesTab.setContent(this.createLanguageGrid((String)result.get()));
            }
        });
        gp1.add((Node)addtablebutton, 4, 0);
        gp2.setHgap(3.0);
        gp2.setVgap(3.0);
        this.numBuildingRows = count;
        scrollpane.setContent((Node)gp2);
        scrollpane.setVvalue(0.0);
        BorderPane bp = new BorderPane();
        bp.setTop((Node)gp1);
        bp.setCenter((Node)scrollpane);
        return bp;
    }

    private void createFeatureSectionWrapper(GridPane gp2, int count, String featuretype) {
        Label l = new Label(featuretype);
        Font f = l.getFont();
        l.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)20.0));
        gp2.add((Node)l, 0, count);
        Button addtablebutton = new Button("Add New Attribute");
        addtablebutton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Add Feature Data for Feature Type");
            dialog.setHeaderText("Enter New Feature Data Name");
            dialog.setContentText("Feature Data Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                Set<String> ftoa = WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.get(featuretype);
                if (ftoa == null) {
                    ftoa = new TreeSet<String>();
                }
                ftoa.add((String)result.get());
                WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.put(featuretype, ftoa);
                TreeSet<String> al = new TreeSet<String>();
                al.add("");
                WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.put(featuretype + "." + (String)result.get(), al);
                this.featuresTab.setContent(this.createFeaturesGrid(featuretype));
            }
        });
        gp2.add((Node)addtablebutton, 1, count);
        Label instrlabel = new Label("Separate options by ;'s. Use [] and commas for variations: Option 1;Option [a,b,c];3rd choice");
        gp2.add((Node)instrlabel, 0, ++count, 4, 1);
        ++count;
        Set<String> attributes = WorldAndNameData.FEATURE_TYPES_TO_ATTRIBUTES.get(featuretype);
        if (attributes != null) {
            for (String key : attributes) {
                key = key.trim();
                Set<String> options = WorldAndNameData.FEATURE_ATTRIBUTES_TO_OPTIONS.get(featuretype + "." + key);
                Label syllname = new Label(key + " values:");
                gp2.add((Node)syllname, 0, count);
                StringBuilder optionstring = new StringBuilder();
                for (String opt : options) {
                    if (optionstring.length() > 0) {
                        optionstring.append(";");
                    }
                    optionstring.append(opt);
                }
                TextField ftf = new TextField(optionstring.toString());
                ftf.setMinWidth(400.0);
                this.featureTFs.put(featuretype + "\t" + key, ftf);
                gp2.add((Node)ftf, 1, count);
                CheckBox removecb = new CheckBox("Remove Option");
                gp2.add((Node)removecb, 2, count);
                this.removeFeatureCBsMap.put(featuretype + "\t" + key, removecb);
                ++count;
            }
        }
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {});
        ++count;
    }

    private void createEncounterSectionWrapper(GridPane gp2, int count, String terrainType, String level) {
        Map<String, Pair<String, String>> oneTerrainAndLevelsEncounters;
        gp2.getChildren().clear();
        Label l = new Label(terrainType);
        Font f = l.getFont();
        l.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)20.0));
        gp2.add((Node)l, 0, count);
        Button addOptionGroup = new Button("Add New Row");
        int finalCount = count;
        addOptionGroup.setOnAction(event -> {
            Map<String, Pair<String, String>> oneTerrainAndLevelsEncounters;
            Map<String, Map<String, Pair<String, String>>> oneTerrainsEncounters = WorldAndNameData.ENCOUNTERS_BY_TERRAIN.get(terrainType);
            if (oneTerrainsEncounters != null && oneTerrainsEncounters.get(level) != null && (oneTerrainAndLevelsEncounters = oneTerrainsEncounters.get(level)) != null) {
                String key = "New " + (int)(Math.random() * 10000.0);
                oneTerrainAndLevelsEncounters.put(key, (Pair<String, String>)new Pair((Object)key, (Object)"Enter new description"));
                this.createEncounterSectionWrapper(gp2, finalCount, terrainType, level);
            }
        });
        gp2.add((Node)addOptionGroup, 1, count);
        Label instrlabel = new Label("Separate options by ;'s. Use [] and commas for variations: Option 1;Option [a,b,c];3rd choice");
        gp2.add((Node)instrlabel, 0, ++count, 4, 1);
        ++count;
        Map<String, Map<String, Pair<String, String>>> oneTerrainsEncounters = WorldAndNameData.ENCOUNTERS_BY_TERRAIN.get(terrainType);
        if (oneTerrainsEncounters != null && level != null && (oneTerrainAndLevelsEncounters = oneTerrainsEncounters.get(level)) != null) {
            for (String key : oneTerrainAndLevelsEncounters.keySet()) {
                Pair<String, String> idToDesc = oneTerrainAndLevelsEncounters.get(key);
                TextField encounterKeyTF = new TextField(key);
                this.encounterKeyTFs.put(terrainType + "\t" + level + "\t" + key, encounterKeyTF);
                gp2.add((Node)encounterKeyTF, 0, count);
                TextField encounterValueTF = new TextField((String)idToDesc.getValue());
                this.encounterValueTFs.put(terrainType + "\t" + level + "\t" + key, encounterValueTF);
                encounterValueTF.setMinWidth(400.0);
                gp2.add((Node)encounterValueTF, 1, count);
                CheckBox removecb = new CheckBox("Remove Option");
                gp2.add((Node)removecb, 2, count);
                this.removeEncounterCBsMap.put(terrainType + "\t" + level + "\t" + key, removecb);
                ++count;
            }
        }
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {});
        ++count;
    }

    private void createLanguageSectionWrapper(GridPane gp2, int count, String languagetype) {
        Label l = new Label(languagetype);
        Font f = l.getFont();
        l.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)20.0));
        gp2.add((Node)l, 0, count);
        Label locname = new Label("Location Naming");
        locname.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)16.0));
        gp2.add((Node)locname, 0, ++count);
        Button addlocrule = new Button("Add Construction Rule");
        addlocrule.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("New Construction Rule");
            dialog.setHeaderText("Enter New Rule Name");
            dialog.setContentText("Construction Rule Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                Set<String> conrulekeys = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get("LocationName." + languagetype);
                if (conrulekeys == null) {
                    conrulekeys = new TreeSet<String>();
                }
                conrulekeys.add((String)result.get() + ":0");
                WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put("LocationName." + languagetype, conrulekeys);
                TreeSet<String> vals = new TreeSet<String>();
                vals.add("A,B,C");
                WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put("LocationName." + languagetype + "." + (String)result.get(), vals);
                this.languagesTab.setContent(this.createLanguageGrid(languagetype));
            }
        });
        gp2.add((Node)addlocrule, 1, count);
        Button addlocsyllables = new Button("Add Syllable Set");
        addlocsyllables.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("New Syllable Set");
            dialog.setHeaderText("Enter Syllable Set Name");
            dialog.setContentText("Syllable Set Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                Set<String> sskeys = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get("LocationName." + languagetype);
                if (sskeys == null) {
                    sskeys = new TreeSet<String>();
                }
                sskeys.add((String)result.get());
                WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put("LocationName." + languagetype, sskeys);
                TreeSet<String> vals = new TreeSet<String>();
                vals.add("A,B,C");
                WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put("LocationName." + languagetype + "." + (String)result.get(), vals);
                this.languagesTab.setContent(this.createLanguageGrid(languagetype));
            }
        });
        gp2.add((Node)addlocsyllables, 2, count);
        ++count;
        count = this.createLanguageSection(gp2, count, languagetype, "LocationName.");
        Label personname = new Label("Person Naming");
        personname.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)16.0));
        gp2.add((Node)personname, 0, count);
        Button addpersonrule = new Button("Add Construction Rule");
        gp2.add((Node)addpersonrule, 1, count);
        addpersonrule.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("New Construction Rule");
            dialog.setHeaderText("Enter New Rule Name");
            dialog.setContentText("Construction Rule Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                Set<String> conrulekeys = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get("PersonName." + languagetype);
                if (conrulekeys == null) {
                    conrulekeys = new TreeSet<String>();
                }
                conrulekeys.add((String)result.get() + ":0");
                WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put("PersonName." + languagetype, conrulekeys);
                TreeSet<String> vals = new TreeSet<String>();
                vals.add("A,B,C");
                WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.put("PersonName." + languagetype + "." + (String)result.get(), vals);
                this.languagesTab.setContent(this.createLanguageGrid(languagetype));
            }
        });
        Button addpersonsyllables = new Button("Add Syllable Set");
        gp2.add((Node)addpersonsyllables, 2, count);
        addpersonsyllables.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("New Syllable Set");
            dialog.setHeaderText("Enter Syllable Set Name");
            dialog.setContentText("Syllable Set Name:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                this.applyChanges(false);
                Set<String> sskeys = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get("PersonName." + languagetype);
                if (sskeys == null) {
                    sskeys = new TreeSet<String>();
                }
                sskeys.add((String)result.get());
                WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put("PersonName." + languagetype, sskeys);
                TreeSet<String> vals = new TreeSet<String>();
                vals.add("A,B,C");
                WorldAndNameData.NAME_TYPES_TO_SYLLABLES.put("PersonName." + languagetype + "." + (String)result.get(), vals);
                this.languagesTab.setContent(this.createLanguageGrid(languagetype));
            }
        });
        ++count;
        count = this.createLanguageSection(gp2, count, languagetype, "PersonName.");
        Button resetbutton = new Button("Reset");
        resetbutton.setOnAction(event -> {});
    }

    private int createLanguageSection(GridPane gp2, int count, String languagetype, String prefix) {
        Set<String> syllablegroups;
        Set<String> constructionrules = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get(prefix + languagetype);
        if (constructionrules != null) {
            for (String conrule : constructionrules) {
                String key = conrule.substring(0, conrule.indexOf(":"));
                String percent = conrule.substring(conrule.indexOf(":") + 1);
                double percentdouble = Double.parseDouble(percent) * 100.0;
                Set<String> syllablekeylist = WorldAndNameData.NAME_TYPES_TO_CONSTRUCTION_RULES.get(prefix + languagetype + "." + key);
                String syllablekeys = (String)syllablekeylist.toArray()[0];
                Label conrulename = new Label("Construction Rule " + key + ":");
                gp2.add((Node)conrulename, 0, count);
                TextField conruletf = new TextField(syllablekeys);
                this.conRuleTFs.put(prefix + languagetype + "." + key, conruletf);
                gp2.add((Node)conruletf, 1, count);
                FocusSpinner percentspinner = new FocusSpinner(0, 100, (int)percentdouble);
                this.conRuleSpinners.put(prefix + languagetype + "." + key, percentspinner);
                gp2.add(percentspinner, 2, count);
                gp2.add((Node)new Label("%"), 3, count);
                CheckBox removecb = new CheckBox("Remove Rule");
                this.removeConRuleCBsMap.put(prefix + languagetype + "." + key, removecb);
                gp2.add((Node)removecb, 4, count);
                ++count;
            }
        }
        if ((syllablegroups = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get(prefix + languagetype)) != null) {
            for (String key : syllablegroups) {
                Set<String> syllablekeylist = WorldAndNameData.NAME_TYPES_TO_SYLLABLES.get(prefix + languagetype + "." + key);
                StringBuilder syllablekeys = new StringBuilder();
                if (syllablekeylist.size() > 0) {
                    syllablekeys = new StringBuilder((String)syllablekeylist.toArray()[0]);
                }
                for (int i = 1; i < syllablekeylist.size(); ++i) {
                    syllablekeys.append(",").append((String)syllablekeylist.toArray()[i]);
                }
                Label syllname = new Label("Syllable Set " + key + ":");
                gp2.add((Node)syllname, 0, count);
                TextField sylltf = new TextField(syllablekeys.toString());
                this.syllableTFs.put(prefix + languagetype + "." + key, sylltf);
                gp2.add((Node)sylltf, 1, count, 3, 1);
                CheckBox removecb = new CheckBox("Remove Set");
                gp2.add((Node)removecb, 4, count);
                this.removeSyllableSetCBsMap.put(prefix + languagetype + "." + key, removecb);
                ++count;
            }
        }
        return count;
    }
}

