/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfigureGridDialog {
    private final MapUI mapUI;

    public ConfigureGridDialog(MapUI mapUI) {
        this.mapUI = mapUI;
    }

    public void showConfigureGridDialog(Stage parentStage) {
        StyledDialog d = new StyledDialog(true, (Window)parentStage, "Configure Grid");
        d.setHeaderText("Use the Following Controls to Configure the Grid/Borders:");
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label clgrid = new Label("Current Level's Tile Grid");
        Font f1 = clgrid.getFont();
        clgrid.setFont(Font.font((String)f1.getFamily(), (FontWeight)FontWeight.BOLD, (double)f1.getSize()));
        grid.add((Node)clgrid, 0, 0, 2, 1);
        grid.add((Node)new Label("Thickness:"), 0, 1);
        FocusSpinner thicknessSpinner0 = new FocusSpinner(0.0, 10.0, this.mapUI.getMapData().getGrid().getWidth()[0]);
        thicknessSpinner0.setEditable(true);
        grid.add(thicknessSpinner0, 1, 1);
        grid.add((Node)new Label("Color:"), 0, 2);
        ColorPicker colorCP0 = new ColorPicker(this.mapUI.getMapData().getGrid().getColor()[0]);
        grid.add((Node)colorCP0, 1, 2);
        Label olhgrid = new Label("One Level Higher's Grid (if displayed)");
        Font f2 = clgrid.getFont();
        olhgrid.setFont(Font.font((String)f2.getFamily(), (FontWeight)FontWeight.BOLD, (double)f2.getSize()));
        grid.add((Node)olhgrid, 0, 3, 2, 1);
        grid.add((Node)new Label("Thickness:"), 0, 4);
        FocusSpinner thicknessSpinner1 = new FocusSpinner(0.0, 10.0, this.mapUI.getMapData().getGrid().getWidth()[1]);
        thicknessSpinner1.setEditable(true);
        grid.add(thicknessSpinner1, 1, 4);
        grid.add((Node)new Label("Color:"), 0, 5);
        ColorPicker colorCP1 = new ColorPicker(this.mapUI.getMapData().getGrid().getColor()[1]);
        grid.add((Node)colorCP1, 1, 5);
        Label tlhgrid = new Label("Two Levels Higher's Grid (if displayed)");
        Font f3 = clgrid.getFont();
        tlhgrid.setFont(Font.font((String)f3.getFamily(), (FontWeight)FontWeight.BOLD, (double)f3.getSize()));
        grid.add((Node)tlhgrid, 0, 6, 2, 1);
        grid.add((Node)new Label("Thickness:"), 0, 7);
        FocusSpinner thicknessSpinner2 = new FocusSpinner(0.0, 10.0, this.mapUI.getMapData().getGrid().getWidth()[2]);
        thicknessSpinner2.setEditable(true);
        grid.add(thicknessSpinner2, 1, 7);
        grid.add((Node)new Label("Color:"), 0, 8);
        ColorPicker colorCP2 = new ColorPicker(this.mapUI.getMapData().getGrid().getColor()[2]);
        grid.add((Node)colorCP2, 1, 8);
        Label thlhgrid = new Label("Three Levels Higher's Grid (if displayed)");
        Font f4 = clgrid.getFont();
        thlhgrid.setFont(Font.font((String)f4.getFamily(), (FontWeight)FontWeight.BOLD, (double)f4.getSize()));
        grid.add((Node)thlhgrid, 0, 9, 2, 1);
        grid.add((Node)new Label("Thickness:"), 0, 10);
        FocusSpinner thicknessSpinner3 = new FocusSpinner(0.0, 10.0, this.mapUI.getMapData().getGrid().getWidth()[3]);
        thicknessSpinner3.setEditable(true);
        grid.add(thicknessSpinner3, 1, 10);
        grid.add((Node)new Label("Color:"), 0, 11);
        ColorPicker colorCP3 = new ColorPicker(this.mapUI.getMapData().getGrid().getColor()[3]);
        grid.add((Node)colorCP3, 1, 11);
        Label grid4l = new Label("Offset World Grid on Continent Level");
        Font f4b = grid4l.getFont();
        grid4l.setFont(Font.font((String)f4b.getFamily(), (FontWeight)FontWeight.BOLD, (double)f4b.getSize()));
        grid.add((Node)grid4l, 0, 14, 2, 1);
        grid.add((Node)new Label("#Tiles Horizontal:"), 0, 15);
        FocusSpinner wchorizspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetWorldContinentX());
        wchorizspinner.setEditable(true);
        grid.add(wchorizspinner, 1, 15);
        grid.add((Node)new Label("#Tiles Vertical:"), 0, 16);
        FocusSpinner wcvertspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetWorldContinentY());
        wcvertspinner.setEditable(true);
        grid.add(wcvertspinner, 1, 16);
        Label grid5l = new Label("Offset World Grid on Kingdom Level");
        Font f5 = grid5l.getFont();
        grid5l.setFont(Font.font((String)f5.getFamily(), (FontWeight)FontWeight.BOLD, (double)f5.getSize()));
        grid.add((Node)grid5l, 0, 17, 2, 1);
        grid.add((Node)new Label("#Tiles Horizontal:"), 0, 18);
        FocusSpinner wkhorizspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetWorldKingdomX());
        wkhorizspinner.setEditable(true);
        grid.add(wkhorizspinner, 1, 18);
        grid.add((Node)new Label("#Tiles Vertical:"), 0, 19);
        FocusSpinner wkvertspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetWorldKingdomY());
        wkvertspinner.setEditable(true);
        grid.add(wkvertspinner, 1, 19);
        Label grid6l = new Label("Offset Continent Grid on Kingdom Level");
        Font f6 = grid6l.getFont();
        grid6l.setFont(Font.font((String)f6.getFamily(), (FontWeight)FontWeight.BOLD, (double)f6.getSize()));
        grid.add((Node)grid6l, 0, 20, 2, 1);
        grid.add((Node)new Label("#Tiles Horizontal:"), 0, 21);
        FocusSpinner ckhorizspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetContinentKingdomX());
        ckhorizspinner.setEditable(true);
        grid.add(ckhorizspinner, 1, 21);
        grid.add((Node)new Label("#Tiles Vertical:"), 0, 22);
        FocusSpinner ckvertspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getView().getGridOffsetContinentKingdomY());
        ckvertspinner.setEditable(true);
        grid.add(ckvertspinner, 1, 22);
        Label squaregrid = new Label("Square/Rectangular Grid");
        Font f = squaregrid.getFont();
        squaregrid.setFont(Font.font((String)f.getFamily(), (FontWeight)FontWeight.BOLD, (double)f.getSize()));
        grid.add((Node)squaregrid, 2, 0, 2, 1);
        grid.add((Node)new Label("Use Square Grid:"), 2, 1);
        HBox rbbox1 = new HBox();
        ToggleGroup tg1 = new ToggleGroup();
        RadioButton squaregridnorb = new RadioButton("No ");
        squaregridnorb.setSelected(this.mapUI.getMapData().getGrid().getSquare() == 0 || this.mapUI.getMapData().getGrid().getSquare() == 8);
        tg1.getToggles().add((Object)squaregridnorb);
        rbbox1.getChildren().add((Object)squaregridnorb);
        RadioButton squaregridinsteadrb = new RadioButton("Instead ");
        squaregridinsteadrb.setSelected(this.mapUI.getMapData().getGrid().getSquare() == 1 || this.mapUI.getMapData().getGrid().getSquare() == 9);
        tg1.getToggles().add((Object)squaregridinsteadrb);
        rbbox1.getChildren().add((Object)squaregridinsteadrb);
        RadioButton squaregridadditionrb = new RadioButton("In Addition");
        squaregridadditionrb.setSelected(this.mapUI.getMapData().getGrid().getSquare() == 2 || this.mapUI.getMapData().getGrid().getSquare() == 10);
        tg1.getToggles().add((Object)squaregridadditionrb);
        rbbox1.getChildren().add((Object)squaregridadditionrb);
        grid.add((Node)rbbox1, 3, 1, 4, 1);
        grid.add((Node)new Label("Hex Orienation (for Battlemats):"), 2, 2, 2, 1);
        ToggleGroup tg0 = new ToggleGroup();
        RadioButton hexcols = new RadioButton("Columns");
        tg0.getToggles().add((Object)hexcols);
        hexcols.setSelected(this.mapUI.getMapData().getGrid().getSquare() < 8);
        grid.add((Node)hexcols, 4, 2);
        RadioButton hexrows = new RadioButton("Rows Line Up");
        tg0.getToggles().add((Object)hexrows);
        hexrows.setSelected(this.mapUI.getMapData().getGrid().getSquare() >= 8);
        grid.add((Node)hexrows, 5, 2, 2, 1);
        grid.add((Node)new Label("Match Tile Dimensions:"), 2, 3);
        HBox rbbox2 = new HBox();
        ToggleGroup tg = new ToggleGroup();
        RadioButton dontmatchrb = new RadioButton("No ");
        tg.getToggles().add((Object)dontmatchrb);
        dontmatchrb.setSelected(this.mapUI.getMapData().getGrid().getSquareWidth() > 0.0);
        rbbox2.getChildren().add((Object)dontmatchrb);
        RadioButton matchdimsrb = new RadioButton("Yes");
        tg.getToggles().add((Object)matchdimsrb);
        matchdimsrb.setSelected(this.mapUI.getMapData().getGrid().getSquareWidth() <= 0.0);
        rbbox2.getChildren().add((Object)matchdimsrb);
        grid.add((Node)rbbox2, 3, 3, 4, 1);
        grid.add((Node)new Label("  If No:"), 2, 4);
        grid.add((Node)new Label("Width:"), 3, 4);
        double valw = this.mapUI.getMapData().getGrid().getSquareWidth();
        if (valw < 0.0) {
            valw = 40.0;
        }
        FocusSpinner wspinner = new FocusSpinner(1.0, 1000.0, valw);
        wspinner.setMaxWidth(60.0);
        wspinner.setEditable(true);
        grid.add(wspinner, 4, 4);
        grid.add((Node)new Label(" Height:"), 5, 4);
        double valh = this.mapUI.getMapData().getGrid().getSquareHeight();
        if (valh < 0.0) {
            valh = 40.0;
        }
        FocusSpinner hspinner = new FocusSpinner(1.0, 1000.0, valh);
        hspinner.setMaxWidth(60.0);
        hspinner.setEditable(true);
        grid.add(hspinner, 6, 4);
        grid.add((Node)new Label("Offset X:"), 3, 5);
        FocusSpinner xspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getGrid().getOffsetX());
        xspinner.setMaxWidth(60.0);
        xspinner.setEditable(true);
        grid.add(xspinner, 4, 5);
        grid.add((Node)new Label(" Offset Y:"), 5, 5);
        FocusSpinner yspinner = new FocusSpinner(-1000.0, 1000.0, this.mapUI.getMapData().getGrid().getOffsetY());
        yspinner.setMaxWidth(60.0);
        yspinner.setEditable(true);
        grid.add(yspinner, 6, 5);
        grid.add((Node)new Label("Thickness:"), 2, 6);
        FocusSpinner thicknessSpinnerSq = new FocusSpinner(0.0, 10.0, this.mapUI.getMapData().getGrid().getWidth()[4]);
        thicknessSpinnerSq.setEditable(true);
        grid.add(thicknessSpinnerSq, 3, 6, 4, 1);
        grid.add((Node)new Label("Color:"), 2, 7);
        ColorPicker colorCPSq = new ColorPicker(this.mapUI.getMapData().getGrid().getColor()[3]);
        grid.add((Node)colorCPSq, 3, 7, 4, 1);
        d.getDialogPane().setContent((Node)grid);
        d.getDialogPane().setMinWidth(800.0);
        ButtonType yes = new ButtonType("OK");
        ButtonType cancel = new ButtonType("Cancel");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes, cancel});
        Optional result = d.showAndWait();
        if (result.isPresent() && result.get() == yes) {
            int gs;
            MapData mapData = this.mapUI.getMapData();
            mapData.getGrid().getColor()[0] = (Color)colorCP0.getValue();
            mapData.getGrid().getWidth()[0] = (Double)thicknessSpinner0.getValue();
            mapData.getGrid().getColor()[1] = (Color)colorCP1.getValue();
            mapData.getGrid().getWidth()[1] = (Double)thicknessSpinner1.getValue();
            mapData.getGrid().getColor()[2] = (Color)colorCP2.getValue();
            mapData.getGrid().getWidth()[2] = (Double)thicknessSpinner2.getValue();
            mapData.getGrid().getColor()[3] = (Color)colorCP3.getValue();
            mapData.getGrid().getWidth()[3] = (Double)thicknessSpinner3.getValue();
            mapData.getGrid().getColor()[4] = (Color)colorCPSq.getValue();
            mapData.getGrid().getWidth()[4] = (Double)thicknessSpinnerSq.getValue();
            mapData.getView().setGridOffsetContinentKingdomX((Double)ckhorizspinner.getValue());
            mapData.getView().setGridOffsetContinentKingdomY((Double)ckvertspinner.getValue());
            mapData.getView().setGridOffsetWorldContinentX((Double)wchorizspinner.getValue());
            mapData.getView().setGridOffsetWorldContinentY((Double)wcvertspinner.getValue());
            mapData.getView().setGridOffsetWorldKingdomX((Double)wkhorizspinner.getValue());
            mapData.getView().setGridOffsetWorldKingdomY((Double)wkvertspinner.getValue());
            int n = squaregridnorb.isSelected() ? 0 : (gs = squaregridinsteadrb.isSelected() ? 1 : 2);
            if (hexrows.isSelected()) {
                gs += 8;
            }
            mapData.getGrid().setSquare(gs);
            if (dontmatchrb.isSelected()) {
                mapData.getGrid().setSquareHeight((Double)hspinner.getValue());
                mapData.getGrid().setSquareWidth((Double)wspinner.getValue());
            } else {
                mapData.getGrid().setSquareHeight(-1.0);
                mapData.getGrid().setSquareWidth(-1.0);
            }
            mapData.getGrid().setOffsetX((Double)xspinner.getValue());
            mapData.getGrid().setOffsetY((Double)yspinner.getValue());
            this.mapUI.draw();
        }
    }
}

