/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.task.ChildMapTask;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.toolbox.ViewLevelBox;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.stage.Window;

public class CreateChildMapDialog {
    private final Worldographer worldographer;

    public CreateChildMapDialog(Worldographer worldographer) {
        this.worldographer = worldographer;
    }

    public void createChildMap(ViewLevel oldValue, ViewLevel newValue, int numhexes, MapData destinationMapData) {
        StyledDialog d = new StyledDialog(true, (Window)this.worldographer.getPrimaryStage(), "Worldographer New Level");
        d.setHeaderText("Creating New Map Level");
        Label statusLabel = new Label("Creating Map Level...                  ");
        d.getDialogPane().setContent((Node)statusLabel);
        ButtonType ok = new ButtonType("OK");
        d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok});
        d.show();
        CreateChildMapDialog createChildMapDialog = this;
        ChildMapTask task = new ChildMapTask(createChildMapDialog.worldographer.getMapUI(), oldValue, newValue, statusLabel, numhexes, this.worldographer.terrainToolbox.shuffleTerrainToggle.isSelected());
        task.setOnSucceeded(t -> {
            task.getValue();
            double factor = MapObject.getConversionFactor(newValue, oldValue, destinationMapData.getView().getContinentFactor(), destinationMapData.getView().getKingdomFactor(), destinationMapData.getView().getProvinceFactor());
            if (this.worldographer.viewLevelBox.switchMapViewLevel(newValue, oldValue, factor, this.worldographer.rightClickModelPt)) {
                this.worldographer.rightClickModelPt = null;
            }
            if (newValue != ViewLevel.BATTLEMAT && newValue != ViewLevel.SETTLEMENT) {
                this.worldographer.viewLevelBox.viewLevelCombo.getSelectionModel().select((Object)newValue);
            }
            this.worldographer.viewLevelBox.updateOverviewLabel(false);
            CreateChildMapDialog createChildMapDialog = this;
            if (createChildMapDialog.worldographer.getMapUI().getCurrentObjects() != null) {
                CreateChildMapDialog createChildMapDialog2 = this;
                if (createChildMapDialog2.worldographer.getMapUI().getCurrentObjects().size() > 0) {
                    CreateChildMapDialog createChildMapDialog3 = this;
                    for (MapObject mo : createChildMapDialog3.worldographer.getMapUI().getCurrentObjects()) {
                        if (!(mo instanceof MapShape)) continue;
                        this.worldographer.shapesToolbox.strokeWidthSpinner.getValueFactory().setValue((Object)(((MapShape)mo).getShape().getStrokeWidth() * 100.0));
                        break;
                    }
                }
            }
            ViewLevelBox.dontRecalculateViewLevels = false;
        });
        new Thread((Runnable)((Object)task)).start();
    }
}

