/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.dialog;

import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.StyledDialog;
import java.util.Optional;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Window;

public class DPIDialog {
    public double promptForDPI(Worldographer worldographer) {
        StyledDialog d2 = new StyledDialog(true, (Window)worldographer.getPrimaryStage(), "Select Image DPI");
        d2.setHeaderText("Select Image DPI (Dots Per Inch)");
        Label info = new Label("Dots per inch (2.54 cm) is a bit of metadata added to the file. (The\ntile width & height is used for the number of pixels in the image.)\n\nIt doesn't affect how many dots are in the image, but some image\neditors and printers use it for the default display size of an image.\n\n72dpi is typical for screen images, 300dpi is typical for printed\nimages, although the human eye only sees about 150dpi.\n");
        VBox vbox = new VBox();
        vbox.getChildren().add((Object)info);
        HBox hbox = new HBox();
        hbox.getChildren().add((Object)new Label("Enter DPI: "));
        FocusSpinner bluespinner = new FocusSpinner(72.0, 600.0, 72.0, 1.0);
        hbox.getChildren().add(bluespinner);
        vbox.getChildren().add((Object)hbox);
        hbox.setAlignment(Pos.CENTER);
        d2.getDialogPane().setContent((Node)vbox);
        ButtonType ok1 = new ButtonType("OK");
        d2.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ok1});
        Optional result = d2.showAndWait();
        if (result.isPresent() && result.get() == ok1) {
            return (Double)bluespinner.getValue();
        }
        return -1.0;
    }
}

