/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.setup;

import com.inkwellideas.ographer.data.FeatureDecoration;
import com.inkwellideas.ographer.data.HexOrientation;
import com.inkwellideas.ographer.data.LabelStyle;
import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.generator.world.WorldAndNameData;
import com.inkwellideas.ographer.io.LoadImage;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapDataSetup;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapProjection;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.map.component.NumberingData;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.model.ShapeStyle;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.ui.dialog.StartNewMapDialog;
import com.inkwellideas.ographer.ui.widget.FocusSpinner;
import com.inkwellideas.ographer.ui.widget.PopupStage;
import com.inkwellideas.ographer.util.SafePreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class SetupCosmicScreen
extends PopupStage {
    private Stage popupStage;
    private final Worldographer worldographer;
    private final Spinner<Integer> hexesWideSpinner = new FocusSpinner<Integer>(1, 10000, 100);
    private final Spinner<Integer> hexesHighSpinner = new FocusSpinner<Integer>(1, 10000, 50);
    private final Spinner<Integer> seedSpinner = new FocusSpinner<Integer>(1, 10000000, (int)(Math.random() * 1000000.0));
    private final Spinner<Integer> systemChanceSpinner = new FocusSpinner<Integer>(0, 100, 50);
    private final Spinner<Integer> amberChanceSpinner = new FocusSpinner<Integer>(0, 100, 10);
    private final Spinner<Integer> redChanceSpinner = new FocusSpinner<Integer>(0, 100, 10);
    String[] labelOptions = new String[]{"System Names", "Hex Codes", "Both"};
    ObservableList<String> labelOptionsList = FXCollections.observableArrayList((Object[])this.labelOptions);
    private final ComboBox<String> labelOptionsCombo = new ComboBox(this.labelOptionsList);
    private final Spinner<Double> hexWidthSpinner = new FocusSpinner<Double>(1.0, 100000.0, 46.18);
    private final Spinner<Double> hexHeightSpinner = new FocusSpinner<Double>(1.0, 100000.0, 40.0);
    private final RadioButton blankMapButton = new RadioButton("Blank Map");
    private final RadioButton systemsMapButton = new RadioButton("Generate Systems:");
    String[] populations = new String[]{"Tens of billions", "Hundreds of billions", "Trillions"};
    ObservableList<String> populationsList = FXCollections.observableArrayList((Object[])this.populations);
    private final ComboBox<String> populationCombo = new ComboBox(this.populationsList);
    SafePreferences prefs = new SafePreferences("com/inkwellideas/worldographer2025");
    MapDataSetup setup = null;

    public SetupCosmicScreen(Worldographer ms) {
        this.worldographer = ms;
    }

    public void start(Stage popStage) {
        this.popupStage = popStage;
        popStage.setTitle("Worldographer Cosmic Sub/Sector Setup Screen");
        BorderPane border = new BorderPane();
        border.setPadding(new Insets(10.0, 12.0, 10.0, 10.0));
        border.setLeft((Node)this.getSizePane());
        border.setRight(this.getTerrainPane());
        Button generateButton = new Button("Generate Map");
        generateButton.setOnAction(e -> {
            String mapType;
            Terrain[][] t = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
            this.setup = new MapDataSetup();
            for (int y = 0; y < t[0].length; ++y) {
                for (int x = 0; x < t.length; ++x) {
                    t[x][y] = new Terrain("Empty", true);
                }
            }
            HashMap<String, LabelStyle> labelStyleMap = new HashMap<String, LabelStyle>();
            LabelStyle.setupLabelStyles(labelStyleMap, ViewLevel.COSMIC);
            this.setup.labelStyles = labelStyleMap;
            HashMap<String, ShapeStyle> shapeStyleMap = new HashMap<String, ShapeStyle>();
            ShapeStyle.setupShapeStyles(shapeStyleMap, ViewLevel.COSMIC);
            this.setup.shapeStyles = shapeStyleMap;
            this.setup.type = MapData.Type.WORLD;
            this.setup.cosmicTerrain = t;
            this.setup.hexWidth = (Double)this.hexWidthSpinner.getValue();
            this.setup.hexHeight = (Double)this.hexHeightSpinner.getValue();
            this.setup.hexOrientation = HexOrientation.COLUMNS;
            this.setup.mapProjection = MapProjection.FLAT;
            this.setup.generateOneTerrain = true;
            this.setup.solidTerrain = "Blank";
            ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
            MapLayer featureLayer = new MapLayer("Features");
            mapLayers.add(new MapLayer("Labels"));
            mapLayers.add(featureLayer);
            mapLayers.add(new MapLayer("Above Terrain"));
            mapLayers.add(new MapLayer("Terrain Land"));
            mapLayers.add(new MapLayer("Above Water"));
            mapLayers.add(new MapLayer("Terrain Water"));
            mapLayers.add(new MapLayer("Below All"));
            this.setup.mapLayers = mapLayers;
            this.setup.generate = mapType = "Cosmic";
            HashSet<Note> notes = new HashSet<Note>();
            this.setup.notes = notes;
            ArrayList<Feature> features = new ArrayList<Feature>();
            this.prefs.put("generate", mapType);
            this.prefs.put("cosmicHexWidth", String.valueOf(this.hexWidthSpinner.getValue()));
            this.prefs.put("cosmicHexHeight", String.valueOf(this.hexHeightSpinner.getValue()));
            this.prefs.put("cosmicTilesWide", String.valueOf(this.hexesWideSpinner.getValue()));
            this.prefs.put("cosmicTilesHigh", String.valueOf(this.hexesHighSpinner.getValue()));
            this.prefs.put("systemChance", String.valueOf(this.systemChanceSpinner.getValue()));
            this.prefs.put("initialView", String.valueOf((Object)ViewLevel.COSMIC));
            Terrain[][] t2 = new Terrain[((Integer)this.hexesWideSpinner.getValue()).intValue()][((Integer)this.hexesHighSpinner.getValue()).intValue()];
            Random random = new Random(((Integer)this.seedSpinner.getValue()).intValue());
            for (int i = 0; i < t2.length; ++i) {
                for (int j = 0; j < t2[i].length; ++j) {
                    if (this.systemsMapButton.isSelected()) {
                        t2[i][j] = new Terrain("Cosmic/Stars", true);
                        if (!(random.nextDouble(100.0) < (double)((Integer)this.systemChanceSpinner.getValue()).intValue())) continue;
                        this.makeSolarSystem(featureLayer, random, features, notes, i, j);
                        continue;
                    }
                    t2[i][j] = new Terrain("Blank", true);
                }
            }
            this.setup.cosmicTerrain = t2;
            ArrayList<MapShape> shapes = new ArrayList<MapShape>();
            ArrayList<MapLabel> labels = new ArrayList<MapLabel>();
            this.setup.shapes = shapes;
            this.setup.features = features;
            this.setup.labels = labels;
            this.setup.show.notes = false;
            this.setup.show.gridNumbers = true;
            this.setup.grid.gridcolor0 = Color.GRAY;
            this.setup.numbering.setSeparator(".");
            this.setup.numbering.setFontColor(Color.GRAY);
            this.setup.numbering.setPosition(NumberingData.NumberPosition.TOP);
            this.setup.mapLayers.add(1, new MapLayer("Grid"));
            new StartNewMapDialog().startNewMap(this.setup, this.worldographer);
            this.popupStage.close();
        });
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER_RIGHT);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.add((Node)generateButton, 0, 1);
        border.setBottom((Node)grid);
        ScrollPane sp = new ScrollPane();
        sp.setContent((Node)border);
        Pane root = new Pane(new Node[]{sp});
        int width = 800;
        int height = 480;
        this.setLocationAndPopup(root, width, height, this.worldographer, this.popupStage);
    }

    private void makeSolarSystem(MapLayer featureLayer, Random random, List<Feature> features, HashSet<Note> notes, int i, int j) {
        String name;
        int size;
        int population = random.nextInt(11);
        if (((String)this.populationCombo.getValue()).equals("Hundreds of billions")) {
            population = random.nextInt(12);
        } else if (((String)this.populationCombo.getValue()).equals("Trillions")) {
            population = random.nextInt(13);
        }
        Object populationType = "" + population;
        if (population == 10) {
            populationType = "A";
        }
        if (population == 11) {
            populationType = "B";
        }
        if (population == 12) {
            populationType = "C";
        }
        StringBuilder populationStr = new StringBuilder();
        for (int k = 0; k < population + 1; ++k) {
            if (k % 3 == 0 && k != 0) {
                populationStr.insert(0, ",");
            }
            if (k >= population) continue;
            populationStr.insert(0, "0");
        }
        Object text = "<li>Population: 1" + String.valueOf(populationStr) + "+</li>\n";
        if (population == 0) {
            text = "<li>Population: 0</li>\n";
        }
        text = (size = random.nextInt(11)) == 0 ? (String)text + "<li>Size: Less than 1000km</li>" : (String)text + "<li>Size: " + size * 1600 + "km</li>";
        int atmosphere = random.nextInt(6) + random.nextInt(6) - 5 + size;
        if (atmosphere < 0) {
            atmosphere = 0;
        }
        if (atmosphere > 15) {
            atmosphere = 15;
        }
        Object atmosphereType = "" + atmosphere;
        if (atmosphere == 10) {
            atmosphereType = "A";
        }
        if (atmosphere == 11) {
            atmosphereType = "B";
        }
        if (atmosphere == 12) {
            atmosphereType = "C";
        }
        if (atmosphere == 13) {
            atmosphereType = "D";
        }
        if (atmosphere == 14) {
            atmosphereType = "E";
        }
        if (atmosphere == 15) {
            atmosphereType = "F";
        }
        if (atmosphere == 0) {
            text = (String)text + "<li>Atmosphere: None (0.00; Vacc Suit Required)</li>";
        }
        if (atmosphere == 1) {
            text = (String)text + "<li>Atmosphere: Trace (0.001-0.09; Vacc Suit Required)</li>";
        }
        if (atmosphere == 2) {
            text = (String)text + "<li>Atmosphere: Very Thin, Tainted (0.01-0.42; Respirator, Filter Required)</li>";
        }
        if (atmosphere == 3) {
            text = (String)text + "<li>Atmosphere: Very Thin (0.01-0.42; Respirator Required)</li>";
        }
        if (atmosphere == 4) {
            text = (String)text + "<li>Atmosphere: Thin, Tainted (0.43-0.7; Filter Required)</li>";
        }
        if (atmosphere == 5) {
            text = (String)text + "<li>Atmosphere: Thin (0.43-0.7)</li>";
        }
        if (atmosphere == 6) {
            text = (String)text + "<li>Atmosphere: Standard (0.71-1.49)</li>";
        }
        if (atmosphere == 7) {
            text = (String)text + "<li>Atmosphere: Standard, Tainted (0.71-1.49; Filter Required)</li>";
        }
        if (atmosphere == 8) {
            text = (String)text + "<li>Atmosphere: Dense (1.5-2.49)</li>";
        }
        if (atmosphere == 9) {
            text = (String)text + "<li>Atmosphere: Dense, Tainted (1.5-2.49; Filter Required)</li>";
        }
        if (atmosphere == 10) {
            text = (String)text + "<li>Atmosphere: Exotic (Varies, Air Supply Required)</li>";
        }
        if (atmosphere == 11) {
            text = (String)text + "<li>Atmosphere: Corrosive (Varies, Vacc Suit Required)</li>";
        }
        if (atmosphere == 12) {
            text = (String)text + "<li>Atmosphere: Insidious (Varies, Vacc Suit Required)</li>";
        }
        if (atmosphere == 13) {
            text = (String)text + "<li>Atmosphere: Very Dense (2.5+)</li>";
        }
        if (atmosphere == 14) {
            text = (String)text + "<li>Atmosphere: Low (0.5 or less)</li>";
        }
        if (atmosphere == 15) {
            text = (String)text + "<li>Atmosphere: Unusual (Varies)</li>";
        }
        int temperature = random.nextInt(6) + random.nextInt(6) - 2;
        if (atmosphere == 2 || atmosphere == 3) {
            temperature -= 2;
        }
        if (atmosphere == 4 || atmosphere == 5 || atmosphere == 14) {
            --temperature;
        }
        if (atmosphere == 8 || atmosphere == 9) {
            ++temperature;
        }
        if (atmosphere == 10 || atmosphere == 13 || atmosphere == 15) {
            temperature += 2;
        }
        if (atmosphere == 11 || atmosphere == 12) {
            temperature += 6;
        }
        if (temperature < 2) {
            temperature = 2;
        }
        if (temperature > 12) {
            temperature = 12;
        }
        if (temperature == 2) {
            text = (String)text + "<li>Temperature: Frozen (-51C or less)</li>";
        } else if (temperature == 3 || temperature == 4) {
            text = (String)text + "<li>Temperature: Cold (-51C to 0C)</li>";
        } else if (temperature > 4 && temperature < 10) {
            text = (String)text + "<li>Temperature: Temperate (0C to 30C)</li>";
        } else if (temperature == 10 || temperature == 11) {
            text = (String)text + "<li>Temperature: Hot (31C to 80C)</li>";
        } else if (temperature == 12) {
            text = (String)text + "<li>Temperature: Boiling (81C or more)</li>";
        }
        int hydrographics = random.nextInt(6) + random.nextInt(6) - 5 + size;
        if (size == 0 || size == 1) {
            hydrographics = 0;
        }
        if (atmosphere <= 1 || atmosphere >= 10) {
            hydrographics -= 4;
        }
        if (temperature >= 12) {
            hydrographics -= 6;
        } else if (temperature >= 10) {
            hydrographics -= 2;
        }
        if (hydrographics < 0) {
            hydrographics = 0;
        }
        Object hydrographicsType = "" + hydrographics;
        if (hydrographics >= 10) {
            hydrographics = 10;
            hydrographicsType = "A";
        }
        if (hydrographics == 0) {
            text = (String)text + "<li>Hydrographics: 0-5% (Desert world)</li>";
        } else if (hydrographics == 1) {
            text = (String)text + "<li>Hydrographics: 6-15% (Dry world)</li>";
        } else if (hydrographics == 2) {
            text = (String)text + "<li>Hydrographics: 16-25% (A few small seas)</li>";
        } else if (hydrographics == 3) {
            text = (String)text + "<li>Hydrographics: 26-35% (Small seas and oceans)</li>";
        } else if (hydrographics == 4) {
            text = (String)text + "<li>Hydrographics: 36-45% (Wet World)</li>";
        } else if (hydrographics == 5) {
            text = (String)text + "<li>Hydrographics: 46-55% (A large ocean)</li>";
        } else if (hydrographics == 6) {
            text = (String)text + "<li>Hydrographics: 56-65% (Large oceans)</li>";
        } else if (hydrographics == 7) {
            text = (String)text + "<li>Hydrographics: 66-75% (Earth-like world)</li>";
        } else if (hydrographics == 8) {
            text = (String)text + "<li>Hydrographics: 76-85% (Only a few islands/archipelagos)</li>";
        } else if (hydrographics == 9) {
            text = (String)text + "<li>Hydrographics: 86-95% (Almost entirely water)</li>";
        } else if (hydrographics == 10) {
            text = (String)text + "<li>Hydrographics: 96-100% (Waterworld)</li>";
        }
        int government = random.nextInt(6) + random.nextInt(6) - 5 + population;
        Object governmentType = "" + government;
        if (government < 0) {
            government = 0;
            governmentType = "0";
        }
        if (government == 10) {
            governmentType = "A";
        }
        if (government == 11) {
            governmentType = "B";
        }
        if (government == 12) {
            governmentType = "C";
        }
        if (government == 13) {
            governmentType = "D";
        }
        if (government == 14) {
            governmentType = "E";
        }
        if (government >= 15) {
            government = 15;
            governmentType = "F";
        }
        String[] governmentsArray = new String[]{"None", "Company/Corporation", "Participating Democracy", "Self-perpetuating Oligarchy", "Representative Democracy", "Feudal Technocracy", "Captive Government", "Balkanization", "Civil Service Bureaucracy", "Impersonal Bureaucracy", "Charismatic Dictator", "Non-Charismatic Leader", "Charismatic Oligarchy", "Religious Dictatorship", "Religious Autocracy", "Totalitarian Oligarchy"};
        text = (String)text + "<li>Government: " + governmentsArray[government] + "</li>";
        int law = random.nextInt(6) + random.nextInt(6) - 5 + government;
        if (law < 0) {
            law = 0;
        }
        if (law > 9) {
            law = 9;
        }
        String[] lawBansArray = new String[]{"No Restrictions", "Poison gas, explosives, undetectable weapons, WMD", "Portable energy weapons (except ship-mounted weapons)", "Heavy weapons", "Light assault weapons and submachine guns", "Personal concealable weapons", "All firearms except shotguns and stunners; carrying weapons discouraged", "Shotguns", "All bladed weapons, stunners", "All weapons"};
        text = (String)text + "<li>Law Level: " + law + " Weapon Restrictions: " + lawBansArray[law] + "</li>";
        char starportClass = this.getStarportClass(population, random);
        int tech = random.nextInt(6) + 1;
        if (starportClass == 'A') {
            tech += 6;
        }
        if (starportClass == 'B') {
            tech += 4;
        }
        if (starportClass == 'C') {
            tech += 2;
        }
        if (starportClass == 'X') {
            tech -= 4;
        }
        if (size == 0 || size == 1) {
            tech += 2;
        }
        if (size >= 2 && size <= 4) {
            ++tech;
        }
        if (atmosphere <= 3 || atmosphere >= 10) {
            ++tech;
        }
        if (hydrographics == 0 || hydrographics == 9) {
            ++tech;
        }
        if (hydrographics == 10) {
            tech += 2;
        }
        if (population >= 1 && population <= 5) {
            ++tech;
        }
        if (population == 8) {
            ++tech;
        }
        if (population == 9) {
            tech += 2;
        }
        if (population == 10) {
            tech += 4;
        }
        if (government == 0 || government == 5) {
            ++tech;
        }
        if (government == 7) {
            tech += 2;
        }
        if (government == 13 || government == 14) {
            tech -= 2;
        }
        text = (String)text + "<li>Tech Level: " + tech + "</li>";
        boolean militaryBase = false;
        boolean navalBase = false;
        boolean scoutBase = false;
        boolean corsairBase = false;
        if (starportClass == 'A') {
            militaryBase = random.nextInt(6) + random.nextInt(6) + 2 >= 8;
            navalBase = random.nextInt(6) + random.nextInt(6) + 2 >= 8;
            scoutBase = random.nextInt(6) + random.nextInt(6) + 2 >= 10;
        } else if (starportClass == 'B') {
            militaryBase = random.nextInt(6) + random.nextInt(6) + 2 >= 8;
            navalBase = random.nextInt(6) + random.nextInt(6) + 2 >= 8;
            scoutBase = random.nextInt(6) + random.nextInt(6) + 2 >= 9;
        } else if (starportClass == 'C') {
            militaryBase = random.nextInt(6) + random.nextInt(6) + 2 >= 10;
            scoutBase = random.nextInt(6) + random.nextInt(6) + 2 >= 9;
        } else if (starportClass == 'D') {
            corsairBase = random.nextInt(6) + random.nextInt(6) + 2 >= 12;
            scoutBase = random.nextInt(6) + random.nextInt(6) + 2 >= 8;
        } else {
            corsairBase = random.nextInt(6) + random.nextInt(6) + 2 >= 10;
        }
        Object bases = (militaryBase ? "Military, " : "") + (navalBase ? "Naval, " : "") + (scoutBase ? "Scout, " : "") + (corsairBase ? "Corsair, " : "");
        if (((String)bases).length() > 2) {
            bases = ((String)bases).substring(0, ((String)bases).length() - 2);
        }
        text = (String)text + "<li>Bases: " + (String)bases + "</li>";
        Object facilities = "None";
        if (starportClass == 'A') {
            facilities = "Shipyard (all), Repair";
            if (random.nextInt(6) + random.nextInt(6) + 2 >= 6) {
                facilities = (String)facilities + ", Highport";
            }
        } else if (starportClass == 'B') {
            facilities = "Shipyard (spacecraft), Repair";
            if (random.nextInt(6) + random.nextInt(6) + 2 >= 8) {
                facilities = (String)facilities + ", Highport";
            }
        } else if (starportClass == 'C') {
            facilities = "Shipyard (small craft), Repair";
            if (random.nextInt(6) + random.nextInt(6) + 2 >= 10) {
                facilities = (String)facilities + ", Highport";
            }
        } else if (starportClass == 'D') {
            facilities = "Limited Repair";
            if (random.nextInt(6) + random.nextInt(6) + 2 >= 12) {
                facilities = (String)facilities + ", Highport";
            }
        }
        text = (String)text + "<li>Facilities: " + (String)facilities + "</li>";
        StringBuilder tradeCodes = new StringBuilder();
        if (atmosphere >= 4 && atmosphere <= 9 && hydrographics >= 4 && hydrographics <= 8 && population >= 5 && population <= 7) {
            tradeCodes.append("Agriculture, ");
        }
        if (size == 0 && atmosphere == 0 && hydrographics == 0) {
            tradeCodes.append("Asteroid, ");
        }
        if (population == 0 && government == 0 && law == 0) {
            tradeCodes.append("Barren, ");
        }
        if (atmosphere >= 2 && atmosphere <= 9 && hydrographics == 0) {
            tradeCodes.append("Desert, ");
        }
        if (atmosphere >= 10 && hydrographics >= 1) {
            tradeCodes.append("Fluid Oceans, ");
        }
        if (size >= 6 && size <= 8 && (atmosphere == 5 || atmosphere == 6 || atmosphere == 8) && hydrographics >= 5 && hydrographics <= 7) {
            tradeCodes.append("Garden,  ");
        }
        if (population >= 9) {
            tradeCodes.append("High Population, ");
        }
        if (tech >= 12) {
            tradeCodes.append("High Tech, ");
        }
        if (atmosphere <= 1 && hydrographics >= 1) {
            tradeCodes.append("Ice-Capped, ");
        }
        if ((atmosphere <= 2 || atmosphere == 4 || atmosphere == 7 || atmosphere == 9 || atmosphere == 10 || atmosphere == 11 || atmosphere == 12) && population >= 9) {
            tradeCodes.append("Industrial, ");
        }
        if (population <= 3) {
            tradeCodes.append("Low Population, ");
        }
        if (population >= 1 && tech <= 5) {
            tradeCodes.append("Low Tech, ");
        }
        if (atmosphere <= 3 && hydrographics <= 3 && population >= 6) {
            tradeCodes.append("Non-Agricultural, ");
        }
        if (population >= 4 && population <= 6) {
            tradeCodes.append("Non-Industrial, ");
        }
        if (atmosphere >= 2 && atmosphere <= 5 && hydrographics <= 3) {
            tradeCodes.append("Poor, ");
        }
        if ((atmosphere == 6 || atmosphere == 8) && population >= 6 && population <= 8 && government >= 4 && government <= 9) {
            tradeCodes.append("Rich, ");
        }
        if (atmosphere == 0) {
            tradeCodes.append("Vacuum, ");
        }
        if ((atmosphere >= 3 && atmosphere <= 9 || atmosphere >= 13) && hydrographics >= 10) {
            tradeCodes.append("Waterworld, ");
        }
        String tradeCodeString = "None";
        if (!tradeCodes.isEmpty()) {
            tradeCodeString = tradeCodes.substring(0, tradeCodes.length() - 2);
        }
        text = (String)text + "<li>Trade Codes: " + tradeCodeString + "</li>";
        String iconType = size == 0 ? (random.nextBoolean() ? "Cosmic/Asteroids" : "Cosmic/Space Station") : (hydrographics < 3 && temperature < 5 ? "Cosmic/Planet Low Water Low Temperature" : (hydrographics < 3 && temperature < 10 ? "Cosmic/Planet Low Water Medium Temperature" : (hydrographics < 3 ? "Cosmic/Planet Low Water High Temperature" : (hydrographics < 8 && temperature < 5 ? "Cosmic/Planet Medium Water Low Temperature" : (hydrographics < 8 && temperature < 10 ? "Cosmic/Planet Medium Water Medium Temperature" : (hydrographics < 8 ? "Cosmic/Planet Medium Water High Temperature" : (temperature < 5 ? "Cosmic/Planet High Water Low Temperature" : (temperature < 10 ? "Cosmic/Planet High Water Medium Temperature" : "Cosmic/Planet High Water High Temperature"))))))));
        Feature f = new Feature(iconType);
        f.setUUID(UUID.randomUUID().toString());
        if (size < 4) {
            f.setScale(40.0);
        } else if (size < 6) {
            f.setScale(55.0);
        } else if (size < 8) {
            f.setScale(70.0);
        } else {
            f.setScale(85.0);
        }
        if (atmosphere == 10) {
            f.setOverrideColor(Color.LIME);
        } else if (atmosphere == 11) {
            f.setOverrideColor(Color.GOLDENROD);
        } else if (atmosphere == 12) {
            f.setOverrideColor(Color.FIREBRICK);
        } else if (atmosphere == 15) {
            f.setOverrideColor(Color.MEDIUMPURPLE);
        }
        f.setLocation(ViewLevel.COSMIC, i * 225 + 150, j * 300 + (i % 2 == 0 ? 150 : 300));
        f.setMapLayer(featureLayer);
        if (size != 0) {
            f.setHorizontalFlip(random.nextBoolean());
            f.setVerticalFlip(random.nextBoolean());
            f.setRotate(random.nextDouble(-20.0, 20.0));
        }
        List<String> languages = WorldAndNameData.LOCATION_NAME_TYPES;
        String nameByPopulation = name = WorldAndNameData.getNameDynamic(languages.get(random.nextInt(languages.size())), WorldAndNameData.NameType.LocationName, null);
        if (population >= 9) {
            nameByPopulation = name.toUpperCase(Locale.ROOT);
        } else if (population <= 3) {
            nameByPopulation = name.toLowerCase(Locale.ROOT);
        }
        String hexCode = starportClass + String.valueOf(size == 10 ? "A" : Integer.valueOf(size)) + (String)atmosphereType + (String)hydrographicsType + (String)populationType + (String)governmentType + law + "-" + tech;
        Object labelText = nameByPopulation + "\n" + hexCode;
        if (((String)this.labelOptionsCombo.getValue()).equals(this.labelOptions[0])) {
            labelText = nameByPopulation;
        } else if (((String)this.labelOptionsCombo.getValue()).equals(this.labelOptions[1])) {
            labelText = hexCode;
        }
        f.setLabel(new MapLabel("Star System", (String)labelText, "Arial", Color.WHITE, 0.0, Color.WHITE, Color.RED, null, 0.0, 0.0, 0.0, true, true, true, true, false, false, false, TextAlignment.CENTER, "", featureLayer));
        f.setLabelPosition(180.0);
        f.setFeatureDecorations(new FeatureDecoration[6]);
        f.getFeatureDecorations()[0] = new FeatureDecoration("" + starportClass, Color.LIGHTGRAY, 0.0);
        if (((String)bases).contains("Military")) {
            f.getFeatureDecorations()[1] = new FeatureDecoration("\u25c6", Color.LIGHTGRAY, 315.0);
        }
        if (((String)bases).contains("Naval")) {
            f.getFeatureDecorations()[2] = new FeatureDecoration("\u272d", Color.LIGHTGRAY, 270.0);
        }
        if (((String)bases).contains("Corsair")) {
            f.getFeatureDecorations()[2] = new FeatureDecoration("\u2726", Color.LIGHTGRAY, 225.0);
        }
        f.setLabelDistance(-15);
        if (random.nextInt(100) < (Integer)this.amberChanceSpinner.getValue()) {
            f.setRing(Color.YELLOW);
        } else if (random.nextInt(100) < (Integer)this.redChanceSpinner.getValue()) {
            f.setRing(Color.RED);
        }
        features.add(f);
        Note note = new Note(ViewLevel.COSMIC, i * 225 + 150, j * 300 + (i % 2 == 0 ? 150 : 300));
        note.setTitle(name + " " + hexCode);
        note.setDetails((String)text);
        note.setParent(f);
        notes.add(note);
    }

    private char getStarportClass(int population, Random random) {
        int a = random.nextInt(6) + 1;
        int b = random.nextInt(6) + 1;
        int sum = a + b;
        if (population >= 8) {
            ++sum;
        }
        if (population >= 10) {
            ++sum;
        }
        if (population <= 4) {
            --sum;
        }
        if (population <= 2) {
            --sum;
        }
        if (sum <= 2) {
            return 'X';
        }
        if (sum <= 4) {
            return 'E';
        }
        if (sum <= 6) {
            return 'D';
        }
        if (sum <= 8) {
            return 'C';
        }
        if (sum <= 10) {
            return 'B';
        }
        return 'A';
    }

    private GridPane getSizePane() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        grid.setAlignment(Pos.TOP_CENTER);
        grid.setMinWidth(160.0);
        Label titlelabel = new Label("Map Attributes");
        titlelabel.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)titlelabel, 0, 0, 2, 1);
        Label wideLabel = new Label("Tiles Wide:");
        grid.add((Node)wideLabel, 0, 1);
        this.hexesWideSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("cosmicTilesWide", "32")));
        this.hexesWideSpinner.setMinWidth(100.0);
        this.hexesWideSpinner.setMaxWidth(100.0);
        grid.add(this.hexesWideSpinner, 1, 1);
        Label highLabel = new Label("Tiles High:");
        grid.add((Node)highLabel, 0, 2);
        this.hexesHighSpinner.getValueFactory().setValue((Object)Integer.parseInt(this.prefs.get("cosmicTilesHigh", "40")));
        this.hexesHighSpinner.setMinWidth(100.0);
        this.hexesHighSpinner.setMaxWidth(100.0);
        grid.add(this.hexesHighSpinner, 1, 2);
        Label defualts = new Label("Use default #Tiles:");
        grid.add((Node)defualts, 0, 3);
        Button sectorButton = new Button("Sector");
        sectorButton.setOnAction(event -> {
            this.hexesWideSpinner.getValueFactory().setValue((Object)32);
            this.hexesHighSpinner.getValueFactory().setValue((Object)40);
        });
        Button subsectorButton = new Button("Sub-Sector");
        subsectorButton.setOnAction(event -> {
            this.hexesWideSpinner.getValueFactory().setValue((Object)8);
            this.hexesHighSpinner.getValueFactory().setValue((Object)10);
        });
        grid.add((Node)subsectorButton, 1, 3);
        grid.add((Node)sectorButton, 1, 4);
        Label widthLabel = new Label("Tile Width (pixels):");
        grid.add((Node)widthLabel, 0, 6);
        this.hexWidthSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("cosmicHexWidth", "46.18")));
        this.hexWidthSpinner.setMinWidth(100.0);
        this.hexWidthSpinner.setMaxWidth(100.0);
        this.hexWidthSpinner.setEditable(true);
        grid.add(this.hexWidthSpinner, 1, 6);
        Label heightLabel = new Label("Tile Height (pixels):");
        grid.add((Node)heightLabel, 0, 7);
        this.hexHeightSpinner.getValueFactory().setValue((Object)Double.valueOf(this.prefs.get("cosmicHexHeight", "40")));
        this.hexHeightSpinner.setMinWidth(100.0);
        this.hexHeightSpinner.setMaxWidth(100.0);
        this.hexHeightSpinner.setEditable(true);
        grid.add(this.hexHeightSpinner, 1, 7);
        return grid;
    }

    private Node getTerrainPane() {
        HBox mainbox = new HBox();
        GridPane innergrid2 = new GridPane();
        innergrid2.setAlignment(Pos.CENTER);
        innergrid2.setHgap(5.0);
        innergrid2.setVgap(5.0);
        mainbox.setMinWidth(400.0);
        ToggleGroup tggroup = new ToggleGroup();
        Label scenetitle = new Label("Cosmic Sub/Sector Setup");
        scenetitle.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        innergrid2.add((Node)scenetitle, 0, 0, 2, 1);
        this.blankMapButton.setToggleGroup(tggroup);
        this.blankMapButton.setSelected(this.prefs.get("generateCosmic", "COSMIC").equals("BLANK"));
        innergrid2.add((Node)this.blankMapButton, 0, 1, 2, 1);
        this.systemsMapButton.setSelected(this.prefs.get("generateCosmic", "COSMIC").equals("COSMIC"));
        this.systemsMapButton.setToggleGroup(tggroup);
        innergrid2.add((Node)this.systemsMapButton, 0, 2, 2, 1);
        HBox gensectionsbox = new HBox();
        Button helpButton = new Button("", (Node)new ImageView(LoadImage.image("other_imgs/question.png")));
        gensectionsbox.getChildren().add((Object)helpButton);
        helpButton.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        helpButton.setOnAction(event -> {
            Dialog d = new Dialog();
            d.setTitle("Generate Dungeon By Sections");
            d.setHeaderText("Instructions");
            WebView view = new WebView();
            view.setMinSize(300.0, 300.0);
            view.setPrefSize(550.0, 350.0);
            String configureText = "<p>Generating a dungeon via sections will add a number of 20x20 sections to the dungeons similar (but not the same) as DungeonMorphs by Inkwell Ideas.</p><ul><li><b># Sections Wide &amp; High:</b> These fields let you specify the map size.  Because each section is 20x20, if you set your map up as 5x4, your map will be 100x80 tiles.</li><li><b>Sections Required &amp; Exclude:</b> Each section has a design which is the purpose of that dungeon area. You can use these multi-select boxes to either require specific sections (if there are enough spots) which will be randomly used or ensure some are not included at all. Note: This is a pro feature--these boxes are disabled in the free version.</li><li><b>Wall, Floor, and Deluxe Floor Texture:</b> These fields are used for the lines &amp; fills of the dungeon.</li><li><b>Random Seed:</b> This generator lets you give it a random seed.  Giving it the same seed with the same other settings will result in the same dungeon.  This will not be true from one update to another if we make changes to the generator.</li></ul>";
            WebEngine textengine = view.getEngine();
            textengine.loadContent("<style type=\"text/css\">p {font-family: Futura,Trebuchet MS,Arial,sans-serif; font-size:0.875em; padding: 0; margin: 0} h1,h2,h3 {font-family: Futura,Trebuchet MS,Arial,sans-serif; padding: 0; margin: 0}</style>" + configureText);
            d.getDialogPane().setContent((Node)view);
            ButtonType yes = new ButtonType("OK");
            d.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{yes});
            d.showAndWait();
        });
        innergrid2.setPadding(new Insets(3.0, 3.0, 3.0, 23.0));
        innergrid2.add((Node)new Label("  System Chance (%):"), 0, 5);
        this.systemChanceSpinner.setMinWidth(100.0);
        this.systemChanceSpinner.setMaxWidth(100.0);
        innergrid2.add(this.systemChanceSpinner, 1, 5);
        innergrid2.add((Node)new Label("  Max Population (%):"), 0, 6);
        this.populationCombo.getSelectionModel().select(2);
        innergrid2.add(this.populationCombo, 1, 6);
        innergrid2.add((Node)new Label("  Amber Chance (%):"), 0, 7);
        this.amberChanceSpinner.setMinWidth(100.0);
        this.amberChanceSpinner.setMaxWidth(100.0);
        innergrid2.add(this.amberChanceSpinner, 1, 7);
        innergrid2.add((Node)new Label("  Red Chance (%):"), 0, 8);
        this.redChanceSpinner.setMinWidth(100.0);
        this.redChanceSpinner.setMaxWidth(100.0);
        innergrid2.add(this.redChanceSpinner, 1, 8);
        innergrid2.add((Node)new Label("  Label Options:"), 0, 9);
        innergrid2.add(this.labelOptionsCombo, 1, 9);
        this.labelOptionsCombo.getSelectionModel().select(0);
        innergrid2.add((Node)new Label("  Random Seed:"), 0, 12);
        innergrid2.add(this.seedSpinner, 1, 12);
        this.seedSpinner.setMinWidth(100.0);
        this.seedSpinner.setMaxWidth(100.0);
        mainbox.getChildren().add((Object)innergrid2);
        return mainbox;
    }

    public Stage getPopupStage() {
        return this.popupStage;
    }
}

