/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.ui.widget;

import java.util.HashSet;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class DraggableTab
extends Tab {
    private static final Set<TabPane> tabPanes = new HashSet<TabPane>();
    private final Label nameLabel;
    private final Text dragText;
    private static final Stage markerStage = new Stage();
    private final Stage dragStage;
    private boolean detachable;

    public DraggableTab(String text) {
        this.nameLabel = new Label(text);
        this.setGraphic((Node)this.nameLabel);
        this.detachable = true;
        this.dragStage = new Stage();
        this.dragStage.initStyle(StageStyle.UNDECORATED);
        StackPane dragStagePane = new StackPane();
        dragStagePane.setStyle("-fx-background-color:#DDDDDD;");
        this.dragText = new Text(text);
        StackPane.setAlignment((Node)this.dragText, (Pos)Pos.CENTER);
        dragStagePane.getChildren().add((Object)this.dragText);
        this.dragStage.setScene(new Scene((Parent)dragStagePane));
        this.nameLabel.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                DraggableTab.this.dragStage.setWidth(DraggableTab.this.nameLabel.getWidth() + 10.0);
                DraggableTab.this.dragStage.setHeight(DraggableTab.this.nameLabel.getHeight() + 10.0);
                DraggableTab.this.dragStage.setX(t.getScreenX());
                DraggableTab.this.dragStage.setY(t.getScreenY());
                DraggableTab.this.dragStage.show();
                Point2D screenPoint = new Point2D(t.getScreenX(), t.getScreenY());
                tabPanes.add(DraggableTab.this.getTabPane());
                InsertData data = DraggableTab.this.getInsertData(screenPoint);
                if (data == null || data.getInsertPane().getTabs().isEmpty()) {
                    markerStage.hide();
                } else {
                    int index = data.getIndex();
                    boolean end = false;
                    if (index == data.getInsertPane().getTabs().size()) {
                        end = true;
                        --index;
                    }
                    Rectangle2D rect = DraggableTab.this.getAbsoluteRect((Tab)data.getInsertPane().getTabs().get(index));
                    if (end) {
                        markerStage.setX(rect.getMaxX() + 13.0);
                    } else {
                        markerStage.setX(rect.getMinX());
                    }
                    markerStage.setY(rect.getMaxY() + 10.0);
                    markerStage.show();
                }
            }
        });
        this.nameLabel.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                markerStage.hide();
                DraggableTab.this.dragStage.hide();
                if (!t.isStillSincePress()) {
                    Point2D screenPoint = new Point2D(t.getScreenX(), t.getScreenY());
                    TabPane oldTabPane = DraggableTab.this.getTabPane();
                    int oldIndex = oldTabPane.getTabs().indexOf((Object)DraggableTab.this);
                    tabPanes.add(oldTabPane);
                    InsertData insertData = DraggableTab.this.getInsertData(screenPoint);
                    if (insertData != null) {
                        int addIndex = insertData.getIndex();
                        if (oldTabPane == insertData.getInsertPane() && oldTabPane.getTabs().size() == 1) {
                            return;
                        }
                        oldTabPane.getTabs().remove((Object)DraggableTab.this);
                        if (oldIndex < addIndex && oldTabPane == insertData.getInsertPane()) {
                            --addIndex;
                        }
                        if (addIndex > insertData.getInsertPane().getTabs().size()) {
                            addIndex = insertData.getInsertPane().getTabs().size();
                        }
                        insertData.getInsertPane().getTabs().add(addIndex, (Object)DraggableTab.this);
                        ((SingleSelectionModel)insertData.getInsertPane().selectionModelProperty().get()).select(addIndex);
                        return;
                    }
                    if (!DraggableTab.this.detachable) {
                        return;
                    }
                    Stage newStage = new Stage();
                    TabPane pane = new TabPane();
                    tabPanes.add(pane);
                    newStage.setOnHiding(t1 -> tabPanes.remove(pane));
                    DraggableTab.this.getTabPane().getTabs().remove((Object)DraggableTab.this);
                    pane.getTabs().add((Object)DraggableTab.this);
                    pane.getTabs().addListener(change -> {
                        if (pane.getTabs().isEmpty()) {
                            newStage.hide();
                        }
                    });
                    newStage.setScene(new Scene((Parent)pane));
                    newStage.initStyle(StageStyle.UTILITY);
                    newStage.setX(t.getScreenX());
                    newStage.setY(t.getScreenY());
                    newStage.show();
                    pane.requestLayout();
                    pane.requestFocus();
                }
            }
        });
    }

    public String getLabelText() {
        return this.nameLabel.getText();
    }

    public void setLabelText(String text) {
        this.nameLabel.setText(text);
        this.dragText.setText(text);
    }

    private InsertData getInsertData(Point2D screenPoint) {
        for (TabPane tabPane : tabPanes) {
            Rectangle2D tabAbsolute = this.getAbsoluteRect((Control)tabPane);
            if (!tabAbsolute.contains(screenPoint)) continue;
            int tabInsertIndex = 0;
            if (!tabPane.getTabs().isEmpty()) {
                Rectangle2D firstTabRect = this.getAbsoluteRect((Tab)tabPane.getTabs().get(0));
                if (firstTabRect.getMaxY() + 60.0 < screenPoint.getY() || firstTabRect.getMinY() > screenPoint.getY()) {
                    return null;
                }
                Rectangle2D lastTabRect = this.getAbsoluteRect((Tab)tabPane.getTabs().get(tabPane.getTabs().size() - 1));
                if (screenPoint.getX() < firstTabRect.getMinX() + firstTabRect.getWidth() / 2.0) {
                    tabInsertIndex = 0;
                } else if (screenPoint.getX() > lastTabRect.getMaxX() - lastTabRect.getWidth() / 2.0) {
                    tabInsertIndex = tabPane.getTabs().size();
                } else {
                    for (int i = 0; i < tabPane.getTabs().size() - 1; ++i) {
                        Rectangle2D rightTabRect;
                        Rectangle2D leftTabRect;
                        Tab leftTab = (Tab)tabPane.getTabs().get(i);
                        Tab rightTab = (Tab)tabPane.getTabs().get(i + 1);
                        if (!(leftTab instanceof DraggableTab) || !(rightTab instanceof DraggableTab) || !this.betweenX(leftTabRect = this.getAbsoluteRect(leftTab), rightTabRect = this.getAbsoluteRect(rightTab), screenPoint.getX())) continue;
                        tabInsertIndex = i + 1;
                        break;
                    }
                }
            }
            return new InsertData(tabInsertIndex, tabPane);
        }
        return null;
    }

    private Rectangle2D getAbsoluteRect(Control node) {
        return new Rectangle2D(node.localToScene(node.getLayoutBounds().getMinX(), node.getLayoutBounds().getMinY()).getX() + node.getScene().getWindow().getX(), node.localToScene(node.getLayoutBounds().getMinX(), node.getLayoutBounds().getMinY()).getY() + node.getScene().getWindow().getY(), node.getWidth(), node.getHeight());
    }

    private Rectangle2D getAbsoluteRect(Tab tab) {
        Label node = ((DraggableTab)tab).getLabel();
        return this.getAbsoluteRect((Control)node);
    }

    private Label getLabel() {
        return this.nameLabel;
    }

    private boolean betweenX(Rectangle2D r1, Rectangle2D r2, double xPoint) {
        double lowerBound = r1.getMinX() + r1.getWidth() / 2.0;
        double upperBound = r2.getMaxX() - r2.getWidth() / 2.0;
        return xPoint >= lowerBound && xPoint <= upperBound;
    }

    static {
        markerStage.initStyle(StageStyle.UNDECORATED);
        Rectangle dummy = new Rectangle(3.0, 10.0, (Paint)Color.web((String)"#555555"));
        StackPane markerStack = new StackPane();
        markerStack.getChildren().add((Object)dummy);
        markerStage.setScene(new Scene((Parent)markerStack));
    }

    private static class InsertData {
        private final int index;
        private final TabPane insertPane;

        public InsertData(int index, TabPane insertPane) {
            this.index = index;
            this.insertPane = insertPane;
        }

        public int getIndex() {
            return this.index;
        }

        public TabPane getInsertPane() {
            return this.insertPane;
        }
    }
}

