/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.undo;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.MapObject;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.ui.MapUI;
import com.inkwellideas.ographer.ui.Worldographer;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoRedoHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.geometry.Point2D;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.util.Pair;

public class CopyDataHolder {
    final List<Point2D> sourcePts;
    final ViewLevel sourceVL;
    final Polygon sourcePolygon;
    Double minSourceX;
    Double minSourceY;
    final ArrayList<MapLayer> layers = new ArrayList();
    final List<MapShape> shapes = new ArrayList<MapShape>();
    final List<Feature> features = new ArrayList<Feature>();
    final List<MapLabel> labels = new ArrayList<MapLabel>();
    final TreeMap<Point, Terrain> terrain = new TreeMap();
    final Map<MapLayer, Map<Point, Terrain>> extraTerrainByLayer = new HashMap<MapLayer, Map<Point, Terrain>>();
    final UndoRedoHandler sourceUndoRedoHandler;
    final MapUI sourceUI;
    final Worldographer worldographer;
    final boolean excludeTerrain;
    final boolean excludeExtraTerrain;
    final boolean excludeFeatures;
    final boolean excludeShapes;
    final boolean excludeLabels;

    public CopyDataHolder(Worldographer w, List<Point2D> sourcePts, ViewLevel sourceVL, MapUI mapui, UndoRedoHandler uah, boolean excludeTerrain, boolean excludeExtraTerrain, boolean excludeFeatures, boolean excludeShapes, boolean excludeLabels) {
        this.worldographer = w;
        this.sourcePts = sourcePts;
        this.sourceVL = sourceVL;
        this.sourceUI = mapui;
        this.sourceUndoRedoHandler = uah;
        this.excludeTerrain = excludeTerrain;
        this.excludeExtraTerrain = excludeExtraTerrain;
        this.excludeFeatures = excludeFeatures;
        this.excludeShapes = excludeShapes;
        this.excludeLabels = excludeLabels;
        int i = 0;
        double[] pts = new double[sourcePts.size() * 2];
        this.minSourceX = Double.MAX_VALUE;
        this.minSourceY = Double.MAX_VALUE;
        if (this.sourcePts != null) {
            for (Point2D pt : sourcePts) {
                pts[i] = pt.getX();
                pts[++i] = pt.getY();
                ++i;
                if (pt.getX() < this.minSourceX) {
                    this.minSourceX = pt.getX();
                }
                if (!(pt.getY() < this.minSourceY)) continue;
                this.minSourceY = pt.getY();
            }
        }
        this.sourcePolygon = new Polygon(pts);
    }

    /*
     * WARNING - void declaration
     */
    public void copyCutData(MapData md, List<MapObject> selectedObjs, boolean cut, boolean delete) {
        UndoActionGroup uag = new UndoActionGroup();
        ArrayList<Feature> removeFeatures = new ArrayList<Feature>();
        ArrayList<MapLabel> removeLabels = new ArrayList<MapLabel>();
        ArrayList<MapShape> removeShapes = new ArrayList<MapShape>();
        ArrayList<ExtraTerrainHolder> removeExtraTerrain = new ArrayList<ExtraTerrainHolder>();
        for (MapLayer mapLayer : md.getMapLayers()) {
            this.layers.add(new MapLayer(mapLayer.getName()));
        }
        if (!delete) {
            boolean hasTerrainIndividuallySelected = false;
            for (MapObject mo : selectedObjs) {
                if (!delete) {
                    if (mo instanceof Feature) {
                        this.features.add((Feature)mo);
                    } else if (mo instanceof MapLabel) {
                        this.labels.add((MapLabel)mo);
                    } else if (mo instanceof MapShape) {
                        this.shapes.add((MapShape)mo);
                    } else if (mo instanceof Terrain) {
                        boolean foundExtraTerrain = false;
                        for (MapLayer ml : md.getExtraTerrainByLayer().keySet()) {
                            Map<Point, Terrain> extraTerrainByPts = md.getExtraTerrainByLayer().get(ml);
                            for (Point pt : extraTerrainByPts.keySet()) {
                                Terrain t = extraTerrainByPts.get(pt);
                                if (mo != t) continue;
                                foundExtraTerrain = true;
                                Map<Point, Terrain> copiedExtraTerrainByPts = this.extraTerrainByLayer.get(ml);
                                if (copiedExtraTerrainByPts == null) {
                                    copiedExtraTerrainByPts = new HashMap<Point, Terrain>();
                                    this.extraTerrainByLayer.put(ml, copiedExtraTerrainByPts);
                                }
                                copiedExtraTerrainByPts.put(pt, extraTerrainByPts.get(pt));
                            }
                        }
                        if (!foundExtraTerrain) {
                            hasTerrainIndividuallySelected = true;
                        }
                    }
                }
                if (!cut) continue;
                if (mo instanceof Feature) {
                    removeFeatures.add((Feature)mo);
                    continue;
                }
                if (mo instanceof MapLabel) {
                    removeLabels.add((MapLabel)mo);
                    continue;
                }
                if (mo instanceof MapShape) {
                    removeShapes.add((MapShape)mo);
                    continue;
                }
                if (!(mo instanceof Terrain)) continue;
                for (MapLayer ml : md.getExtraTerrainByLayer().keySet()) {
                    Map<Point, Terrain> extraTerrainByPts = md.getExtraTerrainByLayer().get(ml);
                    for (Point pt : extraTerrainByPts.keySet()) {
                        Terrain t = extraTerrainByPts.get(pt);
                        if (mo != t) continue;
                        removeExtraTerrain.add(new ExtraTerrainHolder(this, ml, pt, t));
                    }
                }
            }
            if (hasTerrainIndividuallySelected) {
                void var11_15;
                boolean bl = false;
                while (var11_15 < md.getTerrain(this.sourceVL).length) {
                    for (int j = 0; j < md.getTerrain(this.sourceVL)[var11_15].length; ++j) {
                        Terrain t = md.getTerrain(this.sourceVL)[var11_15][j];
                        if (!selectedObjs.contains(t)) continue;
                        this.terrain.put(new Point((double)var11_15, j), t.clone());
                    }
                    ++var11_15;
                }
            }
        }
        if (this.sourcePolygon.getPoints().size() > 0) {
            if (!this.excludeFeatures) {
                for (Feature feature : md.getFeatures()) {
                    if (!this.sourcePolygon.contains(feature.getLocation(this.sourceVL))) continue;
                    if (!delete) {
                        this.features.add(feature.clone());
                    }
                    if (!cut) continue;
                    removeFeatures.add(feature);
                }
            }
            if (!this.excludeLabels) {
                for (MapLabel mapLabel : md.getLabels()) {
                    if (!this.sourcePolygon.contains(mapLabel.getLocation(this.sourceVL))) continue;
                    if (!delete) {
                        this.labels.add(mapLabel.clone());
                    }
                    if (!cut) continue;
                    removeLabels.add(mapLabel);
                }
            }
            if (!this.excludeShapes) {
                for (MapShape mapShape : md.getShapes()) {
                    if (Shape.intersect((Shape)mapShape.getShape(), (Shape)this.sourcePolygon).getBoundsInLocal().isEmpty()) continue;
                    if (!delete) {
                        this.shapes.add(mapShape.clone());
                    }
                    if (!cut) continue;
                    removeShapes.add(mapShape);
                }
            }
            if (!this.excludeExtraTerrain) {
                for (MapLayer mapLayer : md.getExtraTerrainByLayer().keySet()) {
                    Map<Point, Terrain> extraTerrainByPts = md.getExtraTerrainByLayer().get(mapLayer);
                    for (Point pt : extraTerrainByPts.keySet()) {
                        if (!this.sourcePolygon.contains(pt.getX(), pt.getY())) continue;
                        if (!delete) {
                            Map<Point, Terrain> copiedExtraTerrainByPts = this.extraTerrainByLayer.get(mapLayer);
                            if (copiedExtraTerrainByPts == null) {
                                copiedExtraTerrainByPts = new HashMap<Point, Terrain>();
                                this.extraTerrainByLayer.put(mapLayer, copiedExtraTerrainByPts);
                            }
                            copiedExtraTerrainByPts.put(pt, extraTerrainByPts.get(pt));
                        }
                        if (!cut) continue;
                        removeExtraTerrain.add(new ExtraTerrainHolder(this, mapLayer, pt, extraTerrainByPts.get(pt)));
                    }
                }
            }
        }
        for (Feature feature : removeFeatures) {
            md.getFeatures().remove(feature);
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.FEATURE, feature, null, null, null, null, null));
        }
        for (MapLabel mapLabel : removeLabels) {
            md.getLabels().remove(mapLabel);
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.LABEL, mapLabel, null, null, null, null, null));
        }
        for (MapShape mapShape : removeShapes) {
            md.getShapes().remove(mapShape);
            uag.addAction(new UndoAction(UndoAction.Action.REMOVE, UndoAction.Thing.MAP_SHAPE, mapShape, null, null, null, null, null));
        }
        for (ExtraTerrainHolder extraTerrainHolder : removeExtraTerrain) {
            this.sourceUI.getController().deleteTerrain(extraTerrainHolder.terrain, uag);
        }
        if (!this.excludeTerrain) {
            void var11_25;
            Pair<Integer, Integer> startTerrainLoc = this.sourceUI.getTerrainFromModelPt(this.minSourceX, this.minSourceY);
            int n = (Integer)startTerrainLoc.getKey();
            while (var11_25 < md.getTerrain(this.sourceVL).length) {
                for (int j = ((Integer)startTerrainLoc.getValue()).intValue(); j < md.getTerrain(this.sourceVL)[var11_25].length; ++j) {
                    Pair<Double, Double> pair = this.sourceUI.getModelPtFromTerrain((double)var11_25, j);
                    if (!this.sourcePolygon.contains(new Point2D(((Double)pair.getKey()).doubleValue(), ((Double)pair.getValue()).doubleValue()))) continue;
                    if (!delete) {
                        this.terrain.put(new Point((double)var11_25, j), md.getTerrain(this.sourceVL)[var11_25][j].clone());
                    }
                    if (!cut && !delete) continue;
                    Terrain newTerrain = new Terrain("Empty", true);
                    uag.addAction(new UndoAction(UndoAction.Action.MODIFY, UndoAction.Thing.TERRAIN, null, newTerrain, md.getTerrain(this.sourceVL)[var11_25][j].clone(), (int)var11_25, j, (Object)this.sourceVL));
                    md.getTerrain((ViewLevel)this.sourceVL)[var11_25][j] = newTerrain;
                }
                ++var11_25;
            }
        }
        this.sourceUndoRedoHandler.push(uag);
    }

    public void pasteData(MapUI destinationUI, Point2D destinationCenter, ViewLevel currentVL, boolean alignPasteWithGrid) {
        Terrain t;
        Point2D destination;
        MapObject clone;
        Point2D sourceCenter;
        HashSet<String> neededLayers = new HashSet<String>();
        if (this.sourcePolygon != null && this.sourcePolygon.getPoints().size() > 0) {
            maxSourceX = Double.MIN_VALUE;
            maxSourceY = Double.MIN_VALUE;
            Object minSourceX = Double.MAX_VALUE;
            Double minSourceY = Double.MAX_VALUE;
            for (int i = 0; i < this.sourcePolygon.getPoints().size(); i += 2) {
                if ((Double)this.sourcePolygon.getPoints().get(i) > maxSourceX) {
                    maxSourceX = (Double)this.sourcePolygon.getPoints().get(i);
                }
                if ((Double)this.sourcePolygon.getPoints().get(i) < (Double)minSourceX) {
                    minSourceX = (Double)this.sourcePolygon.getPoints().get(i);
                }
                if ((Double)this.sourcePolygon.getPoints().get(i + 1) > maxSourceY) {
                    maxSourceY = (Double)this.sourcePolygon.getPoints().get(i + 1);
                }
                if (!((Double)this.sourcePolygon.getPoints().get(i + 1) < minSourceY)) continue;
                minSourceY = (Double)this.sourcePolygon.getPoints().get(i + 1);
            }
            sourceCenter = new Point2D((maxSourceX - (Double)minSourceX) / 2.0 + (Double)minSourceX, (maxSourceY - minSourceY) / 2.0 + minSourceY);
        } else {
            maxSourceX = Double.MIN_VALUE;
            maxSourceY = Double.MIN_VALUE;
            for (Feature f : this.features) {
                if (f.getLocation(this.sourceVL).getX() < this.minSourceX) {
                    this.minSourceX = f.getLocation(this.sourceVL).getX();
                }
                if (f.getLocation(this.sourceVL).getY() < this.minSourceY) {
                    this.minSourceY = f.getLocation(this.sourceVL).getY();
                }
                if (f.getLocation(this.sourceVL).getX() > maxSourceX) {
                    maxSourceX = f.getLocation(this.sourceVL).getX();
                }
                if (!(f.getLocation(this.sourceVL).getY() > maxSourceY)) continue;
                maxSourceY = f.getLocation(this.sourceVL).getY();
            }
            for (MapLabel l : this.labels) {
                if (l.getLocation(this.sourceVL).getX() < this.minSourceX) {
                    this.minSourceX = l.getLocation(this.sourceVL).getX();
                }
                if (l.getLocation(this.sourceVL).getY() < this.minSourceY) {
                    this.minSourceY = l.getLocation(this.sourceVL).getY();
                }
                if (l.getLocation(this.sourceVL).getX() > maxSourceX) {
                    maxSourceX = l.getLocation(this.sourceVL).getX();
                }
                if (!(l.getLocation(this.sourceVL).getY() > maxSourceY)) continue;
                maxSourceY = l.getLocation(this.sourceVL).getY();
            }
            for (MapShape ms : this.shapes) {
                List<Point2D> pts = ms.getShapePoints();
                for (Point2D point2D : pts) {
                    if (point2D.getX() < this.minSourceX) {
                        this.minSourceX = point2D.getX();
                    }
                    if (point2D.getY() < this.minSourceY) {
                        this.minSourceY = point2D.getY();
                    }
                    if (point2D.getX() > maxSourceX) {
                        maxSourceX = point2D.getX();
                    }
                    if (!(point2D.getY() > maxSourceY)) continue;
                    maxSourceY = point2D.getY();
                }
            }
            for (Point coordinate : this.terrain.keySet()) {
                Pair<Double, Double> pt = destinationUI.getMapData().getModelPtFromTerrain((int)coordinate.x, (int)coordinate.y);
                if ((Double)pt.getKey() < this.minSourceX) {
                    this.minSourceX = (Double)pt.getKey();
                }
                if ((Double)pt.getValue() < this.minSourceY) {
                    this.minSourceY = (Double)pt.getValue();
                }
                if ((Double)pt.getKey() > maxSourceX) {
                    maxSourceX = (Double)pt.getKey();
                }
                if (!((Double)pt.getValue() > maxSourceY)) continue;
                maxSourceY = (Double)pt.getValue();
            }
            sourceCenter = new Point2D((maxSourceX - this.minSourceX) / 2.0 + this.minSourceX, (maxSourceY - this.minSourceY) / 2.0 + this.minSourceY);
        }
        if (alignPasteWithGrid) {
            int xInt = (int)((sourceCenter.getX() + 38.0) / 75.0);
            int yInt = (int)((sourceCenter.getY() + 38.0) / 75.0);
            sourceCenter = new Point2D((double)(xInt * 75), (double)(yInt * 75));
        }
        double diffX = destinationCenter.getX() - sourceCenter.getX();
        double diffY = destinationCenter.getY() - sourceCenter.getY();
        UndoActionGroup uag = new UndoActionGroup();
        if (!this.excludeFeatures) {
            for (Feature feature : this.features) {
                if (destinationUI.getMapData().getMapLayer(feature.getMapLayer().getName()) != null) continue;
                neededLayers.add(feature.getMapLayer().getName());
            }
        }
        if (!this.excludeLabels) {
            for (MapLabel mapLabel : this.labels) {
                if (destinationUI.getMapData().getMapLayer(mapLabel.getMapLayer().getName()) != null) continue;
                neededLayers.add(mapLabel.getMapLayer().getName());
            }
        }
        if (!this.excludeShapes) {
            for (MapShape mapShape : this.shapes) {
                if (destinationUI.getMapData().getMapLayer(mapShape.getMapLayer().getName()) != null) continue;
                neededLayers.add(mapShape.getMapLayer().getName());
            }
        }
        if (!this.excludeExtraTerrain) {
            for (MapLayer mapLayer : this.extraTerrainByLayer.keySet()) {
                if (destinationUI.getMapData().getMapLayer(mapLayer.getName()) != null) continue;
                neededLayers.add(mapLayer.getName());
            }
        }
        this.addNeededLayers(destinationUI, uag, neededLayers);
        if (!this.excludeFeatures) {
            for (Feature feature : this.features) {
                clone = feature.clone();
                destination = new Point2D(((Feature)clone).getLocation(this.sourceVL).getX() + diffX, ((Feature)clone).getLocation(this.sourceVL).getY() + diffY);
                if (!((Feature)clone).isPlaceFreely()) {
                    destination = this.sourceUI.getSnapFeatureModelPt(destination.getX() - 37.0, destination.getY() - 37.0, true);
                }
                ((Feature)clone).setLocation(currentVL, destination);
                destinationUI.getMapData().getFeatures().add((Feature)clone);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.FEATURE, clone, null, null, null, null, null));
            }
        }
        if (!this.excludeLabels) {
            for (MapLabel mapLabel : this.labels) {
                clone = mapLabel.clone();
                destination = new Point2D(((MapLabel)clone).getLocation(this.sourceVL).getX() + diffX, ((MapLabel)clone).getLocation(this.sourceVL).getY() + diffY);
                ((MapLabel)clone).setLocationAndScale(currentVL, destination, ((MapLabel)clone).getScale(currentVL));
                destinationUI.getMapData().getMapLabels().add((MapLabel)clone);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LABEL, clone, null, null, null, null, null));
            }
        }
        if (!this.excludeShapes) {
            for (MapShape mapShape : this.shapes) {
                clone = mapShape.clone();
                if (((MapShape)clone).isSnapVertices()) {
                    int diffXInt = (int)((diffX - 37.0) / 75.0);
                    diffX = diffXInt * 75;
                    int diffYInt = (int)((diffY - 37.0) / 75.0);
                    diffY = diffYInt * 75;
                }
                ((MapShape)clone).move(diffX, diffY);
                destinationUI.getMapData().getShapes().add((MapShape)clone);
                System.out.println("added shape");
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.MAP_SHAPE, clone, null, null, null, null, null));
            }
        }
        if (!this.excludeTerrain) {
            for (Point point : this.terrain.keySet()) {
                int i = (int)point.getX();
                int j = (int)point.getY();
                Pair<Double, Double> copiedCoordinate = destinationUI.getMapData().getModelPtFromTerrain(i, j);
                t = this.terrain.get(point);
                Pair<Integer, Integer> terrainLoc = destinationUI.getMapData().getTerrainFromModelPt((Double)copiedCoordinate.getKey() + diffX, (Double)copiedCoordinate.getValue() + diffY);
                ArrayList<Terrain> tl = new ArrayList<Terrain>();
                tl.add(t);
                destinationUI.getMapData().changeTerrain(uag, tl, new Point2D((double)((Integer)terrainLoc.getKey()).intValue(), (double)((Integer)terrainLoc.getValue()).intValue()), currentVL, currentVL, true, null, t.isGmOnly(), t.isIcy(), false, t.getElevation(), t.getExtraInfo().getResources());
            }
        }
        if (!this.excludeExtraTerrain) {
            for (MapLayer mapLayer : this.extraTerrainByLayer.keySet()) {
                Map<Point, Terrain> pointTerrainMap = this.extraTerrainByLayer.get(mapLayer);
                for (Point pt : pointTerrainMap.keySet()) {
                    t = pointTerrainMap.get(pt);
                    Terrain newTerrain = t.clone();
                    double x = pt.getX() + diffX;
                    double y = pt.getY() + diffY;
                    destinationUI.getController().addExtraTerrain(newTerrain, mapLayer, (Pair<Double, Double>)new Pair((Object)x, (Object)y), uag);
                }
            }
        }
        destinationUI.getController().getUndoRedoHandler().push(uag);
        destinationUI.draw();
    }

    private void addNeededLayers(MapUI destinationUI, UndoActionGroup uag, Set<String> neededLayers) {
        boolean pastFeatures = false;
        boolean pastTerrainLand = false;
        boolean pastTerrainWater = false;
        boolean hasFeaturesLayer = false;
        for (MapLayer ml : this.layers) {
            if (!ml.getName().equals("Features")) continue;
            hasFeaturesLayer = true;
        }
        for (String neededLayerName : neededLayers) {
            MapLayer newML;
            if (neededLayerName.equals("Features")) {
                pastFeatures = true;
                hasFeaturesLayer = true;
            }
            if (neededLayerName.equals("Terrain Land")) {
                pastTerrainLand = true;
            }
            if (neededLayerName.equals("Terrain Water")) {
                pastTerrainWater = true;
            }
            if (destinationUI.getMapData().getMapLayer(neededLayerName) != null) continue;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int count = 0;
            for (MapLayer currentLayer : destinationUI.getMapData().getMapLayers()) {
                map.put(currentLayer.getName(), count);
                ++count;
            }
            if (pastTerrainWater) {
                System.out.println("adding pastTerrainWater " + neededLayerName);
                newML = this.sourceUI.getController().addLayer(uag, (Integer)map.get("Terrain Water") + 1, neededLayerName);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, newML, null, null, (Integer)map.get("Terrain Water") + 1, null, null));
                continue;
            }
            if (pastTerrainLand) {
                System.out.println("adding pastTerrainLand " + neededLayerName);
                newML = this.sourceUI.getController().addLayer(uag, (Integer)map.get("Terrain Land") + 1, neededLayerName);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, newML, null, null, (Integer)map.get("Terrain Land") + 1, null, null));
                continue;
            }
            if (pastFeatures) {
                System.out.println("adding pastFeatures " + neededLayerName);
                newML = destinationUI.getController().addLayer(uag, (Integer)map.get("Features") + 1, neededLayerName);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, newML, null, null, (Integer)map.get("Features") + 1, null, null));
                continue;
            }
            if (hasFeaturesLayer) {
                System.out.println("adding features " + neededLayerName);
                newML = destinationUI.getController().addLayer(uag, (Integer)map.get("Features") - 1, neededLayerName);
                uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, newML, null, null, (Integer)map.get("Features") - 1, null, null));
                continue;
            }
            System.out.println("adding else " + neededLayerName);
            newML = this.sourceUI.getController().addLayer(uag, 0, neededLayerName);
            uag.addAction(new UndoAction(UndoAction.Action.ADD, UndoAction.Thing.LAYER, newML, null, null, 0, null, null));
        }
        this.worldographer.updateLayersToolbox();
        System.out.println("Layers:" + String.valueOf(this.sourceUI.getMapData().getMapLayers()));
    }

    class ExtraTerrainHolder {
        MapLayer mapLayer;
        Point point;
        Terrain terrain;

        public ExtraTerrainHolder(CopyDataHolder this$0, MapLayer mapLayer, Point point, Terrain t) {
            this.mapLayer = mapLayer;
            this.point = point;
            this.terrain = t;
        }
    }
}

