/*
 * Decompiled with CFR 0.152.
 */
package com.inkwellideas.ographer.undo;

import com.inkwellideas.ographer.data.MapLayer;
import com.inkwellideas.ographer.data.ViewLevel;
import com.inkwellideas.ographer.map.MapData;
import com.inkwellideas.ographer.map.MapLabel;
import com.inkwellideas.ographer.map.MapShape;
import com.inkwellideas.ographer.map.Terrain;
import com.inkwellideas.ographer.model.Feature;
import com.inkwellideas.ographer.model.Note;
import com.inkwellideas.ographer.ui.toolbox.WLogger;
import com.inkwellideas.ographer.undo.Point;
import com.inkwellideas.ographer.undo.UndoAction;
import com.inkwellideas.ographer.undo.UndoActionGroup;
import com.inkwellideas.ographer.undo.UndoStack;
import com.inkwellideas.ographer.undo.Undoable;
import java.util.ArrayList;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.shape.Arc;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.util.Pair;

public class UndoRedoHandler {
    final UndoStack undoStack = new UndoStack();
    final MapData mapData;
    private final WLogger loggerUI;
    boolean changed = false;

    public UndoRedoHandler(MapData md, WLogger loggerUI) {
        this.mapData = md;
        this.loggerUI = loggerUI;
    }

    public void push(UndoAction action) {
        UndoAction previous;
        this.loggerUI.addLogText("Undo/Redo push:" + String.valueOf(action), false);
        this.changed = true;
        if (this.getTopAction() != null && (previous = this.getTopAction()).getTimestamp() + 100L > action.getTimestamp()) {
            UndoActionGroup uag;
            if (previous instanceof UndoActionGroup) {
                uag = (UndoActionGroup)this.undoStack.getCurrentActionUndo();
            } else {
                uag = new UndoActionGroup();
                uag.addAction(this.undoStack.getCurrentActionUndo());
            }
            if (action instanceof UndoActionGroup) {
                UndoActionGroup newgroup = (UndoActionGroup)action;
                for (UndoAction ua : newgroup.getActions()) {
                    uag.addAction(ua);
                }
            } else {
                uag.addAction(action);
            }
            uag.setTimestamp(System.currentTimeMillis());
            action = uag;
        }
        this.undoStack.add(action);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public UndoAction getTopAction() {
        return this.undoStack.getCurrentActionNoPop();
    }

    public void handleUndo() {
        this.changed = true;
        UndoAction ua = this.undoStack.getCurrentActionUndo();
        this.loggerUI.addLogText("#Undos:" + this.undoStack.actions.size() + " Undo:" + String.valueOf(ua), false);
        if (ua == null) {
            return;
        }
        if (ua instanceof UndoActionGroup) {
            UndoActionGroup uag = (UndoActionGroup)ua;
            for (int i = uag.getActions().size() - 1; i >= 0; --i) {
                this.undoRedo(uag.getActions().get(i), uag.getActions().get(i).getOldValue(), false);
            }
        } else {
            this.undoRedo(ua, ua.getOldValue(), false);
        }
    }

    public void handleRedo() {
        this.changed = true;
        UndoAction ua = this.undoStack.getCurrentActionRedo();
        this.loggerUI.addLogText("Redo:" + String.valueOf(ua), false);
        if (ua == null) {
            return;
        }
        if (ua instanceof UndoActionGroup) {
            UndoActionGroup uag = (UndoActionGroup)ua;
            for (int i = 0; i < uag.getActions().size(); ++i) {
                this.undoRedo(uag.getActions().get(i), uag.getActions().get(i).getNewValue(), true);
            }
        } else {
            this.undoRedo(ua, ua.getNewValue(), true);
        }
    }

    public void undoRedo(UndoAction ua, Object changeto, boolean isRedo) {
        if (ua == null) {
            return;
        }
        switch (ua.getAction()) {
            case ADD: {
                if (ua.getThing().equals((Object)UndoAction.Thing.LINE_PT)) {
                    Shape pt;
                    Shape shape = ((MapShape)ua.getObject()).getShape();
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        pt = (Point2D)ua.getNewValue();
                        if (isRedo) {
                            p.getPoints().add((Object)pt.getX());
                            p.getPoints().add((Object)pt.getY());
                            break;
                        }
                        ArrayList<Double> pts = new ArrayList<Double>();
                        for (int i = 0; i < p.getPoints().size(); i += 2) {
                            Point2D polypt = new Point2D(((Double)p.getPoints().get(i)).doubleValue(), ((Double)p.getPoints().get(i + 1)).doubleValue());
                            if (polypt.equals((Object)pt)) continue;
                            pts.add((Double)p.getPoints().get(i));
                            pts.add((Double)p.getPoints().get(i + 1));
                        }
                        p.getPoints().retainAll(pts);
                        break;
                    }
                    pt = ((MapShape)ua.getObject()).getShape();
                    if (pt instanceof Path) {
                        Path p = (Path)pt;
                        if (isRedo) {
                            p.getElements().add(((Integer)ua.getModifier1()).intValue(), (Object)((PathElement)ua.getNewValue()));
                            break;
                        }
                        p.getElements().remove(ua.getNewValue());
                        break;
                    }
                    pt = ((MapShape)ua.getObject()).getShape();
                    if (!(pt instanceof Arc)) break;
                    Arc a = (Arc)pt;
                    if (isRedo) {
                        a.setCenterX(((Point2D)ua.getNewValue()).getX());
                        a.setCenterY(((Point2D)ua.getNewValue()).getY());
                        a.setRadiusX(((Point2D)ua.getModifier1()).getX());
                        a.setRadiusY(((Point2D)ua.getModifier1()).getY());
                        break;
                    }
                    a.setCenterX(((Point2D)ua.getOldValue()).getX());
                    a.setCenterY(((Point2D)ua.getOldValue()).getY());
                    a.setRadiusX(((Point2D)ua.getModifier2()).getX());
                    a.setRadiusY(((Point2D)ua.getModifier2()).getY());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) {
                    if (isRedo) {
                        this.mapData.getFeatures().add((Feature)ua.getObject());
                        break;
                    }
                    this.mapData.getFeatures().remove((Feature)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.LABEL)) {
                    if (isRedo) {
                        this.mapData.getMapLabels().add((MapLabel)ua.getObject());
                        break;
                    }
                    this.mapData.getMapLabels().remove((MapLabel)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) {
                    if (isRedo) {
                        this.mapData.getShapes().add((MapShape)ua.getObject());
                        break;
                    }
                    this.mapData.getShapes().remove((MapShape)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.NOTE)) {
                    if (isRedo) {
                        this.mapData.getNotes().add((Note)ua.getObject());
                        break;
                    }
                    this.mapData.getNotes().remove((Note)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.TERRAIN)) {
                    Pair mapLayerAndLocation = (Pair)ua.getModifier1();
                    if (isRedo) {
                        this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey()).put((Point)mapLayerAndLocation.getValue(), (Terrain)ua.getObject());
                        break;
                    }
                    Map<Point, Terrain> locAndTerrain = this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey());
                    locAndTerrain.remove(mapLayerAndLocation.getValue());
                    break;
                }
                if (!ua.getThing().equals((Object)UndoAction.Thing.LAYER)) break;
                MapLayer ml = (MapLayer)ua.getObject();
                Integer index = (Integer)ua.getModifier1();
                if (isRedo) {
                    this.mapData.getMapLayers().add(index, ml);
                    break;
                }
                this.mapData.getMapLayers().remove(ml);
                break;
            }
            case MODIFY: {
                if (ua.getThing().equals((Object)UndoAction.Thing.TERRAIN)) {
                    if (ua.getModifier3() == null) {
                        Terrain t = (Terrain)ua.getObject();
                        t.makeEqual((Terrain)changeto);
                        break;
                    }
                    this.mapData.getTerrain((ViewLevel)((Object)ua.getModifier3()))[(Integer)ua.getModifier1()][(Integer)ua.getModifier2()].makeEqual((Terrain)changeto);
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) {
                    Feature f = (Feature)ua.getObject();
                    f.makeIdenticalTo((Feature)changeto);
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) {
                    MapShape ms = (MapShape)ua.getObject();
                    if (changeto instanceof Shape) {
                        ms.setShape((Shape)changeto);
                        break;
                    }
                    ms.makeIdenticalTo((Undoable)changeto);
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.SHAPE_PTS)) {
                    MapShape ms = (MapShape)ua.getObject();
                    ms.setShape((Shape)changeto);
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.LABEL)) {
                    MapLabel ml = (MapLabel)ua.getObject();
                    ml.makeIdenticalTo((Undoable)changeto);
                    break;
                }
                if (!ua.getThing().equals((Object)UndoAction.Thing.LAYER)) break;
                ((MapLayer)ua.getObject()).setName((String)changeto);
                break;
            }
            case MODIFY_LABEL: {
                if (!ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) break;
                Feature f = (Feature)ua.getObject();
                MapLabel ml = f.getLabel();
                if ("text".equals(ua.getModifier1())) {
                    if (changeto instanceof String) {
                        ml.setText((String)changeto);
                        break;
                    }
                    if (!(changeto instanceof MapLabel)) break;
                    f.setLabel((MapLabel)changeto);
                    break;
                }
                if ("bold".equals(ua.getModifier1())) {
                    ml.setBold((Boolean)changeto);
                    break;
                }
                if ("italic".equals(ua.getModifier1())) {
                    ml.setItalic((Boolean)changeto);
                    break;
                }
                if ("size".equals(ua.getModifier1())) break;
                if ("outlinecolor".equals(ua.getModifier1())) {
                    ml.setOutlineColor((Color)changeto);
                    break;
                }
                if ("color".equals(ua.getModifier1())) {
                    ml.setColor((Color)changeto);
                    break;
                }
                if (!"font".equals(ua.getModifier1())) break;
                ml.setFontFace((String)changeto);
                break;
            }
            case MODIFY_LOCATION: {
                if (ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) {
                    Feature f = (Feature)ua.getObject();
                    f.setLocation((ViewLevel)((Object)ua.getModifier1()), (Point2D)changeto);
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.NOTE)) {
                    Note n = (Note)ua.getObject();
                    n.setLocation((ViewLevel)((Object)ua.getModifier1()), (Point2D)changeto);
                }
                if (!ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) break;
                MapShape ms = (MapShape)ua.getObject();
                Shape shape = ms.getShape();
                Point2D laterpos = (Point2D)ua.getNewValue();
                Point2D earlypos = (Point2D)ua.getOldValue();
                if (isRedo) {
                    laterpos = (Point2D)ua.getOldValue();
                    earlypos = (Point2D)ua.getNewValue();
                }
                double diffx = laterpos.getX() - earlypos.getX();
                double diffy = laterpos.getY() - earlypos.getY();
                if (shape instanceof Polygon) {
                    Polygon p = (Polygon)shape;
                    for (int i = 0; i < p.getPoints().size(); i += 2) {
                        try {
                            p.getPoints().set(i, (Object)((Double)p.getPoints().get(i) + diffx));
                            p.getPoints().set(i + 1, (Object)((Double)p.getPoints().get(i + 1) + diffy));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                } else {
                    if (shape instanceof Arc) {
                        Arc a = (Arc)shape;
                        a.setCenterX(a.getCenterX() + diffx);
                        a.setCenterY(a.getCenterY() + diffy);
                        break;
                    }
                    if (!(shape instanceof Path)) break;
                    Path p = (Path)shape;
                    for (int i = 0; i < p.getElements().size(); ++i) {
                        PathElement pe = (PathElement)p.getElements().get(i);
                        if (pe instanceof MoveTo) {
                            MoveTo mt = (MoveTo)pe;
                            mt.setX(mt.getX() + diffx);
                            mt.setY(mt.getY() + diffy);
                            continue;
                        }
                        if (pe instanceof LineTo) {
                            LineTo lt = (LineTo)pe;
                            lt.setX(lt.getX() + diffx);
                            lt.setY(lt.getY() + diffy);
                            continue;
                        }
                        if (!(pe instanceof CubicCurveTo)) continue;
                        CubicCurveTo ct = (CubicCurveTo)pe;
                        ct.setX(ct.getX() + diffx);
                        ct.setY(ct.getY() + diffy);
                        ct.setControlX1(ct.getControlX1() + diffx);
                        ct.setControlY1(ct.getControlY1() + diffy);
                        ct.setControlX2(ct.getControlX2() + diffx);
                        ct.setControlY2(ct.getControlY2() + diffy);
                    }
                }
                break;
            }
            case MODIFY_SHAPE: {
                if (!ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) break;
                MapShape ms = (MapShape)ua.getObject();
                ms.setShape((Shape)changeto);
                break;
            }
            case REMOVE: {
                if (ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) {
                    if (isRedo) {
                        this.mapData.getFeatures().remove((Feature)ua.getObject());
                        break;
                    }
                    this.mapData.getFeatures().add((Feature)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.LABEL)) {
                    if (isRedo) {
                        this.mapData.getMapLabels().remove((MapLabel)ua.getObject());
                        break;
                    }
                    this.mapData.getMapLabels().add((MapLabel)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) {
                    if (isRedo) {
                        this.mapData.getShapes().remove((MapShape)ua.getObject());
                        break;
                    }
                    this.mapData.getShapes().add((MapShape)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.NOTE)) {
                    if (isRedo) {
                        this.mapData.getNotes().remove((Note)ua.getObject());
                        break;
                    }
                    this.mapData.getNotes().add((Note)ua.getObject());
                    break;
                }
                if (ua.getThing().equals((Object)UndoAction.Thing.TERRAIN)) {
                    Pair mapLayerAndLocation = (Pair)ua.getModifier1();
                    if (isRedo) {
                        Map<Point, Terrain> locAndTerrain = this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey());
                        locAndTerrain.remove(mapLayerAndLocation.getValue());
                        break;
                    }
                    this.mapData.getExtraTerrainByLayer().get(mapLayerAndLocation.getKey()).put((Point)mapLayerAndLocation.getValue(), (Terrain)ua.getObject());
                    break;
                }
                if (!ua.getThing().equals((Object)UndoAction.Thing.LAYER)) break;
                MapLayer ml = (MapLayer)ua.getObject();
                Integer index = (Integer)ua.getModifier1();
                if (isRedo) {
                    this.mapData.getMapLayers().remove(ml);
                    break;
                }
                this.mapData.getMapLayers().add(index, ml);
                break;
            }
            case REORDER: {
                if (ua.getThing().equals((Object)UndoAction.Thing.FEATURE)) {
                    this.mapData.getFeatures().remove((Feature)ua.getObject());
                    this.mapData.getFeatures().add((Integer)changeto, (Feature)ua.getObject());
                    break;
                }
                if (!ua.getThing().equals((Object)UndoAction.Thing.MAP_SHAPE)) break;
                this.mapData.getShapes().remove((MapShape)ua.getObject());
                this.mapData.getShapes().add((Integer)changeto, (MapShape)ua.getObject());
                break;
            }
        }
    }
}

